/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.fragment;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentTransaction;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.DidClickForHardPermissionListener;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.customviews.CloseImageView;
import com.clevertap.android.sdk.inapp.CTInAppAction;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inapp.CTInAppNotificationButton;
import com.clevertap.android.sdk.inapp.InAppActionType;
import com.clevertap.android.sdk.inapp.InAppListener;
import com.clevertap.android.sdk.inapp.images.FileResourceProvider;
import com.clevertap.android.sdk.utils.UriHelper;
import java.lang.ref.WeakReference;
import java.net.URLDecoder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 E2\u00020\u0001:\u0002EFB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010!\u001a\u00020\"H$J\b\u0010#\u001a\u00020\"H$J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0016J\u001a\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0016\u0010,\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u00010+J\u000e\u00103\u001a\u00020\"2\u0006\u00104\u001a\u000201J\u0010\u00105\u001a\u00020\"2\b\u00106\u001a\u0004\u0018\u00010+J\u0010\u00107\u001a\u00020\"2\b\u00106\u001a\u0004\u0018\u00010+J\b\u00108\u001a\u0004\u0018\u00010\u001eJ\u000e\u00109\u001a\u00020\"2\u0006\u0010:\u001a\u00020\u001eJ\u000e\u0010;\u001a\u00020\u00112\u0006\u0010<\u001a\u00020\u0011J\u000e\u0010=\u001a\u00020\"2\u0006\u0010>\u001a\u00020\u0011J\u0006\u0010?\u001a\u00020@J\u0012\u0010A\u001a\u0004\u0018\u00010+2\u0006\u0010B\u001a\u00020CH\u0002J$\u0010D\u001a\u0004\u0018\u00010+2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010+H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/clevertap/android/sdk/inapp/fragment/CTInAppBaseFragment;", "Landroidx/fragment/app/Fragment;", "<init>", "()V", "inAppNotification", "Lcom/clevertap/android/sdk/inapp/CTInAppNotification;", "getInAppNotification", "()Lcom/clevertap/android/sdk/inapp/CTInAppNotification;", "setInAppNotification", "(Lcom/clevertap/android/sdk/inapp/CTInAppNotification;)V", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "getConfig", "()Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "setConfig", "(Lcom/clevertap/android/sdk/CleverTapInstanceConfig;)V", "currentOrientation", "", "getCurrentOrientation", "()I", "setCurrentOrientation", "(I)V", "closeImageView", "Lcom/clevertap/android/sdk/customviews/CloseImageView;", "getCloseImageView", "()Lcom/clevertap/android/sdk/customviews/CloseImageView;", "setCloseImageView", "(Lcom/clevertap/android/sdk/customviews/CloseImageView;)V", "listenerWeakReference", "Ljava/lang/ref/WeakReference;", "Lcom/clevertap/android/sdk/inapp/InAppListener;", "didClickForHardPermissionListener", "Lcom/clevertap/android/sdk/DidClickForHardPermissionListener;", "cleanup", "", "generateListener", "onAttach", "context", "Landroid/content/Context;", "onViewCreated", "view", "Landroid/view/View;", "savedInstanceState", "Landroid/os/Bundle;", "setArguments", "triggerAction", "action", "Lcom/clevertap/android/sdk/inapp/CTInAppAction;", "callToAction", "", "additionalData", "openActionUrl", "url", "didDismiss", "data", "didShow", "getListener", "setListener", "listener", "getScaledPixels", "raw", "handleButtonClickAtIndex", "index", "resourceProvider", "Lcom/clevertap/android/sdk/inapp/images/FileResourceProvider;", "didClick", "button", "Lcom/clevertap/android/sdk/inapp/CTInAppNotificationButton;", "notifyActionTriggered", "Companion", "CTInAppNativeButtonClickListener", "clevertap-core_release"})
public abstract class CTInAppBaseFragment
extends Fragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    protected CTInAppNotification inAppNotification;
    protected CleverTapInstanceConfig config;
    private int currentOrientation;
    @Nullable
    private CloseImageView closeImageView;
    @Nullable
    private WeakReference<InAppListener> listenerWeakReference;
    @Nullable
    private DidClickForHardPermissionListener didClickForHardPermissionListener;

    @NotNull
    protected final CTInAppNotification getInAppNotification() {
        CTInAppNotification cTInAppNotification = this.inAppNotification;
        if (cTInAppNotification != null) {
            return cTInAppNotification;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"inAppNotification");
        return null;
    }

    protected final void setInAppNotification(@NotNull CTInAppNotification cTInAppNotification) {
        Intrinsics.checkNotNullParameter((Object)cTInAppNotification, (String)"<set-?>");
        this.inAppNotification = cTInAppNotification;
    }

    @NotNull
    protected final CleverTapInstanceConfig getConfig() {
        CleverTapInstanceConfig cleverTapInstanceConfig = this.config;
        if (cleverTapInstanceConfig != null) {
            return cleverTapInstanceConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    protected final void setConfig(@NotNull CleverTapInstanceConfig cleverTapInstanceConfig) {
        Intrinsics.checkNotNullParameter((Object)cleverTapInstanceConfig, (String)"<set-?>");
        this.config = cleverTapInstanceConfig;
    }

    protected final int getCurrentOrientation() {
        return this.currentOrientation;
    }

    protected final void setCurrentOrientation(int n) {
        this.currentOrientation = n;
    }

    @Nullable
    protected final CloseImageView getCloseImageView() {
        return this.closeImageView;
    }

    protected final void setCloseImageView(@Nullable CloseImageView closeImageView) {
        this.closeImageView = closeImageView;
    }

    protected abstract void cleanup();

    protected abstract void generateListener();

    public void onAttach(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.onAttach(context);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            Parcelable parcelable = bundle.getParcelable("inApp");
            Intrinsics.checkNotNull((Object)parcelable);
            this.setInAppNotification((CTInAppNotification)parcelable);
            Parcelable parcelable2 = bundle.getParcelable("config");
            Intrinsics.checkNotNull((Object)parcelable2);
            this.setConfig((CleverTapInstanceConfig)parcelable2);
            this.currentOrientation = this.getResources().getConfiguration().orientation;
            this.generateListener();
            if (context instanceof DidClickForHardPermissionListener) {
                this.didClickForHardPermissionListener = (DidClickForHardPermissionListener)context;
            }
        }
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.didShow(null);
    }

    public final void setArguments(@NotNull CTInAppNotification inAppNotification, @NotNull CleverTapInstanceConfig config) {
        Intrinsics.checkNotNullParameter((Object)inAppNotification, (String)"inAppNotification");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Bundle bundle = new Bundle();
        bundle.putParcelable("inApp", (Parcelable)inAppNotification);
        bundle.putParcelable("config", (Parcelable)config);
        this.setArguments(bundle);
    }

    public final void triggerAction(@NotNull CTInAppAction action, @Nullable String callToAction, @Nullable Bundle additionalData) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Bundle additionalData2 = additionalData;
        CTInAppAction action2 = action;
        String callToAction2 = callToAction;
        if (action2.getType() == InAppActionType.OPEN_URL) {
            String[] stringArray;
            List parts;
            Bundle urlActionData = UriHelper.getAllKeyValuePairs(action2.getActionUrl(), false);
            String callToActionUrlParam = urlActionData.getString("wzrk_c2a");
            urlActionData.remove("wzrk_c2a");
            if (additionalData2 != null) {
                urlActionData.putAll(additionalData2);
            }
            additionalData2 = urlActionData;
            if (callToActionUrlParam != null && (parts = StringsKt.split$default((CharSequence)callToActionUrlParam, (String[])(stringArray = new String[]{"__dl__"}), (boolean)false, (int)0, (int)6, null)).size() == 2) {
                try {
                    callToActionUrlParam = URLDecoder.decode((String)parts.get(0), "UTF-8");
                }
                catch (Exception e) {
                    this.getConfig().getLogger().debug("Error parsing c2a param", e);
                }
                action2 = CTInAppAction.CREATOR.createOpenUrlAction((String)parts.get(1));
            }
            if (callToAction2 == null) {
                callToAction2 = callToActionUrlParam;
            }
        }
        if ((string2 = callToAction2) == null) {
            string2 = "";
        }
        Bundle actionData = this.notifyActionTriggered(action2, string2, additionalData2);
        this.didDismiss(actionData);
    }

    public final void openActionUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.triggerAction(CTInAppAction.CREATOR.createOpenUrlAction(url), null, null);
    }

    public final void didDismiss(@Nullable Bundle data) {
        block0: {
            this.cleanup();
            InAppListener inAppListener = this.getListener();
            if (inAppListener == null) break block0;
            inAppListener.inAppNotificationDidDismiss(this.getInAppNotification(), data);
        }
    }

    public final void didShow(@Nullable Bundle data) {
        block0: {
            InAppListener inAppListener = this.getListener();
            if (inAppListener == null) break block0;
            inAppListener.inAppNotificationDidShow(this.getInAppNotification(), data);
        }
    }

    @Nullable
    public final InAppListener getListener() {
        InAppListener listener;
        WeakReference<InAppListener> weakReference = this.listenerWeakReference;
        InAppListener inAppListener = listener = weakReference != null ? (InAppListener)weakReference.get() : null;
        if (listener == null) {
            this.getConfig().getLogger().verbose(this.getConfig().getAccountId(), "InAppListener is null for notification: " + this.getInAppNotification().getJsonDescription());
        }
        return listener;
    }

    public final void setListener(@NotNull InAppListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listenerWeakReference = new WeakReference<InAppListener>(listener);
    }

    public final int getScaledPixels(int raw) {
        return (int)TypedValue.applyDimension((int)1, (float)raw, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public final void handleButtonClickAtIndex(int index) {
        try {
            CTInAppAction action;
            CTInAppNotificationButton button = this.getInAppNotification().getButtons().get(index);
            Bundle clickData = this.didClick(button);
            if (this.getInAppNotification().isLocalInApp() && this.didClickForHardPermissionListener != null) {
                switch (index) {
                    case 0: {
                        DidClickForHardPermissionListener didClickForHardPermissionListener = this.didClickForHardPermissionListener;
                        if (didClickForHardPermissionListener != null) {
                            didClickForHardPermissionListener.didClickForHardPermissionWithFallbackSettings(this.getInAppNotification().getFallBackToNotificationSettings());
                        }
                        return;
                    }
                    case 1: {
                        DidClickForHardPermissionListener didClickForHardPermissionListener = this.didClickForHardPermissionListener;
                        if (didClickForHardPermissionListener == null) break;
                        didClickForHardPermissionListener.didCancelPermissionRequest();
                        break;
                    }
                }
            }
            if ((action = button.action) != null && InAppActionType.REQUEST_FOR_PERMISSIONS == action.getType() && this.didClickForHardPermissionListener != null) {
                DidClickForHardPermissionListener didClickForHardPermissionListener = this.didClickForHardPermissionListener;
                if (didClickForHardPermissionListener != null) {
                    didClickForHardPermissionListener.didClickForHardPermissionWithFallbackSettings(action.shouldFallbackToSettings());
                }
                return;
            }
            this.didDismiss(clickData);
        }
        catch (Throwable t) {
            this.getConfig().getLogger().debug("Error handling notification button click", t);
            this.didDismiss(null);
        }
    }

    @NotNull
    public final FileResourceProvider resourceProvider() {
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext(...)");
        return FileResourceProvider.Companion.getInstance(context, this.getConfig().getLogger());
    }

    private final Bundle didClick(CTInAppNotificationButton button) {
        CTInAppAction action = button.action;
        if (action == null) {
            action = CTInAppAction.CREATOR.createCloseAction();
        }
        return this.notifyActionTriggered(action, button.getText(), null);
    }

    private final Bundle notifyActionTriggered(CTInAppAction action, String callToAction, Bundle additionalData) {
        InAppListener inAppListener = this.getListener();
        return inAppListener != null ? inAppListener.inAppNotificationActionTriggered(this.getInAppNotification(), action, callToAction, additionalData, (Context)this.getActivity()) : null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/clevertap/android/sdk/inapp/fragment/CTInAppBaseFragment$CTInAppNativeButtonClickListener;", "Landroid/view/View$OnClickListener;", "<init>", "(Lcom/clevertap/android/sdk/inapp/fragment/CTInAppBaseFragment;)V", "onClick", "", "view", "Landroid/view/View;", "clevertap-core_release"})
    protected final class CTInAppNativeButtonClickListener
    implements View.OnClickListener {
        public void onClick(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Object object = view.getTag();
            Integer n = object instanceof Integer ? (Integer)object : null;
            if (n == null) {
                return;
            }
            int index = n;
            CTInAppBaseFragment.this.handleButtonClickAtIndex(index);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/clevertap/android/sdk/inapp/fragment/CTInAppBaseFragment$Companion;", "", "<init>", "()V", "showOnActivity", "", "inAppFragment", "Lcom/clevertap/android/sdk/inapp/fragment/CTInAppBaseFragment;", "activity", "Landroid/app/Activity;", "inAppNotification", "Lcom/clevertap/android/sdk/inapp/CTInAppNotification;", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "logTag", "", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean showOnActivity(@NotNull CTInAppBaseFragment inAppFragment, @NotNull Activity activity, @NotNull CTInAppNotification inAppNotification, @NotNull CleverTapInstanceConfig config, @NotNull String logTag) {
            Intrinsics.checkNotNullParameter((Object)((Object)inAppFragment), (String)"inAppFragment");
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)inAppNotification, (String)"inAppNotification");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)logTag, (String)"logTag");
            try {
                FragmentTransaction fragmentTransaction = ((FragmentActivity)activity).getSupportFragmentManager().beginTransaction();
                Intrinsics.checkNotNullExpressionValue((Object)fragmentTransaction, (String)"beginTransaction(...)");
                FragmentTransaction fragmentTransaction2 = fragmentTransaction;
                inAppFragment.setArguments(inAppNotification, config);
                fragmentTransaction2.setCustomAnimations(0x10B0000, 0x10B0001);
                fragmentTransaction2.add(0x1020002, (Fragment)inAppFragment, inAppNotification.getType$clevertap_core_release());
                Logger.v(logTag, "calling InAppFragment " + inAppNotification.getCampaignId());
                fragmentTransaction2.commitNow();
                return true;
            }
            catch (ClassCastException e) {
                Logger.v(logTag, "Fragment not able to render, please ensure your Activity is an instance of AppCompatActivity", e);
                return false;
            }
            catch (Throwable t) {
                Logger.v(logTag, "Fragment not able to render", t);
                return false;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

