/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.evaluation;

import androidx.annotation.VisibleForTesting;
import com.clevertap.android.sdk.CTXtensions;
import com.clevertap.android.sdk.inapp.evaluation.TriggerAdapterKt;
import com.clevertap.android.sdk.inapp.evaluation.TriggerCondition;
import com.clevertap.android.sdk.inapp.evaluation.TriggerGeoRadius;
import com.clevertap.android.sdk.inapp.evaluation.TriggerOperator;
import com.clevertap.android.sdk.inapp.evaluation.TriggerValue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0007J\u0010\u0010#\u001a\u0004\u0018\u00010!2\u0006\u0010$\u001a\u00020\u0019J\u0010\u0010%\u001a\u0004\u0018\u00010!2\u0006\u0010$\u001a\u00020\u0019J\u0010\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010$\u001a\u00020\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/clevertap/android/sdk/inapp/evaluation/TriggerAdapter;", "", "triggerJSON", "Lorg/json/JSONObject;", "<init>", "(Lorg/json/JSONObject;)V", "eventName", "", "getEventName", "()Ljava/lang/String;", "properties", "Lorg/json/JSONArray;", "getProperties", "()Lorg/json/JSONArray;", "items", "getItems", "geoRadiusArray", "getGeoRadiusArray", "profileAttrName", "getProfileAttrName", "firstTimeOnly", "", "getFirstTimeOnly", "()Z", "propertyCount", "", "getPropertyCount", "()I", "itemsCount", "getItemsCount", "geoRadiusCount", "getGeoRadiusCount", "triggerConditionFromJSON", "Lcom/clevertap/android/sdk/inapp/evaluation/TriggerCondition;", "property", "propertyAtIndex", "index", "itemAtIndex", "geoRadiusAtIndex", "Lcom/clevertap/android/sdk/inapp/evaluation/TriggerGeoRadius;", "Companion", "clevertap-core_release"})
public final class TriggerAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String eventName;
    @Nullable
    private final JSONArray properties;
    @Nullable
    private final JSONArray items;
    @Nullable
    private final JSONArray geoRadiusArray;
    @Nullable
    private final String profileAttrName;
    private final boolean firstTimeOnly;
    @NotNull
    public static final String KEY_FIRST_TIME_ONLY = "firstTimeOnly";
    @NotNull
    public static final String KEY_EVENT_NAME = "eventName";
    @NotNull
    public static final String KEY_EVENT_PROPERTIES = "eventProperties";
    @NotNull
    public static final String KEY_ITEM_PROPERTIES = "itemProperties";
    @NotNull
    public static final String KEY_GEO_RADIUS_PROPERTIES = "geoRadius";
    @NotNull
    public static final String KEY_PROFILE_ATTR_NAME = "profileAttrName";
    @NotNull
    public static final String KEY_PROPERTY_VALUE = "propertyValue";
    @NotNull
    public static final String INAPP_OPERATOR = "operator";
    @NotNull
    public static final String INAPP_PROPERTYNAME = "propertyName";

    public TriggerAdapter(@NotNull JSONObject triggerJSON) {
        Intrinsics.checkNotNullParameter((Object)triggerJSON, (String)"triggerJSON");
        String string2 = triggerJSON.optString(KEY_EVENT_NAME, "");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"optString(...)");
        this.eventName = string2;
        this.properties = triggerJSON.optJSONArray(KEY_EVENT_PROPERTIES);
        this.items = triggerJSON.optJSONArray(KEY_ITEM_PROPERTIES);
        this.geoRadiusArray = triggerJSON.optJSONArray(KEY_GEO_RADIUS_PROPERTIES);
        this.profileAttrName = triggerJSON.optString(KEY_PROFILE_ATTR_NAME, null);
        this.firstTimeOnly = triggerJSON.optBoolean(KEY_FIRST_TIME_ONLY, false);
    }

    @NotNull
    public final String getEventName() {
        return this.eventName;
    }

    @Nullable
    public final JSONArray getProperties() {
        return this.properties;
    }

    @Nullable
    public final JSONArray getItems() {
        return this.items;
    }

    @Nullable
    public final JSONArray getGeoRadiusArray() {
        return this.geoRadiusArray;
    }

    @Nullable
    public final String getProfileAttrName() {
        return this.profileAttrName;
    }

    public final boolean getFirstTimeOnly() {
        return this.firstTimeOnly;
    }

    public final int getPropertyCount() {
        JSONArray jSONArray = this.properties;
        return jSONArray != null ? jSONArray.length() : 0;
    }

    public final int getItemsCount() {
        JSONArray jSONArray = this.items;
        return jSONArray != null ? jSONArray.length() : 0;
    }

    public final int getGeoRadiusCount() {
        JSONArray jSONArray = this.geoRadiusArray;
        return jSONArray != null ? jSONArray.length() : 0;
    }

    @VisibleForTesting
    @NotNull
    public final TriggerCondition triggerConditionFromJSON(@NotNull JSONObject property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        TriggerValue value = new TriggerValue(property.opt(KEY_PROPERTY_VALUE), null, 2, null);
        TriggerOperator operator = TriggerAdapterKt.optTriggerOperator(property, INAPP_OPERATOR);
        String string2 = property.optString(INAPP_PROPERTYNAME, "");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"optString(...)");
        return new TriggerCondition(string2, operator, value);
    }

    @Nullable
    public final TriggerCondition propertyAtIndex(int index) {
        if (CTXtensions.isInvalidIndex(this.properties, index)) {
            return null;
        }
        JSONArray jSONArray = this.properties;
        if (jSONArray == null || (jSONArray = jSONArray.optJSONObject(index)) == null) {
            return null;
        }
        JSONArray propertyJSONObject = jSONArray;
        return this.triggerConditionFromJSON((JSONObject)propertyJSONObject);
    }

    @Nullable
    public final TriggerCondition itemAtIndex(int index) {
        if (CTXtensions.isInvalidIndex(this.items, index)) {
            return null;
        }
        JSONArray jSONArray = this.items;
        if (jSONArray == null || (jSONArray = jSONArray.optJSONObject(index)) == null) {
            return null;
        }
        JSONArray itemJSONObject = jSONArray;
        return this.triggerConditionFromJSON((JSONObject)itemJSONObject);
    }

    @Nullable
    public final TriggerGeoRadius geoRadiusAtIndex(int index) {
        if (CTXtensions.isInvalidIndex(this.geoRadiusArray, index)) {
            return null;
        }
        JSONArray jSONArray = this.geoRadiusArray;
        if (jSONArray == null || (jSONArray = jSONArray.optJSONObject(index)) == null) {
            return null;
        }
        JSONArray geoRadiusItem = jSONArray;
        double latitude = geoRadiusItem.optDouble("lat");
        double longitude = geoRadiusItem.optDouble("lng");
        double radius = geoRadiusItem.optDouble("rad");
        return new TriggerGeoRadius(latitude, longitude, radius);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/clevertap/android/sdk/inapp/evaluation/TriggerAdapter$Companion;", "", "<init>", "()V", "KEY_FIRST_TIME_ONLY", "", "KEY_EVENT_NAME", "KEY_EVENT_PROPERTIES", "KEY_ITEM_PROPERTIES", "KEY_GEO_RADIUS_PROPERTIES", "KEY_PROFILE_ATTR_NAME", "KEY_PROPERTY_VALUE", "INAPP_OPERATOR", "INAPP_PROPERTYNAME", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

