/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.cryption;

import android.content.Context;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.cryption.ICryptRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptRepository;", "Lcom/clevertap/android/sdk/cryption/ICryptRepository;", "context", "Landroid/content/Context;", "accountId", "", "<init>", "(Landroid/content/Context;Ljava/lang/String;)V", "getContext", "()Landroid/content/Context;", "getAccountId", "()Ljava/lang/String;", "migrationFailureCount", "", "isSSInAppDataMigrated", "", "updateIsSSInAppDataMigrated", "", "migrated", "storedEncryptionLevel", "localEncryptionKey", "updateLocalEncryptionKey", "key", "updateEncryptionLevel", "configEncryptionLevel", "updateMigrationFailureCount", "migrationSuccessful", "clevertap-core_release"})
public final class CryptRepository
implements ICryptRepository {
    @NotNull
    private final Context context;
    @NotNull
    private final String accountId;
    private int migrationFailureCount;

    public CryptRepository(@NotNull Context context, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        this.context = context;
        this.accountId = accountId;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final String getAccountId() {
        return this.accountId;
    }

    @Override
    public boolean isSSInAppDataMigrated() {
        return StorageHelper.getBoolean(this.context, StorageHelper.storageKeyWithSuffix(this.accountId, "ssInAppMigrated"), false);
    }

    @Override
    public void updateIsSSInAppDataMigrated(boolean migrated) {
        StorageHelper.putBoolean(this.context, StorageHelper.storageKeyWithSuffix(this.accountId, "ssInAppMigrated"), migrated);
    }

    @Override
    public int storedEncryptionLevel() {
        return StorageHelper.getInt(this.context, StorageHelper.storageKeyWithSuffix(this.accountId, "encryptionLevel"), -1);
    }

    @Override
    public int migrationFailureCount() {
        return StorageHelper.getInt(this.context, StorageHelper.storageKeyWithSuffix(this.accountId, "encryptionMigrationFailureCount"), -1);
    }

    @Override
    @Nullable
    public String localEncryptionKey() {
        String encodedKey = StorageHelper.getString(this.context, "EncryptionKey", null);
        return encodedKey;
    }

    @Override
    public void updateLocalEncryptionKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        StorageHelper.putString(this.context, "EncryptionKey", key);
    }

    @Override
    public void updateEncryptionLevel(int configEncryptionLevel) {
        StorageHelper.putInt(this.context, StorageHelper.storageKeyWithSuffix(this.accountId, "encryptionLevel"), configEncryptionLevel);
    }

    @Override
    public void updateMigrationFailureCount(boolean migrationSuccessful) {
        this.migrationFailureCount = migrationSuccessful ? 0 : this.migrationFailureCount + 1;
        Logger.v(this.accountId, "Updating migrationFailureCount to " + this.migrationFailureCount);
        StorageHelper.putInt(this.context, StorageHelper.storageKeyWithSuffix(this.accountId, "encryptionMigrationFailureCount"), this.migrationFailureCount);
    }
}

