/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import com.clevertap.android.sdk.validation.ValidationResult;
import com.clevertap.android.sdk.validation.ValidationResultFactory;
import com.clevertap.android.sdk.validation.ValidationResultStack;
import com.clevertap.android.sdk.validation.Validator;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002J,\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0002J3\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u001a\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001aj\n\u0012\u0004\u0012\u00020\u000e\u0018\u0001`\u0019H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u0001H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/clevertap/android/sdk/ProfileValueHandler;", "", "validator", "Lcom/clevertap/android/sdk/validation/Validator;", "validationResultStack", "Lcom/clevertap/android/sdk/validation/ValidationResultStack;", "<init>", "(Lcom/clevertap/android/sdk/validation/Validator;Lcom/clevertap/android/sdk/validation/ValidationResultStack;)V", "numberValueType", "Lcom/clevertap/android/sdk/ProfileValueHandler$NumberValueType;", "handleIncrementDecrementValues", "", "value", "command", "", "existingValue", "getNumberValueType", "handleMultiValues", "Lorg/json/JSONArray;", "key", "values", "existingValues", "constructExistingMultiValue", "existing", "cleanMultiValues", "Lkotlin/collections/ArrayList;", "Ljava/util/ArrayList;", "(Ljava/lang/String;Ljava/util/ArrayList;)Lorg/json/JSONArray;", "generateEmptyMultiValueError", "", "stringifyAndCleanScalarProfilePropValue", "NumberValueType", "clevertap-core_release"})
public final class ProfileValueHandler {
    @NotNull
    private final Validator validator;
    @NotNull
    private final ValidationResultStack validationResultStack;
    @Nullable
    private NumberValueType numberValueType;

    public ProfileValueHandler(@NotNull Validator validator, @NotNull ValidationResultStack validationResultStack) {
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter((Object)validationResultStack, (String)"validationResultStack");
        this.validator = validator;
        this.validationResultStack = validationResultStack;
    }

    @Nullable
    public final Number handleIncrementDecrementValues(@NotNull Number value, @NotNull String command, @Nullable Number existingValue) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Number updatedValue = null;
        if (existingValue == null) {
            NumberValueType numberValueType = this.getNumberValueType(value);
            switch (numberValueType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[numberValueType.ordinal()]) {
                case 1: {
                    if (Intrinsics.areEqual((Object)command, (Object)"$incr")) {
                        updatedValue = value.doubleValue();
                        break;
                    }
                    if (!Intrinsics.areEqual((Object)command, (Object)"$decr")) break;
                    updatedValue = -value.doubleValue();
                    break;
                }
                case 2: {
                    if (Intrinsics.areEqual((Object)command, (Object)"$incr")) {
                        updatedValue = Float.valueOf(value.floatValue());
                        break;
                    }
                    if (!Intrinsics.areEqual((Object)command, (Object)"$decr")) break;
                    updatedValue = Float.valueOf(-value.floatValue());
                    break;
                }
                default: {
                    if (Intrinsics.areEqual((Object)command, (Object)"$incr")) {
                        updatedValue = value.intValue();
                        break;
                    }
                    if (!Intrinsics.areEqual((Object)command, (Object)"$decr")) break;
                    updatedValue = -value.intValue();
                }
            }
            return updatedValue;
        }
        NumberValueType numberValueType = this.getNumberValueType(existingValue);
        switch (numberValueType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[numberValueType.ordinal()]) {
            case 1: {
                if (Intrinsics.areEqual((Object)command, (Object)"$incr")) {
                    updatedValue = existingValue.doubleValue() + value.doubleValue();
                    break;
                }
                if (!Intrinsics.areEqual((Object)command, (Object)"$decr")) break;
                updatedValue = existingValue.doubleValue() - value.doubleValue();
                break;
            }
            case 2: {
                if (Intrinsics.areEqual((Object)command, (Object)"$incr")) {
                    updatedValue = Float.valueOf(existingValue.floatValue() + value.floatValue());
                    break;
                }
                if (!Intrinsics.areEqual((Object)command, (Object)"$decr")) break;
                updatedValue = Float.valueOf(existingValue.floatValue() - value.floatValue());
                break;
            }
            default: {
                if (Intrinsics.areEqual((Object)command, (Object)"$incr")) {
                    updatedValue = existingValue.intValue() + value.intValue();
                    break;
                }
                if (!Intrinsics.areEqual((Object)command, (Object)"$decr")) break;
                updatedValue = existingValue.intValue() - value.intValue();
            }
        }
        return updatedValue;
    }

    private final NumberValueType getNumberValueType(Number value) {
        Number number = value;
        return Intrinsics.areEqual((Object)number, (Object)value.intValue()) ? NumberValueType.INT_NUMBER : (Intrinsics.areEqual((Object)number, (Object)value.doubleValue()) ? NumberValueType.DOUBLE_NUMBER : (Intrinsics.areEqual((Object)number, (Object)Float.valueOf(value.floatValue())) ? NumberValueType.FLOAT_NUMBER : this.numberValueType));
    }

    @Nullable
    public final JSONArray handleMultiValues(@NotNull String key, @Nullable JSONArray values, @NotNull String command, @Nullable Object existingValues) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        JSONArray currentValues = this.constructExistingMultiValue(command, existingValues);
        JSONArray jSONArray = values;
        Intrinsics.checkNotNull((Object)jSONArray);
        ArrayList<String> arrayList = CTJsonConverter.toList(jSONArray);
        Intrinsics.checkNotNull(arrayList, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.String>");
        JSONArray newValues = this.cleanMultiValues(key, arrayList);
        if (currentValues == null || newValues == null) {
            return null;
        }
        String mergeOperation = Intrinsics.areEqual((Object)command, (Object)"$remove") ? "multiValuePropertyRemoveValues" : "multiValuePropertyAddValues";
        ValidationResult vr = this.validator.mergeMultiValuePropertyForKey(currentValues, newValues, mergeOperation, key);
        if (vr.getErrorCode() != 0) {
            this.validationResultStack.pushValidationResult(vr);
        }
        Object object = vr.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.JSONArray");
        JSONArray localValues = (JSONArray)object;
        return localValues.length() <= 0 ? null : localValues;
    }

    private final JSONArray constructExistingMultiValue(String command, Object existing) {
        boolean remove2 = Intrinsics.areEqual((Object)command, (Object)"$remove");
        boolean add = Intrinsics.areEqual((Object)command, (Object)"$add");
        if (!remove2 && !add) {
            return new JSONArray();
        }
        if (existing == null) {
            return remove2 ? null : new JSONArray();
        }
        if (existing instanceof JSONArray) {
            return (JSONArray)existing;
        }
        JSONArray jSONArray = add ? new JSONArray() : null;
        String stringified = this.stringifyAndCleanScalarProfilePropValue(existing);
        return stringified != null ? new JSONArray().put((Object)stringified) : jSONArray;
    }

    private final JSONArray cleanMultiValues(String key, ArrayList<String> values) {
        JSONArray jSONArray;
        try {
            if (values == null) {
                return null;
            }
            JSONArray cleanedValues = new JSONArray();
            ValidationResult vr = null;
            Iterator<String> iterator = values.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object vrValue;
                String value;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                vr = this.validator.cleanMultiValuePropertyValue(value);
                if (vr.getErrorCode() != 0) {
                    this.validationResultStack.pushValidationResult(vr);
                }
                String cleanedValue = (vrValue = vr.getObject()) != null ? vr.getObject().toString() : null;
                if (((CharSequence)value).length() == 0) {
                    this.generateEmptyMultiValueError(key);
                    return null;
                }
                cleanedValues.put((Object)cleanedValue);
            }
        }
        catch (Throwable t) {
            Logger.v("Error cleaning multi values for key " + key, t);
            this.generateEmptyMultiValueError(key);
            jSONArray = null;
        }
        return jSONArray;
    }

    private final void generateEmptyMultiValueError(String key) {
        String[] stringArray = new String[]{key};
        ValidationResult error = ValidationResultFactory.create(512, 1, stringArray);
        this.validationResultStack.pushValidationResult(error);
        Logger.v(error.getErrorDesc());
    }

    private final String stringifyAndCleanScalarProfilePropValue(Object value) {
        String cleanedValue = CTJsonConverter.toJsonString(value);
        if (cleanedValue != null) {
            Object vrValue;
            ValidationResult vr = this.validator.cleanMultiValuePropertyValue(cleanedValue);
            if (vr.getErrorCode() != 0) {
                this.validationResultStack.pushValidationResult(vr);
            }
            cleanedValue = (vrValue = vr.getObject()) != null ? vr.getObject().toString() : null;
        }
        return cleanedValue;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/clevertap/android/sdk/ProfileValueHandler$NumberValueType;", "", "<init>", "(Ljava/lang/String;I)V", "INT_NUMBER", "FLOAT_NUMBER", "DOUBLE_NUMBER", "clevertap-core_release"})
    public static final class NumberValueType
    extends Enum<NumberValueType> {
        public static final /* enum */ NumberValueType INT_NUMBER = new NumberValueType();
        public static final /* enum */ NumberValueType FLOAT_NUMBER = new NumberValueType();
        public static final /* enum */ NumberValueType DOUBLE_NUMBER = new NumberValueType();
        private static final /* synthetic */ NumberValueType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NumberValueType[] values() {
            return (NumberValueType[])$VALUES.clone();
        }

        public static NumberValueType valueOf(String value) {
            return Enum.valueOf(NumberValueType.class, value);
        }

        @NotNull
        public static EnumEntries<NumberValueType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = numberValueTypeArray = new NumberValueType[]{NumberValueType.INT_NUMBER, NumberValueType.FLOAT_NUMBER, NumberValueType.DOUBLE_NUMBER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NumberValueType.values().length];
            try {
                nArray[NumberValueType.DOUBLE_NUMBER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NumberValueType.FLOAT_NUMBER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

