/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.bitmap;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.bitmap.BitmapDownloadRequest;
import com.clevertap.android.sdk.bitmap.IBitmapDownloadRequestHandler;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.network.DownloadedBitmapFactory;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/clevertap/android/sdk/bitmap/BitmapDownloadRequestHandlerWithTimeLimit;", "Lcom/clevertap/android/sdk/bitmap/IBitmapDownloadRequestHandler;", "iBitmapDownloadRequestHandler", "<init>", "(Lcom/clevertap/android/sdk/bitmap/IBitmapDownloadRequestHandler;)V", "handleRequest", "Lcom/clevertap/android/sdk/network/DownloadedBitmap;", "bitmapDownloadRequest", "Lcom/clevertap/android/sdk/bitmap/BitmapDownloadRequest;", "clevertap-core_release"})
public final class BitmapDownloadRequestHandlerWithTimeLimit
implements IBitmapDownloadRequestHandler {
    @NotNull
    private final IBitmapDownloadRequestHandler iBitmapDownloadRequestHandler;

    public BitmapDownloadRequestHandlerWithTimeLimit(@NotNull IBitmapDownloadRequestHandler iBitmapDownloadRequestHandler) {
        Intrinsics.checkNotNullParameter((Object)iBitmapDownloadRequestHandler, (String)"iBitmapDownloadRequestHandler");
        this.iBitmapDownloadRequestHandler = iBitmapDownloadRequestHandler;
    }

    @Override
    @NotNull
    public DownloadedBitmap handleRequest(@NotNull BitmapDownloadRequest bitmapDownloadRequest) {
        Intrinsics.checkNotNullParameter((Object)bitmapDownloadRequest, (String)"bitmapDownloadRequest");
        Logger.v("handling bitmap download request in BitmapDownloadRequestHandlerWithTimeLimit....");
        boolean fallbackToAppIcon = bitmapDownloadRequest.component2();
        Context context = bitmapDownloadRequest.component3();
        CleverTapInstanceConfig instanceConfig = bitmapDownloadRequest.component4();
        long downloadTimeLimitInMillis = bitmapDownloadRequest.component5();
        if (instanceConfig == null || downloadTimeLimitInMillis == -1L) {
            Logger.v("either config is null or downloadTimeLimitInMillis is negative.");
            Logger.v("will download bitmap without time limit");
            return this.iBitmapDownloadRequestHandler.handleRequest(bitmapDownloadRequest);
        }
        Task<DownloadedBitmap> task = CTExecutorFactory.executors(instanceConfig).ioTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"ioTask(...)");
        Task<DownloadedBitmap> bitmapDownloadTask = task;
        DownloadedBitmap downloadedBitmap = bitmapDownloadTask.submitAndGetResult("getNotificationBitmap", () -> BitmapDownloadRequestHandlerWithTimeLimit.handleRequest$lambda$0(this, bitmapDownloadRequest), downloadTimeLimitInMillis);
        if (downloadedBitmap == null) {
            downloadedBitmap = DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.DOWNLOAD_FAILED);
        }
        DownloadedBitmap downloadedBitmap2 = Utils.getDownloadedBitmapPostFallbackIconCheck(fallbackToAppIcon, context, downloadedBitmap);
        Intrinsics.checkNotNullExpressionValue((Object)downloadedBitmap2, (String)"getDownloadedBitmapPostFallbackIconCheck(...)");
        return downloadedBitmap2;
    }

    private static final DownloadedBitmap handleRequest$lambda$0(BitmapDownloadRequestHandlerWithTimeLimit this$0, BitmapDownloadRequest $bitmapDownloadRequest) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bitmapDownloadRequest, (String)"$bitmapDownloadRequest");
        return this$0.iBitmapDownloadRequestHandler.handleRequest($bitmapDownloadRequest);
    }
}

