/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.bitmap.IBitmapInputStreamReader;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.network.DownloadedBitmapFactory;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0016\u0018\u00002\u00020\u0001B'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/clevertap/android/sdk/bitmap/BitmapInputStreamDecoder;", "Lcom/clevertap/android/sdk/bitmap/IBitmapInputStreamReader;", "saveBytes", "", "saveBitmap", "logger", "Lcom/clevertap/android/sdk/Logger;", "<init>", "(ZZLcom/clevertap/android/sdk/Logger;)V", "getSaveBytes", "()Z", "getSaveBitmap", "getLogger", "()Lcom/clevertap/android/sdk/Logger;", "readInputStream", "Lcom/clevertap/android/sdk/network/DownloadedBitmap;", "inputStream", "Ljava/io/InputStream;", "connection", "Ljava/net/HttpURLConnection;", "downloadStartTimeInMilliseconds", "", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nBitmapInputStreamDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapInputStreamDecoder.kt\ncom/clevertap/android/sdk/bitmap/BitmapInputStreamDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public class BitmapInputStreamDecoder
implements IBitmapInputStreamReader {
    private final boolean saveBytes;
    private final boolean saveBitmap;
    @Nullable
    private final Logger logger;

    public BitmapInputStreamDecoder(boolean saveBytes, boolean saveBitmap, @Nullable Logger logger) {
        this.saveBytes = saveBytes;
        this.saveBitmap = saveBitmap;
        this.logger = logger;
    }

    public /* synthetic */ BitmapInputStreamDecoder(boolean bl, boolean bl2, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            logger = null;
        }
        this(bl, bl2, logger);
    }

    public final boolean getSaveBytes() {
        return this.saveBytes;
    }

    public final boolean getSaveBitmap() {
        return this.saveBitmap;
    }

    @Nullable
    public final Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public DownloadedBitmap readInputStream(@NotNull InputStream inputStream, @NotNull HttpURLConnection connection, long downloadStartTimeInMilliseconds) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Logger logger = this.logger;
        if (logger != null) {
            logger.verbose("reading bitmap input stream in BitmapInputStreamDecoder....");
        }
        byte[] bufferForHttpInputStream = new byte[16384];
        ByteArrayOutputStream finalDataFromHttpInputStream = new ByteArrayOutputStream();
        int totalBytesRead = 0;
        int bytesRead = 0;
        while (true) {
            int n;
            int it = n = inputStream.read(bufferForHttpInputStream);
            boolean bl = false;
            bytesRead = it;
            if (n == -1) break;
            totalBytesRead += bytesRead;
            finalDataFromHttpInputStream.write(bufferForHttpInputStream, 0, bytesRead);
            Logger logger2 = this.logger;
            if (logger2 == null) continue;
            logger2.verbose("Downloaded " + totalBytesRead + " bytes");
        }
        Logger logger3 = this.logger;
        if (logger3 != null) {
            logger3.verbose("Total download size for bitmap = " + totalBytesRead);
        }
        byte[] dataReadFromStreamInByteArray = finalDataFromHttpInputStream.toByteArray();
        int fileLength = connection.getContentLength();
        if (fileLength != -1 && fileLength != totalBytesRead) {
            Logger logger4 = this.logger;
            if (logger4 != null) {
                logger4.debug("File not loaded completely not going forward. URL was: " + connection.getURL());
            }
            return DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.DOWNLOAD_FAILED);
        }
        DownloadedBitmap downloadedBitmap = null;
        if (this.saveBitmap) {
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])dataReadFromStreamInByteArray, (int)0, (int)dataReadFromStreamInByteArray.length);
            downloadedBitmap = bitmap != null ? DownloadedBitmapFactory.INSTANCE.successBitmap(bitmap, Utils.getNowInMillis() - downloadStartTimeInMilliseconds, (byte[])(this.saveBytes ? dataReadFromStreamInByteArray : null)) : DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.DOWNLOAD_FAILED);
        } else {
            long l = Utils.getNowInMillis() - downloadStartTimeInMilliseconds;
            Intrinsics.checkNotNull((Object)dataReadFromStreamInByteArray);
            downloadedBitmap = DownloadedBitmapFactory.INSTANCE.successBytes(l, dataReadFromStreamInByteArray);
        }
        return downloadedBitmap;
    }

    public BitmapInputStreamDecoder() {
        this(false, false, null, 7, null);
    }
}

