/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification.work;

import android.content.Context;
import androidx.work.Constraints;
import androidx.work.ExistingWorkPolicy;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.clevertap.android.sdk.CTXtensions;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.pushnotification.work.CTFlushPushImpressionsWork;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/clevertap/android/sdk/pushnotification/work/CTWorkManager;", "", "context", "Landroid/content/Context;", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "(Landroid/content/Context;Lcom/clevertap/android/sdk/CleverTapInstanceConfig;)V", "accountId", "", "logger", "Lcom/clevertap/android/sdk/Logger;", "init", "", "schedulePushImpressionsFlushWork", "clevertap-core_release"})
public final class CTWorkManager {
    @NotNull
    private final Context context;
    @NotNull
    private final String accountId;
    @NotNull
    private final Logger logger;

    public CTWorkManager(@NotNull Context context, @NotNull CleverTapInstanceConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        String string2 = config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"config.accountId");
        this.accountId = string2;
        Logger logger = config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"config.logger");
        this.logger = logger;
    }

    private final void schedulePushImpressionsFlushWork() {
        this.logger.verbose(this.accountId, "scheduling one time work request to flush push impressions...");
        try {
            Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).setRequiresCharging(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)constraints, (String)"Builder()\n              \u2026\n                .build()");
            Constraints constraints2 = constraints;
            WorkRequest workRequest = ((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(CTFlushPushImpressionsWork.class).setConstraints(constraints2)).build();
            Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"Builder(CTFlushPushImpre\u2026\n                .build()");
            OneTimeWorkRequest flushPushImpressionsWorkRequest = (OneTimeWorkRequest)workRequest;
            WorkManager.getInstance((Context)this.context).enqueueUniqueWork("CTFlushPushImpressionsOneTime", ExistingWorkPolicy.KEEP, flushPushImpressionsWorkRequest);
            this.logger.verbose(this.accountId, "Finished scheduling one time work request to flush push impressions...");
        }
        catch (Throwable t) {
            this.logger.verbose(this.accountId, "Failed to schedule one time work request to flush push impressions.", t);
            t.printStackTrace();
        }
    }

    public final void init() {
        if (CTXtensions.isPackageAndOsTargetsAbove(this.context, 26) && Utils.isMainProcess(this.context, this.context.getPackageName())) {
            this.schedulePushImpressionsFlushWork();
        }
    }
}

