/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.utils;

import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.db.DBAdapter;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inbox.CTInboxMessage;
import com.clevertap.android.sdk.validation.ValidationResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CTJsonConverter {
    public static JSONObject toJsonObject(String json, Logger logger, String accountId) {
        JSONObject cache = null;
        if (json != null) {
            try {
                cache = new JSONObject(json);
            }
            catch (Throwable t) {
                logger.verbose(accountId, "Error reading guid cache: " + t.toString());
            }
        }
        return cache != null ? cache : new JSONObject();
    }

    public static JSONObject displayUnitFromExtras(Bundle extras) throws JSONException {
        JSONObject r = new JSONObject();
        String pushJsonPayload = extras.getString("wzrk_adunit");
        Logger.v("Received Display Unit via push payload: " + pushJsonPayload);
        JSONArray displayUnits = new JSONArray();
        r.put("adUnit_notifs", (Object)displayUnits);
        JSONObject testPushObject = new JSONObject(pushJsonPayload);
        displayUnits.put((Object)testPushObject);
        return r;
    }

    public static JSONObject from(DeviceInfo deviceInfo, CoreMetaData coreMetaData, boolean enableNetworkInfoReporting, boolean deviceIsMultiUser) throws JSONException {
        JSONObject evtData = new JSONObject();
        Location locationFromUser = coreMetaData.getLocationFromUser();
        evtData.put("Build", (Object)(deviceInfo.getBuild() + ""));
        evtData.put("Version", (Object)deviceInfo.getVersionName());
        evtData.put("OS Version", (Object)deviceInfo.getOsVersion());
        evtData.put("SDK Version", deviceInfo.getSdkVersion());
        if (locationFromUser != null) {
            evtData.put("Latitude", locationFromUser.getLatitude());
            evtData.put("Longitude", locationFromUser.getLongitude());
        }
        if (deviceInfo.getGoogleAdID() != null) {
            String baseAdIDKey = "GoogleAdID";
            String adIDKey = deviceIsMultiUser ? "mt_" + baseAdIDKey : baseAdIDKey;
            evtData.put(adIDKey, (Object)deviceInfo.getGoogleAdID());
            evtData.put("GoogleAdIDLimit", deviceInfo.isLimitAdTrackingEnabled());
        }
        try {
            String cc;
            String fcmSenderId;
            boolean sslPinning;
            String spikyProxyDomain;
            String proxyDomain;
            evtData.put("Make", (Object)deviceInfo.getManufacturer());
            evtData.put("Model", (Object)deviceInfo.getModel());
            evtData.put("Carrier", (Object)deviceInfo.getCarrier());
            evtData.put("useIP", enableNetworkInfoReporting);
            evtData.put("OS", (Object)deviceInfo.getOsName());
            evtData.put("wdt", deviceInfo.getWidth());
            evtData.put("hgt", deviceInfo.getHeight());
            evtData.put("dpi", deviceInfo.getDPI());
            evtData.put("dt", DeviceInfo.getDeviceType(deviceInfo.getContext()));
            evtData.put("locale", (Object)deviceInfo.getLocale());
            if (Build.VERSION.SDK_INT >= 28) {
                evtData.put("abckt", (Object)deviceInfo.getAppBucket());
            }
            if (deviceInfo.getLibrary() != null) {
                evtData.put("lib", (Object)deviceInfo.getLibrary());
            }
            if (!TextUtils.isEmpty((CharSequence)(proxyDomain = ManifestInfo.getInstance(deviceInfo.getContext()).getProxyDomain()))) {
                evtData.put("proxyDomain", (Object)proxyDomain);
            }
            if (!TextUtils.isEmpty((CharSequence)(spikyProxyDomain = ManifestInfo.getInstance(deviceInfo.getContext()).getSpikeyProxyDomain()))) {
                evtData.put("spikyProxyDomain", (Object)spikyProxyDomain);
            }
            if (sslPinning = ManifestInfo.getInstance(deviceInfo.getContext()).isSSLPinningEnabled()) {
                evtData.put("sslpin", true);
            }
            if (!TextUtils.isEmpty((CharSequence)(fcmSenderId = ManifestInfo.getInstance(deviceInfo.getContext()).getFCMSenderId()))) {
                evtData.put("fcmsid", true);
            }
            if ((cc = deviceInfo.getCountryCode()) != null && !cc.equals("")) {
                evtData.put("cc", (Object)cc);
            }
            if (enableNetworkInfoReporting) {
                String radio;
                String bluetoothVersion;
                Boolean isBluetoothEnabled;
                Boolean isWifi = deviceInfo.isWifiConnected();
                if (isWifi != null) {
                    evtData.put("wifi", (Object)isWifi);
                }
                if ((isBluetoothEnabled = deviceInfo.isBluetoothEnabled()) != null) {
                    evtData.put("BluetoothEnabled", (Object)isBluetoothEnabled);
                }
                if ((bluetoothVersion = deviceInfo.getBluetoothVersion()) != null) {
                    evtData.put("BluetoothVersion", (Object)bluetoothVersion);
                }
                if ((radio = deviceInfo.getNetworkType()) != null) {
                    evtData.put("Radio", (Object)radio);
                }
            }
            evtData.put("LIAMC", deviceInfo.getLocalInAppCount());
            HashMap<String, Integer> allCustomSdkVersions = coreMetaData.getAllCustomSdkVersions();
            for (Map.Entry<String, Integer> entries : allCustomSdkVersions.entrySet()) {
                evtData.put(entries.getKey(), (Object)entries.getValue());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return evtData;
    }

    public static JSONObject getErrorObject(ValidationResult vr) {
        JSONObject error = new JSONObject();
        try {
            error.put("c", vr.getErrorCode());
            error.put("d", (Object)vr.getErrorDesc());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return error;
    }

    public static JSONArray getRenderedTargetList(DBAdapter dbAdapter) {
        String[] pushIds = dbAdapter.fetchPushNotificationIds();
        JSONArray renderedTargets = new JSONArray();
        for (String pushId : pushIds) {
            Logger.v("RTL IDs -" + pushId);
            renderedTargets.put((Object)pushId);
        }
        return renderedTargets;
    }

    public static JSONObject getWzrkFields(CTInAppNotification root) throws JSONException {
        JSONObject fields = new JSONObject();
        JSONObject jsonObject = root.getJsonDescription();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String keyName = (String)iterator.next();
            if (!keyName.startsWith("wzrk_")) continue;
            fields.put(keyName, jsonObject.get(keyName));
        }
        return fields;
    }

    public static JSONObject getWzrkFields(CTInboxMessage root) {
        return root.getWzrkParams();
    }

    public static <T> Object[] toArray(@NonNull JSONArray jsonArray) {
        Object[] array = new Object[jsonArray.length()];
        try {
            for (int i = 0; i < jsonArray.length(); ++i) {
                array[i] = jsonArray.get(i);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return array;
    }

    public static JSONArray toJsonArray(@NonNull List<?> list) {
        JSONArray array = new JSONArray();
        for (Object item : list) {
            if (item == null) continue;
            array.put(item);
        }
        return array;
    }

    public static String toJsonString(Object value) {
        String val = null;
        try {
            val = value.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static ArrayList<?> toList(@NonNull JSONArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            try {
                list.add(array.get(i));
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

