/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification.fcm;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.interfaces.INotificationParser;
import com.clevertap.android.sdk.interfaces.IPushAmpHandler;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.PushNotificationHandler;
import com.clevertap.android.sdk.pushnotification.fcm.FcmNotificationBundleManipulation;
import com.clevertap.android.sdk.pushnotification.fcm.FcmNotificationParser;
import com.clevertap.android.sdk.pushnotification.fcm.IFcmMessageHandler;
import com.google.firebase.messaging.RemoteMessage;

public class CTFcmMessageHandler
implements IFcmMessageHandler,
IPushAmpHandler<RemoteMessage> {
    private final INotificationParser<RemoteMessage> mParser;

    public CTFcmMessageHandler() {
        this(new FcmNotificationParser());
    }

    CTFcmMessageHandler(INotificationParser<RemoteMessage> parser) {
        this.mParser = parser;
    }

    @Override
    public boolean createNotification(Context context, RemoteMessage message) {
        boolean isSuccess = false;
        Bundle messageBundle = this.mParser.toBundle(message);
        if (messageBundle != null) {
            messageBundle = new FcmNotificationBundleManipulation(messageBundle).addPriority(message).build();
            isSuccess = PushNotificationHandler.getPushNotificationHandler().onMessageReceived(context, messageBundle, PushConstants.PushType.FCM.toString());
        }
        return isSuccess;
    }

    @Override
    public boolean onNewToken(Context applicationContext, String token) {
        boolean isSuccess = false;
        try {
            PushNotificationHandler.getPushNotificationHandler().onNewToken(applicationContext, token, PushConstants.PushType.FCM.getType());
            Logger.d("PushProvider", PushConstants.FCM_LOG_TAG + "New token received from FCM - " + token);
            isSuccess = true;
        }
        catch (Throwable t) {
            Logger.d("PushProvider", PushConstants.FCM_LOG_TAG + "Error onNewToken", t);
        }
        return isSuccess;
    }

    @Override
    public void processPushAmp(Context context, @NonNull RemoteMessage message) {
        Bundle messageBundle = this.mParser.toBundle(message);
        if (messageBundle != null) {
            CleverTapAPI.processPushNotification(context, messageBundle);
        }
    }
}

