/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.inapp.CTInAppAction;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CTInAppNotificationButton
implements Parcelable {
    public static final Parcelable.Creator<CTInAppNotificationButton> CREATOR = new Parcelable.Creator<CTInAppNotificationButton>(){

        public CTInAppNotificationButton createFromParcel(Parcel in) {
            return new CTInAppNotificationButton(in);
        }

        public CTInAppNotificationButton[] newArray(int size) {
            return new CTInAppNotificationButton[size];
        }
    };
    private String backgroundColor;
    private String borderColor;
    private String borderRadius;
    private String error;
    private JSONObject jsonDescription;
    private String text;
    private String textColor;
    private CTInAppAction action;

    CTInAppNotificationButton() {
    }

    protected CTInAppNotificationButton(Parcel in) {
        this.text = in.readString();
        this.textColor = in.readString();
        this.backgroundColor = in.readString();
        this.borderColor = in.readString();
        this.borderRadius = in.readString();
        try {
            this.jsonDescription = in.readByte() == 0 ? null : new JSONObject(in.readString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.error = in.readString();
        this.action = (CTInAppAction)in.readParcelable(CTInAppAction.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public HashMap<String, String> getKeyValues() {
        return this.action != null ? this.action.getKeyValues() : null;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.text);
        dest.writeString(this.textColor);
        dest.writeString(this.backgroundColor);
        dest.writeString(this.borderColor);
        dest.writeString(this.borderRadius);
        if (this.jsonDescription == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.jsonDescription.toString());
        }
        dest.writeString(this.error);
        dest.writeParcelable((Parcelable)this.action, flags);
    }

    String getBackgroundColor() {
        return this.backgroundColor;
    }

    String getBorderColor() {
        return this.borderColor;
    }

    String getBorderRadius() {
        return this.borderRadius;
    }

    String getError() {
        return this.error;
    }

    public String getText() {
        return this.text;
    }

    String getTextColor() {
        return this.textColor;
    }

    public CTInAppAction getAction() {
        return this.action;
    }

    CTInAppNotificationButton initWithJSON(JSONObject jsonObject) {
        this.jsonDescription = jsonObject;
        this.text = jsonObject.optString("text");
        this.textColor = jsonObject.optString("color", "#0000FF");
        this.backgroundColor = jsonObject.optString("bg", "#FFFFFF");
        this.borderColor = jsonObject.optString("border", "#FFFFFF");
        this.borderRadius = jsonObject.optString("radius");
        this.action = CTInAppAction.createFromJson(jsonObject.optJSONObject("actions"));
        return this;
    }
}

