/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.audiovisualization;

import android.opengl.GLES20;
import com.cleveroad.audiovisualization.GLShape;
import com.cleveroad.audiovisualization.Utils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Random;

class GLWave
extends GLShape {
    public static final byte DIRECTION_UP = 0;
    public static final byte DIRECTION_DOWN = 1;
    private static final float SMOOTH_A = 0.35f;
    private static final int POINTS_PER_WAVE = 40;
    private static final int ADDITIONAL_POINTS = 5;
    private static final int SKIP = (int)Math.ceil(2.5) * 3;
    private FloatBuffer vertexBuffer;
    private ShortBuffer shortBuffer;
    private final Random random;
    private final float fromX;
    private final float toX;
    private final float fromY;
    private final float toY;
    private float[] vertices;
    private float currentAngle;
    private float coefficient;
    private float latestCoefficient;
    private float prevVal;
    float waveX = 0.0f;

    public GLWave(float[] color2, float fromX, float toX, float fromY, float toY, byte direction, Random random) {
        super(color2);
        this.fromX = fromX;
        this.toX = toX;
        this.fromY = fromY;
        this.toY = toY;
        this.random = random;
        this.currentAngle = direction == 0 ? 0.0f : (float)Math.PI;
        this.initVertices();
        this.initIndices();
    }

    private void initIndices() {
        short[] indices = new short[129];
        for (int i = 0; i < indices.length / 3; ++i) {
            indices[3 * i] = 0;
            indices[3 * i + 1] = (short)(i + 1);
            indices[3 * i + 2] = (short)(i + 2);
        }
        ByteBuffer indicesByteBuffer = ByteBuffer.allocateDirect(indices.length * 2);
        indicesByteBuffer.order(ByteOrder.nativeOrder());
        this.shortBuffer = indicesByteBuffer.asShortBuffer();
        this.shortBuffer.put(indices);
        this.shortBuffer.position(0);
    }

    private void initVertices() {
        int items = 45;
        int size = items * 3;
        this.vertices = new float[size];
        this.vertices[0] = Utils.normalizeGl(0.0f, this.fromX, this.toX);
        this.vertices[1] = Utils.normalizeGl(-1.0f, this.fromY, this.toY);
        this.vertices[3] = Utils.normalizeGl(-1.0f, this.fromX, this.toX);
        this.vertices[4] = Utils.normalizeGl(-1.0f, this.fromY, this.toY);
        this.vertices[6] = this.vertices[3];
        this.vertices[7] = Utils.normalizeGl(0.0f, this.fromY, this.toY);
        this.vertices[this.vertices.length - 6] = Utils.normalizeGl(1.0f, this.fromX, this.toX);
        this.vertices[this.vertices.length - 5] = this.vertices[7];
        this.vertices[this.vertices.length - 3] = this.vertices[this.vertices.length - 6];
        this.vertices[this.vertices.length - 2] = this.vertices[4];
    }

    public void update(float dAngle) {
        if (this.vertexBuffer == null) {
            ByteBuffer vertexByteBuffer = ByteBuffer.allocateDirect(this.vertices.length * 4);
            vertexByteBuffer.order(ByteOrder.nativeOrder());
            this.vertexBuffer = vertexByteBuffer.asFloatBuffer();
            this.vertexBuffer.put(this.vertices);
            this.vertexBuffer.position(0);
        }
        float angle = this.currentAngle;
        this.currentAngle = angle += dAngle;
        if (this.coefficient == 0.0f && this.latestCoefficient > 0.0f) {
            this.coefficient = Utils.smooth(0.0f, this.latestCoefficient, 0.35f);
        }
        float val = (float)Math.sin(angle) * this.coefficient;
        if (this.prevVal > 0.0f && val <= 0.0f || this.prevVal < 0.0f && val >= 0.0f) {
            this.coefficient = Utils.smooth(this.coefficient, this.latestCoefficient, 0.35f);
            this.waveX = this.random.nextFloat() * 0.3f * (float)(this.random.nextBoolean() ? 1 : -1);
        }
        this.prevVal = val;
        int i = 0;
        double step = 0.025;
        float posX = Utils.normalizeGl(this.waveX, this.fromX, this.toX);
        float posY = Utils.normalizeGl(val, this.fromY, this.toY);
        float time = 0.0f;
        while ((double)time < 1.0 - step / 2.0) {
            this.vertices[3 * i + 1 + GLWave.SKIP] = angle;
            this.vertexBuffer.put(3 * i + SKIP, Utils.quad(time, this.vertices[6], posX, this.vertices[this.vertices.length - 6]));
            this.vertexBuffer.put(3 * i + 1 + SKIP, Utils.quad(time, this.vertices[7], posY, this.vertices[this.vertices.length - 5]));
            ++i;
            time = (float)((double)time + step);
        }
    }

    public boolean isCalmedDown() {
        return Math.abs(this.prevVal) < 0.001f;
    }

    public void setCoefficient(float coefficient) {
        this.latestCoefficient = coefficient;
    }

    public void draw() {
        GLES20.glUseProgram((int)this.getProgram());
        int positionHandle = GLES20.glGetAttribLocation((int)this.getProgram(), (String)"vPosition");
        GLES20.glEnableVertexAttribArray((int)positionHandle);
        GLES20.glVertexAttribPointer((int)positionHandle, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)this.vertexBuffer);
        int colorHandle = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"vColor");
        GLES20.glUniform4fv((int)colorHandle, (int)1, (float[])this.getColor(), (int)0);
        GLES20.glDrawElements((int)6, (int)this.shortBuffer.capacity(), (int)5123, (Buffer)this.shortBuffer);
        GLES20.glDisableVertexAttribArray((int)positionHandle);
    }
}

