/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.cardinality;

import com.clearspring.analytics.stream.cardinality.AdaptiveCounting;
import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import com.clearspring.analytics.stream.cardinality.LinearCounting;
import com.clearspring.analytics.util.IBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class CountThenEstimate
implements ICardinality,
Externalizable {
    protected static final byte LC = 1;
    protected static final byte AC = 2;
    protected static final byte HLC = 3;
    protected int tippingPoint;
    protected boolean tipped = false;
    protected IBuilder<ICardinality> builder;
    protected ICardinality estimator;
    protected Set<Object> counter;

    public CountThenEstimate() {
        this(1000, AdaptiveCounting.Builder.obyCount(1000000000L));
    }

    public CountThenEstimate(int tippingPoint, IBuilder<ICardinality> builder) {
        this.tippingPoint = tippingPoint;
        this.builder = builder;
        this.counter = new HashSet<Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountThenEstimate(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInput in = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            in = new ObjectInputStream(bais);
            this.readExternal(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        if (!this.tipped && this.builder.sizeof() <= bytes.length) {
            this.tip();
        }
    }

    @Override
    public long cardinality() {
        if (this.tipped) {
            return this.estimator.cardinality();
        }
        return this.counter.size();
    }

    @Override
    public boolean offer(Object o) {
        boolean modified = false;
        if (this.tipped) {
            modified = this.estimator.offer(o);
        } else if (this.counter.add(o)) {
            modified = true;
            if (this.counter.size() > this.tippingPoint) {
                this.tip();
            }
        }
        return modified;
    }

    @Override
    public int sizeof() {
        if (this.tipped) {
            return this.estimator.sizeof();
        }
        return -1;
    }

    private void tip() {
        this.estimator = this.builder.build();
        for (Object o : this.counter) {
            this.estimator.offer(o);
        }
        this.counter = null;
        this.builder = null;
        this.tipped = true;
    }

    public boolean tipped() {
        return this.tipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes() throws IOException {
        byte[] bytes = null;
        ObjectOutput out = null;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            this.writeExternal(out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        try {
            bytes = baos.toByteArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return bytes;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tipped = in.readBoolean();
        if (this.tipped) {
            byte type = in.readByte();
            byte[] bytes = new byte[in.readInt()];
            in.readFully(bytes);
            switch (type) {
                case 1: {
                    this.estimator = new LinearCounting(bytes);
                    break;
                }
                case 2: {
                    this.estimator = new AdaptiveCounting(bytes);
                    break;
                }
                case 3: {
                    this.estimator = HyperLogLog.Builder.build(bytes);
                    break;
                }
                default: {
                    throw new IOException("Unrecognized estimator type: " + type);
                }
            }
        } else {
            this.tippingPoint = in.readInt();
            this.builder = (IBuilder)in.readObject();
            int count = in.readInt();
            assert (count <= this.tippingPoint) : String.format("Invalid serialization: count (%d) > tippingPoint (%d)", count, this.tippingPoint);
            this.counter = new HashSet<Object>(count);
            for (int i = 0; i < count; ++i) {
                this.counter.add(in.readObject());
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.tipped);
        if (this.tipped) {
            if (this.estimator instanceof LinearCounting) {
                out.writeByte(1);
            } else if (this.estimator instanceof AdaptiveCounting) {
                out.writeByte(2);
            } else if (this.estimator instanceof HyperLogLog) {
                out.writeByte(3);
            } else {
                throw new IOException("Estimator unsupported for serialization: " + this.estimator.getClass().getName());
            }
            byte[] bytes = this.estimator.getBytes();
            out.writeInt(bytes.length);
            out.write(bytes);
        } else {
            out.writeInt(this.tippingPoint);
            out.writeObject(this.builder);
            out.writeInt(this.counter.size());
            for (Object o : this.counter) {
                out.writeObject(o);
            }
        }
    }

    @Override
    public ICardinality merge(ICardinality ... estimators) throws CardinalityMergeException {
        int numEstimators = estimators == null ? 0 : estimators.length;
        CountThenEstimate[] ces = new CountThenEstimate[numEstimators + 1];
        if (numEstimators > 0) {
            for (int i = 0; i < numEstimators; ++i) {
                if (!(estimators[i] instanceof CountThenEstimate)) {
                    throw new CountThenEstimateMergeException("Unable to merge CountThenEstimate with " + estimators[i].getClass().getName());
                }
                ces[i] = (CountThenEstimate)estimators[i];
            }
        }
        ces[numEstimators] = this;
        return CountThenEstimate.mergeEstimators(ces);
    }

    public static CountThenEstimate mergeEstimators(CountThenEstimate ... estimators) throws CardinalityMergeException {
        int numEstimators;
        CountThenEstimate merged = null;
        int n = numEstimators = estimators == null ? 0 : estimators.length;
        if (numEstimators > 0) {
            ArrayList<ICardinality> tipped = new ArrayList<ICardinality>(numEstimators);
            ArrayList<CountThenEstimate> untipped = new ArrayList<CountThenEstimate>(numEstimators);
            for (CountThenEstimate estimator : estimators) {
                if (estimator.tipped) {
                    tipped.add(estimator.estimator);
                    continue;
                }
                untipped.add(estimator);
            }
            if (untipped.size() > 0) {
                merged = new CountThenEstimate(0, ((CountThenEstimate)untipped.get((int)0)).builder);
                merged.tip();
                for (CountThenEstimate cte : untipped) {
                    for (Object o : cte.counter) {
                        merged.estimator.offer(o);
                    }
                }
            } else {
                merged = new CountThenEstimate(0, new LinearCounting.Builder(1));
                merged.tip();
                merged.estimator = (ICardinality)tipped.remove(0);
            }
            merged.estimator = merged.estimator.merge(tipped.toArray(new ICardinality[tipped.size()]));
        }
        return merged;
    }

    protected static class CountThenEstimateMergeException
    extends CardinalityMergeException {
        public CountThenEstimateMergeException(String message) {
            super(message);
        }
    }
}

