/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.sast.utils.zip;

import com.cx.restclient.sast.utils.zip.ZipListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;

public class Zipper {
    private final Logger log;

    public Zipper(Logger log) {
        this.log = log;
    }

    public void zip(File baseDir, String[] filterIncludePatterns, String[] filterExcludePatterns, OutputStream outputStream, long maxZipSize, ZipListener listener) throws IOException {
        assert (baseDir != null) : "baseDir must not be null";
        assert (outputStream != null) : "outputStream must not be null";
        DirectoryScanner ds = this.createDirectoryScanner(baseDir, filterIncludePatterns, filterExcludePatterns);
        ds.setFollowSymlinks(true);
        ds.scan();
        if (ds.getIncludedFiles().length == 0) {
            outputStream.close();
            this.log.info("No files to zip");
            throw new NoFilesToZip();
        }
        this.zipFile(baseDir, ds.getIncludedFiles(), outputStream, maxZipSize, listener);
    }

    private void zipFile(File baseDir, String[] files, OutputStream outputStream, long maxZipSize, ZipListener listener) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        zipOutputStream.setEncoding("UTF8");
        long compressedSize = 0L;
        double AVERAGE_ZIP_COMPRESSION_RATIO = 4.0;
        String[] arr$ = files;
        int len$ = files.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String fileName = arr$[i$];
            File file = new File(baseDir, fileName);
            if (!file.canRead()) {
                this.log.warn("Skipping unreadable file: " + file);
                continue;
            }
            if (maxZipSize > 0L && (double)compressedSize + (double)file.length() / 4.0 > (double)maxZipSize) {
                this.log.info("Maximum zip file size reached. Zip size: " + compressedSize + " bytes Limit: " + maxZipSize + " bytes");
                zipOutputStream.close();
                throw new MaxZipSizeReached(compressedSize, maxZipSize);
            }
            if (listener != null) {
                listener.updateProgress(fileName, compressedSize);
            }
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOutputStream.putNextEntry(zipEntry);
            FileInputStream fileInputStream = new FileInputStream(file);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
            fileInputStream.close();
            zipOutputStream.closeEntry();
            compressedSize += zipEntry.getCompressedSize();
        }
        zipOutputStream.close();
    }

    private DirectoryScanner createDirectoryScanner(File baseDir, String[] filterIncludePatterns, String[] filterExcludePatterns) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(baseDir);
        ds.setCaseSensitive(false);
        ds.setFollowSymlinks(false);
        ds.setErrorOnMissingDir(false);
        if (filterIncludePatterns != null && filterIncludePatterns.length > 0) {
            ds.setIncludes(filterIncludePatterns);
        }
        if (filterExcludePatterns != null && filterExcludePatterns.length > 0) {
            ds.setExcludes(filterExcludePatterns);
        }
        return ds;
    }

    private void printDebug(DirectoryScanner ds) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Base Directory: " + ds.getBasedir());
            for (String file : ds.getIncludedFiles()) {
                this.log.debug("Included: " + file);
            }
            for (String file : ds.getExcludedFiles()) {
                this.log.debug("Excluded File: " + file);
            }
            for (String file : ds.getExcludedDirectories()) {
                this.log.debug("Excluded Dir: " + file);
            }
            for (String file : ds.getNotFollowedSymlinks()) {
                this.log.debug("Not followed symbolic link: " + file);
            }
        }
    }

    public static class MaxZipSizeReached
    extends IOException {
        private long compressedSize;
        private long maxZipSize;

        public MaxZipSizeReached(long compressedSize, long maxZipSize) {
            super("Zip compressed size reached a limit of " + maxZipSize + " bytes");
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public long getMaxZipSize() {
            return this.maxZipSize;
        }
    }

    public static class NoFilesToZip
    extends IOException {
        public NoFilesToZip() {
            super("No files to zip");
        }
    }
}

