/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.sast.utils.zip;

import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.PathFilter;
import com.cx.restclient.sast.utils.zip.CxZip;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;

public abstract class CxZipUtils {
    public static File getZippedSources(CxScanConfig config, PathFilter filter, String sourceDir, Logger log) throws IOException {
        File result = config.getZipFile();
        if (result == null) {
            log.info("Zipping sources");
            Long maxZipSize = config.getMaxZipSize() != null ? (long)(config.getMaxZipSize() * 1024 * 1024) : 0x80000000L;
            CxZip cxZip = new CxZip("zippedSource", maxZipSize, log);
            result = cxZip.zipWorkspaceFolder(new File(sourceDir), filter);
            log.debug("The sources were zipped to " + result.getAbsolutePath());
        }
        return result;
    }

    public static void deleteZippedSources(File file, CxScanConfig config, Logger log) {
        boolean isZipFileProvidedExternally;
        boolean bl = isZipFileProvidedExternally = config.getZipFile() != null;
        if (!isZipFileProvidedExternally) {
            if (file.exists() && !file.delete()) {
                log.warn("Failed to delete temporary zip file: " + file.getAbsolutePath());
            } else {
                log.info("Temporary file deleted");
            }
        }
    }
}

