/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.sast.utils;

import com.cx.restclient.common.UrlUtils;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.cxArm.dto.CxArmConfig;
import com.cx.restclient.dto.CxVersion;
import com.cx.restclient.dto.EngineConfiguration;
import com.cx.restclient.dto.LoginSettings;
import com.cx.restclient.dto.Team;
import com.cx.restclient.dto.TokenLoginResponse;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.exception.CxHTTPClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import com.cx.restclient.httpClient.utils.HttpClientHelper;
import com.cx.restclient.osa.dto.ClientType;
import com.cx.restclient.sast.dto.CreateProjectRequest;
import com.cx.restclient.sast.dto.CxNameObj;
import com.cx.restclient.sast.dto.Preset;
import com.cx.restclient.sast.dto.Project;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;

public abstract class LegacyClient {
    private static final String DEFAULT_AUTH_API_PATH = "CxRestApi/auth/";
    protected CxHttpClient httpClient;
    protected CxScanConfig config;
    protected Logger log;
    private String teamPath;
    protected long projectId;

    public LegacyClient(CxScanConfig config, Logger log) throws MalformedURLException {
        this.config = config;
        this.log = log;
        this.initHttpClient(config, log);
        this.validateConfig(config);
    }

    public void setConfig(CxScanConfig config) {
        this.config = config;
    }

    public void close() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    public long resolveProjectId() throws IOException {
        List<Project> projects = this.getProjectByName(this.config.getProjectName(), this.config.getTeamId(), this.teamPath);
        if (projects == null || projects.isEmpty()) {
            if (this.config.getDenyProject().booleanValue()) {
                throw new CxClientException("Creation of the new project [{projectName}] is not authorized. Please use an existing project. \nYou can enable the creation of new projects by disabling the Deny new Checkmarx projects creation checkbox in the Checkmarx plugin global settings.\n".replace("{projectName}", this.config.getProjectName()));
            }
            CreateProjectRequest request = new CreateProjectRequest(this.config.getProjectName(), this.config.getTeamId(), this.config.getPublic());
            this.projectId = this.createNewProject(request, this.teamPath).getId();
        } else {
            this.projectId = projects.get(0).getId();
        }
        return this.projectId;
    }

    public String configureTeamPath() throws IOException, CxClientException {
        List<Team> teamList = this.populateTeamList();
        if (StringUtils.isEmpty((String)this.teamPath) && teamList != null && !teamList.isEmpty()) {
            this.teamPath = teamList.get(0).getFullName();
        }
        this.httpClient.setTeamPathHeader(this.teamPath);
        this.log.debug(" setTeamPathHeader " + this.teamPath);
        return this.teamPath;
    }

    public List<Team> getTeamList() throws IOException, CxClientException {
        return this.populateTeamList();
    }

    private List<Team> populateTeamList() throws IOException {
        return (List)((Object)this.httpClient.getRequest("auth/teams", "application/json;v=1.0", Team.class, 200, "team list", true));
    }

    public String getToken() throws IOException, CxClientException {
        LoginSettings settings = this.getDefaultLoginSettings();
        settings.setClientTypeForPasswordAuth(ClientType.CLI);
        TokenLoginResponse tokenLoginResponse = this.getHttpClient().generateToken(settings);
        return tokenLoginResponse.getRefresh_token();
    }

    public void revokeToken(String token) throws IOException, CxClientException {
        this.getHttpClient().revokeToken(token);
    }

    private Project createNewProject(CreateProjectRequest request, String teamPath) throws IOException {
        String json = HttpClientHelper.convertToJson(request);
        this.httpClient.setTeamPathHeader(teamPath);
        StringEntity entity = new StringEntity(json, StandardCharsets.UTF_8);
        return this.httpClient.postRequest("projects", "application/json;v=1.0", (HttpEntity)entity, Project.class, 201, "create new project: " + request.getName());
    }

    private List<Project> getProjectByName(String projectName, String teamId, String teamPath) throws IOException, CxClientException {
        List projects;
        block2: {
            projectName = URLEncoder.encode(projectName, "UTF-8");
            String projectNamePath = "projects?projectname={name}&teamid={teamId}".replace("{name}", projectName).replace("{teamId}", teamId);
            projects = null;
            try {
                this.httpClient.setTeamPathHeader(teamPath);
                projects = (List)((Object)this.httpClient.getRequest(projectNamePath, "application/json;v=1.0", Project.class, 200, "project by name: " + projectName, true));
            }
            catch (CxHTTPClientException ex) {
                if (ex.getStatusCode() == 404) break block2;
                throw ex;
            }
        }
        return projects;
    }

    private void initHttpClient(CxScanConfig config, Logger log) throws MalformedURLException {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)config.getUrl())) {
            this.httpClient = new CxHttpClient(UrlUtils.parseURLToString(config.getUrl(), "CxRestAPI/"), config.getCxOrigin(), config.isDisableCertificateValidation(), config.isUseSSOLogin(), config.getRefreshToken(), config.getProxyConfig(), log);
        }
    }

    public void init() throws CxClientException {
        try {
            if (this.config.isSastOrOSAEnabled()) {
                String version = this.getCxVersion();
                this.login(version);
                this.resolveTeam();
                if (this.config.isSastEnabled()) {
                    this.resolvePreset();
                }
                if (this.config.getEnablePolicyViolations()) {
                    this.resolveCxARMUrl();
                }
                this.resolveEngineConfiguration();
                this.resolveProjectId();
            }
        }
        catch (IOException e) {
            throw new CxClientException(e.getMessage());
        }
    }

    public String getCxVersion() throws IOException, CxClientException {
        String version = "";
        try {
            this.config.setCxVersion(this.httpClient.getRequest("system/version", "application/json;v=1.0", CxVersion.class, 200, "cx Version", false));
            String hotfix = "";
            try {
                if (this.config.getCxVersion().getHotFix() != null && Integer.parseInt(this.config.getCxVersion().getHotFix()) > 0) {
                    hotfix = " Hotfix [" + this.config.getCxVersion().getHotFix() + "].";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            version = this.config.getCxVersion().getVersion();
            this.log.info("Checkmarx server version [" + this.config.getCxVersion().getVersion() + "]." + hotfix);
        }
        catch (Exception ex) {
            version = "lower than 9.0";
            this.log.debug("Checkmarx server version [lower than 9.0]");
        }
        return version;
    }

    public void login() throws IOException {
        String version = this.getCxVersion();
        this.login(version);
    }

    public void login(String version) throws IOException, CxClientException {
        this.log.info("Logging into the Checkmarx service.");
        if (this.config.getToken() != null) {
            this.httpClient.setToken(this.config.getToken());
            return;
        }
        LoginSettings settings = this.getDefaultLoginSettings();
        settings.setRefreshToken(this.config.getRefreshToken());
        settings.setVersion(version);
        this.httpClient.login(settings);
    }

    public LoginSettings getDefaultLoginSettings() throws MalformedURLException {
        LoginSettings result = new LoginSettings();
        String baseUrl = UrlUtils.parseURLToString(this.config.getUrl(), DEFAULT_AUTH_API_PATH);
        result.setAccessControlBaseUrl(baseUrl);
        result.setUsername(this.config.getUsername());
        result.setPassword(this.config.getPassword());
        result.getSessionCookies().addAll(this.config.getSessionCookie());
        result.setClientTypeForPasswordAuth(ClientType.RESOURCE_OWNER);
        result.setClientTypeForRefreshToken(ClientType.CLI);
        return result;
    }

    public CxHttpClient getHttpClient() {
        return this.httpClient;
    }

    private void resolveEngineConfiguration() throws IOException {
        if (this.config.getEngineConfigurationId() == null && this.config.getEngineConfigurationName() == null) {
            this.config.setEngineConfigurationId(1);
        } else if (this.config.getEngineConfigurationName() != null) {
            List<EngineConfiguration> engineConfigurations = this.getEngineConfiguration();
            for (EngineConfiguration engineConfiguration : engineConfigurations) {
                if (!engineConfiguration.getName().equalsIgnoreCase(this.config.getEngineConfigurationName())) continue;
                this.config.setEngineConfigurationId(engineConfiguration.getId());
                this.log.info("Engine configuration: \"" + this.config.getEngineConfigurationName() + "\" was validated in server");
            }
            if (this.config.getEngineConfigurationId() == null) {
                throw new CxClientException("Engine configuration: \"" + this.config.getEngineConfigurationName() + "\" was not found in server");
            }
        }
    }

    public List<EngineConfiguration> getEngineConfiguration() throws IOException {
        this.configureTeamPath();
        this.httpClient.setTeamPathHeader(this.teamPath);
        return (List)((Object)this.httpClient.getRequest("sast/engineConfigurations", "application/json;v=1.0", EngineConfiguration.class, 200, "engine configurations", true));
    }

    public void validateConfig(CxScanConfig config) throws CxClientException {
        String message = null;
        if (config == null) {
            message = "Non-null config must be provided.";
        } else if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)config.getUrl()) && config.isSastOrOSAEnabled()) {
            message = "Server URL is required when SAST or OSA is enabled.";
        }
        if (message != null) {
            throw new CxClientException(message);
        }
    }

    private void resolveTeam() throws CxClientException, IOException {
        this.configureTeamPath();
        if (this.config.getTeamId() == null) {
            this.config.setTeamId(this.getTeamIdByName(this.config.getTeamPath()));
        }
        this.printTeamPath();
    }

    public String getTeamIdByName(String teamName) throws CxClientException, IOException {
        teamName = this.replaceDelimiters(teamName);
        List<Team> allTeams = this.getTeamList();
        for (Team team : allTeams) {
            String fullName = this.replaceDelimiters(team.getFullName());
            if (!fullName.equalsIgnoreCase(teamName)) continue;
            return team.getId();
        }
        throw new CxClientException("Could not resolve team ID from team name: " + teamName);
    }

    private String replaceDelimiters(String teamName) {
        while (teamName.contains("\\") || teamName.contains("//")) {
            teamName = teamName.replace("\\", "/");
            teamName = teamName.replace("//", "/");
        }
        return teamName;
    }

    private CxArmConfig getCxARMConfig() throws IOException, CxClientException {
        this.httpClient.setTeamPathHeader(this.teamPath);
        return this.httpClient.getRequest("/Configurations/Portal", "application/json;v=1.0", CxArmConfig.class, 200, "CxARM URL", false);
    }

    private void resolveCxARMUrl() throws CxClientException {
        try {
            this.config.setCxARMUrl(this.getCxARMConfig().getCxARMPolicyURL());
        }
        catch (Exception ex) {
            throw new CxClientException("CxARM is not available. Policy violations cannot be calculated: " + ex.getMessage());
        }
    }

    private void resolvePreset() throws CxClientException, IOException {
        if (this.config.getPresetId() == null) {
            this.config.setPresetId(this.getPresetIdByName(this.config.getPresetName()));
        }
        this.printPresetName();
    }

    public int getPresetIdByName(String presetName) throws CxClientException, IOException {
        List<Preset> allPresets = this.getPresetList();
        for (Preset preset : allPresets) {
            if (!preset.getName().equalsIgnoreCase(presetName)) continue;
            return preset.getId();
        }
        throw new CxClientException("Could not resolve preset ID from preset name: " + presetName);
    }

    public List<Preset> getPresetList() throws IOException, CxClientException {
        this.configureTeamPath();
        return (List)((Object)this.httpClient.getRequest("sast/presets", "application/json;v=1.0", Preset.class, 200, "preset list", true));
    }

    private void printPresetName() {
        try {
            String presetName = this.config.getPresetName();
            if (presetName == null) {
                presetName = this.getPresetById(this.config.getPresetId()).getName();
            }
            this.log.info("preset name: " + presetName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Preset getPresetById(int presetId) throws IOException, CxClientException {
        this.httpClient.setTeamPathHeader(this.teamPath);
        return this.httpClient.getRequest("sast/presets/" + presetId, "application/json;v=1.0", Preset.class, 200, "preset by id", false);
    }

    private void printTeamPath() {
        try {
            this.teamPath = this.config.getTeamPath();
            if (this.teamPath == null) {
                this.teamPath = this.getTeamNameById(this.config.getTeamId());
            }
            this.log.info("full team path: " + this.teamPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTeamNameById(String teamId) throws CxClientException, IOException {
        List<Team> allTeams = this.getTeamList();
        for (Team team : allTeams) {
            if (!teamId.equals(team.getId())) continue;
            return team.getFullName();
        }
        throw new CxClientException("Could not resolve team name from id: " + teamId);
    }

    public List<Project> getAllProjects() throws IOException, CxClientException {
        List projects;
        block2: {
            projects = null;
            this.configureTeamPath();
            try {
                projects = (List)((Object)this.httpClient.getRequest("projects", "application/json;v=1.0", Project.class, 200, "all projects", true));
            }
            catch (HttpResponseException ex) {
                if (ex.getStatusCode() == 404) break block2;
                throw ex;
            }
        }
        return projects;
    }

    public Project getProjectById(String projectId, String contentType) throws IOException, CxClientException {
        Project projects;
        block2: {
            String projectNamePath = "projects/{projectId}".replace("{projectId}", projectId);
            projects = null;
            try {
                this.httpClient.setTeamPathHeader(this.teamPath);
                projects = this.httpClient.getRequest(projectNamePath, contentType, Project.class, 200, "project by id: " + projectId, false);
            }
            catch (CxHTTPClientException ex) {
                if (ex.getStatusCode() == 404) break block2;
                throw ex;
            }
        }
        return projects;
    }

    public List<CxNameObj> getConfigurationSetList() throws IOException, CxClientException {
        this.configureTeamPath();
        return (List)((Object)this.httpClient.getRequest("sast/engineConfigurations", "application/json;v=1.0", CxNameObj.class, 200, "engine configurations", true));
    }

    public String getTeamPath() {
        return this.teamPath;
    }

    public void setTeamPath(String teamPath) {
        this.teamPath = teamPath;
    }
}

