/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.sast.dto;

import com.cx.restclient.cxArm.dto.Policy;
import com.cx.restclient.cxArm.utils.CxARMUtils;
import com.cx.restclient.dto.Results;
import com.cx.restclient.sast.dto.CxXMLResults;
import com.cx.restclient.sast.dto.SASTStatisticsResponse;
import com.cx.restclient.sast.dto.SupportedLanguage;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class SASTResults
implements Serializable,
Results {
    private long scanId;
    private boolean sastResultsReady = false;
    private int high = 0;
    private int medium = 0;
    private int low = 0;
    private int information = 0;
    private int newHigh = 0;
    private int newMedium = 0;
    private int newLow = 0;
    private int newInfo = 0;
    private String sastScanLink;
    private String sastProjectLink;
    private String sastPDFLink;
    private String scanStart = "";
    private String scanTime = "";
    private String scanStartTime = "";
    private String scanEndTime = "";
    private String filesScanned;
    private String LOC;
    private List<CxXMLResults.Query> queryList;
    private byte[] rawXMLReport;
    private byte[] PDFReport;
    private String pdfFileName;
    private List<Policy> sastPolicies = new ArrayList<Policy>();

    public void setScanDetailedReport(CxXMLResults reportObj) {
        this.scanStart = reportObj.getScanStart();
        this.scanTime = reportObj.getScanTime();
        this.setScanStartEndDates(this.scanStart, this.scanTime);
        this.LOC = reportObj.getLinesOfCodeScanned();
        this.filesScanned = reportObj.getFilesScanned();
        for (CxXMLResults.Query q : reportObj.getQuery()) {
            List<CxXMLResults.Query.Result> qResult = q.getResult();
            block7: for (int i = 0; i < qResult.size(); ++i) {
                CxXMLResults.Query.Result result = qResult.get(i);
                if ("True".equals(result.getFalsePositive())) {
                    qResult.remove(i);
                    continue;
                }
                if (!"New".equals(result.getStatus())) continue;
                Severity sev = Severity.valueOf(result.getSeverity());
                switch (sev) {
                    case High: {
                        ++this.newHigh;
                        continue block7;
                    }
                    case Medium: {
                        ++this.newMedium;
                        continue block7;
                    }
                    case Low: {
                        ++this.newLow;
                        continue block7;
                    }
                    case Information: {
                        ++this.newInfo;
                    }
                }
            }
        }
        this.queryList = reportObj.getQuery();
    }

    public void setResults(long scanId, SASTStatisticsResponse statisticsResults, String url, long projectId) {
        this.setScanId(scanId);
        this.setHigh(statisticsResults.getHighSeverity());
        this.setMedium(statisticsResults.getMediumSeverity());
        this.setLow(statisticsResults.getLowSeverity());
        this.setInformation(statisticsResults.getInfoSeverity());
        this.setSastScanLink(url, scanId, projectId);
        this.setSastProjectLink(url, projectId);
    }

    public void addPolicy(Policy policy) {
        this.sastPolicies.addAll(CxARMUtils.getPolicyList(policy));
    }

    public long getScanId() {
        return this.scanId;
    }

    public void setScanId(long scanId) {
        this.scanId = scanId;
    }

    public int getHigh() {
        return this.high;
    }

    public void setHigh(int high) {
        this.high = high;
    }

    public int getMedium() {
        return this.medium;
    }

    public void setMedium(int medium) {
        this.medium = medium;
    }

    public int getLow() {
        return this.low;
    }

    public void setLow(int low) {
        this.low = low;
    }

    public int getInformation() {
        return this.information;
    }

    public void setInformation(int information) {
        this.information = information;
    }

    public int getNewHigh() {
        return this.newHigh;
    }

    public void setNewHigh(int newHigh) {
        this.newHigh = newHigh;
    }

    public int getNewMedium() {
        return this.newMedium;
    }

    public void setNewMedium(int newMedium) {
        this.newMedium = newMedium;
    }

    public int getNewLow() {
        return this.newLow;
    }

    public void setNewLow(int newLow) {
        this.newLow = newLow;
    }

    public int getNewInfo() {
        return this.newInfo;
    }

    public void setNewInfo(int newInfo) {
        this.newInfo = newInfo;
    }

    public String getSastScanLink() {
        return this.sastScanLink;
    }

    public void setSastScanLink(String sastScanLink) {
        this.sastScanLink = sastScanLink;
    }

    public void setSastScanLink(String url, long scanId, long projectId) {
        this.sastScanLink = String.format(url + "/CxWebClient/ViewerMain.aspx?scanId=%s&ProjectID=%s", scanId, projectId);
    }

    public String getSastProjectLink() {
        return this.sastProjectLink;
    }

    public void setSastProjectLink(String sastProjectLink) {
        this.sastProjectLink = sastProjectLink;
    }

    public void setSastProjectLink(String url, long projectId) {
        this.sastProjectLink = String.format(url + "/CxWebClient/portal#/projectState/%d/Summary", projectId);
    }

    public String getSastPDFLink() {
        return this.sastPDFLink;
    }

    public void setSastPDFLink(String sastPDFLink) {
        this.sastPDFLink = sastPDFLink;
    }

    public String getScanStart() {
        return this.scanStart;
    }

    public void setScanStart(String scanStart) {
        this.scanStart = scanStart;
    }

    public String getScanTime() {
        return this.scanTime;
    }

    public void setScanTime(String scanTime) {
        this.scanTime = scanTime;
    }

    public String getScanStartTime() {
        return this.scanStartTime;
    }

    public void setScanStartTime(String scanStartTime) {
        this.scanStartTime = scanStartTime;
    }

    public String getScanEndTime() {
        return this.scanEndTime;
    }

    public void setScanEndTime(String scanEndTime) {
        this.scanEndTime = scanEndTime;
    }

    public String getFilesScanned() {
        return this.filesScanned;
    }

    public void setFilesScanned(String filesScanned) {
        this.filesScanned = filesScanned;
    }

    public boolean isSastResultsReady() {
        return this.sastResultsReady;
    }

    public void setSastResultsReady(boolean sastResultsReady) {
        this.sastResultsReady = sastResultsReady;
    }

    public String getLOC() {
        return this.LOC;
    }

    public void setLOC(String LOC) {
        this.LOC = LOC;
    }

    public void setQueryList(List<CxXMLResults.Query> queryList) {
        this.queryList = queryList;
    }

    public List<CxXMLResults.Query> getQueryList() {
        return this.queryList;
    }

    public byte[] getRawXMLReport() {
        return this.rawXMLReport;
    }

    public String getPdfFileName() {
        return this.pdfFileName;
    }

    public void setPdfFileName(String pdfFileName) {
        this.pdfFileName = pdfFileName;
    }

    public void setRawXMLReport(byte[] rawXMLReport) {
        this.rawXMLReport = rawXMLReport;
    }

    public byte[] getPDFReport() {
        return this.PDFReport;
    }

    public void setPDFReport(byte[] PDFReport) {
        this.PDFReport = PDFReport;
    }

    public boolean hasNewResults() {
        return this.newHigh + this.newMedium + this.newLow > 0;
    }

    private void setScanStartEndDates(String scanStart, String scanTime) {
        try {
            Date scanStartDate = this.createStartDate(scanStart);
            Date scanTimeDate = this.createTimeDate(scanTime);
            Date scanEndDate = this.createEndDate(scanStartDate, scanTimeDate);
            String scanStartDateFormatted = this.formatToDisplayDate(scanStartDate);
            String scanEndDateFormatted = this.formatToDisplayDate(scanEndDate);
            this.scanStartTime = scanStartDateFormatted;
            this.scanEndTime = scanEndDateFormatted;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String formatToDisplayDate(Date date) {
        String displayDatePattern = "dd/MM/yy HH:mm";
        Locale locale = Locale.ENGLISH;
        return new SimpleDateFormat(displayDatePattern, locale).format(date);
    }

    private Date createStartDate(String scanStart) throws Exception {
        Date formattedDate = null;
        for (SupportedLanguage lang : SupportedLanguage.values()) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(lang.getFormat(), lang.getLocale());
                formattedDate = formatter.parse(scanStart);
                break;
            }
            catch (Exception exception) {
            }
        }
        if (formattedDate == null) {
            throw new Exception(String.format("Failed parsing date [%s]", scanStart));
        }
        return formattedDate;
    }

    private Date createTimeDate(String scanTime) throws ParseException {
        String oldPattern = "HH'h':mm'm':ss's'";
        SimpleDateFormat oldTimeFormat = new SimpleDateFormat(oldPattern);
        oldTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return oldTimeFormat.parse(scanTime);
    }

    private Date createEndDate(Date scanStartDate, Date scanTimeDate) {
        long time = scanStartDate.getTime() + scanTimeDate.getTime();
        return new Date(time);
    }

    public List<Policy> getSastPolicies() {
        return this.sastPolicies;
    }

    public void setSastPolicies(List<Policy> sastPolicies) {
        this.sastPolicies = sastPolicies;
    }

    public static enum Severity {
        High,
        Medium,
        Low,
        Information;

    }
}

