/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.dto.scansummary;

import com.cx.restclient.ast.dto.sca.AstScaResults;
import com.cx.restclient.ast.dto.sca.report.AstScaSummaryResults;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.scansummary.ErrorSource;
import com.cx.restclient.dto.scansummary.Severity;
import com.cx.restclient.dto.scansummary.ThresholdError;
import com.cx.restclient.osa.dto.OSAResults;
import com.cx.restclient.osa.dto.OSASummaryResults;
import com.cx.restclient.sast.dto.SASTResults;
import java.util.ArrayList;
import java.util.List;

public class ScanSummary {
    private final List<ThresholdError> thresholdErrors = new ArrayList<ThresholdError>();
    private final List<Severity> newResultThresholdErrors = new ArrayList<Severity>();
    private final boolean policyViolated;

    public ScanSummary(CxScanConfig config, SASTResults sastResults, OSAResults osaResults, AstScaResults scaResults) {
        this.addSastThresholdErrors(config, sastResults);
        this.addDependencyScanThresholdErrors(config, osaResults, scaResults);
        this.addNewResultThresholdErrors(config, sastResults);
        this.policyViolated = ScanSummary.determinePolicyViolation(config, sastResults, osaResults);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (ThresholdError error : this.thresholdErrors) {
            result.append(String.format("%s severity results are above threshold. Results: %d. Threshold: %d.%n", error.getSeverity().toString().toLowerCase(), error.getValue(), error.getThreshold()));
        }
        for (Severity severity : this.newResultThresholdErrors) {
            result.append(String.format("One or more new results of %s severity%n", severity.toString().toLowerCase()));
        }
        if (this.policyViolated) {
            result.append("Project policy status : violated").append("\n");
        }
        return result.toString();
    }

    public List<ThresholdError> getThresholdErrors() {
        return this.thresholdErrors;
    }

    public boolean hasErrors() {
        return !this.thresholdErrors.isEmpty() || !this.newResultThresholdErrors.isEmpty() || this.policyViolated;
    }

    public boolean isPolicyViolated() {
        return this.policyViolated;
    }

    public boolean isSastThresholdExceeded() {
        return this.thresholdErrors.stream().anyMatch(error -> error.getSource() == ErrorSource.SAST);
    }

    public boolean isOsaThresholdExceeded() {
        return this.thresholdErrors.stream().anyMatch(error -> error.getSource() == ErrorSource.DEPENDENCY_SCANNER);
    }

    public boolean isSastThresholdForNewResultsExceeded() {
        return !this.newResultThresholdErrors.isEmpty();
    }

    private void addSastThresholdErrors(CxScanConfig config, SASTResults sastResults) {
        if (config.isSASTThresholdEffectivelyEnabled() && sastResults != null && sastResults.isSastResultsReady()) {
            this.checkForThresholdError(sastResults.getHigh(), config.getSastHighThreshold(), ErrorSource.SAST, Severity.HIGH);
            this.checkForThresholdError(sastResults.getMedium(), config.getSastMediumThreshold(), ErrorSource.SAST, Severity.MEDIUM);
            this.checkForThresholdError(sastResults.getLow(), config.getSastLowThreshold(), ErrorSource.SAST, Severity.LOW);
        }
    }

    private void addDependencyScanThresholdErrors(CxScanConfig config, OSAResults osaResults, AstScaResults scaResults) {
        if (config.isOSAThresholdEffectivelyEnabled() && scaResults != null || osaResults != null) {
            OSASummaryResults summary;
            int totalHigh = 0;
            int totalMedium = 0;
            int totalLow = 0;
            boolean hasSummary = false;
            if (scaResults != null) {
                AstScaSummaryResults summary2 = scaResults.getSummary();
                if (summary2 != null) {
                    hasSummary = true;
                    totalHigh = summary2.getHighVulnerabilityCount();
                    totalMedium = summary2.getMediumVulnerabilityCount();
                    totalLow = summary2.getLowVulnerabilityCount();
                }
            } else if (osaResults.isOsaResultsReady() && (summary = osaResults.getResults()) != null) {
                hasSummary = true;
                totalHigh = summary.getTotalHighVulnerabilities();
                totalMedium = summary.getTotalMediumVulnerabilities();
                totalLow = summary.getTotalLowVulnerabilities();
            }
            if (hasSummary) {
                this.checkForThresholdError(totalHigh, config.getOsaHighThreshold(), ErrorSource.DEPENDENCY_SCANNER, Severity.HIGH);
                this.checkForThresholdError(totalMedium, config.getOsaMediumThreshold(), ErrorSource.DEPENDENCY_SCANNER, Severity.MEDIUM);
                this.checkForThresholdError(totalLow, config.getOsaLowThreshold(), ErrorSource.DEPENDENCY_SCANNER, Severity.LOW);
            }
        }
    }

    private void addNewResultThresholdErrors(CxScanConfig config, SASTResults sastResults) {
        if (sastResults != null && sastResults.isSastResultsReady() && config.getSastNewResultsThresholdEnabled().booleanValue()) {
            String severity = config.getSastNewResultsThresholdSeverity();
            if ("LOW".equals(severity)) {
                if (sastResults.getNewLow() > 0) {
                    this.newResultThresholdErrors.add(Severity.LOW);
                }
                severity = "MEDIUM";
            }
            if ("MEDIUM".equals(severity)) {
                if (sastResults.getNewMedium() > 0) {
                    this.newResultThresholdErrors.add(Severity.MEDIUM);
                }
                severity = "HIGH";
            }
            if ("HIGH".equals(severity) && sastResults.getNewHigh() > 0) {
                this.newResultThresholdErrors.add(Severity.HIGH);
            }
        }
    }

    private static boolean determinePolicyViolation(CxScanConfig config, SASTResults sastResults, OSAResults osaResults) {
        return config.getEnablePolicyViolations() && (osaResults != null && !osaResults.getOsaPolicies().isEmpty() || sastResults != null && !sastResults.getSastPolicies().isEmpty());
    }

    private void checkForThresholdError(int value, Integer threshold, ErrorSource source, Severity severity) {
        if (threshold != null && value > threshold) {
            ThresholdError error = new ThresholdError(source, severity, value, threshold);
            this.thresholdErrors.add(error);
        }
    }
}

