/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.configuration;

import com.cx.restclient.ast.dto.sast.AstSastConfig;
import com.cx.restclient.ast.dto.sca.AstScaConfig;
import com.cx.restclient.dto.CxVersion;
import com.cx.restclient.dto.ProxyConfig;
import com.cx.restclient.dto.RemoteSourceTypes;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.dto.TokenLoginResponse;
import com.cx.restclient.sast.dto.ReportType;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.cookie.Cookie;

public class CxScanConfig
implements Serializable {
    private String cxOrigin;
    private CxVersion cxVersion;
    private boolean disableCertificateValidation = false;
    private boolean useSSOLogin = false;
    private String sourceDir;
    private String osaLocationPath;
    private File reportsDir;
    private Map<ReportType, String> reports = new HashMap<ReportType, String>();
    private String username;
    private String password;
    private String refreshToken;
    private String url;
    private String projectName;
    private String teamPath;
    private String mvnPath;
    private String teamId;
    private Boolean denyProject = false;
    private Boolean hideResults = false;
    private Boolean isPublic = true;
    private Boolean forceScan = false;
    private String presetName;
    private Integer presetId;
    private String sastFolderExclusions;
    private String sastFilterPattern;
    private Integer sastScanTimeoutInMinutes;
    private Integer osaScanTimeoutInMinutes;
    private String scanComment;
    private Boolean isIncremental = false;
    private Boolean isSynchronous = false;
    private Boolean sastThresholdsEnabled = false;
    private Integer sastHighThreshold;
    private Integer sastMediumThreshold;
    private Integer sastLowThreshold;
    private Boolean sastNewResultsThresholdEnabled = false;
    private String sastNewResultsThresholdSeverity;
    private TokenLoginResponse token;
    private Boolean generatePDFReport = false;
    private File zipFile;
    private Integer engineConfigurationId;
    private String engineConfigurationName;
    private String osaFolderExclusions;
    private String osaFilterPattern;
    private String osaArchiveIncludePatterns;
    private Boolean osaGenerateJsonReport = true;
    private Boolean osaRunInstall = false;
    private Boolean osaThresholdsEnabled = false;
    private Integer osaHighThreshold;
    private Integer osaMediumThreshold;
    private Integer osaLowThreshold;
    private Properties osaFsaConfig;
    private String osaDependenciesJson;
    private Boolean avoidDuplicateProjectScans = false;
    private boolean enablePolicyViolations = false;
    private Boolean generateXmlReport = true;
    private String cxARMUrl;
    private String[] paths;
    private RemoteSourceTypes remoteType = null;
    private String remoteSrcUser;
    private String remoteSrcPass;
    private String remoteSrcUrl;
    private int remoteSrcPort;
    private byte[] remoteSrcKeyFile;
    private String remoteSrcBranch;
    private String perforceMode;
    private Integer progressInterval;
    private Integer osaProgressInterval;
    private Integer connectionRetries;
    private String osaScanDepth;
    private Integer maxZipSize;
    private String defaultProjectName;
    private AstScaConfig astScaConfig;
    private AstSastConfig astSastConfig;
    private final Set<ScannerType> scannerTypes = new HashSet<ScannerType>();
    private final List<Cookie> sessionCookies = new ArrayList<Cookie>();
    private ProxyConfig proxyConfig;

    public String getEngineConfigurationName() {
        return this.engineConfigurationName;
    }

    public void setEngineConfigurationName(String engineConfigurationName) {
        this.engineConfigurationName = engineConfigurationName;
    }

    public CxScanConfig() {
    }

    public CxScanConfig(String url, String username, String password, String cxOrigin, boolean disableCertificateValidation) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.cxOrigin = cxOrigin;
        this.disableCertificateValidation = disableCertificateValidation;
    }

    public CxScanConfig(String url, String refreshToken, String cxOrigin, boolean disableCertificateValidation) {
        this.url = url;
        this.refreshToken = refreshToken;
        this.cxOrigin = cxOrigin;
        this.disableCertificateValidation = disableCertificateValidation;
    }

    public boolean isSastEnabled() {
        return this.scannerTypes.contains((Object)ScannerType.SAST);
    }

    public boolean isOsaEnabled() {
        return this.scannerTypes.contains((Object)ScannerType.OSA);
    }

    public boolean isAstScaEnabled() {
        return this.scannerTypes.contains((Object)ScannerType.AST_SCA);
    }

    public boolean isAstSastEnabled() {
        return this.scannerTypes.contains((Object)ScannerType.AST_SAST);
    }

    public void setSastEnabled(boolean sastEnabled) {
        if (sastEnabled) {
            this.scannerTypes.add(ScannerType.SAST);
        } else {
            this.scannerTypes.remove((Object)ScannerType.SAST);
        }
    }

    public String getCxOrigin() {
        return this.cxOrigin;
    }

    public void setCxOrigin(String cxOrigin) {
        this.cxOrigin = cxOrigin;
    }

    public boolean isDisableCertificateValidation() {
        return this.disableCertificateValidation;
    }

    public void setDisableCertificateValidation(boolean disableCertificateValidation) {
        this.disableCertificateValidation = disableCertificateValidation;
    }

    public boolean isUseSSOLogin() {
        return this.useSSOLogin;
    }

    public void setUseSSOLogin(boolean useSSOLogin) {
        this.useSSOLogin = useSSOLogin;
    }

    public Boolean getAvoidDuplicateProjectScans() {
        return this.avoidDuplicateProjectScans;
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    public String getOsaLocationPath() {
        return this.osaLocationPath;
    }

    public void setOsaLocationPath(String osaLocationPath) {
        this.osaLocationPath = osaLocationPath;
    }

    public String getEffectiveSourceDirForDependencyScan() {
        return this.osaLocationPath != null ? this.osaLocationPath : this.sourceDir;
    }

    public File getReportsDir() {
        return this.reportsDir;
    }

    public void setReportsDir(File reportsDir) {
        this.reportsDir = reportsDir;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setRefreshToken(String token) {
        this.refreshToken = token;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getTeamPath() {
        return this.teamPath;
    }

    public void setTeamPath(String teamPath) {
        if (!(StringUtils.isEmpty((CharSequence)teamPath) || teamPath.startsWith("\\") || teamPath.startsWith("/"))) {
            teamPath = "\\" + teamPath;
        }
        this.teamPath = teamPath;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public Boolean getDenyProject() {
        return this.denyProject;
    }

    public void setDenyProject(Boolean denyProject) {
        this.denyProject = denyProject;
    }

    public Boolean getPublic() {
        return this.isPublic;
    }

    public void setPublic(Boolean aPublic) {
        this.isPublic = aPublic;
    }

    public Boolean getForceScan() {
        return this.forceScan;
    }

    public void setForceScan(Boolean forceScan) {
        this.forceScan = forceScan;
    }

    public String getPresetName() {
        return this.presetName;
    }

    public void setPresetName(String presetName) {
        this.presetName = presetName;
    }

    public Integer getPresetId() {
        return this.presetId;
    }

    public void setPresetId(Integer presetId) {
        this.presetId = presetId;
    }

    public String getSastFolderExclusions() {
        return this.sastFolderExclusions;
    }

    public void setSastFolderExclusions(String sastFolderExclusions) {
        this.sastFolderExclusions = sastFolderExclusions;
    }

    public String getSastFilterPattern() {
        return this.sastFilterPattern;
    }

    public void setSastFilterPattern(String sastFilterPattern) {
        this.sastFilterPattern = sastFilterPattern;
    }

    public Integer getSastScanTimeoutInMinutes() {
        return this.sastScanTimeoutInMinutes == null ? -1 : this.sastScanTimeoutInMinutes;
    }

    public void setSastScanTimeoutInMinutes(Integer sastScanTimeoutInMinutes) {
        this.sastScanTimeoutInMinutes = sastScanTimeoutInMinutes;
    }

    public Integer getOsaScanTimeoutInMinutes() {
        return this.osaScanTimeoutInMinutes == null ? -1 : this.osaScanTimeoutInMinutes;
    }

    public void setOsaScanTimeoutInMinutes(Integer sastOsaScanTimeoutInMinutes) {
        this.osaScanTimeoutInMinutes = sastOsaScanTimeoutInMinutes;
    }

    public String getScanComment() {
        return this.scanComment;
    }

    public void setScanComment(String scanComment) {
        this.scanComment = scanComment;
    }

    public Boolean getIncremental() {
        return this.isIncremental;
    }

    public void setIncremental(Boolean incremental) {
        this.isIncremental = incremental;
    }

    public Boolean getSynchronous() {
        return this.isSynchronous;
    }

    public void setSynchronous(Boolean synchronous) {
        this.isSynchronous = synchronous;
    }

    public Boolean getSastThresholdsEnabled() {
        return this.sastThresholdsEnabled;
    }

    public void setSastThresholdsEnabled(Boolean sastThresholdsEnabled) {
        this.sastThresholdsEnabled = sastThresholdsEnabled;
    }

    public Integer getSastHighThreshold() {
        return this.sastHighThreshold;
    }

    public void setSastHighThreshold(Integer sastHighThreshold) {
        this.sastHighThreshold = sastHighThreshold;
    }

    public Integer getSastMediumThreshold() {
        return this.sastMediumThreshold;
    }

    public void setSastMediumThreshold(Integer sastMediumThreshold) {
        this.sastMediumThreshold = sastMediumThreshold;
    }

    public Integer getSastLowThreshold() {
        return this.sastLowThreshold;
    }

    public void setSastLowThreshold(Integer sastLowThreshold) {
        this.sastLowThreshold = sastLowThreshold;
    }

    public String getSastNewResultsThresholdSeverity() {
        return this.sastNewResultsThresholdSeverity;
    }

    public void setSastNewResultsThresholdSeverity(String sastNewResultsThresholdSeverity) {
        this.sastNewResultsThresholdSeverity = sastNewResultsThresholdSeverity;
    }

    public Boolean getSastNewResultsThresholdEnabled() {
        return this.sastNewResultsThresholdEnabled;
    }

    public void setSastNewResultsThresholdEnabled(Boolean sastNewResultsThresholdEnabled) {
        this.sastNewResultsThresholdEnabled = sastNewResultsThresholdEnabled;
    }

    public Boolean getGeneratePDFReport() {
        return this.generatePDFReport;
    }

    public void setGeneratePDFReport(Boolean generatePDFReport) {
        this.generatePDFReport = generatePDFReport;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    public Integer getEngineConfigurationId() {
        return this.engineConfigurationId;
    }

    public void setEngineConfigurationId(Integer engineConfigurationId) {
        this.engineConfigurationId = engineConfigurationId;
    }

    public String getOsaFilterPattern() {
        return this.osaFilterPattern;
    }

    public String getOsaFolderExclusions() {
        return this.osaFolderExclusions;
    }

    public void setOsaFolderExclusions(String osaFolderExclusions) {
        this.osaFolderExclusions = osaFolderExclusions;
    }

    public void setOsaFilterPattern(String osaFilterPattern) {
        this.osaFilterPattern = osaFilterPattern;
    }

    public String getOsaArchiveIncludePatterns() {
        return this.osaArchiveIncludePatterns;
    }

    public void setOsaArchiveIncludePatterns(String osaArchiveIncludePatterns) {
        this.osaArchiveIncludePatterns = osaArchiveIncludePatterns;
    }

    public Boolean getOsaRunInstall() {
        return this.osaRunInstall;
    }

    public void setOsaRunInstall(Boolean osaRunInstall) {
        this.osaRunInstall = osaRunInstall;
    }

    public Boolean getOsaThresholdsEnabled() {
        return this.osaThresholdsEnabled;
    }

    public void setOsaThresholdsEnabled(Boolean osaThresholdsEnabled) {
        this.osaThresholdsEnabled = osaThresholdsEnabled;
    }

    public Integer getOsaHighThreshold() {
        return this.osaHighThreshold;
    }

    public void setOsaHighThreshold(Integer osaHighThreshold) {
        this.osaHighThreshold = osaHighThreshold;
    }

    public Integer getOsaMediumThreshold() {
        return this.osaMediumThreshold;
    }

    public void setOsaMediumThreshold(Integer osaMediumThreshold) {
        this.osaMediumThreshold = osaMediumThreshold;
    }

    public Integer getOsaLowThreshold() {
        return this.osaLowThreshold;
    }

    public void setOsaLowThreshold(Integer osaLowThreshold) {
        this.osaLowThreshold = osaLowThreshold;
    }

    public Properties getOsaFsaConfig() {
        return this.osaFsaConfig;
    }

    public void setOsaFsaConfig(Properties osaFsaConfig) {
        this.osaFsaConfig = osaFsaConfig;
    }

    public String getOsaDependenciesJson() {
        return this.osaDependenciesJson;
    }

    public boolean isSASTThresholdEffectivelyEnabled() {
        return this.isSastEnabled() && this.getSastThresholdsEnabled() != false && (this.getSastHighThreshold() != null || this.getSastMediumThreshold() != null || this.getSastLowThreshold() != null);
    }

    public boolean isOSAThresholdEffectivelyEnabled() {
        return !(!this.isOsaEnabled() && !this.isAstScaEnabled() || this.getOsaThresholdsEnabled() == false || this.getOsaHighThreshold() == null && this.getOsaMediumThreshold() == null && this.getOsaLowThreshold() == null);
    }

    public void setOsaDependenciesJson(String osaDependenciesJson) {
        this.osaDependenciesJson = osaDependenciesJson;
    }

    public Boolean getOsaGenerateJsonReport() {
        return this.osaGenerateJsonReport;
    }

    public void setOsaGenerateJsonReport(Boolean osaGenerateJsonReport) {
        this.osaGenerateJsonReport = osaGenerateJsonReport;
    }

    public boolean getEnablePolicyViolations() {
        return this.enablePolicyViolations;
    }

    public void setEnablePolicyViolations(boolean enablePolicyViolations) {
        this.enablePolicyViolations = enablePolicyViolations;
    }

    public boolean isEnablePolicyViolations() {
        return this.enablePolicyViolations;
    }

    public String getCxARMUrl() {
        return this.cxARMUrl;
    }

    public void setCxARMUrl(String cxARMUrl) {
        this.cxARMUrl = cxARMUrl;
    }

    public Boolean getHideResults() {
        return this.hideResults;
    }

    public void setHideResults(Boolean hideResults) {
        this.hideResults = hideResults;
    }

    public Boolean isAvoidDuplicateProjectScans() {
        return this.avoidDuplicateProjectScans;
    }

    public void setAvoidDuplicateProjectScans(Boolean avoidDuplicateProjectScans) {
        this.avoidDuplicateProjectScans = avoidDuplicateProjectScans;
    }

    public String getRemoteSrcUser() {
        return this.remoteSrcUser;
    }

    public void setRemoteSrcUser(String remoteSrcUser) {
        this.remoteSrcUser = remoteSrcUser;
    }

    public String getRemoteSrcPass() {
        return this.remoteSrcPass;
    }

    public void setRemoteSrcPass(String remoteSrcPass) {
        this.remoteSrcPass = remoteSrcPass;
    }

    public String getRemoteSrcUrl() {
        return this.remoteSrcUrl;
    }

    public void setRemoteSrcUrl(String remoteSrcUrl) {
        this.remoteSrcUrl = remoteSrcUrl;
    }

    public int getRemoteSrcPort() {
        return this.remoteSrcPort;
    }

    public void setRemoteSrcPort(int remoteSrcPort) {
        this.remoteSrcPort = remoteSrcPort;
    }

    public byte[] getRemoteSrcKeyFile() {
        return this.remoteSrcKeyFile;
    }

    public void setRemoteSrcKeyFile(byte[] remoteSrcKeyFile) {
        this.remoteSrcKeyFile = remoteSrcKeyFile;
    }

    public RemoteSourceTypes getRemoteType() {
        return this.remoteType;
    }

    public void setRemoteType(RemoteSourceTypes remoteType) {
        this.remoteType = remoteType;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public void setPaths(String[] paths) {
        this.paths = paths;
    }

    public String getRemoteSrcBranch() {
        return this.remoteSrcBranch;
    }

    public void setRemoteSrcBranch(String remoteSrcBranch) {
        this.remoteSrcBranch = remoteSrcBranch;
    }

    public String getPerforceMode() {
        return this.perforceMode;
    }

    public void setPerforceMode(String perforceMode) {
        this.perforceMode = perforceMode;
    }

    public Boolean getGenerateXmlReport() {
        return this.generateXmlReport;
    }

    public void setGenerateXmlReport(Boolean generateXmlReport) {
        this.generateXmlReport = generateXmlReport;
    }

    public CxVersion getCxVersion() {
        return this.cxVersion;
    }

    public void setCxVersion(CxVersion cxVersion) {
        this.cxVersion = cxVersion;
    }

    public Integer getProgressInterval() {
        return this.progressInterval;
    }

    public void setProgressInterval(Integer progressInterval) {
        this.progressInterval = progressInterval;
    }

    public Integer getOsaProgressInterval() {
        return this.osaProgressInterval;
    }

    public void setOsaProgressInterval(Integer osaProgressInterval) {
        this.osaProgressInterval = osaProgressInterval;
    }

    public Integer getConnectionRetries() {
        return this.connectionRetries;
    }

    public void setConnectionRetries(Integer connectionRetries) {
        this.connectionRetries = connectionRetries;
    }

    public String getMvnPath() {
        return this.mvnPath;
    }

    public void setMvnPath(String mvnPath) {
        this.mvnPath = mvnPath;
    }

    public String getOsaScanDepth() {
        return this.osaScanDepth;
    }

    public void setOsaScanDepth(String osaScanDepth) {
        this.osaScanDepth = osaScanDepth;
    }

    public Integer getMaxZipSize() {
        return this.maxZipSize;
    }

    public void setMaxZipSize(Integer maxZipSize) {
        this.maxZipSize = maxZipSize;
    }

    public String getDefaultProjectName() {
        return this.defaultProjectName;
    }

    public void setDefaultProjectName(String defaultProjectName) {
        this.defaultProjectName = defaultProjectName;
    }

    public Map<ReportType, String> getReports() {
        return this.reports;
    }

    public void addPDFReport(String pdfReportPath) {
        this.reports.put(ReportType.PDF, pdfReportPath);
    }

    public void addXMLReport(String xmlReportPath) {
        this.reports.put(ReportType.XML, xmlReportPath);
    }

    public void addCSVReport(String csvReportPath) {
        this.reports.put(ReportType.CSV, csvReportPath);
    }

    public void addRTFReport(String rtfReportPath) {
        this.reports.put(ReportType.RTF, rtfReportPath);
    }

    public AstScaConfig getAstScaConfig() {
        return this.astScaConfig;
    }

    public void setAstScaConfig(AstScaConfig astScaConfig) {
        this.astScaConfig = astScaConfig;
    }

    public AstSastConfig getAstSastConfig() {
        return this.astSastConfig;
    }

    public void setAstSastConfig(AstSastConfig astConfig) {
        this.astSastConfig = astConfig;
    }

    public Set<ScannerType> getScannerTypes() {
        return this.scannerTypes;
    }

    public void addScannerType(ScannerType scannerType) {
        this.scannerTypes.add(scannerType);
    }

    public boolean isSastOrOSAEnabled() {
        return this.isSastEnabled() || this.isOsaEnabled();
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public void addCookie(Cookie cookie) {
        this.sessionCookies.add(cookie);
    }

    public List<Cookie> getSessionCookie() {
        return this.sessionCookies;
    }

    public TokenLoginResponse getToken() {
        return this.token;
    }

    public void setToken(TokenLoginResponse token) {
        this.token = token;
    }
}

