/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.common.summary;

import com.cx.restclient.ast.dto.sca.AstScaResults;
import com.cx.restclient.common.summary.DependencyScanResult;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.cxArm.dto.Policy;
import com.cx.restclient.dto.scansummary.ScanSummary;
import com.cx.restclient.osa.dto.OSAResults;
import com.cx.restclient.sast.dto.SASTResults;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public abstract class SummaryUtils {
    private SummaryUtils() {
    }

    public static String generateSummary(SASTResults sastResults, OSAResults osaResults, AstScaResults scaResults, CxScanConfig config) throws IOException, TemplateException {
        Configuration cfg = new Configuration(new Version("2.3.23"));
        cfg.setClassForTemplateLoading(SummaryUtils.class, "/com/cx/report");
        Template template = cfg.getTemplate("report.ftl");
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        templateData.put("config", config);
        templateData.put("sast", sastResults != null ? sastResults : new SASTResults());
        templateData.put("osa", osaResults != null ? osaResults : new OSAResults());
        templateData.put("sca", scaResults != null ? scaResults : new AstScaResults());
        DependencyScanResult dependencyScanResult = SummaryUtils.resolveDependencyResult(osaResults, scaResults);
        templateData.put("dependencyResult", dependencyScanResult != null ? dependencyScanResult : new DependencyScanResult());
        ScanSummary scanSummary = new ScanSummary(config, sastResults, osaResults, scaResults);
        boolean buildFailed = false;
        boolean policyViolated = false;
        if (config.isSastEnabled()) {
            if (sastResults.isSastResultsReady()) {
                boolean sastThresholdExceeded = scanSummary.isSastThresholdExceeded();
                boolean sastNewResultsExceeded = scanSummary.isSastThresholdForNewResultsExceeded();
                templateData.put("sastThresholdExceeded", sastThresholdExceeded);
                templateData.put("sastNewResultsExceeded", sastNewResultsExceeded);
                buildFailed = sastThresholdExceeded || sastNewResultsExceeded;
                float maxCount = Math.max(sastResults.getHigh(), Math.max(sastResults.getMedium(), sastResults.getLow()));
                float sastBarNorm = maxCount * 10.0f / 9.0f;
                float sastHighTotalHeight = (float)sastResults.getHigh() / sastBarNorm * 238.0f;
                float sastHighNewHeight = SummaryUtils.calculateNewBarHeight(sastResults.getNewHigh(), sastResults.getHigh(), sastHighTotalHeight);
                float sastHighRecurrentHeight = sastHighTotalHeight - sastHighNewHeight;
                templateData.put("sastHighTotalHeight", Float.valueOf(sastHighTotalHeight));
                templateData.put("sastHighNewHeight", Float.valueOf(sastHighNewHeight));
                templateData.put("sastHighRecurrentHeight", Float.valueOf(sastHighRecurrentHeight));
                float sastMediumTotalHeight = (float)sastResults.getMedium() / sastBarNorm * 238.0f;
                float sastMediumNewHeight = SummaryUtils.calculateNewBarHeight(sastResults.getNewMedium(), sastResults.getMedium(), sastMediumTotalHeight);
                float sastMediumRecurrentHeight = sastMediumTotalHeight - sastMediumNewHeight;
                templateData.put("sastMediumTotalHeight", Float.valueOf(sastMediumTotalHeight));
                templateData.put("sastMediumNewHeight", Float.valueOf(sastMediumNewHeight));
                templateData.put("sastMediumRecurrentHeight", Float.valueOf(sastMediumRecurrentHeight));
                float sastLowTotalHeight = (float)sastResults.getLow() / sastBarNorm * 238.0f;
                float sastLowNewHeight = SummaryUtils.calculateNewBarHeight(sastResults.getNewLow(), sastResults.getLow(), sastLowTotalHeight);
                float sastLowRecurrentHeight = sastLowTotalHeight - sastLowNewHeight;
                templateData.put("sastLowTotalHeight", Float.valueOf(sastLowTotalHeight));
                templateData.put("sastLowNewHeight", Float.valueOf(sastLowNewHeight));
                templateData.put("sastLowRecurrentHeight", Float.valueOf(sastLowRecurrentHeight));
            } else {
                buildFailed = true;
            }
        }
        if (config.isOsaEnabled() || config.isAstScaEnabled()) {
            if (dependencyScanResult != null && dependencyScanResult.isResultReady()) {
                boolean thresholdExceeded = scanSummary.isOsaThresholdExceeded();
                templateData.put("dependencyThresholdExceeded", thresholdExceeded);
                buildFailed = config.isSastEnabled() ? (buildFailed |= thresholdExceeded || buildFailed) : (buildFailed |= thresholdExceeded);
                int dependencyHigh = dependencyScanResult.getHighVulnerability();
                int dependencyMedium = dependencyScanResult.getMediumVulnerability();
                int dependencyLow = dependencyScanResult.getLowVulnerability();
                float dependencyMaxCount = Math.max(dependencyHigh, Math.max(dependencyMedium, dependencyLow));
                float dependencyBarNorm = dependencyMaxCount * 10.0f / 9.0f;
                float dependencyHighTotalHeight = (float)dependencyHigh / dependencyBarNorm * 238.0f;
                float dependencyMediumTotalHeight = (float)dependencyMedium / dependencyBarNorm * 238.0f;
                float dependencyLowTotalHeight = (float)dependencyLow / dependencyBarNorm * 238.0f;
                templateData.put("dependencyHighTotalHeight", Float.valueOf(dependencyHighTotalHeight));
                templateData.put("dependencyMediumTotalHeight", Float.valueOf(dependencyMediumTotalHeight));
                templateData.put("dependencyLowTotalHeight", Float.valueOf(dependencyLowTotalHeight));
            } else {
                buildFailed = true;
            }
        }
        if (config.getEnablePolicyViolations()) {
            int policyViolatedCount;
            Map<String, String> policies = new HashMap<String, String>();
            if (config.isSastEnabled() && !sastResults.getSastPolicies().isEmpty()) {
                policyViolated = true;
                policies = sastResults.getSastPolicies().stream().collect(Collectors.toMap(Policy::getPolicyName, Policy::getRuleName, (left, right) -> left));
            }
            if (Boolean.TRUE.equals(config.isOsaEnabled()) && osaResults != null && CollectionUtils.isNotEmpty(osaResults.getOsaPolicies())) {
                policyViolated = true;
                policies.putAll(osaResults.getOsaPolicies().stream().collect(Collectors.toMap(Policy::getPolicyName, Policy::getRuleName, (left, right) -> left)));
            }
            String policyLabel = (policyViolatedCount = policies.size()) == 1 ? "Policy" : "Policies";
            templateData.put("policyLabel", policyLabel);
            templateData.put("policyViolatedCount", policyViolatedCount);
        }
        templateData.put("policyViolated", policyViolated);
        templateData.put("buildFailed", buildFailed |= policyViolated);
        StringWriter writer = new StringWriter();
        template.process(templateData, (Writer)writer);
        return writer.toString();
    }

    private static DependencyScanResult resolveDependencyResult(OSAResults osaResults, AstScaResults scaResults) {
        DependencyScanResult dependencyScanResult = osaResults != null ? new DependencyScanResult(osaResults) : (scaResults != null ? new DependencyScanResult(scaResults) : null);
        return dependencyScanResult;
    }

    private static float calculateNewBarHeight(int newCount, int count, float totalHeight) {
        float highNewHeightPx = (float)newCount / (float)count * totalHeight;
        int minimalVisibilityHeight = 5;
        if (SummaryUtils.isNewNeedChange(totalHeight, highNewHeightPx, minimalVisibilityHeight)) {
            highNewHeightPx = minimalVisibilityHeight;
        }
        return highNewHeightPx;
    }

    private static boolean isNewNeedChange(float highTotalHeightPx, float highNewHeightPx, int minimalVisibilityHeight) {
        return highNewHeightPx > 0.0f && highNewHeightPx < (float)minimalVisibilityHeight && highTotalHeightPx > (float)(minimalVisibilityHeight * 2);
    }
}

