/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.ast;

import com.cx.restclient.ast.AstClient;
import com.cx.restclient.ast.ClientTypeResolver;
import com.cx.restclient.ast.SCAWaiter;
import com.cx.restclient.ast.dto.common.HandlerRef;
import com.cx.restclient.ast.dto.common.RemoteRepositoryInfo;
import com.cx.restclient.ast.dto.common.ScanConfig;
import com.cx.restclient.ast.dto.sca.AstScaConfig;
import com.cx.restclient.ast.dto.sca.AstScaResults;
import com.cx.restclient.ast.dto.sca.CreateProjectRequest;
import com.cx.restclient.ast.dto.sca.Project;
import com.cx.restclient.ast.dto.sca.report.AstScaSummaryResults;
import com.cx.restclient.ast.dto.sca.report.Finding;
import com.cx.restclient.ast.dto.sca.report.Package;
import com.cx.restclient.common.Scanner;
import com.cx.restclient.common.UrlUtils;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.LoginSettings;
import com.cx.restclient.dto.PathFilter;
import com.cx.restclient.dto.Results;
import com.cx.restclient.dto.ScanResults;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.dto.SourceLocationType;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import com.cx.restclient.httpClient.utils.HttpClientHelper;
import com.cx.restclient.osa.dto.ClientType;
import com.cx.restclient.sast.utils.zip.CxZipUtils;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;

public class AstScaClient
extends AstClient
implements Scanner {
    private static final String ENGINE_TYPE_FOR_API = "sca";
    public static final String ENCODING = StandardCharsets.UTF_8.name();
    private static final String TENANT_HEADER_NAME = "Account-Name";
    private static final ObjectMapper caseInsensitiveObjectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
    private String projectId;
    private String scanId;

    public AstScaClient(CxScanConfig config, Logger log) {
        super(config, log);
        AstScaConfig astScaConfig = config.getAstScaConfig();
        this.validate(astScaConfig);
        this.httpClient = this.createHttpClient(astScaConfig.getApiUrl());
        this.httpClient.addCustomHeader(TENANT_HEADER_NAME, config.getAstScaConfig().getTenant());
    }

    @Override
    protected String getScannerDisplayName() {
        return ScannerType.AST_SCA.getDisplayName();
    }

    @Override
    protected ScanConfig getScanConfig() {
        return ScanConfig.builder().type(ENGINE_TYPE_FOR_API).build();
    }

    @Override
    protected HandlerRef getBranchToScan(RemoteRepositoryInfo repoInfo) {
        if (StringUtils.isNotEmpty((CharSequence)repoInfo.getBranch())) {
            String message = String.format("Branch specification is not yet supported by %s.", this.getScannerDisplayName());
            throw new CxClientException(message);
        }
        return null;
    }

    @Override
    protected URL getEffectiveRepoUrl(RemoteRepositoryInfo repoInfo) {
        URL result;
        URL initialUrl = repoInfo.getUrl();
        String username = StringUtils.defaultString((String)repoInfo.getUsername());
        String password = StringUtils.defaultString((String)repoInfo.getPassword());
        try {
            if (StringUtils.isNotEmpty((CharSequence)username) || StringUtils.isNotEmpty((CharSequence)password)) {
                this.log.info(String.format("Adding credentials as the userinfo part of the URL, because %s only supports this kind of authentication.", this.getScannerDisplayName()));
                result = new URIBuilder(initialUrl.toURI()).setUserInfo(username, password).build().toURL();
            } else {
                result = repoInfo.getUrl();
            }
        }
        catch (Exception e) {
            throw new CxClientException("Error getting effective repo URL.");
        }
        return result;
    }

    @Override
    public void init() {
        try {
            this.login();
            this.resolveProject();
        }
        catch (IOException e) {
            throw new CxClientException("Failed to init CxSCA Client.", e);
        }
    }

    @Override
    public Results waitForScanResults() {
        this.log.info("------------------------------------Get CxSCA Results:-----------------------------------");
        this.log.info("Waiting for CxSCA scan to finish");
        SCAWaiter waiter = new SCAWaiter(this.httpClient, this.config);
        waiter.waitForScanToFinish(this.scanId);
        this.log.info("CxSCA scan finished successfully. Retrieving CxSCA scan results.");
        AstScaResults scaResult = this.retrieveScanResults();
        scaResult.setScaResultReady(true);
        return scaResult;
    }

    @Override
    public Results initiateScan() {
        this.log.info(String.format("----------------------------------- Initiating %s Scan:------------------------------------", this.getScannerDisplayName()));
        AstScaResults scaResults = new AstScaResults();
        this.scanId = null;
        try {
            AstScaConfig scaConfig = this.config.getAstScaConfig();
            SourceLocationType locationType = scaConfig.getSourceLocationType();
            HttpResponse response = locationType == SourceLocationType.REMOTE_REPOSITORY ? this.submitSourcesFromRemoteRepo(scaConfig, this.projectId) : this.submitSourcesFromLocalDir();
            this.scanId = this.extractScanIdFrom(response);
            scaResults.setScanId(this.scanId);
            return scaResults;
        }
        catch (IOException e) {
            throw new CxClientException("Error creating scan.", e);
        }
    }

    private HttpResponse submitSourcesFromLocalDir() throws IOException {
        this.log.info("Using local directory flow.");
        PathFilter filter = new PathFilter(this.config.getOsaFolderExclusions(), this.config.getOsaFilterPattern(), this.log);
        String sourceDir = this.config.getEffectiveSourceDirForDependencyScan();
        File zipFile = CxZipUtils.getZippedSources(this.config, filter, sourceDir, this.log);
        String uploadedArchiveUrl = this.getSourcesUploadUrl();
        this.uploadArchive(zipFile, uploadedArchiveUrl);
        CxZipUtils.deleteZippedSources(zipFile, this.config, this.log);
        RemoteRepositoryInfo uploadedFileInfo = new RemoteRepositoryInfo();
        uploadedFileInfo.setUrl(new URL(uploadedArchiveUrl));
        return this.sendStartScanRequest(uploadedFileInfo, SourceLocationType.LOCAL_DIRECTORY, this.projectId);
    }

    private String getSourcesUploadUrl() throws IOException {
        JsonNode response = this.httpClient.postRequest("/api/uploads", null, null, JsonNode.class, 200, "get upload URL for sources");
        if (response == null || response.get("url") == null) {
            throw new CxClientException("Unable to get the upload URL.");
        }
        return response.get("url").asText();
    }

    private void uploadArchive(File source, String uploadUrl) throws IOException {
        this.log.info("Uploading the zipped sources.");
        FileEntity request = new FileEntity(source);
        CxHttpClient uploader = this.createHttpClient(uploadUrl);
        uploader.putRequest("", "", (HttpEntity)request, JsonNode.class, 200, "upload ZIP file");
    }

    private void printWebReportLink(AstScaResults scaResult) {
        if (!StringUtils.isEmpty((CharSequence)scaResult.getWebReportLink())) {
            this.log.info(String.format("CxSCA scan results location: %s", scaResult.getWebReportLink()));
        }
    }

    @Override
    public ScanResults getLatestScanResults() {
        return new ScanResults();
    }

    void testConnection() throws IOException {
        this.login();
        this.getProjects();
    }

    public void login() throws IOException {
        this.log.info("Logging into CxSCA.");
        AstScaConfig scaConfig = this.config.getAstScaConfig();
        LoginSettings settings = new LoginSettings();
        String acUrl = scaConfig.getAccessControlUrl();
        settings.setAccessControlBaseUrl(acUrl);
        settings.setUsername(scaConfig.getUsername());
        settings.setPassword(scaConfig.getPassword());
        settings.setTenant(scaConfig.getTenant());
        ClientTypeResolver resolver = new ClientTypeResolver();
        ClientType clientType = resolver.determineClientType(acUrl);
        settings.setClientTypeForPasswordAuth(clientType);
        this.httpClient.login(settings);
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    public void testScaConnection() {
        try {
            this.testConnection();
        }
        catch (IOException e) {
            throw new CxClientException(e);
        }
    }

    private void resolveProject() throws IOException {
        String projectName = this.config.getProjectName();
        this.log.info(String.format("Getting project by name: '%s'", projectName));
        this.projectId = this.getProjectIdByName(projectName);
        if (this.projectId == null) {
            this.log.info("Project not found, creating a new one.");
            this.projectId = this.createProject(projectName);
            this.log.info(String.format("Created a project with ID %s", this.projectId));
        } else {
            this.log.info(String.format("Project already exists with ID %s", this.projectId));
        }
    }

    private String getProjectIdByName(String name) throws IOException {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new CxClientException("Non-empty project name must be provided.");
        }
        List<Project> allProjects = this.getProjects();
        return allProjects.stream().filter(project -> name.equals(project.getName())).map(Project::getId).findFirst().orElse(null);
    }

    private List<Project> getProjects() throws IOException {
        return (List)((Object)this.httpClient.getRequest("/risk-management/projects", "application/json", Project.class, 200, "CxSCA projects", true));
    }

    private String createProject(String name) throws IOException {
        CreateProjectRequest request = new CreateProjectRequest();
        request.setName(name);
        StringEntity entity = HttpClientHelper.convertToStringEntity(request);
        Project newProject = this.httpClient.postRequest("/risk-management/projects", "application/json", (HttpEntity)entity, Project.class, 201, "create a project");
        return newProject.getId();
    }

    private AstScaResults retrieveScanResults() {
        try {
            String reportId = this.getReportId();
            AstScaResults scaResults = new AstScaResults();
            scaResults.setScanId(this.scanId);
            AstScaSummaryResults scanSummary = this.getSummaryReport(reportId);
            scaResults.setSummary(scanSummary);
            this.printSummary(scanSummary, this.scanId);
            List<Finding> findings = this.getFindings(reportId);
            scaResults.setFindings(findings);
            List<Package> packages = this.getPackages(reportId);
            scaResults.setPackages(packages);
            String reportLink = this.getWebReportLink(reportId);
            scaResults.setWebReportLink(reportLink);
            this.printWebReportLink(scaResults);
            scaResults.setScaResultReady(true);
            this.log.info("Retrieved SCA results successfully.");
            return scaResults;
        }
        catch (IOException e) {
            throw new CxClientException("Error retrieving CxSCA scan results.", e);
        }
    }

    private String getWebReportLink(String reportId) {
        String MESSAGE = "Unable to generate web report link.";
        String result = null;
        try {
            String webAppUrl = this.config.getAstScaConfig().getWebAppUrl();
            if (StringUtils.isEmpty((CharSequence)webAppUrl)) {
                this.log.warn(String.format("%s Web app URL is not specified.", "Unable to generate web report link."));
            } else {
                String path = String.format("/#/projects/%s/reports/%s", URLEncoder.encode(this.projectId, ENCODING), URLEncoder.encode(reportId, ENCODING));
                result = UrlUtils.parseURLToString(webAppUrl, path);
            }
        }
        catch (MalformedURLException e) {
            this.log.warn("Unable to generate web report link: invalid web app URL.", (Throwable)e);
        }
        catch (Exception e) {
            this.log.warn("Unable to generate web report link: general error.", (Throwable)e);
        }
        return result;
    }

    private String getReportId() throws IOException {
        this.log.debug(String.format("Getting report ID by scan ID: %s", this.scanId));
        String path = String.format("/risk-management/scans/%s/riskReportId", URLEncoder.encode(this.scanId, ENCODING));
        String reportId = this.httpClient.getRequest(path, "application/json", String.class, 200, "Risk report ID", false);
        this.log.debug(String.format("Found report ID: %s", reportId));
        return reportId;
    }

    private AstScaSummaryResults getSummaryReport(String reportId) throws IOException {
        this.log.debug("Getting summary report.");
        String path = String.format("/risk-management/riskReports/%s/summary", URLEncoder.encode(reportId, ENCODING));
        return this.httpClient.getRequest(path, "application/json", AstScaSummaryResults.class, 200, "CxSCA report summary", false);
    }

    private List<Finding> getFindings(String reportId) throws IOException {
        this.log.debug("Getting findings.");
        String path = String.format("/risk-management/riskReports/%s/vulnerabilities", URLEncoder.encode(reportId, ENCODING));
        ArrayNode responseJson = this.httpClient.getRequest(path, "application/json", ArrayNode.class, 200, "CxSCA findings", false);
        Finding[] findings = (Finding[])caseInsensitiveObjectMapper.treeToValue((TreeNode)responseJson, Finding[].class);
        return Arrays.asList(findings);
    }

    private List<Package> getPackages(String reportId) throws IOException {
        this.log.debug("Getting packages.");
        String path = String.format("/risk-management/riskReports/%s/packages", URLEncoder.encode(reportId, ENCODING));
        return (List)((Object)this.httpClient.getRequest(path, "application/json", Package.class, 200, "CxSCA findings", true));
    }

    private void printSummary(AstScaSummaryResults summary, String scanId) {
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format("%n----CxSCA risk report summary----", new Object[0]));
            this.log.info(String.format("Created on: %s", summary.getCreatedOn()));
            this.log.info(String.format("Direct packages: %d", summary.getDirectPackages()));
            this.log.info(String.format("High vulnerabilities: %d", summary.getHighVulnerabilityCount()));
            this.log.info(String.format("Medium vulnerabilities: %d", summary.getMediumVulnerabilityCount()));
            this.log.info(String.format("Low vulnerabilities: %d", summary.getLowVulnerabilityCount()));
            this.log.info(String.format("Risk report ID: %s", summary.getRiskReportId()));
            this.log.info(String.format("Scan ID: %s", scanId));
            this.log.info(String.format("Risk score: %.2f", summary.getRiskScore()));
            this.log.info(String.format("Total packages: %d", summary.getTotalPackages()));
            this.log.info(String.format("Total outdated packages: %d%n", summary.getTotalOutdatedPackages()));
        }
    }

    private void validate(AstScaConfig config) {
        String error = null;
        if (config == null) {
            error = "%s config must be provided.";
        } else if (StringUtils.isEmpty((CharSequence)config.getApiUrl())) {
            error = "%s API URL must be provided.";
        } else if (StringUtils.isEmpty((CharSequence)config.getAccessControlUrl())) {
            error = "%s access control URL must be provided.";
        } else {
            RemoteRepositoryInfo repoInfo = config.getRemoteRepositoryInfo();
            if (repoInfo == null && config.getSourceLocationType() == SourceLocationType.REMOTE_REPOSITORY) {
                error = "%s remote repository info must be provided.";
            } else if (repoInfo != null && StringUtils.isNotEmpty((CharSequence)repoInfo.getBranch())) {
                error = "%s doesn't support specifying custom branches. It currently uses the default branch of a repo.";
            }
        }
        if (error != null) {
            throw new IllegalArgumentException(String.format(error, this.getScannerDisplayName()));
        }
    }
}

