/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.ast;

import com.cx.restclient.ast.dto.common.ASTConfig;
import com.cx.restclient.ast.dto.common.GitCredentials;
import com.cx.restclient.ast.dto.common.HandlerRef;
import com.cx.restclient.ast.dto.common.ProjectToScan;
import com.cx.restclient.ast.dto.common.RemoteRepositoryInfo;
import com.cx.restclient.ast.dto.common.ScanConfig;
import com.cx.restclient.ast.dto.common.ScanStartHandler;
import com.cx.restclient.ast.dto.common.StartScanRequest;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.SourceLocationType;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import com.cx.restclient.httpClient.utils.HttpClientHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;

public abstract class AstClient {
    private static final String LOCATION_HEADER = "Location";
    private static final String CREDENTIAL_TYPE_PASSWORD = "password";
    protected final CxScanConfig config;
    protected final Logger log;
    protected CxHttpClient httpClient;

    public AstClient(CxScanConfig config, Logger log) {
        this.validate(config, log);
        this.config = config;
        this.log = log;
    }

    protected abstract String getScannerDisplayName();

    protected abstract ScanConfig getScanConfig();

    protected abstract HandlerRef getBranchToScan(RemoteRepositoryInfo var1);

    protected CxHttpClient createHttpClient(String baseUrl) {
        this.log.debug("Creating HTTP client.");
        return new CxHttpClient(baseUrl, this.config.getCxOrigin(), this.config.isDisableCertificateValidation(), this.config.isUseSSOLogin(), null, this.config.getProxyConfig(), this.log);
    }

    private void validate(CxScanConfig config, Logger log) {
        if (config == null && log == null) {
            throw new CxClientException("Both scan config and log must be provided.");
        }
    }

    protected HttpResponse sendStartScanRequest(RemoteRepositoryInfo repoInfo, SourceLocationType sourceLocation, String projectId) throws IOException {
        this.log.debug("Constructing the 'start scan' request");
        ScanStartHandler handler = this.getScanStartHandler(repoInfo);
        ProjectToScan project = ProjectToScan.builder().id(projectId).type(sourceLocation.getApiValue()).handler(handler).build();
        List<ScanConfig> apiScanConfig = Collections.singletonList(this.getScanConfig());
        StartScanRequest request = StartScanRequest.builder().project(project).config(apiScanConfig).build();
        StringEntity entity = HttpClientHelper.convertToStringEntity(request);
        this.log.info("Sending a request to start scan.");
        return this.httpClient.postRequest("/api/scans", "application/json", (HttpEntity)entity, HttpResponse.class, 201, "start the scan");
    }

    protected HttpResponse submitSourcesFromRemoteRepo(ASTConfig config, String projectId) throws IOException {
        this.log.info("Using remote repository flow.");
        RemoteRepositoryInfo repoInfo = config.getRemoteRepositoryInfo();
        this.validateRepoInfo(repoInfo);
        URL sanitizedUrl = AstClient.sanitize(repoInfo.getUrl());
        this.log.info(String.format("Repository URL: %s", sanitizedUrl));
        return this.sendStartScanRequest(repoInfo, SourceLocationType.REMOTE_REPOSITORY, projectId);
    }

    private ScanStartHandler getScanStartHandler(RemoteRepositoryInfo repoInfo) {
        this.log.debug("Creating the handler object.");
        HandlerRef ref = this.getBranchToScan(repoInfo);
        GitCredentials credentials = GitCredentials.builder().type(CREDENTIAL_TYPE_PASSWORD).value(repoInfo.getPassword()).build();
        URL effectiveRepoUrl = this.getEffectiveRepoUrl(repoInfo);
        return ScanStartHandler.builder().ref(ref).username(repoInfo.getUsername()).credentials(credentials).url(effectiveRepoUrl.toString()).build();
    }

    protected URL getEffectiveRepoUrl(RemoteRepositoryInfo repoInfo) {
        return repoInfo.getUrl();
    }

    private static URL sanitize(URL url) throws MalformedURLException {
        return new URL(url.getProtocol(), url.getHost(), url.getFile());
    }

    private void validateRepoInfo(RemoteRepositoryInfo repoInfo) {
        this.log.debug("Validating remote repository info.");
        if (repoInfo == null) {
            String message = String.format("%s must be provided in %s configuration when using source location of type %s.", RemoteRepositoryInfo.class.getName(), this.getScannerDisplayName(), SourceLocationType.REMOTE_REPOSITORY.name());
            throw new CxClientException(message);
        }
    }

    protected String extractScanIdFrom(HttpResponse response) {
        String result = null;
        this.log.debug(String.format("Extracting scan ID from the '%s' response header.", LOCATION_HEADER));
        if (response != null && response.getLastHeader(LOCATION_HEADER) != null) {
            String urlPathWithScanId = response.getLastHeader(LOCATION_HEADER).getValue();
            result = FilenameUtils.getName((String)urlPathWithScanId);
        }
        if (!StringUtils.isNotEmpty(result)) {
            throw new CxClientException("Unable to get scan ID.");
        }
        this.log.info(String.format("Scan started successfully. Scan ID: %s", result));
        return result;
    }
}

