/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.FastPushbackReader;
import java.io.IOException;

public class FastPushbackBytesReader
implements FastPushbackReader {
    private int idxSnippet = 0;
    protected int line = 1;
    protected int col = 0;
    private byte[] bytes;
    private int indexBytes = 0;

    FastPushbackBytesReader(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public String getLastSnippet() {
        StringBuilder s = new StringBuilder();
        int i = this.idxSnippet;
        while (i < 256) {
            if (this.appendChar(s, i)) break;
            ++i;
        }
        i = 0;
        while (i < this.idxSnippet) {
            if (this.appendChar(s, i)) break;
            ++i;
        }
        return s.toString();
    }

    private boolean appendChar(StringBuilder s, int i) {
        byte snip;
        block5: {
            block4: {
                try {
                    if (i < this.bytes.length) break block4;
                    return true;
                }
                catch (Exception exception) {
                    return true;
                }
            }
            snip = this.bytes[i];
            if (snip != 0) break block5;
            return true;
        }
        s.appendCodePoint(snip);
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.indexBytes >= this.bytes.length) {
            return -1;
        }
        byte ch = this.bytes[this.indexBytes++];
        ++this.col;
        if (ch == 10) {
            ++this.line;
            this.col = 0;
        }
        ++this.idxSnippet;
        return ch;
    }

    @Override
    public int getCol() {
        return this.col;
    }

    @Override
    public int getLine() {
        return this.col;
    }

    @Override
    public void unread(int c) throws IOException {
        --this.indexBytes;
        if (c == 10) {
            --this.line;
        } else {
            --this.col;
        }
        --this.idxSnippet;
    }

    @Override
    public void close() throws IOException {
    }
}

