/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.ClassFactory;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.Resolver;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public class ThrowableFactory
implements ClassFactory {
    private static final String STACK_TRACE = "stackTrace";
    private static final String CAUSE = "cause";

    @Override
    public Object newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(jObj);
        for (Map.Entry<Object, Object> entry : jObj.entrySet()) {
            JsonObject jsonValue;
            Class<?> targetType;
            Object value = entry.getValue();
            if (value instanceof JsonObject && (targetType = (jsonValue = (JsonObject)value).getRawType()) != null) {
                value = resolver.toJava(targetType, jsonValue);
            }
            map.put(entry.getKey(), value);
        }
        JsonObject jsonCause = (JsonObject)jObj.get(CAUSE);
        if (jsonCause != null) {
            if (jsonCause.isEmpty()) {
                map.put(CAUSE, null);
            } else {
                Object convertedCause;
                Class<?> causeType = jsonCause.getRawType();
                if (causeType != null) {
                    convertedCause = resolver.toJava(causeType, jsonCause);
                    map.put(CAUSE, convertedCause);
                } else {
                    convertedCause = resolver.toJava((Type)((Object)Throwable.class), jsonCause);
                    map.put(CAUSE, convertedCause);
                }
            }
        }
        Throwable t = (Throwable)resolver.getConverter().convert(map, c);
        Object[] stackTrace = (Object[])jObj.get(STACK_TRACE);
        if (stackTrace != null) {
            StackTraceElement[] elements = new StackTraceElement[stackTrace.length];
            for (int i = 0; i < stackTrace.length; ++i) {
                JsonObject stackTraceMap = (JsonObject)stackTrace[i];
                elements[i] = stackTraceMap == null ? null : (StackTraceElement)resolver.toJava((Type)((Object)StackTraceElement.class), stackTraceMap);
            }
            t.setStackTrace(elements);
        }
        return t;
    }
}

