/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.ClassFactory;
import com.cedarsoftware.io.JsonClassReader;
import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.SystemUtilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class RecordFactory
implements ClassFactory {
    private static final boolean JAVA_16_OR_ABOVE = SystemUtilities.isJavaVersionAtLeast((int)16, (int)0);

    @Override
    public Object newInstance(Class<?> c, JsonObject jsonObj, Resolver resolver) {
        if (!JAVA_16_OR_ABOVE) {
            throw new JsonIoException("Record de-serialization requires Java 16 or higher [current Java version: " + System.getProperty("java.version") + "]");
        }
        try {
            Object[] recordComponents;
            ArrayList<Class> lParameterTypes = new ArrayList<Class>(jsonObj.size());
            ArrayList<Object> lParameterValues = new ArrayList<Object>(jsonObj.size());
            Method getRecordComponents = ReflectionUtils.getMethod(Class.class, (String)"getRecordComponents", (Class[])new Class[0]);
            if (getRecordComponents == null) {
                throw new NoSuchMethodException("getRecordComponents method not found - Java 16+ required for Record support");
            }
            for (Object recordComponent : recordComponents = (Object[])getRecordComponents.invoke(c, new Object[0])) {
                Class type = (Class)ReflectionUtils.call((Object)recordComponent, (String)"getType", (Object[])new Object[0]);
                lParameterTypes.add(type);
                String parameterName = (String)ReflectionUtils.call((Object)recordComponent, (String)"getName", (Object[])new Object[0]);
                JsonObject paramValueJsonObj = new JsonObject();
                paramValueJsonObj.setType(type);
                paramValueJsonObj.setValue(jsonObj.get(parameterName));
                if (resolver.valueToTarget(paramValueJsonObj)) {
                    lParameterValues.add(paramValueJsonObj.getTarget());
                    continue;
                }
                lParameterValues.add(paramValueJsonObj.getValue());
            }
            Constructor constructor = ReflectionUtils.getConstructor(c, (Class[])lParameterTypes.toArray(new Class[0]));
            if (constructor == null) {
                throw new NoSuchMethodException("Record constructor not found for class: " + c.getName() + " with parameter types: " + lParameterTypes);
            }
            return constructor.newInstance(lParameterValues.toArray(new Object[0]));
        }
        catch (JsonIoException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new JsonIoException("Failed to create Record instance: " + e.getMessage() + " [class: " + c.getName() + "]", e);
        }
        catch (ReflectiveOperationException e) {
            throw new JsonIoException("Failed to access Record components via reflection [class: " + c.getName() + "]", e);
        }
        catch (Exception e) {
            throw new JsonIoException("Unexpected error creating Record instance [class: " + c.getName() + "]", e);
        }
    }

    @Override
    public boolean isObjectFinal() {
        return true;
    }

    public static class RecordReader
    implements JsonClassReader {
        public Object read(Object o, Resolver resolver) {
            if (!JAVA_16_OR_ABOVE) {
                throw new JsonIoException("Record de-serialization requires Java 16 or higher [current Java version: " + System.getProperty("java.version") + "]");
            }
            try {
                Object[] recordComponents;
                JsonObject jsonObj = (JsonObject)o;
                ArrayList<Class> lParameterTypes = new ArrayList<Class>(jsonObj.size());
                ArrayList<Object> lParameterValues = new ArrayList<Object>(jsonObj.size());
                Class<?> c = jsonObj.getRawType();
                Method getRecordComponents = ReflectionUtils.getMethod(Class.class, (String)"getRecordComponents", (Class[])new Class[0]);
                if (getRecordComponents == null) {
                    throw new NoSuchMethodException("getRecordComponents method not found - Java 16+ required for Record support");
                }
                for (Object recordComponent : recordComponents = (Object[])getRecordComponents.invoke(c, new Object[0])) {
                    Class type = (Class)ReflectionUtils.call((Object)recordComponent, (String)"getType", (Object[])new Object[0]);
                    lParameterTypes.add(type);
                    String parameterName = (String)ReflectionUtils.call((Object)recordComponent, (String)"getName", (Object[])new Object[0]);
                    JsonObject paramValueJsonObj = new JsonObject();
                    paramValueJsonObj.setType(type);
                    paramValueJsonObj.setValue(jsonObj.get(parameterName));
                    if (resolver.valueToTarget(paramValueJsonObj)) {
                        lParameterValues.add(paramValueJsonObj.getTarget());
                        continue;
                    }
                    lParameterValues.add(paramValueJsonObj.getValue());
                }
                Constructor constructor = ReflectionUtils.getConstructor(c, (Class[])lParameterTypes.toArray(new Class[0]));
                if (constructor == null) {
                    throw new NoSuchMethodException("Record constructor not found for class: " + c.getName() + " with parameter types: " + lParameterTypes);
                }
                return constructor.newInstance(lParameterValues.toArray(new Object[0]));
            }
            catch (JsonIoException e) {
                throw e;
            }
            catch (ClassCastException e) {
                throw new JsonIoException("Failed to read Record: invalid JSON object structure [expected JsonObject, got: " + o.getClass().getSimpleName() + "]", e);
            }
            catch (NoSuchMethodException e) {
                throw new JsonIoException("Failed to create Record instance: " + e.getMessage(), e);
            }
            catch (ReflectiveOperationException e) {
                throw new JsonIoException("Failed to access Record components via reflection [class: " + ((JsonObject)o).getRawType().getName() + "]", e);
            }
            catch (Exception e) {
                String className = o instanceof JsonObject ? ((JsonObject)o).getRawType().getName() : "unknown";
                throw new JsonIoException("Unexpected error reading Record [class: " + className + "]", e);
            }
        }
    }
}

