/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.ClassFactory;
import com.cedarsoftware.io.JsonClassReader;
import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.MissingFieldHandler;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.TypeUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectResolver
extends Resolver {
    public ObjectResolver(ReadOptions readOptions, ReferenceTracker references, Converter converter) {
        super(readOptions, references, converter);
    }

    @Override
    public void traverseFields(JsonObject jsonObj) {
        if (ObjectResolver.markFinishedIfNot(jsonObj)) {
            return;
        }
        Object javaMate = jsonObj.getTarget();
        Map<String, Injector> injectorMap = this.readOptions.getDeepInjectorMap(javaMate.getClass());
        MissingFieldHandler missingFieldHandler = this.readOptions.getMissingFieldHandler();
        for (Map.Entry<Object, Object> entry : jsonObj.entrySet()) {
            String key = (String)entry.getKey();
            Injector injector = injectorMap.get(key);
            Object rhs = entry.getValue();
            if (injector != null) {
                this.assignField(jsonObj, injector, rhs);
                continue;
            }
            if (missingFieldHandler == null) continue;
            this.handleMissingField(jsonObj, rhs, key);
        }
    }

    public void assignField(JsonObject jsonObj, Injector injector, Object rhs) {
        Object special;
        Object target = jsonObj.getTarget();
        Type fieldType = injector.getGenericType();
        Class rawFieldType = TypeUtilities.getRawClass((Type)fieldType);
        if (rhs == null) {
            injector.inject(target, rawFieldType.isPrimitive() ? this.converter.convert(null, rawFieldType) : null);
            return;
        }
        if (rhs instanceof JsonObject) {
            JsonObject jObj;
            Type explicitType;
            if (fieldType instanceof ParameterizedType) {
                this.markUntypedObjects(fieldType, (JsonObject)rhs);
            }
            if ((explicitType = (jObj = (JsonObject)rhs).getType()) != null && !TypeUtilities.hasUnresolvedType((Type)explicitType)) {
                jObj.setType(explicitType);
            } else {
                Type resolvedFieldType = TypeUtilities.resolveTypeUsingInstance((Object)target, (Type)fieldType);
                jObj.setType(resolvedFieldType);
            }
        }
        if ((special = this.readWithFactoryIfExists(rhs, rawFieldType)) != null) {
            injector.inject(target, special);
        } else if (rhs.getClass().isArray()) {
            Object[] elements = (Object[])rhs;
            JsonObject jsonArray = new JsonObject();
            jsonArray.setType(fieldType);
            jsonArray.setItems(elements);
            this.createInstance(jsonArray);
            injector.inject(target, jsonArray.getTarget());
            this.push(jsonArray);
        } else if (rhs instanceof JsonObject) {
            JsonObject jsRhs = (JsonObject)rhs;
            if (jsRhs.isReference()) {
                long ref = jsRhs.getReferenceId();
                JsonObject refObject = this.references.getOrThrow(ref);
                if (refObject.getTarget() != null) {
                    injector.inject(target, refObject.getTarget());
                } else {
                    this.addUnresolvedReference(new Resolver.UnresolvedReference(jsonObj, injector.getName(), ref));
                }
            } else {
                this.createInstance(jsRhs);
                Object fieldObject = jsRhs.getTarget();
                injector.inject(target, fieldObject);
                if (!this.readOptions.isNonReferenceableClass(jsRhs.getRawType())) {
                    this.push(jsRhs);
                }
            }
        } else if (rhs instanceof String && ((String)rhs).trim().isEmpty() && rawFieldType != String.class) {
            injector.inject(target, null);
        } else {
            injector.inject(target, rhs);
        }
    }

    protected void handleMissingField(JsonObject jsonObj, Object rhs, String missingField) {
        Object target = jsonObj.getTarget();
        try {
            if (rhs == null) {
                this.storeMissingField(target, missingField, null);
                return;
            }
            Object special = this.readWithFactoryIfExists(rhs, null);
            if (special != null) {
                this.storeMissingField(target, missingField, special);
            } else if (rhs.getClass().isArray()) {
                this.storeMissingField(target, missingField, null);
            } else if (rhs instanceof JsonObject) {
                JsonObject jObj = (JsonObject)rhs;
                if (jObj.isReference()) {
                    long ref = jObj.getReferenceId();
                    JsonObject refObject = this.references.getOrThrow(ref);
                    this.storeMissingField(target, missingField, refObject.getTarget());
                } else if (jObj.getType() != null) {
                    Object javaInstance = this.createInstance(jObj);
                    if (!this.readOptions.isNonReferenceableClass(jObj.getRawType()) && !jObj.isFinished) {
                        this.push((JsonObject)rhs);
                    }
                    this.storeMissingField(target, missingField, javaInstance);
                } else {
                    this.storeMissingField(target, missingField, null);
                }
            } else {
                this.storeMissingField(target, missingField, rhs);
            }
        }
        catch (Exception e) {
            if (e instanceof JsonIoException) {
                throw e;
            }
            String message = e.getClass().getSimpleName() + " missing field '" + missingField + "' on target: " + ObjectResolver.safeToString(target) + " with value: " + rhs;
            throw new JsonIoException(message, e);
        }
    }

    private void storeMissingField(Object target, String missingField, Object value) {
        this.addMissingField(new Resolver.Missingfields(target, missingField, value));
    }

    private static String safeToString(Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Exception e) {
            return o.getClass().toString();
        }
    }

    @Override
    protected void traverseCollection(JsonObject jsonObj) {
        ParameterizedType pt;
        Type[] typeArgs;
        if (ObjectResolver.markFinishedIfNot(jsonObj)) {
            return;
        }
        Object[] items = jsonObj.getItems();
        if (items == null) {
            return;
        }
        Collection col = (Collection)jsonObj.getTarget();
        ObjectResolver.ensureCollectionCapacity(col, items.length);
        boolean isList = col instanceof List;
        int idx = 0;
        Type fullType = jsonObj.getType();
        Object elementType = Object.class;
        if (fullType instanceof ParameterizedType && (typeArgs = (pt = (ParameterizedType)fullType).getActualTypeArguments()).length > 0) {
            elementType = typeArgs[0];
        }
        Class rawElementType = TypeUtilities.getRawClass(elementType);
        for (Object element : items) {
            if (element == null) {
                col.add(null);
                ++idx;
                continue;
            }
            if (ObjectResolver.isDirectlyAddableJsonValue(element)) {
                col.add(element);
                ++idx;
                continue;
            }
            Class<?> elementClass = element.getClass();
            if (element instanceof JsonObject) {
                JsonObject jObj = (JsonObject)element;
                if (jObj.isReference()) {
                    this.resolveReferenceInCollection(jObj, jsonObj, col, idx, isList);
                } else {
                    jObj.setType((Type)elementType);
                    this.createInstance(jObj);
                    this.addResolvedObjectToCollection(jObj, col);
                }
            } else if (elementClass.isArray()) {
                Object arrayComponentType = TypeUtilities.extractArrayComponentType((Type)elementType);
                if (arrayComponentType == null) {
                    arrayComponentType = Object.class;
                }
                this.wrapArrayAndAddToCollection((Object[])element, (Type)arrayComponentType, col);
            } else {
                Object special = this.readWithFactoryIfExists(element, rawElementType);
                if (special != null) {
                    col.add(special);
                } else {
                    col.add(element);
                }
            }
            ++idx;
        }
    }

    @Override
    protected void traverseArray(JsonObject jsonObj) {
        if (ObjectResolver.markFinishedIfNot(jsonObj)) {
            return;
        }
        Object[] jsonItems = jsonObj.getItems();
        if (ArrayUtilities.isEmpty((Object)jsonItems)) {
            return;
        }
        int len = jsonItems.length;
        Object array = jsonObj.getTarget();
        Class<?> fallbackCompType = array.getClass().getComponentType();
        Class<?> effectiveComponentType = TypeUtilities.extractArrayComponentType((Type)jsonObj.getType());
        if (effectiveComponentType == null) {
            effectiveComponentType = fallbackCompType;
        }
        Class effectiveRawComponentType = TypeUtilities.getRawClass(effectiveComponentType);
        boolean isEnumComponentType = effectiveRawComponentType.isEnum();
        boolean isPrimitive = fallbackCompType.isPrimitive();
        Object[] refArray = isPrimitive ? null : (Object[])array;
        for (int i = 0; i < len; ++i) {
            Object element = jsonItems[i];
            if (element == null) {
                ObjectResolver.setArrayElement(array, refArray, i, null, isPrimitive);
                continue;
            }
            Object special = this.readWithFactoryIfExists(element, effectiveRawComponentType);
            if (special != null) {
                if (isEnumComponentType && special instanceof String) {
                    special = Enum.valueOf(effectiveRawComponentType, (String)special);
                }
                ObjectResolver.setArrayElement(array, refArray, i, special, isPrimitive);
                continue;
            }
            if (element.getClass().isArray()) {
                if (char[].class == effectiveRawComponentType) {
                    Object[] jsonArray = (Object[])element;
                    char[] chars = jsonArray.length == 0 ? new char[]{} : ((String)jsonArray[0]).toCharArray();
                    ObjectResolver.setArrayElement(array, refArray, i, chars, isPrimitive);
                    continue;
                }
                JsonObject jsonArray = new JsonObject();
                jsonArray.setItems((Object[])element);
                jsonArray.setType(effectiveComponentType);
                Object instance = this.createInstance(jsonArray);
                ObjectResolver.setArrayElement(array, refArray, i, instance, isPrimitive);
                this.push(jsonArray);
                continue;
            }
            if (element instanceof JsonObject) {
                JsonObject jsonElement = (JsonObject)element;
                if (jsonElement.isReference()) {
                    long ref = jsonElement.getReferenceId();
                    JsonObject refObject = this.references.getOrThrow(ref);
                    if (refObject.getTarget() != null) {
                        ObjectResolver.setArrayElement(array, refArray, i, refObject.getTarget(), isPrimitive);
                        continue;
                    }
                    this.addUnresolvedReference(new Resolver.UnresolvedReference(jsonObj, i, ref));
                    continue;
                }
                jsonElement.setType(effectiveComponentType);
                Object arrayElement = this.createInstance(jsonElement);
                ObjectResolver.setArrayElement(array, refArray, i, arrayElement, isPrimitive);
                if (arrayElement == null || this.readOptions.isNonReferenceableClass(arrayElement.getClass()) || jsonElement.isFinished) continue;
                this.push(jsonElement);
                continue;
            }
            boolean isEmptyString = element instanceof String && ((String)element).trim().isEmpty() && effectiveRawComponentType != String.class && effectiveRawComponentType != Object.class;
            ObjectResolver.setArrayElement(array, refArray, i, isEmptyString ? null : element, isPrimitive);
        }
        jsonObj.clear();
    }

    @Override
    protected Object readWithFactoryIfExists(Object o, Type inferredType) {
        JsonClassReader reader;
        Object value;
        Class<?> targetClass;
        JsonObject jsonObj;
        Class<?> rawInferred;
        Convention.throwIfNull((Object)o, (String)"Bug in json-io, null must be checked before calling this method.");
        Class<?> clazz = rawInferred = inferredType != null ? TypeUtilities.getRawClass((Type)inferredType) : null;
        if (rawInferred == null && !(o instanceof JsonObject)) {
            return null;
        }
        if (rawInferred != null && this.readOptions.isNotCustomReaderClass(rawInferred)) {
            return null;
        }
        if (o instanceof JsonObject) {
            jsonObj = (JsonObject)o;
            if (jsonObj.isReference()) {
                return null;
            }
            if (jsonObj.getTarget() == null) {
                targetClass = jsonObj.getRawType();
                if (targetClass == null || rawInferred == null) {
                    return null;
                }
                Object factoryCreated = this.createInstance(jsonObj);
                if (factoryCreated != null && jsonObj.isFinished()) {
                    return factoryCreated;
                }
            } else {
                targetClass = jsonObj.getRawType();
            }
        } else {
            targetClass = rawInferred.equals(Object.class) ? o.getClass() : rawInferred;
            jsonObj = new JsonObject();
            jsonObj.setValue(o);
            jsonObj.setType(targetClass);
        }
        if (targetClass != rawInferred && this.readOptions.isNotCustomReaderClass(targetClass)) {
            return null;
        }
        if (jsonObj.getTarget() == null && jsonObj.hasValue() && this.converter.isSimpleTypeConversionSupported((value = jsonObj.getValue()).getClass(), targetClass)) {
            Object converted = this.converter.convert(value, targetClass);
            return jsonObj.setFinishedTarget(converted, true);
        }
        ClassFactory classFactory = this.readOptions.getClassFactory(targetClass);
        if (classFactory != null && jsonObj.getTarget() == null) {
            Object target = this.createInstanceUsingClassFactory(targetClass, jsonObj);
            if (jsonObj.isFinished()) {
                return target;
            }
        }
        if ((reader = this.readOptions.getCustomReader(targetClass)) == null) {
            return null;
        }
        Object read = reader.read(o, this);
        return read != null ? jsonObj.setFinishedTarget(read, true) : null;
    }

    private void markUntypedObjects(Type type, JsonObject rhs) {
        if (rhs.isFinished) {
            return;
        }
        ArrayDeque<Map.Entry<Type, Object>> stack = new ArrayDeque<Map.Entry<Type, Object>>();
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        stack.addFirst(new AbstractMap.SimpleEntry<Type, JsonObject>(type, rhs));
        while (!stack.isEmpty()) {
            Map.Entry item = (Map.Entry)stack.removeFirst();
            Type t = (Type)item.getKey();
            Object instance = item.getValue();
            if (instance == null) continue;
            if (instance instanceof JsonObject) {
                JsonObject jObj = (JsonObject)instance;
                if (jObj.isFinished || !visited.add(jObj)) continue;
            }
            if (t instanceof ParameterizedType) {
                this.handleParameterizedTypeMarking((ParameterizedType)t, instance, type, stack);
                continue;
            }
            ObjectResolver.stampTypeOnJsonObject(instance, t);
        }
    }

    private void handleParameterizedTypeMarking(ParameterizedType pType, Object instance, Type parentType, Deque<Map.Entry<Type, Object>> stack) {
        Class clazz = TypeUtilities.getRawClass((Type)pType);
        Type[] typeArgs = pType.getActualTypeArguments();
        if (typeArgs.length < 1 || clazz == null) {
            return;
        }
        Type resolvedType = TypeUtilities.resolveType((Type)parentType, (Type)pType);
        ObjectResolver.stampTypeOnJsonObject(instance, resolvedType);
        if (Map.class.isAssignableFrom(clazz)) {
            this.handleMapTypeMarking(instance, typeArgs, stack);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            this.handleCollectionTypeMarking(instance, pType, typeArgs, clazz, stack);
        } else {
            this.handleObjectFieldsMarking(instance, pType, typeArgs, stack);
        }
    }

    private void handleMapTypeMarking(Object instance, Type[] typeArgs, Deque<Map.Entry<Type, Object>> stack) {
        JsonObject jsonObj = (JsonObject)instance;
        Map.Entry<Object[], Object[]> pair = jsonObj.asTwoArrays();
        this.addItemsToStack(stack, pair.getKey(), typeArgs[0]);
        this.addItemsToStack(stack, pair.getValue(), typeArgs[1]);
    }

    private void handleCollectionTypeMarking(Object instance, Type containerType, Type[] typeArgs, Class<?> collectionClass, Deque<Map.Entry<Type, Object>> stack) {
        block6: {
            block7: {
                block5: {
                    if (!instance.getClass().isArray()) break block5;
                    this.handleArrayInCollection(instance, containerType, collectionClass, stack);
                    break block6;
                }
                if (!(instance instanceof Collection)) break block7;
                if (this.shouldSkipTraversal(typeArgs[0])) {
                    return;
                }
                for (Object o : (Collection)instance) {
                    stack.addFirst(new AbstractMap.SimpleEntry(typeArgs[0], o));
                }
                break block6;
            }
            if (!(instance instanceof JsonObject)) break block6;
            if (this.shouldSkipTraversal(typeArgs[0])) {
                return;
            }
            Object[] array = ((JsonObject)instance).getItems();
            if (array != null) {
                for (Object o : array) {
                    stack.addFirst(new AbstractMap.SimpleEntry<Type, Object>(typeArgs[0], o));
                }
            }
        }
    }

    private void handleArrayInCollection(Object arrayInstance, Type containerType, Class<?> collectionClass, Deque<Map.Entry<Type, Object>> stack) {
        int len = ArrayUtilities.getLength((Object)arrayInstance);
        for (int i = 0; i < len; ++i) {
            Object element = ArrayUtilities.getElement((Object)arrayInstance, (int)i);
            if (element == null) continue;
            if (element.getClass().isArray()) {
                int innerLen = ArrayUtilities.getLength((Object)element);
                ArrayList<Object> items = new ArrayList<Object>(innerLen);
                for (int j = 0; j < innerLen; ++j) {
                    items.add(ArrayUtilities.getElement((Object)element, (int)j));
                }
                JsonObject coll = new JsonObject();
                coll.setType(collectionClass);
                coll.setItems((Object[])element);
                stack.addFirst(new AbstractMap.SimpleEntry(containerType, items));
                ArrayUtilities.setElement((Object)arrayInstance, (int)i, (Object)coll);
                continue;
            }
            stack.addFirst(new AbstractMap.SimpleEntry<Type, Object>(containerType, element));
        }
    }

    private void handleObjectFieldsMarking(Object instance, Type containerType, Type[] typeArgs, Deque<Map.Entry<Type, Object>> stack) {
        if (!(instance instanceof JsonObject)) {
            return;
        }
        Class rawClass = TypeUtilities.getRawClass((Type)containerType);
        if (rawClass == null) {
            return;
        }
        Map<String, Injector> classFields = this.readOptions.getDeepInjectorMap(rawClass);
        JsonObject jObj = (JsonObject)instance;
        for (Map.Entry<Object, Object> entry : jObj.entrySet()) {
            Injector injector;
            String fieldName = (String)entry.getKey();
            if (fieldName.startsWith("this$") || (injector = classFields.get(fieldName)) == null) continue;
            Type genericType = injector.getGenericType();
            Type resolved = TypeUtilities.resolveType((Type)containerType, (Type)genericType);
            if (TypeUtilities.hasUnresolvedType((Type)resolved)) {
                resolved = typeArgs[0];
            }
            if (this.shouldSkipTraversal(resolved)) continue;
            stack.addFirst(new AbstractMap.SimpleEntry<Type, Object>(resolved, entry.getValue()));
        }
    }

    private boolean shouldSkipTraversal(Type type) {
        Class rawClass = TypeUtilities.getRawClass((Type)type);
        if (rawClass == null) {
            return false;
        }
        if (rawClass.isPrimitive() || rawClass == String.class || Number.class.isAssignableFrom(rawClass) || rawClass == Boolean.class || rawClass == Character.class) {
            return true;
        }
        ClassFactory factory = this.readOptions.getClassFactory(rawClass);
        return factory != null && factory.isObjectFinal();
    }

    private void addItemsToStack(Deque<Map.Entry<Type, Object>> stack, Object[] items, Type itemType) {
        if (items == null || items.length < 1) {
            return;
        }
        if (this.shouldSkipTraversal(itemType)) {
            return;
        }
        Class rawType = TypeUtilities.getRawClass((Type)itemType);
        if (rawType != null && Collection.class.isAssignableFrom(rawType)) {
            stack.addFirst(new AbstractMap.SimpleEntry<Type, Object[]>(itemType, items));
        } else {
            for (int i = items.length - 1; i >= 0; --i) {
                stack.addFirst(new AbstractMap.SimpleEntry<Type, Object>(itemType, items[i]));
            }
        }
    }

    private static void stampTypeOnJsonObject(Object o, Type t) {
        JsonObject jObj;
        if (o instanceof JsonObject && t != null && (jObj = (JsonObject)o).getType() == null) {
            jObj.type = t;
        }
    }

    @Override
    protected Object resolveArray(Type suggestedType, List<Object> list) {
        if (suggestedType == null || TypeUtilities.getRawClass((Type)suggestedType) == Object.class) {
            return list.toArray();
        }
        JsonObject jsonArray = new JsonObject();
        jsonArray.setType(suggestedType);
        Class rawType = TypeUtilities.getRawClass((Type)suggestedType);
        if (Collection.class.isAssignableFrom(rawType)) {
            jsonArray.setTarget(this.createInstance(jsonArray));
        } else {
            jsonArray.setTarget(Array.newInstance(rawType, list.size()));
        }
        jsonArray.setItems(list.toArray());
        return jsonArray;
    }
}

