/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.TypeUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class MapResolver
extends Resolver {
    protected MapResolver(ReadOptions readOptions, ReferenceTracker references, Converter converter) {
        super(readOptions, references, converter);
    }

    @Override
    protected Object readWithFactoryIfExists(Object o, Type compType) {
        return null;
    }

    @Override
    public void traverseFields(JsonObject jsonObj) {
        Object target = jsonObj.getTarget();
        Map<String, Injector> injectorMap = null;
        if (target != null) {
            injectorMap = this.getReadOptions().getDeepInjectorMap(target.getClass());
        }
        ReferenceTracker refTracker = this.getReferences();
        Converter converter = this.getConverter();
        ReadOptions readOptions = this.getReadOptions();
        for (Map.Entry<Object, Object> e : jsonObj.entrySet()) {
            Class<?> fieldType;
            Injector injector;
            String fieldName = (String)e.getKey();
            Object rhs = e.getValue();
            if (rhs == null) {
                jsonObj.put(fieldName, (Object)null);
                continue;
            }
            Class<?> rhsClass = rhs.getClass();
            Injector injector2 = injector = injectorMap == null ? null : injectorMap.get(fieldName);
            if (rhsClass.isArray()) {
                JsonObject jsonArray = new JsonObject();
                jsonArray.setItems((Object[])rhs);
                this.push(jsonArray);
                jsonObj.put(fieldName, rhs);
                continue;
            }
            if (rhs instanceof JsonObject) {
                Class<?> injectorType;
                boolean isNonRefClass;
                JsonObject jObj = (JsonObject)rhs;
                if (injector != null && (isNonRefClass = readOptions.isNonReferenceableClass(injectorType = injector.getType()))) {
                    jObj.setValue(converter.convert(jObj.getValue(), injectorType));
                    continue;
                }
                Long refId = jObj.getReferenceId();
                if (refId != null) {
                    JsonObject refObject = refTracker.getOrThrow(refId);
                    jsonObj.put(fieldName, refObject);
                    continue;
                }
                this.push(jObj);
                continue;
            }
            if (injector == null || (fieldType = injector.getType()) == Object.class || rhsClass == fieldType) continue;
            Object fastValue = MapResolver.fastPrimitiveCoercion(rhs, rhsClass, fieldType);
            if (fastValue != null) {
                jsonObj.put(fieldName, fastValue);
                continue;
            }
            if (converter.isConversionSupportedFor(rhsClass, fieldType)) {
                Object fieldValue = converter.convert(rhs, fieldType);
                jsonObj.put(fieldName, fieldValue);
                continue;
            }
            if (!(rhs instanceof String) || fieldType == String.class || fieldType == StringBuilder.class || fieldType == StringBuffer.class || !"".equals(((String)rhs).trim())) continue;
            jsonObj.put(fieldName, (Object)null);
        }
        jsonObj.setTarget(null);
    }

    private void handleNestedArray(Object element, Class<?> componentType, Object target, int index) {
        JsonObject jsonObject = null;
        if (element instanceof JsonObject && ((JsonObject)element).isArray()) {
            jsonObject = (JsonObject)element;
        } else if (element != null && element.getClass().isArray()) {
            jsonObject = new JsonObject();
            jsonObject.setItems((Object[])element);
        }
        if (jsonObject != null) {
            if (componentType.isArray()) {
                Object arrayElement;
                jsonObject.setType(componentType);
                ((Object[])target)[index] = arrayElement = this.createInstance(jsonObject);
            }
            this.push(jsonObject);
        }
    }

    @Override
    protected void traverseArray(JsonObject jsonObj) {
        boolean isPrimitive;
        Class<?> targetClass;
        Object[] items = jsonObj.getItems();
        if (ArrayUtilities.isEmpty((Object)items)) {
            return;
        }
        Object target = jsonObj.getTarget() != null ? jsonObj.getTarget() : items;
        ReferenceTracker refTracker = this.getReferences();
        Converter converter = this.getConverter();
        ReadOptions readOptions = this.getReadOptions();
        Class componentType = Object.class;
        if (jsonObj.getTarget() != null && (targetClass = jsonObj.getTarget().getClass()).isArray()) {
            componentType = targetClass.getComponentType();
        }
        Object refArray = (isPrimitive = componentType.isPrimitive()) ? null : target;
        int len = items.length;
        for (int i = 0; i < len; ++i) {
            Object element = items[i];
            if (element == null) {
                if (isPrimitive) {
                    ArrayUtilities.setPrimitiveElement((Object)target, (int)i, null);
                    continue;
                }
                refArray[i] = null;
                continue;
            }
            Class<?> elementClass = element.getClass();
            if (elementClass.isArray() || element instanceof JsonObject && ((JsonObject)element).isArray()) {
                this.handleNestedArray(element, componentType, target, i);
                continue;
            }
            Object fastValue = MapResolver.fastPrimitiveCoercion(element, elementClass, componentType);
            if (fastValue != null) {
                if (isPrimitive) {
                    ArrayUtilities.setPrimitiveElement((Object)target, (int)i, (Object)fastValue);
                    continue;
                }
                refArray[i] = fastValue;
                continue;
            }
            if (converter.isConversionSupportedFor(elementClass, componentType)) {
                Object convertedValue = converter.convert(element, componentType);
                if (isPrimitive) {
                    ArrayUtilities.setPrimitiveElement((Object)target, (int)i, (Object)convertedValue);
                    continue;
                }
                refArray[i] = convertedValue;
                continue;
            }
            if (element instanceof JsonObject) {
                boolean isNonRef;
                JsonObject jsonObject = (JsonObject)element;
                Long refId = jsonObject.getReferenceId();
                if (refId == null) {
                    boolean isNonRef2;
                    Class<?> type = jsonObject.getRawType();
                    boolean bl = isNonRef2 = type != null && readOptions.isNonReferenceableClass(type);
                    if (isNonRef2 && converter.isConversionSupportedFor(Map.class, type)) {
                        Object converted = converter.convert((Object)jsonObject, type);
                        if (isPrimitive) {
                            ArrayUtilities.setPrimitiveElement((Object)target, (int)i, (Object)converted);
                        } else {
                            refArray[i] = converted;
                        }
                        jsonObject.setFinished();
                        continue;
                    }
                    this.push(jsonObject);
                    continue;
                }
                JsonObject refObject = refTracker.getOrThrow(refId);
                Class<?> type = refObject.getRawType();
                boolean bl = isNonRef = type != null && readOptions.isNonReferenceableClass(type);
                if (isNonRef && converter.isConversionSupportedFor(Map.class, type)) {
                    Object convertedRef = converter.convert((Object)refObject, type);
                    refObject.setFinishedTarget(convertedRef, true);
                    if (isPrimitive) {
                        ArrayUtilities.setPrimitiveElement((Object)target, (int)i, (Object)refObject.getTarget());
                        continue;
                    }
                    refArray[i] = refObject.getTarget();
                    continue;
                }
                if (isPrimitive) {
                    ArrayUtilities.setPrimitiveElement((Object)target, (int)i, (Object)refObject);
                    continue;
                }
                refArray[i] = refObject;
                continue;
            }
            if (isPrimitive) {
                ArrayUtilities.setPrimitiveElement((Object)target, (int)i, (Object)element);
                continue;
            }
            refArray[i] = element;
        }
        jsonObj.setFinished();
    }

    @Override
    protected void traverseCollection(JsonObject jsonObj) {
        if (jsonObj.isFinished) {
            return;
        }
        Object[] items = jsonObj.getItems();
        Collection col = (Collection)jsonObj.getTarget();
        if (col == null) {
            col = (Collection)this.createInstance(jsonObj);
        }
        if (items != null && col instanceof ArrayList) {
            ((ArrayList)col).ensureCapacity(items.length);
        }
        boolean isList = col instanceof List;
        int idx = 0;
        if (items != null) {
            ReadOptions readOptions = this.getReadOptions();
            ReferenceTracker refTracker = this.getReferences();
            for (Object element : items) {
                JsonObject jObj;
                if (element == null) {
                    col.add(null);
                    ++idx;
                    continue;
                }
                if (element instanceof String || element instanceof Boolean || element instanceof Double || element instanceof Long) {
                    col.add(element);
                } else if (element.getClass().isArray()) {
                    jObj = new JsonObject();
                    jObj.setType((Type)((Object)Object[].class));
                    jObj.setItems((Object[])element);
                    this.createInstance(jObj);
                    col.add(jObj.getTarget());
                    this.push(jObj);
                } else {
                    jObj = (JsonObject)element;
                    Long ref = jObj.getReferenceId();
                    if (ref != null) {
                        JsonObject refObject = refTracker.getOrThrow(ref);
                        if (refObject.getTarget() != null) {
                            col.add(refObject.getTarget());
                        } else {
                            this.addUnresolvedReference(new Resolver.UnresolvedReference(jsonObj, idx, (long)ref));
                            if (isList) {
                                col.add(null);
                            }
                        }
                    } else {
                        if (col instanceof EnumSet) {
                            boolean noEnumName;
                            Class<?> rawType = jObj.getRawType();
                            boolean bl = noEnumName = !jObj.containsKey("name") && !jObj.containsKey("Enum.name") && !jObj.hasValue();
                            if (rawType != null && rawType.isEnum() && noEnumName) {
                                jObj.setFinished();
                                ++idx;
                                continue;
                            }
                        }
                        jObj.setType((Type)((Object)Object.class));
                        this.createInstance(jObj);
                        boolean isNonRefClass = readOptions.isNonReferenceableClass(jObj.getRawType());
                        if (!isNonRefClass) {
                            this.traverseSpecificType(jObj);
                        }
                        if (!(col instanceof EnumSet)) {
                            col.add(jObj.getTarget());
                        }
                    }
                }
                ++idx;
            }
        }
        jsonObj.setFinished();
    }

    @Override
    protected Object resolveArray(Type suggestedType, List<Object> list) {
        Class rawType;
        Class clazz = rawType = suggestedType == null ? null : TypeUtilities.getRawClass((Type)suggestedType);
        if (suggestedType == null || rawType == Object.class) {
            return list.toArray();
        }
        JsonObject jsonArray = new JsonObject();
        jsonArray.setType(suggestedType);
        if (Collection.class.isAssignableFrom(rawType)) {
            jsonArray.setTarget(this.createInstance(jsonArray));
        } else {
            jsonArray.setTarget(Array.newInstance(rawType, list.size()));
        }
        jsonArray.setItems(list.toArray());
        return jsonArray;
    }

    private static Object fastPrimitiveCoercion(Object value, Class<?> valueClass, Class<?> targetType) {
        if (valueClass == Long.class) {
            long longVal = (Long)value;
            if (targetType == Integer.TYPE || targetType == Integer.class) {
                return (int)longVal;
            }
            if (targetType == Short.TYPE || targetType == Short.class) {
                return (short)longVal;
            }
            if (targetType == Byte.TYPE || targetType == Byte.class) {
                return (byte)longVal;
            }
            if (targetType == Double.TYPE || targetType == Double.class) {
                return (double)longVal;
            }
            if (targetType == Float.TYPE || targetType == Float.class) {
                return Float.valueOf(longVal);
            }
        } else if (valueClass == Double.class) {
            double doubleVal = (Double)value;
            if (targetType == Float.TYPE || targetType == Float.class) {
                return Float.valueOf((float)doubleVal);
            }
            if (targetType == Long.TYPE || targetType == Long.class) {
                return (long)doubleVal;
            }
            if (targetType == Integer.TYPE || targetType == Integer.class) {
                return (int)doubleVal;
            }
        }
        return null;
    }
}

