/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonValue;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.FastReader;
import com.cedarsoftware.util.MathUtilities;
import com.cedarsoftware.util.TypeUtilities;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class JsonParser {
    private static final JsonObject EMPTY_ARRAY;
    private final FastReader input;
    private final StringBuilder strBuf;
    private final StringBuilder numBuf = new StringBuilder();
    private int curParseDepth = 0;
    private final boolean allowNanAndInfinity;
    private final int maxParseDepth;
    private final Resolver resolver;
    private final ReadOptions readOptions;
    private final ReferenceTracker references;
    private final Map<String, String> stringCache;
    private final Map<Number, Number> numberCache;
    private final long maxIdValue;
    private final Map<String, String> substitutes = SUBSTITUTES;
    private static final Map<String, String> STATIC_STRING_CACHE;
    private static final Map<Number, Number> STATIC_NUMBER_CACHE;
    private static final Map<String, String> SUBSTITUTES;
    private static final boolean[] WHITESPACE_MAP;
    private static final char[] ESCAPE_CHAR_MAP;
    private static final int[] HEX_VALUE_MAP;

    JsonParser(FastReader reader, Resolver resolver) {
        this.stringCache = new ParserStringCache(STATIC_STRING_CACHE);
        this.numberCache = new ParserNumberCache(STATIC_NUMBER_CACHE);
        this.input = reader;
        this.resolver = resolver;
        this.readOptions = resolver.getReadOptions();
        this.references = resolver.getReferences();
        this.maxParseDepth = this.readOptions.getMaxDepth();
        this.allowNanAndInfinity = this.readOptions.isAllowNanAndInfinity();
        this.strBuf = new StringBuilder(this.readOptions.getStringBufferSize());
        this.maxIdValue = this.readOptions.getMaxIdValue();
    }

    Object readValue(Type suggestedType) throws IOException {
        int c;
        if (this.curParseDepth > this.maxParseDepth) {
            this.error("Maximum parsing depth exceeded");
        }
        if ((c = this.skipWhitespaceRead(true)) == 123) {
            JsonObject jObj = this.readJsonObject(suggestedType);
            return jObj;
        }
        if (c == 91) {
            Type elementType = TypeUtilities.extractArrayComponentType((Type)suggestedType);
            return this.readArray(elementType);
        }
        switch (c) {
            case 34: {
                String str = this.readString();
                return str;
            }
            case 93: {
                this.input.pushback(']');
                return EMPTY_ARRAY;
            }
            case 70: 
            case 102: {
                this.readToken("false");
                return false;
            }
            case 110: {
                this.readToken("null");
                return null;
            }
            case 78: {
                return this.readNumber(c);
            }
            case 84: 
            case 116: {
                this.readToken("true");
                return true;
            }
            case 45: 
            case 73: {
                return this.readNumber(c);
            }
        }
        if (c >= 48 && c <= 57) {
            return this.readNumber(c);
        }
        return this.error("Unknown JSON value type");
    }

    private JsonObject readJsonObject(Type suggestedType) throws IOException {
        JsonObject jObj = new JsonObject();
        Type resolvedSuggestedType = TypeUtilities.resolveType((Type)suggestedType, (Type)suggestedType);
        jObj.setType(resolvedSuggestedType);
        FastReader in = this.input;
        jObj.line = in.getLine();
        jObj.col = in.getCol();
        int c = this.skipWhitespaceRead(true);
        if (c == 125) {
            return new JsonObject();
        }
        in.pushback((char)c);
        ++this.curParseDepth;
        Class rawClass = TypeUtilities.getRawClass((Type)suggestedType);
        Map<Object, Object> injectors = suggestedType == null || rawClass == Object.class || rawClass == null ? Collections.emptyMap() : this.readOptions.getDeepInjectorMap(rawClass);
        while (true) {
            Type fieldGenericType;
            String field = this.readFieldName();
            Injector injector = (Injector)injectors.get(field = this.substitutes.getOrDefault(field, field));
            Type type = fieldGenericType = injector == null ? null : injector.getGenericType();
            if (fieldGenericType != null) {
                fieldGenericType = TypeUtilities.resolveType((Type)suggestedType, (Type)fieldGenericType);
            }
            Object value = this.readValue(fieldGenericType);
            if (field.length() == 0 || field.charAt(0) != '@') {
                jObj.put(field, value);
            } else {
                switch (field) {
                    case "@type": {
                        Class<?> type2 = this.loadType(value);
                        jObj.setTypeString((String)value);
                        jObj.setType(type2);
                        break;
                    }
                    case "@enum": {
                        this.loadEnum(value, jObj);
                        break;
                    }
                    case "@ref": {
                        this.loadRef(value, jObj);
                        break;
                    }
                    case "@id": {
                        this.loadId(value, jObj);
                        break;
                    }
                    case "@items": {
                        if (value != null && !value.getClass().isArray()) {
                            this.error("Expected @items to have an array [], but found: " + value.getClass().getName());
                        }
                        this.loadItems((Object[])value, jObj);
                        break;
                    }
                    case "@keys": {
                        this.loadKeys(value, jObj);
                        break;
                    }
                    default: {
                        jObj.put(field, value);
                    }
                }
            }
            c = this.skipWhitespaceRead(true);
            if (c == 125) break;
            if (c == 44) continue;
            this.error("Object not ended with '}', instead found '" + (char)c + "'");
        }
        --this.curParseDepth;
        return jObj;
    }

    private Object readArray(Type suggestedType) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>(64);
        ++this.curParseDepth;
        while (true) {
            int c;
            Object value;
            if ((value = this.readValue(suggestedType)) != EMPTY_ARRAY) {
                list.add(value);
            }
            if ((c = this.skipWhitespaceRead(true)) == 93) break;
            if (c == 44) continue;
            this.error("Expected ',' or ']' inside array");
        }
        --this.curParseDepth;
        return this.resolver.resolveArray(suggestedType, list);
    }

    private String readFieldName() throws IOException {
        int c = this.skipWhitespaceRead(true);
        if (c != 34) {
            this.error("Expected quote before field name");
        }
        String field = this.readString();
        c = this.skipWhitespaceRead(true);
        if (c != 58) {
            this.error("Expected ':' between field and value, instead found '" + (char)c + "'");
        }
        return field;
    }

    private void readToken(String token) {
        int len = token.length();
        if (len <= 5) {
            for (int i = 1; i < len; ++i) {
                int c = this.input.read();
                if (c == -1) {
                    this.error("EOF reached while reading token: " + token);
                }
                if (c >= 65 && c <= 90) {
                    c += 32;
                }
                if (token.charAt(i) == c) continue;
                this.error("Expected token: " + token);
            }
        } else {
            for (int i = 1; i < len; ++i) {
                int c = this.input.read();
                if (c == -1) {
                    this.error("EOF reached while reading token: " + token);
                }
                c = Character.toLowerCase((char)c);
                char loTokenChar = token.charAt(i);
                if (loTokenChar == c) continue;
                this.error("Expected token: " + token);
            }
        }
    }

    private Number readNumber(int c) throws IOException {
        FastReader in = this.input;
        if (this.allowNanAndInfinity && (c == 45 || c == 78 || c == 73)) {
            boolean isNeg;
            boolean bl = isNeg = c == 45;
            if (isNeg) {
                c = this.input.read();
            }
            if (c == 73) {
                this.readToken("infinity");
                return isNeg ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (78 == c) {
                this.readToken("nan");
                return Double.NaN;
            }
            this.input.pushback((char)c);
            c = 45;
        }
        if (c >= 48 && c <= 57) {
            int nextChar = in.read();
            if (nextChar == -1 || nextChar == 44 || nextChar == 125 || nextChar == 93 || nextChar == 32 || nextChar == 9 || nextChar == 10 || nextChar == 13) {
                long value;
                Number cachedInstance;
                if (nextChar != -1) {
                    in.pushback((char)nextChar);
                }
                if ((cachedInstance = this.numberCache.get(value = (long)(c - 48))) != null) {
                    return cachedInstance;
                }
                this.numberCache.put(value, value);
                return value;
            }
            in.pushback((char)nextChar);
            return this.readNumberFallback(c);
        }
        return this.readNumberFallback(c);
    }

    private Number readNumberFallback(int firstChar) throws IOException {
        int c;
        FastReader in = this.input;
        boolean isFloat = false;
        StringBuilder number = this.numBuf;
        number.setLength(0);
        number.append((char)firstChar);
        while (true) {
            if ((c = in.read()) >= 48 && c <= 57 || c == 45 || c == 43) {
                number.append((char)c);
                continue;
            }
            if (c != 46 && c != 101 && c != 69) break;
            number.append((char)c);
            isFloat = true;
        }
        if (c != -1) {
            in.pushback((char)c);
        }
        try {
            String numStr = number.toString();
            Number val = isFloat ? (Number)this.readFloatingPoint(numStr) : (Number)this.readInteger(numStr);
            Number cachedInstance = this.numberCache.get(val);
            if (cachedInstance != null) {
                return cachedInstance;
            }
            this.numberCache.put(val, val);
            return val;
        }
        catch (Exception e) {
            return (Number)this.error("Invalid number: " + number, e);
        }
    }

    private Number readInteger(String numStr) {
        if (this.readOptions.isIntegerTypeBigInteger()) {
            return new BigInteger(numStr);
        }
        try {
            return Long.parseLong(numStr);
        }
        catch (Exception e) {
            BigInteger bigInt = new BigInteger(numStr);
            if (this.readOptions.isIntegerTypeBoth()) {
                return bigInt;
            }
            return bigInt.longValue();
        }
    }

    private Number readFloatingPoint(String numStr) {
        if (this.readOptions.isFloatingPointBigDecimal()) {
            return new BigDecimal(numStr);
        }
        Number number = MathUtilities.parseToMinimalNumericType((String)numStr);
        if (this.readOptions.isFloatingPointBoth()) {
            return number;
        }
        return number.doubleValue();
    }

    private String readString() throws IOException {
        StringBuilder str = this.strBuf;
        str.setLength(0);
        FastReader in = this.input;
        char[] ESCAPE_CHARS = ESCAPE_CHAR_MAP;
        int[] HEX_VALUES = HEX_VALUE_MAP;
        while (true) {
            char escaped;
            int c;
            if ((c = in.read()) == -1) {
                this.error("EOF reached while reading JSON string");
            }
            if (c != 92 && c != 34) {
                str.append((char)c);
                continue;
            }
            if (c == 34) {
                if (this.curParseDepth != 0 || (c = this.skipWhitespaceRead(false)) == -1) break;
                throw new JsonIoException("EOF expected, content found after string");
            }
            c = in.read();
            if (c == -1) {
                this.error("EOF reached while reading escape sequence");
            }
            if (c < ESCAPE_CHARS.length && (escaped = ESCAPE_CHARS[c]) != '\u0000') {
                str.append(escaped);
                continue;
            }
            if (c == 117) {
                int value = 0;
                for (int i = 0; i < 4; ++i) {
                    int digit;
                    c = in.read();
                    if (c == -1) {
                        this.error("EOF reached while reading Unicode escape sequence");
                    }
                    int n = digit = c < 128 ? HEX_VALUES[c] : -1;
                    if (digit < 0) {
                        this.error("Expected hexadecimal digit, got: " + (char)c);
                    }
                    value = value << 4 | digit;
                }
                if (value >= 55296 && value <= 56319) {
                    int next = in.read();
                    if (next == 92) {
                        next = in.read();
                        if (next == 117) {
                            int lowSurrogate = 0;
                            for (int i = 0; i < 4; ++i) {
                                int digit;
                                c = in.read();
                                if (c == -1) {
                                    this.error("EOF reached while reading Unicode escape sequence");
                                }
                                int n = digit = c < 128 ? HEX_VALUES[c] : -1;
                                if (digit < 0) {
                                    this.error("Expected hexadecimal digit, got: " + (char)c);
                                }
                                lowSurrogate = lowSurrogate << 4 | digit;
                            }
                            if (lowSurrogate >= 56320 && lowSurrogate <= 57343) {
                                int codePoint = 65536 + (value - 55296 << 10) + (lowSurrogate - 56320);
                                str.appendCodePoint(codePoint);
                                continue;
                            }
                            str.append((char)value);
                            str.append((char)lowSurrogate);
                            continue;
                        }
                        in.pushback((char)next);
                        in.pushback('\\');
                    } else if (next != -1) {
                        in.pushback((char)next);
                    }
                }
                str.append((char)value);
                continue;
            }
            this.error("Invalid character escape sequence specified: " + (char)c);
        }
        return this.cacheString(str);
    }

    private String cacheString(StringBuilder str) {
        int length = str.length();
        if (length == 0) {
            return "";
        }
        String s = str.toString();
        if (length < 33) {
            String cachedInstance = this.stringCache.get(s);
            if (cachedInstance != null) {
                return cachedInstance;
            }
            this.stringCache.put(s, s);
        }
        return s;
    }

    private int skipWhitespaceRead(boolean throwOnEof) throws IOException {
        int c;
        FastReader in = this.input;
        boolean[] WHITESPACE = WHITESPACE_MAP;
        while ((c = in.read()) >= 0 && c < 128 && WHITESPACE[c]) {
        }
        if (c == -1 && throwOnEof) {
            this.error("EOF reached prematurely");
        }
        return c;
    }

    private void loadId(Object value, JsonObject jObj) {
        long id;
        if (value == null) {
            this.error("Null value provided for @id field - expected a number");
        }
        if (jObj == null) {
            this.error("Null JsonObject provided to loadId method");
        }
        if (!(value instanceof Number)) {
            this.error("Expected a number for @id, instead got: " + value.getClass().getSimpleName());
        }
        if ((id = ((Number)value).longValue()) < -this.maxIdValue || id > this.maxIdValue) {
            this.error("ID value out of safe range: " + id + " - IDs must be between -" + this.maxIdValue + " and +" + this.maxIdValue);
        }
        this.references.put(id, jObj);
        jObj.setId(id);
    }

    private void loadRef(Object value, JsonValue jObj) {
        long refId;
        if (value == null) {
            this.error("Null value provided for @ref field - expected a number");
        }
        if (jObj == null) {
            this.error("Null JsonValue provided to loadRef method");
        }
        if (!(value instanceof Number)) {
            this.error("Expected a number for @ref, instead got: " + value.getClass().getSimpleName());
        }
        if ((refId = ((Number)value).longValue()) < -this.maxIdValue || refId > this.maxIdValue) {
            this.error("Reference ID value out of safe range: " + refId + " - reference IDs must be between -" + this.maxIdValue + " and +" + this.maxIdValue);
        }
        jObj.setReferenceId(refId);
    }

    private void loadEnum(Object value, JsonObject jObj) {
        if (!(value instanceof String)) {
            this.error("Expected a String for @enum, instead got: " + value);
        }
        Class<?> enumClass = this.stringToClass((String)value);
        jObj.setTypeString((String)value);
        jObj.setType(enumClass);
        if (jObj.getItems() == null) {
            jObj.setItems(ArrayUtilities.EMPTY_OBJECT_ARRAY);
        }
    }

    private Class<?> loadType(Object value) {
        String javaType;
        String substitute;
        if (!(value instanceof String)) {
            this.error("Expected a String for @type, instead got: " + value);
        }
        if ((substitute = this.readOptions.getTypeNameAlias(javaType = (String)value)) != null) {
            javaType = substitute;
        }
        return this.stringToClass(javaType);
    }

    private void loadItems(Object[] value, JsonObject jObj) {
        if (value == null) {
            return;
        }
        jObj.setItems(value);
    }

    private void loadKeys(Object value, JsonObject jObj) {
        if (value == null) {
            return;
        }
        if (!value.getClass().isArray()) {
            this.error("Expected @keys to have an array [], but found: " + value.getClass().getName());
        }
        jObj.setKeys((Object[])value);
    }

    private Class<?> stringToClass(String className) {
        String resolvedName = this.readOptions.getTypeNameAlias(className);
        Class<Object> clazz = ClassUtilities.forName((String)resolvedName, (ClassLoader)this.readOptions.getClassLoader());
        if (clazz == null) {
            if (this.readOptions.isFailOnUnknownType()) {
                this.error("Unknown type (class) '" + className + "' not defined.");
            }
            if ((clazz = this.readOptions.getUnknownTypeClass()) == null) {
                clazz = LinkedHashMap.class;
            }
        }
        return clazz;
    }

    private Object error(String msg) {
        throw new JsonIoException(this.getMessage(msg));
    }

    private Object error(String msg, Exception e) {
        throw new JsonIoException(this.getMessage(msg), e);
    }

    private String getMessage(String msg) {
        return msg + "\nline: " + this.input.getLine() + ", col: " + this.input.getCol() + "\n" + this.input.getLastSnippet();
    }

    static {
        String[] commonStrings;
        int i;
        EMPTY_ARRAY = new JsonObject();
        STATIC_STRING_CACHE = new ConcurrentHashMap<String, String>(64);
        STATIC_NUMBER_CACHE = new ConcurrentHashMap<Number, Number>(16);
        SUBSTITUTES = new HashMap<String, String>(5);
        WHITESPACE_MAP = new boolean[128];
        ESCAPE_CHAR_MAP = new char[128];
        HEX_VALUE_MAP = new int[128];
        JsonParser.WHITESPACE_MAP[32] = true;
        JsonParser.WHITESPACE_MAP[9] = true;
        JsonParser.WHITESPACE_MAP[10] = true;
        JsonParser.WHITESPACE_MAP[13] = true;
        JsonParser.ESCAPE_CHAR_MAP[92] = 92;
        JsonParser.ESCAPE_CHAR_MAP[47] = 47;
        JsonParser.ESCAPE_CHAR_MAP[34] = 34;
        JsonParser.ESCAPE_CHAR_MAP[39] = 39;
        JsonParser.ESCAPE_CHAR_MAP[98] = 8;
        JsonParser.ESCAPE_CHAR_MAP[102] = 12;
        JsonParser.ESCAPE_CHAR_MAP[110] = 10;
        JsonParser.ESCAPE_CHAR_MAP[114] = 13;
        JsonParser.ESCAPE_CHAR_MAP[116] = 9;
        Arrays.fill(HEX_VALUE_MAP, -1);
        for (i = 48; i <= 57; ++i) {
            JsonParser.HEX_VALUE_MAP[i] = i - 48;
        }
        for (i = 97; i <= 102; ++i) {
            JsonParser.HEX_VALUE_MAP[i] = 10 + (i - 97);
        }
        for (i = 65; i <= 70; ++i) {
            JsonParser.HEX_VALUE_MAP[i] = 10 + (i - 65);
        }
        SUBSTITUTES.put("@i", "@id");
        SUBSTITUTES.put("@r", "@ref");
        SUBSTITUTES.put("@e", "@items");
        SUBSTITUTES.put("@t", "@type");
        SUBSTITUTES.put("@k", "@keys");
        for (String s : commonStrings = new String[]{"", "true", "True", "TRUE", "false", "False", "FALSE", "null", "yes", "Yes", "YES", "no", "No", "NO", "on", "On", "ON", "off", "Off", "OFF", "id", "ID", "type", "value", "name", "@id", "@ref", "@items", "@type", "@keys", "-1", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}) {
            STATIC_STRING_CACHE.put(s, s);
        }
        STATIC_NUMBER_CACHE.put(-1L, -1L);
        STATIC_NUMBER_CACHE.put(0L, 0L);
        STATIC_NUMBER_CACHE.put(1L, 1L);
        STATIC_NUMBER_CACHE.put(-1.0, -1.0);
        STATIC_NUMBER_CACHE.put(0.0, 0.0);
        STATIC_NUMBER_CACHE.put(1.0, 1.0);
        STATIC_NUMBER_CACHE.put(Double.MIN_VALUE, Double.MIN_VALUE);
        STATIC_NUMBER_CACHE.put(Double.MAX_VALUE, Double.MAX_VALUE);
        STATIC_NUMBER_CACHE.put(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        STATIC_NUMBER_CACHE.put(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        STATIC_NUMBER_CACHE.put(Double.NaN, Double.NaN);
    }

    private static class ParserStringCache
    extends AbstractMap<String, String> {
        private final Map<String, String> staticCache;
        private final Map<String, String> instanceCache;

        public ParserStringCache(Map<String, String> staticCache) {
            this.staticCache = staticCache;
            this.instanceCache = new HashMap<String, String>(64);
        }

        @Override
        public String get(Object key) {
            String result = this.staticCache.get(key);
            if (result != null) {
                return result;
            }
            return this.instanceCache.get(key);
        }

        @Override
        public String put(String key, String value) {
            return this.instanceCache.put(key, value);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            HashSet<Map.Entry<String, String>> entries = new HashSet<Map.Entry<String, String>>();
            entries.addAll(this.staticCache.entrySet());
            entries.addAll(this.instanceCache.entrySet());
            return entries;
        }
    }

    private static class ParserNumberCache
    extends AbstractMap<Number, Number> {
        private final Map<Number, Number> staticCache;
        private final Map<Number, Number> instanceCache;

        public ParserNumberCache(Map<Number, Number> staticCache) {
            this.staticCache = staticCache;
            this.instanceCache = new HashMap<Number, Number>(64);
        }

        @Override
        public Number get(Object key) {
            Number result = this.staticCache.get(key);
            if (result != null) {
                return result;
            }
            return this.instanceCache.get(key);
        }

        @Override
        public Number put(Number key, Number value) {
            return this.instanceCache.put(key, value);
        }

        @Override
        public Set<Map.Entry<Number, Number>> entrySet() {
            HashSet<Map.Entry<Number, Number>> entries = new HashSet<Map.Entry<Number, Number>>();
            entries.addAll(this.staticCache.entrySet());
            entries.addAll(this.instanceCache.entrySet());
            return entries;
        }
    }
}

