/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

public final class JsonIoCleanup {
    private JsonIoCleanup() {
        throw new UnsupportedOperationException("JsonIoCleanup is a utility class and cannot be instantiated");
    }

    public static void clearThreadLocals() {
    }

    public static void cleanup() {
        JsonIoCleanup.clearThreadLocals();
    }

    public static boolean hasThreadLocalResources() {
        return false;
    }

    public static String getThreadLocalInfo() {
        StringBuilder info = new StringBuilder();
        info.append("JsonIo ThreadLocal Resources:\n");
        info.append("- JsonParser.STRING_BUFFER: char[1024] buffer for string processing\n");
        info.append("- JsonParser.LARGE_STRING_BUFFER: char[8192] buffer for large string processing\n");
        info.append("\nCall JsonIoCleanup.clearThreadLocals() to clean up these resources.");
        return info.toString();
    }

    public static ThreadLocalCleaner autoCleanup() {
        return new ThreadLocalCleaner();
    }

    public static final class ThreadLocalCleaner
    implements AutoCloseable {
        private ThreadLocalCleaner() {
        }

        @Override
        public void close() {
            JsonIoCleanup.clearThreadLocals();
        }
    }
}

