/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.TypeUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapResolver
extends Resolver {
    private final Map<Class<?>, Map<String, Injector>> classInjectorCache = new HashMap();

    protected MapResolver(ReadOptions readOptions, ReferenceTracker references, Converter converter) {
        super(readOptions, references, converter);
    }

    @Override
    protected Object readWithFactoryIfExists(Object o, Type compType) {
        return null;
    }

    @Override
    public void traverseFields(JsonObject jsonObj) {
        Class<?> targetClass;
        Object target = jsonObj.getTarget();
        Map<String, Injector> injectorMap = null;
        if (target != null && (injectorMap = this.classInjectorCache.get(targetClass = target.getClass())) == null) {
            injectorMap = this.getReadOptions().getDeepInjectorMap(targetClass);
            this.classInjectorCache.put(targetClass, injectorMap);
        }
        ReferenceTracker refTracker = this.getReferences();
        Converter converter = this.getConverter();
        ReadOptions readOptions = this.getReadOptions();
        for (Map.Entry<Object, Object> e : jsonObj.entrySet()) {
            Injector injector;
            String fieldName = (String)e.getKey();
            Object rhs = e.getValue();
            if (rhs == null) {
                jsonObj.put(fieldName, (Object)null);
                continue;
            }
            Class<?> rhsClass = rhs.getClass();
            Injector injector2 = injector = injectorMap == null ? null : injectorMap.get(fieldName);
            if (rhsClass.isArray()) {
                JsonObject jsonArray = new JsonObject();
                jsonArray.setItems((Object[])rhs);
                this.push(jsonArray);
                jsonObj.put(fieldName, rhs);
                continue;
            }
            if (rhs instanceof JsonObject) {
                Class<?> injectorType;
                boolean isNonRefClass;
                JsonObject jObj = (JsonObject)rhs;
                if (injector != null && (isNonRefClass = readOptions.isNonReferenceableClass(injectorType = injector.getType()))) {
                    jObj.setValue(converter.convert(jObj.getValue(), injectorType));
                    continue;
                }
                Long refId = jObj.getReferenceId();
                if (refId != null) {
                    JsonObject refObject = refTracker.getOrThrow(refId);
                    jsonObj.put(fieldName, refObject);
                    continue;
                }
                this.push(jObj);
                continue;
            }
            if (injector == null) continue;
            Class<?> fieldType = injector.getType();
            if (converter.isConversionSupportedFor(rhsClass, fieldType)) {
                Object fieldValue = converter.convert(rhs, fieldType);
                jsonObj.put(fieldName, fieldValue);
                continue;
            }
            if (!(rhs instanceof String) || fieldType == String.class || fieldType == StringBuilder.class || fieldType == StringBuffer.class || !"".equals(((String)rhs).trim())) continue;
            jsonObj.put(fieldName, (Object)null);
        }
        jsonObj.setTarget(null);
    }

    private void handleNestedArray(Object element, Class<?> componentType, Object target, int index) {
        JsonObject jsonObject = null;
        if (element instanceof JsonObject && ((JsonObject)element).isArray()) {
            jsonObject = (JsonObject)element;
        } else if (element != null && element.getClass().isArray()) {
            jsonObject = new JsonObject();
            jsonObject.setItems((Object[])element);
        }
        if (jsonObject != null) {
            if (componentType.isArray()) {
                jsonObject.setType(componentType);
                Object arrayElement = this.createInstance(jsonObject);
                this.setArrayElement(target, index, arrayElement);
            }
            this.push(jsonObject);
        }
    }

    @Override
    protected void traverseArray(JsonObject jsonObj) {
        Class<?> targetClass;
        Object[] items = jsonObj.getItems();
        if (ArrayUtilities.isEmpty((Object)items)) {
            return;
        }
        Object target = jsonObj.getTarget() != null ? jsonObj.getTarget() : items;
        ReferenceTracker refTracker = this.getReferences();
        Converter converter = this.getConverter();
        Class componentType = Object.class;
        if (jsonObj.getTarget() != null && (targetClass = jsonObj.getTarget().getClass()).isArray()) {
            componentType = targetClass.getComponentType();
        }
        int len = items.length;
        for (int i = 0; i < len; ++i) {
            Object element = items[i];
            if (element == null) {
                this.setArrayElement(target, i, null);
                continue;
            }
            if (element.getClass().isArray() || element instanceof JsonObject && ((JsonObject)element).isArray()) {
                this.handleNestedArray(element, componentType, target, i);
                continue;
            }
            if (converter.isConversionSupportedFor(element.getClass(), componentType)) {
                Object convertedValue = converter.convert(element, componentType);
                this.setArrayElement(target, i, convertedValue);
                continue;
            }
            if (element instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)element;
                Long refId = jsonObject.getReferenceId();
                if (refId == null) {
                    Class<?> type = jsonObject.getRawType();
                    if (type != null && converter.isConversionSupportedFor(Map.class, type)) {
                        Object converted = converter.convert((Object)jsonObject, type);
                        this.setArrayElement(target, i, converted);
                        jsonObject.setFinished();
                        continue;
                    }
                    this.push(jsonObject);
                    continue;
                }
                JsonObject refObject = refTracker.getOrThrow(refId);
                Class<?> type = refObject.getRawType();
                if (type != null && converter.isConversionSupportedFor(Map.class, type)) {
                    Object convertedRef = converter.convert((Object)refObject, type);
                    refObject.setFinishedTarget(convertedRef, true);
                    this.setArrayElement(target, i, refObject.getTarget());
                    continue;
                }
                this.setArrayElement(target, i, refObject);
                continue;
            }
            this.setArrayElement(target, i, element);
        }
        jsonObj.setFinished();
    }

    @Override
    protected void traverseCollection(JsonObject jsonObj) {
        if (jsonObj.isFinished) {
            return;
        }
        Object[] items = jsonObj.getItems();
        Collection col = (Collection)jsonObj.getTarget();
        if (col == null) {
            col = (Collection)this.createInstance(jsonObj);
        }
        if (items != null && col instanceof ArrayList) {
            ((ArrayList)col).ensureCapacity(items.length);
        }
        boolean isList = col instanceof List;
        int idx = 0;
        if (items != null) {
            ReadOptions readOptions = this.getReadOptions();
            for (Object element : items) {
                JsonObject jObj;
                if (element == null) {
                    col.add(null);
                    ++idx;
                    continue;
                }
                if (element instanceof String || element instanceof Boolean || element instanceof Double || element instanceof Long) {
                    col.add(element);
                } else if (element.getClass().isArray()) {
                    jObj = new JsonObject();
                    jObj.setType((Type)((Object)Object[].class));
                    jObj.setItems((Object[])element);
                    this.createInstance(jObj);
                    col.add(jObj.getTarget());
                    this.push(jObj);
                } else {
                    jObj = (JsonObject)element;
                    Long ref = jObj.getReferenceId();
                    if (ref != null) {
                        JsonObject refObject = this.getReferences().getOrThrow(ref);
                        if (refObject.getTarget() != null) {
                            col.add(refObject.getTarget());
                        } else {
                            this.addUnresolvedReference(new Resolver.UnresolvedReference(jsonObj, idx, (long)ref));
                            if (isList) {
                                col.add(null);
                            }
                        }
                    } else {
                        if (col instanceof EnumSet) {
                            boolean noEnumName;
                            Class<?> rawType = jObj.getRawType();
                            boolean bl = noEnumName = !jObj.containsKey("name") && !jObj.containsKey("Enum.name") && !jObj.hasValue();
                            if (rawType != null && rawType.isEnum() && noEnumName) {
                                jObj.setFinished();
                                ++idx;
                                continue;
                            }
                        }
                        jObj.setType((Type)((Object)Object.class));
                        this.createInstance(jObj);
                        boolean isNonRefClass = readOptions.isNonReferenceableClass(jObj.getRawType());
                        if (!isNonRefClass) {
                            this.traverseSpecificType(jObj);
                        }
                        if (!(col instanceof EnumSet)) {
                            col.add(jObj.getTarget());
                        }
                    }
                }
                ++idx;
            }
        }
        jsonObj.setFinished();
    }

    @Override
    protected Object resolveArray(Type suggestedType, List<Object> list) {
        Class rawType;
        Class clazz = rawType = suggestedType == null ? null : TypeUtilities.getRawClass((Type)suggestedType);
        if (suggestedType == null || rawType == Object.class) {
            return list.toArray();
        }
        JsonObject jsonArray = new JsonObject();
        jsonArray.setType(suggestedType);
        if (Collection.class.isAssignableFrom(rawType)) {
            jsonArray.setTarget(this.createInstance(jsonArray));
        } else {
            jsonArray.setTarget(Array.newInstance(rawType, list.size()));
        }
        jsonArray.setItems(list.toArray());
        return jsonArray;
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.classInjectorCache.clear();
    }
}

