/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.reflect;

import com.cedarsoftware.util.ExceptionUtilities;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public class Accessor {
    private final String uniqueFieldName;
    private final Field field;
    private final boolean isMethod;
    private final String fieldOrMethodName;
    private final MethodHandle methodHandle;
    private final boolean isPublic;

    private Accessor(Field field, MethodHandle methodHandle, String uniqueFieldName, String fieldOrMethodName, boolean isPublic, boolean isMethod) {
        this.field = field;
        this.methodHandle = methodHandle;
        this.uniqueFieldName = uniqueFieldName;
        this.fieldOrMethodName = fieldOrMethodName;
        this.isPublic = isPublic;
        this.isMethod = isMethod;
    }

    public static Accessor createFieldAccessor(Field field, String uniqueFieldName) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            ExceptionUtilities.safelyIgnoreException(() -> field.setAccessible(true));
        }
        try {
            MethodHandle handle = MethodHandles.lookup().unreflectGetter(field);
            return new Accessor(field, handle, uniqueFieldName, field.getName(), Modifier.isPublic(field.getModifiers()), false);
        }
        catch (IllegalAccessException ex) {
            return new Accessor(field, null, uniqueFieldName, field.getName(), Modifier.isPublic(field.getModifiers()), false);
        }
    }

    public static Accessor createMethodAccessor(Field field, String methodName, String uniqueFieldName) {
        try {
            MethodType type = MethodType.methodType(field.getType());
            MethodHandle handle = MethodHandles.publicLookup().findVirtual(field.getDeclaringClass(), methodName, type);
            return new Accessor(field, handle, uniqueFieldName, methodName, true, true);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public Object retrieve(Object o) {
        try {
            if (this.methodHandle != null) {
                try {
                    return this.methodHandle.invoke(o);
                }
                catch (Throwable t) {
                    return this.field.get(o);
                }
            }
            return this.field.get(o);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public boolean isMethod() {
        return this.isMethod;
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public String getActualFieldName() {
        return this.field.getName();
    }

    public String getUniqueFieldName() {
        return this.uniqueFieldName;
    }

    public String getFieldOrMethodName() {
        return this.fieldOrMethodName;
    }

    public boolean isPublic() {
        return this.isPublic;
    }
}

