/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class FastPushbackReader
extends FilterReader {
    private static final int bufsize = 256;
    private final int[] buf;
    private int idx = 0;
    private int unread = Integer.MAX_VALUE;
    protected int line = 1;
    protected int col = 0;

    FastPushbackReader(Reader reader) {
        super(reader);
        this.buf = new int[256];
    }

    String getLastSnippet() {
        StringBuilder s = new StringBuilder();
        int i = this.idx;
        while (i < 256) {
            if (this.appendChar(s, i)) break;
            ++i;
        }
        i = 0;
        while (i < this.idx) {
            if (this.appendChar(s, i)) break;
            ++i;
        }
        return s.toString();
    }

    private boolean appendChar(StringBuilder s, int i) {
        int snip;
        block3: {
            try {
                snip = this.buf[i];
                if (snip != 0) break block3;
                return true;
            }
            catch (Exception exception) {
                return true;
            }
        }
        s.appendCodePoint(snip);
        return false;
    }

    @Override
    public int read() throws IOException {
        int ch = this.unread == Integer.MAX_VALUE ? this.in.read() : this.unread;
        this.unread = Integer.MAX_VALUE;
        this.buf[this.idx++] = ch;
        if (this.idx >= 256) {
            this.idx = 0;
        }
        if (ch == 10) {
            ++this.line;
            this.col = 0;
        } else {
            ++this.col;
        }
        return ch;
    }

    public void unread(int c) throws IOException {
        this.unread = c;
        this.idx = this.idx < 1 ? 255 : --this.idx;
        if (c == 10) {
            --this.line;
        } else {
            --this.col;
        }
    }
}

