/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.ClassUtilities;
import java.lang.reflect.Array;
import java.util.EnumSet;

public class EnumSetFactory
implements JsonReader.ClassFactory {
    @Override
    public Object newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        Object items;
        Class enumClass = ClassUtilities.getClassIfEnum(jObj.getJavaType());
        if (enumClass == null && (items = jObj.getItems()) != null && Array.getLength(items) > 0) {
            Object firstItem = Array.get(items, 0);
            if (firstItem instanceof JsonObject) {
                JsonObject jsonItem = (JsonObject)firstItem;
                enumClass = ClassUtilities.getClassIfEnum(jsonItem.getJavaType());
            } else if (firstItem instanceof String) {
                throw new JsonIoException("Unable to determine enum class from items in EnumSet");
            }
        }
        if (enumClass == null || !enumClass.isEnum()) {
            throw new JsonIoException("Unable to create EnumSet - no valid enum class found");
        }
        EnumSet enumSet = EnumSet.noneOf(enumClass);
        jObj.setTarget(enumSet);
        Object items2 = jObj.getItems();
        if (items2 == null || Array.getLength(items2) == 0) {
            return enumSet;
        }
        int len = Array.getLength(items2);
        for (int i = 0; i < len; ++i) {
            Object item = Array.get(items2, i);
            if (item instanceof JsonObject) {
                String enumName;
                JsonObject jsonItem = (JsonObject)item;
                Class itemEnumClass = ClassUtilities.getClassIfEnum(jsonItem.getJavaType());
                if (itemEnumClass == null) {
                    itemEnumClass = enumClass;
                }
                if ((enumName = (String)jsonItem.get("name")) == null) {
                    throw new JsonIoException("Enum constant missing 'name' field");
                }
                Object enumConstant = Enum.valueOf(itemEnumClass, enumName);
                enumSet.add(enumConstant);
                continue;
            }
            if (item instanceof String) {
                String enumName = (String)item;
                Object enumConstant = Enum.valueOf(enumClass, enumName);
                enumSet.add(enumConstant);
                continue;
            }
            throw new JsonIoException("Unexpected item type in EnumSet: " + item.getClass());
        }
        return enumSet;
    }

    @Override
    public boolean isObjectFinal() {
        return true;
    }
}

