/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.JsonIo;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.CompactMap;
import com.cedarsoftware.util.convert.Converter;
import java.util.HashMap;
import java.util.Map;

public class CompactMapFactory
implements JsonReader.ClassFactory {
    @Override
    public Map newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        JsonObject map = jObj;
        Converter converter = resolver.getConverter();
        boolean caseSensitive = (Boolean)converter.convert(map.get(JsonIo.PREFIX + "caseSensitive" + JsonIo.SUFFIX), Boolean.TYPE);
        int compactSize = (Integer)converter.convert(map.get(JsonIo.PREFIX + "compactSize" + JsonIo.SUFFIX), Integer.TYPE);
        String order = (String)converter.convert(map.get(JsonIo.PREFIX + "order" + JsonIo.SUFFIX), String.class);
        String singleKey = (String)converter.convert(map.get(JsonIo.PREFIX + "singleKey" + JsonIo.SUFFIX), String.class);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("caseSensitive", caseSensitive);
        options.put("compactSize", compactSize);
        options.put("ordering", order);
        options.put("singleKey", singleKey);
        CompactMap.Builder builder = CompactMap.builder().caseSensitive(caseSensitive).compactSize(compactSize).singleValueKey((Object)singleKey);
        if (order.equals("sorted")) {
            builder.sortedOrder();
        } else if (order.equals("reverse")) {
            builder.reverseOrder();
        } else if (order.equals("insertion")) {
            builder.insertionOrder();
        } else if (order.equals("unordered")) {
            builder.noOrder();
        }
        CompactMap cmap = builder.build();
        JsonReader reader = new JsonReader(resolver);
        Object[] entries = (Object[])map.get(JsonIo.PREFIX + "entries" + JsonIo.SUFFIX);
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                Map pair = (Map)entries[i];
                Object key = pair.get("key");
                Object value = pair.get("value");
                if (key instanceof JsonObject) {
                    key = reader.toJava(null, key);
                }
                if (value instanceof JsonObject) {
                    value = reader.toJava(null, value);
                }
                cmap.put(key, value);
            }
        }
        return cmap;
    }
}

