/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonWriter;
import com.cedarsoftware.io.MetaUtils;
import com.cedarsoftware.io.WriterContext;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

public class Writers {
    private Writers() {
    }

    public static class UUIDWriter
    implements JsonWriter.JsonClassWriter {
        @Override
        public void write(Object obj, boolean showType, Writer output, WriterContext context) throws IOException {
            UUID uuid = (UUID)obj;
            output.write("\"value\":\"");
            output.write(uuid.toString());
            output.write("\"");
        }

        @Override
        public boolean hasPrimitiveForm(WriterContext writerContext) {
            return true;
        }

        @Override
        public void writePrimitiveForm(Object o, Writer writer, WriterContext writerContext) throws IOException {
            UUID buffer = (UUID)o;
            JsonWriter.writeBasicString(writer, buffer.toString());
        }
    }

    public static class BigDecimalWriter
    extends PrimitiveValueWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            BigDecimal big = (BigDecimal)o;
            JsonWriter.writeBasicString(output, big.toPlainString());
        }
    }

    public static class BigIntegerWriter
    extends PrimitiveValueWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            BigInteger big = (BigInteger)o;
            JsonWriter.writeBasicString(output, big.toString(10));
        }
    }

    public static class LocaleWriter
    extends PrimitiveValueWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            Locale locale = (Locale)o;
            JsonWriter.writeBasicString(output, locale.toLanguageTag());
        }
    }

    public static class JsonStringWriter
    extends PrimitiveUtf8StringWriter {
    }

    public static class TimestampWriter
    implements JsonWriter.JsonClassWriter {
        @Override
        public void write(Object o, boolean showType, Writer output, WriterContext writerContext) throws IOException {
            Timestamp tstamp = (Timestamp)o;
            output.write("\"time\":\"");
            output.write(Long.toString(tstamp.getTime() / 1000L * 1000L));
            output.write("\",\"nanos\":\"");
            output.write(Integer.toString(tstamp.getNanos()));
            output.write(34);
        }
    }

    public static class OffsetDateTimeWriter
    extends TemporalWriter<OffsetDateTime> {
        public OffsetDateTimeWriter() {
            this.setFormatter(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
    }

    public static class OffsetTimeWriter
    extends TemporalWriter<OffsetTime> {
        public OffsetTimeWriter() {
            this.setFormatter(DateTimeFormatter.ISO_OFFSET_TIME);
        }
    }

    public static class YearWriter
    extends PrimitiveValueWriter {
        @Override
        public String extractString(Object o) {
            return Integer.toString(((Year)o).getValue());
        }
    }

    public static class MonthDayWriter
    extends TemporalWriter<YearMonth> {
        public static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();

        public MonthDayWriter() {
            this.setFormatter(FORMATTER);
        }
    }

    public static class YearMonthWriter
    extends TemporalWriter<YearMonth> {
        public static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).toFormatter();

        public YearMonthWriter() {
            this.setFormatter(FORMATTER);
        }
    }

    public static class ZonedDateTimeWriter
    extends TemporalWriter<ZonedDateTime> {
        public ZonedDateTimeWriter() {
            this.setFormatter(DateTimeFormatter.ISO_ZONED_DATE_TIME);
        }
    }

    public static class LocalDateTimeWriter
    extends TemporalWriter<LocalDateTime> {
        public LocalDateTimeWriter() {
            this.setFormatter(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
    }

    public static class LocalTimeWriter
    extends TemporalWriter<LocalTime> {
        public LocalTimeWriter() {
            this.setFormatter(DateTimeFormatter.ISO_LOCAL_TIME);
        }
    }

    public static class LocalDateWriter
    extends TemporalWriter<LocalDate> {
        public LocalDateWriter() {
            this.setFormatter(DateTimeFormatter.ISO_LOCAL_DATE);
        }
    }

    public static class TemporalWriter<T extends TemporalAccessor>
    extends PrimitiveTypeWriter {
        protected DateTimeFormatter formatter;

        public void setFormatter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public void writePrimitiveForm(Object obj, Writer output, WriterContext writerContext) throws IOException {
            this.writePrimitiveForm((TemporalAccessor)obj, output);
        }

        protected void writePrimitiveForm(T temporal, Writer output) throws IOException {
            JsonWriter.writeBasicString(output, this.formatter.format((TemporalAccessor)temporal));
        }
    }

    public static class LocalDateAsLong
    extends PrimitiveTypeWriter {
        private final ZoneId zoneId;

        public LocalDateAsLong(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        public LocalDateAsLong() {
            this(ZoneId.systemDefault());
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext writerContext) throws IOException {
            LocalDate localDate = (LocalDate)o;
            ZonedDateTime zonedDateTime = localDate.atStartOfDay(this.zoneId);
            Instant instant = zonedDateTime.toInstant();
            long epochMilli = instant.toEpochMilli();
            output.write(Long.toString(epochMilli));
        }
    }

    public static class DateWriter
    extends PrimitiveUtf8StringWriter {
        private final String dateFormat;

        public DateWriter(String format) {
            this.dateFormat = format;
        }

        @Override
        public String extractString(Object o) {
            Date date = (Date)o;
            return new SimpleDateFormat(this.dateFormat).format(date);
        }

        String getDateFormat() {
            return this.dateFormat;
        }
    }

    public static class DateAsLongWriter
    extends PrimitiveValueWriter {
        @Override
        public String extractString(Object o) {
            return Long.toString(((Date)o).getTime());
        }
    }

    public static class CalendarWriter
    implements JsonWriter.JsonClassWriter {
        @Override
        public void write(Object obj, boolean showType, Writer output, WriterContext context) throws IOException {
            Calendar cal = (Calendar)obj;
            MetaUtils.dateFormat.get().setTimeZone(cal.getTimeZone());
            output.write("\"time\":\"");
            output.write(MetaUtils.dateFormat.get().format(cal.getTime()));
            output.write("\",\"zone\":\"");
            output.write(cal.getTimeZone().getID());
            output.write(34);
        }
    }

    public static class EnumsAsStringWriter
    extends PrimitiveUtf8StringWriter {
        @Override
        protected String getKey() {
            return "name";
        }

        @Override
        public String extractString(Object o) {
            return ((Enum)o).name();
        }
    }

    public static class ClassWriter
    extends PrimitiveUtf8StringWriter {
        @Override
        public String extractString(Object o) {
            return ((Class)o).getName();
        }
    }

    public static class TimeZoneWriter
    extends PrimitiveUtf8StringWriter {
        @Override
        public String extractString(Object o) {
            return ((TimeZone)o).getID();
        }
    }

    public static class PrimitiveBasicStringWriter
    extends PrimitiveTypeWriter {
        public String extractString(Object o) {
            return o.toString();
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext writerContext) throws IOException {
            JsonWriter.writeBasicString(output, this.extractString(o));
        }
    }

    public static class CharacterWriter
    extends PrimitiveTypeWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            JsonWriter.writeJsonUtf8String(output, "" + ((Character)o).charValue());
        }
    }

    public static class PrimitiveUtf8StringWriter
    extends PrimitiveTypeWriter {
        public String extractString(Object o) {
            return o.toString();
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext writerContext) throws IOException {
            JsonWriter.writeJsonUtf8String(output, this.extractString(o));
        }
    }

    public static class DoubleWriter
    extends FloatingPointWriter<Double> {
        @Override
        boolean isNanOrInfinity(Double value) {
            return value.isNaN() || value.isInfinite();
        }
    }

    public static class FloatWriter
    extends FloatingPointWriter<Float> {
        @Override
        boolean isNanOrInfinity(Float value) {
            return value.isNaN() || value.isInfinite();
        }
    }

    public static abstract class FloatingPointWriter<T>
    extends PrimitiveTypeWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            if (!context.getWriteOptions().isAllowNanAndInfinity() && this.isNanOrInfinity(o)) {
                output.write("null");
            } else {
                output.write(o.toString());
            }
        }

        abstract boolean isNanOrInfinity(T var1);
    }

    public static class PrimitiveValueWriter
    extends PrimitiveTypeWriter {
        public String extractString(Object o) {
            return o.toString();
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            output.write(this.extractString(o));
        }
    }

    public static class PrimitiveTypeWriter
    implements JsonWriter.JsonClassWriter {
        protected String getKey() {
            return "value";
        }

        @Override
        public void write(Object obj, boolean showType, Writer output, WriterContext context) throws IOException {
            if (showType) {
                JsonWriter.writeBasicString(output, this.getKey());
                output.write(58);
            }
            this.writePrimitiveForm(obj, output, context);
        }

        @Override
        public boolean hasPrimitiveForm(WriterContext writerContext) {
            return true;
        }
    }
}

