/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.Primitives;
import com.cedarsoftware.util.io.ReadOptions;
import com.cedarsoftware.util.io.ReferenceTracker;
import com.cedarsoftware.util.io.Resolver;
import com.cedarsoftware.util.reflect.Injector;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjectResolver
extends Resolver {
    private final ClassLoader classLoader;

    protected ObjectResolver(ReadOptions readOptions, ReferenceTracker references, Converter converter) {
        super(readOptions, references, converter);
        this.classLoader = readOptions.getClassLoader();
    }

    @Override
    public void traverseFields(Deque<JsonObject> stack, JsonObject jsonObj) {
        Object javaMate = jsonObj.getTarget();
        Iterator<Map.Entry<Object, Object>> i = jsonObj.entrySet().iterator();
        Class<?> cls = javaMate.getClass();
        Map<String, Injector> injectorMap = this.getReadOptions().getDeepInjectorMap(cls);
        while (i.hasNext()) {
            Map.Entry<Object, Object> e = i.next();
            String key = (String)e.getKey();
            Injector injector = injectorMap.get(key);
            Object rhs = e.getValue();
            if (injector != null) {
                this.assignField(stack, jsonObj, injector, rhs);
                continue;
            }
            if (this.getReadOptions().getMissingFieldHandler() == null) continue;
            this.handleMissingField(stack, jsonObj, rhs, key);
        }
    }

    static boolean isBasicWrapperType(Class clazz) {
        return Primitives.PRIMITIVE_WRAPPERS.contains(clazz);
    }

    protected void assignField(Deque<JsonObject> stack, JsonObject jsonObj, Injector injector, Object rhs) {
        Object target = jsonObj.getTarget();
        Class<?> targetClass = target.getClass();
        try {
            Object special;
            Class<?> fieldType = injector.getType();
            if (rhs == null) {
                if (fieldType.isPrimitive()) {
                    if (ObjectResolver.isBasicWrapperType(targetClass)) {
                        jsonObj.setTarget(this.getConverter().convert((Object)"0", fieldType));
                    } else {
                        injector.inject(target, this.getConverter().convert((Object)"0", fieldType));
                    }
                } else {
                    injector.inject(target, null);
                }
                return;
            }
            if (rhs instanceof JsonObject) {
                JsonObject job;
                if (injector.getGenericType() instanceof ParameterizedType) {
                    this.markUntypedObjects(injector.getGenericType(), rhs, fieldType);
                }
                if ((job = (JsonObject)rhs).getJavaType() == null) {
                    job.setJavaType(fieldType);
                }
            }
            if ((special = this.readWithFactoryIfExists(rhs, fieldType, stack)) != null) {
                injector.inject(target, special);
            } else if (rhs.getClass().isArray()) {
                Object[] elements = (Object[])rhs;
                JsonObject jsonArray = new JsonObject();
                if (char[].class == fieldType) {
                    if (elements.length == 0) {
                        injector.inject(target, new char[0]);
                    } else {
                        injector.inject(target, ((String)elements[0]).toCharArray());
                    }
                } else {
                    jsonArray.put("@items", elements);
                    jsonArray.setHintType(fieldType);
                    this.createInstance(jsonArray);
                    injector.inject(target, jsonArray.getTarget());
                    stack.addFirst(jsonArray);
                }
            } else if (rhs instanceof JsonObject) {
                JsonObject jsRhs = (JsonObject)rhs;
                Long ref = jsRhs.getReferenceId();
                if (ref != null) {
                    JsonObject refObject = this.getReferences().get(ref);
                    if (refObject.getTarget() != null) {
                        injector.inject(target, refObject.getTarget());
                    } else {
                        this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, injector.getName(), (long)ref));
                    }
                } else {
                    Object javaObj;
                    jsRhs.setHintType(fieldType);
                    Object fieldObject = this.createInstance(jsRhs);
                    injector.inject(target, fieldObject);
                    boolean isNonRefClass = this.getReadOptions().isNonReferenceableClass(jsRhs.getJavaType());
                    if (!isNonRefClass && (javaObj = this.convertJsonValuesToJava(jsRhs)) != fieldObject) {
                        injector.inject(target, javaObj);
                    }
                }
            } else if (rhs instanceof String && ((String)rhs).trim().isEmpty() && fieldType != String.class) {
                injector.inject(target, null);
            } else {
                injector.inject(target, rhs);
            }
        }
        catch (Exception e) {
            if (e instanceof JsonIoException) {
                throw e;
            }
            throw new JsonIoException("Unable to set field: " + injector.getName() + " on target: " + ObjectResolver.safeToString(target) + " with value: " + rhs, e);
        }
    }

    protected void handleMissingField(Deque<JsonObject> stack, JsonObject jsonObj, Object rhs, String missingField) {
        Object target = jsonObj.getTarget();
        try {
            if (rhs == null) {
                this.storeMissingField(target, missingField, null);
                return;
            }
            Object special = this.readWithFactoryIfExists(rhs, null, stack);
            if (special != null) {
                this.storeMissingField(target, missingField, special);
            } else if (rhs.getClass().isArray()) {
                this.storeMissingField(target, missingField, null);
            } else if (rhs instanceof JsonObject) {
                JsonObject jObj = (JsonObject)rhs;
                Long ref = jObj.getReferenceId();
                if (ref != null) {
                    JsonObject refObject = this.getReferences().get(ref);
                    this.storeMissingField(target, missingField, refObject.getTarget());
                } else if (jObj.getJavaType() != null) {
                    Object javaInstance = this.createInstance(jObj);
                    boolean isNonRefClass = this.getReadOptions().isNonReferenceableClass(jObj.getJavaType());
                    if (!isNonRefClass && !jObj.isFinished) {
                        stack.addFirst((JsonObject)rhs);
                    }
                    this.storeMissingField(target, missingField, javaInstance);
                } else {
                    this.storeMissingField(target, missingField, null);
                }
            } else {
                this.storeMissingField(target, missingField, rhs);
            }
        }
        catch (Exception e) {
            if (e instanceof JsonIoException) {
                throw e;
            }
            String message = e.getClass().getSimpleName() + " missing field '" + missingField + "' on target: " + ObjectResolver.safeToString(target) + " with value: " + rhs;
            throw new JsonIoException(message, e);
        }
    }

    private void storeMissingField(Object target, String missingField, Object value) {
        this.missingFields.add(new Resolver.Missingfields(target, missingField, value));
    }

    private static String safeToString(Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Exception e) {
            return o.getClass().toString();
        }
    }

    @Override
    protected void traverseCollection(Deque<JsonObject> stack, JsonObject jsonObj) {
        String className = jsonObj.getJavaTypeName();
        Object[] items = jsonObj.getArray();
        if (items == null || items.length == 0) {
            if (className != null && className.startsWith("java.util.Immutable")) {
                if (className.contains("Set")) {
                    jsonObj.setTarget(MetaUtils.setOf(new Object[0]));
                } else if (className.contains("List")) {
                    jsonObj.setTarget(MetaUtils.listOf(new Object[0]));
                }
            }
            return;
        }
        Class mayEnumClass = null;
        String mayEnumClasName = (String)jsonObj.get("@enum");
        if (mayEnumClasName != null) {
            mayEnumClass = ClassUtilities.forName((String)mayEnumClasName, (ClassLoader)this.classLoader);
        }
        boolean isImmutable = className != null && className.startsWith("java.util.Immutable");
        Collection<Object> col = isImmutable ? new ArrayList() : (Collection)jsonObj.getTarget();
        boolean isList = col instanceof List;
        int idx = 0;
        for (Object element : items) {
            if (element == null) {
                col.add(null);
            } else {
                JsonObject jObj;
                Object special = this.readWithFactoryIfExists(element, null, stack);
                if (special != null) {
                    col.add(special);
                } else if (element instanceof String || element instanceof Boolean || element instanceof Double || element instanceof Long) {
                    if (mayEnumClass == null) {
                        col.add(element);
                    } else {
                        col.add(Enum.valueOf(mayEnumClass, (String)element));
                    }
                } else if (element.getClass().isArray()) {
                    jObj = new JsonObject();
                    jObj.setHintType(Object.class);
                    jObj.put("@items", element);
                    this.createInstance(jObj);
                    col.add(jObj.getTarget());
                    this.convertJsonValuesToJava(jObj);
                } else {
                    jObj = (JsonObject)element;
                    Long ref = jObj.getReferenceId();
                    if (ref != null) {
                        JsonObject refObject = this.getReferences().get(ref);
                        if (refObject.getTarget() != null) {
                            col.add(refObject.getTarget());
                        } else {
                            this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, idx, (long)ref));
                            if (isList) {
                                col.add(null);
                            }
                        }
                    } else {
                        jObj.setHintType(Object.class);
                        this.createInstance(jObj);
                        boolean isNonRefClass = this.getReadOptions().isNonReferenceableClass(jObj.getJavaType());
                        if (!isNonRefClass) {
                            this.convertJsonValuesToJava(jObj);
                        }
                        if (!(col instanceof EnumSet)) {
                            col.add(jObj.getTarget());
                        }
                    }
                }
            }
            ++idx;
        }
        ObjectResolver.reconcileCollection(jsonObj, col);
        jsonObj.remove("@items");
    }

    public static void reconcileCollection(JsonObject jsonObj, Collection col) {
        boolean isImmutable;
        String className = jsonObj.getJavaTypeName();
        boolean bl = isImmutable = className != null && className.startsWith("java.util.Immutable");
        if (!isImmutable) {
            return;
        }
        if (col == null && jsonObj.getTarget() instanceof Collection) {
            col = (Collection)jsonObj.getTarget();
        }
        if (col == null) {
            return;
        }
        if (className.contains("List")) {
            if (col.stream().noneMatch(c -> c == null || c instanceof JsonObject)) {
                jsonObj.setTarget(MetaUtils.listOf(col.toArray()));
            } else {
                jsonObj.setTarget(col);
            }
        } else if (className.contains("Set")) {
            jsonObj.setTarget(MetaUtils.setOf(col.toArray()));
        } else {
            jsonObj.setTarget(col);
        }
    }

    @Override
    protected void traverseArray(Deque<JsonObject> stack, JsonObject jsonObj) {
        int len = jsonObj.getLength();
        if (len == 0) {
            return;
        }
        Class<?> compType = jsonObj.getComponentType();
        if (Character.TYPE == compType) {
            return;
        }
        if (Byte.TYPE == compType) {
            jsonObj.clearArray();
            return;
        }
        boolean isPrimitive = Primitives.isPrimitive(compType);
        Object array = jsonObj.getTarget();
        Object[] items = jsonObj.getArray();
        for (int i = 0; i < len; ++i) {
            JsonObject jsonObject;
            Object element = items[i];
            if (element == null) {
                Array.set(array, i, null);
                continue;
            }
            Object special = this.readWithFactoryIfExists(element, compType, stack);
            if (special != null) {
                if (compType.isEnum() && special instanceof String) {
                    special = Enum.valueOf(compType, (String)special);
                }
                Array.set(array, i, special);
                continue;
            }
            if (isPrimitive) {
                Array.set(array, i, this.getConverter().convert(element, compType));
                continue;
            }
            if (element.getClass().isArray()) {
                if (char[].class == compType) {
                    Object[] jsonArray = (Object[])element;
                    if (jsonArray.length == 0) {
                        Array.set(array, i, new char[0]);
                        continue;
                    }
                    String value = (String)jsonArray[0];
                    int numChars = value.length();
                    char[] chars = new char[numChars];
                    for (int j = 0; j < numChars; ++j) {
                        chars[j] = value.charAt(j);
                    }
                    Array.set(array, i, chars);
                    continue;
                }
                jsonObject = new JsonObject();
                jsonObject.put("@items", element);
                jsonObject.setHintType(compType);
                Array.set(array, i, this.createInstance(jsonObject));
                stack.addFirst(jsonObject);
                continue;
            }
            if (element instanceof JsonObject) {
                jsonObject = (JsonObject)element;
                Long ref = jsonObject.getReferenceId();
                if (ref != null) {
                    JsonObject refObject = this.getReferences().get(ref);
                    if (refObject.getTarget() != null) {
                        Array.set(array, i, refObject.getTarget());
                        continue;
                    }
                    this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, i, (long)ref));
                    continue;
                }
                jsonObject.setHintType(compType);
                Object arrayElement = this.createInstance(jsonObject);
                Array.set(array, i, arrayElement);
                boolean isNonRefClass = this.getReadOptions().isNonReferenceableClass(arrayElement.getClass());
                if (isNonRefClass || jsonObject.isFinished) continue;
                stack.addFirst(jsonObject);
                continue;
            }
            if (element instanceof String && "".equals(((String)element).trim()) && compType != String.class && compType != Object.class) {
                Array.set(array, i, null);
                continue;
            }
            Array.set(array, i, element);
        }
        jsonObj.clearArray();
    }

    @Override
    protected Object readWithFactoryIfExists(Object o, Class inferredType, Deque<JsonObject> stack) {
        JsonReader.JsonClassReader closestReader;
        JsonReader.ClassFactory classFactory;
        Class c;
        JsonObject jsonObj;
        block26: {
            if (o == null) {
                throw new JsonIoException("Bug in json-io, null must be checked before calling this method.");
            }
            if (inferredType != null && this.getReadOptions().isNotCustomReaderClass(inferredType)) {
                return null;
            }
            boolean isJsonObject = o instanceof JsonObject;
            if (!isJsonObject && inferredType == null) {
                return null;
            }
            if (isJsonObject) {
                jsonObj = (JsonObject)o;
                if (jsonObj.isReference()) {
                    return null;
                }
                if (jsonObj.getTarget() == null) {
                    String typeStr = null;
                    try {
                        String type = jsonObj.getJavaTypeName();
                        if (type != null) {
                            typeStr = type;
                            c = ClassUtilities.forName((String)type, (ClassLoader)this.classLoader);
                        } else if (inferredType != null) {
                            c = inferredType;
                        } else {
                            return null;
                        }
                        jsonObj.setHintType(c);
                        Object factoryCreated = this.createInstance(jsonObj);
                        if (factoryCreated != null && jsonObj.isFinished) {
                            return factoryCreated;
                        }
                        break block26;
                    }
                    catch (JsonIoException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new JsonIoException("Unable to determine type", e);
                    }
                }
                c = jsonObj.getJavaType();
            } else {
                c = inferredType;
                jsonObj = new JsonObject();
                jsonObj.setValue(o);
            }
        }
        if (null == c) {
            return null;
        }
        if (jsonObj.getJavaType() == null) {
            jsonObj.setJavaType(c);
        }
        if (this.getReadOptions().isNotCustomReaderClass(c)) {
            return null;
        }
        if (jsonObj.getTarget() == null) {
            if (jsonObj.hasValue() && jsonObj.getValue() != null) {
                if (this.getConverter().isConversionSupportedFor(jsonObj.getValue().getClass(), c)) {
                    Object target = this.getConverter().convert(jsonObj.getValue(), c);
                    return jsonObj.setFinishedTarget(target, true);
                }
            } else if (MetaUtils.isLogicalPrimitive(c) && this.getConverter().isConversionSupportedFor(Map.class, c)) {
                JsonObject source = this.resolveRefs(jsonObj);
                Object value = this.getConverter().convert((Object)source, c);
                return jsonObj.setFinishedTarget(value, true);
            }
        }
        if ((classFactory = this.getReadOptions().getClassFactory(c)) != null && jsonObj.getTarget() == null) {
            Object target = this.createInstanceUsingClassFactory(c, jsonObj);
            if (jsonObj.isFinished()) {
                return target;
            }
        }
        if ((closestReader = this.getReadOptions().getCustomReader(c)) == null) {
            return null;
        }
        Object read = closestReader.read(o, stack, this);
        return jsonObj.setFinishedTarget(read, true);
    }

    /*
     * WARNING - void declaration
     */
    private void markUntypedObjects(Type type, Object rhs, Class<?> fieldType) {
        ArrayDeque<Object[]> stack = new ArrayDeque<Object[]>();
        stack.addFirst(new Object[]{type, rhs});
        Map<String, Injector> classFields = this.getReadOptions().getDeepInjectorMap(fieldType);
        while (!stack.isEmpty()) {
            Object[] item = (Object[])stack.removeFirst();
            Type t = (Type)item[0];
            Object instance = item[1];
            if (t instanceof ParameterizedType) {
                JsonObject jObj;
                Class clazz = ObjectResolver.getRawType(t);
                ParameterizedType pType = (ParameterizedType)t;
                Type[] typeArgs = pType.getActualTypeArguments();
                if (typeArgs == null || typeArgs.length < 1 || clazz == null) continue;
                ObjectResolver.stampTypeOnJsonObject(instance, t);
                if (Map.class.isAssignableFrom(clazz)) {
                    Map map = (Map)instance;
                    if (!map.containsKey("@keys") && !map.containsKey("@items") && map instanceof JsonObject) {
                        ObjectResolver.convertMapToKeysItems((JsonObject)map);
                    }
                    Object[] keys = (Object[])map.get("@keys");
                    ObjectResolver.getTemplateTraverseWorkItem(stack, keys, typeArgs[0]);
                    Object[] objectArray = (Object[])map.get("@items");
                    ObjectResolver.getTemplateTraverseWorkItem(stack, objectArray, typeArgs[1]);
                    continue;
                }
                if (Collection.class.isAssignableFrom(clazz)) {
                    Object[] array;
                    if (instance instanceof Object[]) {
                        Object[] array2 = (Object[])instance;
                        for (int i = 0; i < array2.length; ++i) {
                            Object object = array2[i];
                            stack.addFirst(new Object[]{t, object});
                            if (object instanceof JsonObject) {
                                stack.addFirst(new Object[]{t, object});
                                continue;
                            }
                            if (object instanceof Object[]) {
                                JsonObject coll = new JsonObject();
                                coll.setJavaType(clazz);
                                List<Object> items = Arrays.asList((Object[])object);
                                coll.put("@items", items.toArray());
                                stack.addFirst(new Object[]{t, items});
                                array2[i] = coll;
                                continue;
                            }
                            stack.addFirst(new Object[]{t, object});
                        }
                        continue;
                    }
                    if (instance instanceof Collection) {
                        Collection col = (Collection)instance;
                        for (Object e : col) {
                            stack.addFirst(new Object[]{typeArgs[0], e});
                        }
                        continue;
                    }
                    if (!(instance instanceof JsonObject) || (array = (jObj = (JsonObject)instance).getArray()) == null) continue;
                    for (Object object : array) {
                        stack.addFirst(new Object[]{typeArgs[0], object});
                    }
                    continue;
                }
                if (!(instance instanceof JsonObject)) continue;
                jObj = (JsonObject)instance;
                for (Map.Entry<Object, Object> entry : jObj.entrySet()) {
                    void var17_31;
                    Injector injector;
                    String fieldName = (String)entry.getKey();
                    if (fieldName.startsWith("this$") || (injector = classFields.get(fieldName)) == null || injector.getType().getTypeParameters().length <= 0 && !(injector.getGenericType() instanceof TypeVariable)) continue;
                    Type type2 = typeArgs[0];
                    if (entry.getValue() instanceof JsonObject && ((JsonObject)entry.getValue()).get("@enum") != null) {
                        Type type3 = injector.getGenericType();
                    }
                    stack.addFirst(new Object[]{var17_31, entry.getValue()});
                }
                continue;
            }
            ObjectResolver.stampTypeOnJsonObject(instance, t);
        }
    }

    private static void getTemplateTraverseWorkItem(Deque<Object[]> stack, Object[] items, Type type) {
        if (items == null || items.length < 1) {
            return;
        }
        Class rawType = ObjectResolver.getRawType(type);
        if (rawType != null && Collection.class.isAssignableFrom(rawType)) {
            stack.add(new Object[]{type, items});
        } else {
            for (Object o : items) {
                stack.add(new Object[]{type, o});
            }
        }
    }

    private static void stampTypeOnJsonObject(Object o, Type t) {
        JsonObject jObj;
        Class clazz;
        Class clazz2 = clazz = t instanceof Class ? (Class)t : ObjectResolver.getRawType(t);
        if (o instanceof JsonObject && clazz != null && (jObj = (JsonObject)o).getJavaType() == null && jObj.getTarget() == null) {
            jObj.setJavaType(clazz);
        }
    }

    public static Class getRawType(Type t) {
        ParameterizedType pType;
        if (t instanceof ParameterizedType && (pType = (ParameterizedType)t).getRawType() instanceof Class) {
            return (Class)pType.getRawType();
        }
        return null;
    }
}

