/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonParser;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.Primitives;
import com.cedarsoftware.util.io.ReadOptions;
import com.cedarsoftware.util.io.ReferenceTracker;
import com.cedarsoftware.util.io.Resolver;
import com.cedarsoftware.util.reflect.ClassDescriptors;
import com.cedarsoftware.util.reflect.Injector;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjectResolver
extends Resolver {
    private final ClassLoader classLoader;
    protected final JsonReader.MissingFieldHandler missingFieldHandler;

    protected ObjectResolver(ReadOptions readOptions, ReferenceTracker references) {
        super(readOptions, references);
        this.classLoader = readOptions.getClassLoader();
        this.missingFieldHandler = readOptions.getMissingFieldHandler();
    }

    @Override
    public void traverseFields(Deque<JsonObject> stack, JsonObject jsonObj) {
        Object javaMate = jsonObj.target;
        Iterator i = jsonObj.entrySet().iterator();
        Class<?> cls = javaMate.getClass();
        Map<String, Injector> injectorMap = ClassDescriptors.instance().getDeepInjectorMap(cls);
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            Injector injector = injectorMap.get(key);
            Object rhs = e.getValue();
            if (injector != null) {
                this.assignField(stack, jsonObj, injector, rhs);
                continue;
            }
            if (this.missingFieldHandler == null) continue;
            this.handleMissingField(stack, jsonObj, rhs, key);
        }
    }

    static boolean isBasicWrapperType(Class clazz) {
        return clazz == Boolean.class || clazz == Integer.class || clazz == Byte.class || clazz == Long.class || clazz == Short.class || clazz == Character.class || clazz == Double.class || clazz == Float.class;
    }

    protected void assignField(Deque<JsonObject> stack, JsonObject jsonObj, Injector injector, Object rhs) {
        Object target = jsonObj.target;
        Class<?> targetClass = target.getClass();
        try {
            Class<?> fieldType = injector.getType();
            if (rhs == null) {
                if (fieldType.isPrimitive()) {
                    if (ObjectResolver.isBasicWrapperType(targetClass)) {
                        jsonObj.target = MetaUtils.convert(fieldType, "0");
                    } else {
                        injector.inject(target, MetaUtils.convert(fieldType, "0"));
                    }
                } else {
                    injector.inject(target, null);
                }
                return;
            }
            if (rhs instanceof JsonObject) {
                if (injector.getGenericType() instanceof ParameterizedType) {
                    this.markUntypedObjects(injector.getGenericType(), rhs, fieldType);
                }
                JsonObject job = (JsonObject)rhs;
                String type = job.type;
                if (type == null || type.isEmpty()) {
                    job.setType(fieldType.getName());
                }
            }
            if (rhs == JsonParser.EMPTY_OBJECT) {
                JsonObject jObj = new JsonObject();
                jObj.type = fieldType.getName();
                Object value = this.createInstance(fieldType, jObj);
                injector.inject(target, value);
            } else {
                Object special = this.readWithFactoryIfExists(rhs, fieldType, stack);
                if (special != null) {
                    injector.inject(target, special);
                } else if (rhs.getClass().isArray()) {
                    Object[] elements = (Object[])rhs;
                    JsonObject jsonArray = new JsonObject();
                    if (char[].class == fieldType) {
                        if (elements.length == 0) {
                            injector.inject(target, new char[0]);
                        } else {
                            injector.inject(target, ((String)elements[0]).toCharArray());
                        }
                    } else {
                        jsonArray.put("@items", elements);
                        this.createInstance(fieldType, jsonArray);
                        injector.inject(target, jsonArray.target);
                        stack.addFirst(jsonArray);
                    }
                } else if (rhs instanceof JsonObject) {
                    JsonObject jsRhs = (JsonObject)rhs;
                    Long ref = jsRhs.getReferenceId();
                    if (ref != null) {
                        JsonObject refObject = this.getReferences().get(ref);
                        if (refObject.target != null) {
                            injector.inject(target, refObject.target);
                        } else {
                            this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, injector.getName(), (long)ref));
                        }
                    } else {
                        Object javaObj;
                        Object fieldObject = this.createInstance(fieldType, jsRhs);
                        injector.inject(target, fieldObject);
                        if (!this.getReadOptions().isLogicalPrimitive(jsRhs.getTargetClass()) && (javaObj = this.convertMapsToObjects(jsRhs)) != fieldObject) {
                            injector.inject(target, javaObj);
                        }
                    }
                } else if (Primitives.isPrimitive(fieldType)) {
                    Object converted = MetaUtils.convert(fieldType, rhs);
                    if (ObjectResolver.isBasicWrapperType(targetClass)) {
                        jsonObj.target = converted;
                    } else {
                        injector.inject(target, converted);
                    }
                } else if (rhs instanceof String && ((String)rhs).trim().isEmpty() && fieldType != String.class) {
                    injector.inject(target, null);
                } else {
                    injector.inject(target, rhs);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof JsonIoException) {
                throw e;
            }
            throw new JsonIoException("Unable to set field: " + injector.getName() + " on target: " + ObjectResolver.safeToString(target) + " with value: " + rhs, e);
        }
    }

    protected void handleMissingField(Deque<JsonObject> stack, JsonObject jsonObj, Object rhs, String missingField) {
        Object target = jsonObj.target;
        try {
            if (rhs == null) {
                this.storeMissingField(target, missingField, null);
                return;
            }
            if (rhs == JsonParser.EMPTY_OBJECT) {
                this.storeMissingField(target, missingField, null);
            } else {
                Object special = this.readWithFactoryIfExists(rhs, null, stack);
                if (special != null) {
                    this.storeMissingField(target, missingField, special);
                } else if (rhs.getClass().isArray()) {
                    this.storeMissingField(target, missingField, null);
                } else if (rhs instanceof JsonObject) {
                    JsonObject jObj = (JsonObject)rhs;
                    Long ref = jObj.getReferenceId();
                    if (ref != null) {
                        JsonObject refObject = this.getReferences().get(ref);
                        this.storeMissingField(target, missingField, refObject.target);
                    } else if (jObj.getType() != null) {
                        Object createJavaObjectInstance = this.createInstance(null, jObj);
                        if (!this.getReadOptions().isLogicalPrimitive(jObj.getTargetClass())) {
                            stack.addFirst((JsonObject)rhs);
                        }
                        this.storeMissingField(target, missingField, createJavaObjectInstance);
                    } else {
                        this.storeMissingField(target, missingField, null);
                    }
                } else {
                    this.storeMissingField(target, missingField, rhs);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof JsonIoException) {
                throw e;
            }
            String message = e.getClass().getSimpleName() + " missing field '" + missingField + "' on target: " + ObjectResolver.safeToString(target) + " with value: " + rhs;
            throw new JsonIoException(message, e);
        }
    }

    private void storeMissingField(Object target, String missingField, Object value) {
        this.missingFields.add(new Resolver.Missingfields(target, missingField, value));
    }

    private static String safeToString(Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Exception e) {
            return o.getClass().toString();
        }
    }

    @Override
    protected void traverseCollection(Deque<JsonObject> stack, JsonObject jsonObj) {
        String className = jsonObj.type;
        Object[] items = jsonObj.getArray();
        if (items == null || items.length == 0) {
            if (className != null && className.startsWith("java.util.Immutable")) {
                if (className.contains("Set")) {
                    jsonObj.target = MetaUtils.setOf(new Object[0]);
                } else if (className.contains("List")) {
                    jsonObj.target = MetaUtils.listOf(new Object[0]);
                }
            }
            return;
        }
        Class<?> mayEnumClass = null;
        String mayEnumClasName = (String)jsonObj.get("@enum");
        if (mayEnumClasName != null) {
            mayEnumClass = MetaUtils.classForName(mayEnumClasName, this.classLoader);
        }
        boolean isImmutable = className != null && className.startsWith("java.util.Immutable");
        Collection<JsonObject> col = isImmutable ? new ArrayList() : (Collection)jsonObj.target;
        boolean isList = col instanceof List;
        int idx = 0;
        for (Object element : items) {
            if (element == null) {
                col.add(null);
            } else if (element == JsonParser.EMPTY_OBJECT) {
                col.add(new JsonObject());
            } else {
                JsonObject jObj;
                Object special = this.readWithFactoryIfExists(element, null, stack);
                if (special != null) {
                    col.add((JsonObject)special);
                } else if (element instanceof String || element instanceof Boolean || element instanceof Double || element instanceof Long) {
                    if (mayEnumClass == null) {
                        col.add((JsonObject)element);
                    } else {
                        col.add((JsonObject)Enum.valueOf(mayEnumClass, (String)element));
                    }
                } else if (element.getClass().isArray()) {
                    jObj = new JsonObject();
                    jObj.put("@items", element);
                    this.createInstance(Object.class, jObj);
                    col.add((JsonObject)jObj.target);
                    this.convertMapsToObjects(jObj);
                } else {
                    jObj = (JsonObject)element;
                    Long ref = jObj.getReferenceId();
                    if (ref != null) {
                        JsonObject refObject = this.getReferences().get(ref);
                        if (refObject.target != null) {
                            col.add((JsonObject)refObject.target);
                        } else {
                            this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, idx, (long)ref));
                            if (isList) {
                                col.add(null);
                            }
                        }
                    } else {
                        this.createInstance(Object.class, jObj);
                        if (!this.getReadOptions().isLogicalPrimitive(jObj.getTargetClass())) {
                            this.convertMapsToObjects(jObj);
                        }
                        if (!(col instanceof EnumSet)) {
                            col.add((JsonObject)jObj.target);
                        }
                    }
                }
            }
            ++idx;
        }
        ObjectResolver.reconcileCollection(jsonObj, col);
        jsonObj.remove("@items");
    }

    public static void reconcileCollection(JsonObject jsonObj, Collection col) {
        boolean isImmutable;
        String className = jsonObj.type;
        boolean bl = isImmutable = className != null && className.startsWith("java.util.Immutable");
        if (!isImmutable) {
            return;
        }
        if (col == null && jsonObj.target instanceof Collection) {
            col = (Collection)jsonObj.target;
        }
        if (col == null) {
            return;
        }
        jsonObj.target = className.contains("List") ? (col.stream().noneMatch(c -> c == null || c instanceof JsonObject) ? MetaUtils.listOf(col.toArray()) : col) : (className.contains("Set") ? MetaUtils.setOf(col.toArray()) : col);
    }

    @Override
    protected void traverseArray(Deque<JsonObject> stack, JsonObject jsonObj) {
        int len = jsonObj.getLength();
        if (len == 0) {
            return;
        }
        Class<?> compType = jsonObj.getComponentType();
        if (Character.TYPE == compType) {
            return;
        }
        if (Byte.TYPE == compType) {
            jsonObj.moveBytesToMate();
            jsonObj.clearArray();
            return;
        }
        boolean isPrimitive = Primitives.isPrimitive(compType);
        Object array = jsonObj.target;
        Object[] items = jsonObj.getArray();
        for (int i = 0; i < len; ++i) {
            JsonObject jsonObject;
            Object element = items[i];
            if (element == null) {
                Array.set(array, i, null);
                continue;
            }
            if (element == JsonParser.EMPTY_OBJECT) {
                Object arrayElement = this.createInstance(compType, new JsonObject());
                Array.set(array, i, arrayElement);
                continue;
            }
            Object special = this.readWithFactoryIfExists(element, compType, stack);
            if (special != null) {
                if (compType.isEnum() && special instanceof String) {
                    special = Enum.valueOf(compType, (String)special);
                }
                Array.set(array, i, special);
                continue;
            }
            if (isPrimitive) {
                Array.set(array, i, MetaUtils.convert(compType, element));
                continue;
            }
            if (element.getClass().isArray()) {
                if (char[].class == compType) {
                    Object[] jsonArray = (Object[])element;
                    if (jsonArray.length == 0) {
                        Array.set(array, i, new char[0]);
                        continue;
                    }
                    String value = (String)jsonArray[0];
                    int numChars = value.length();
                    char[] chars = new char[numChars];
                    for (int j = 0; j < numChars; ++j) {
                        chars[j] = value.charAt(j);
                    }
                    Array.set(array, i, chars);
                    continue;
                }
                jsonObject = new JsonObject();
                jsonObject.put("@items", element);
                Array.set(array, i, this.createInstance(compType, jsonObject));
                stack.addFirst(jsonObject);
                continue;
            }
            if (element instanceof JsonObject) {
                jsonObject = (JsonObject)element;
                Long ref = jsonObject.getReferenceId();
                if (ref != null) {
                    JsonObject refObject = this.getReferences().get(ref);
                    if (refObject.target != null) {
                        Array.set(array, i, refObject.target);
                        continue;
                    }
                    this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, i, (long)ref));
                    continue;
                }
                Object arrayElement = this.createInstance(compType, jsonObject);
                Array.set(array, i, arrayElement);
                if (this.getReadOptions().isLogicalPrimitive(arrayElement.getClass())) continue;
                stack.addFirst(jsonObject);
                continue;
            }
            if (element instanceof String && "".equals(((String)element).trim()) && compType != String.class && compType != Object.class) {
                Array.set(array, i, null);
                continue;
            }
            Array.set(array, i, element);
        }
        jsonObj.clearArray();
    }

    @Override
    protected Object readWithFactoryIfExists(Object o, Class inferredType, Deque<JsonObject> stack) {
        JsonReader.JsonClassReader closestReader;
        Class<?> c;
        JsonObject jsonObj;
        block20: {
            if (o == null) {
                throw new JsonIoException("Bug in json-io, null must be checked before calling this method.");
            }
            if (inferredType != null && this.getReadOptions().isNonCustomizable(inferredType)) {
                return null;
            }
            boolean isJsonObject = o instanceof JsonObject;
            if (!isJsonObject && inferredType == null) {
                return null;
            }
            if (isJsonObject) {
                jsonObj = (JsonObject)o;
                if (jsonObj.isReference()) {
                    return null;
                }
                if (jsonObj.target == null) {
                    String typeStr = null;
                    try {
                        String type = jsonObj.type;
                        if (type != null) {
                            typeStr = type;
                            c = MetaUtils.classForName(type, this.classLoader);
                        } else if (inferredType != null) {
                            c = inferredType;
                        } else {
                            return null;
                        }
                        Object factoryCreated = this.createInstance(c, jsonObj);
                        if (factoryCreated != null && jsonObj.isFinished) {
                            return factoryCreated;
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        throw new JsonIoException("Class listed in @type [" + typeStr + "] is not found", e);
                    }
                }
                c = jsonObj.target.getClass();
            } else {
                c = inferredType;
                jsonObj = new JsonObject();
                jsonObj.setValue(o);
            }
        }
        if (null == c) {
            return null;
        }
        if (jsonObj.type == null) {
            jsonObj.setType(c.getName());
        }
        if (this.getReadOptions().isNonCustomizable(c)) {
            return null;
        }
        JsonReader.ClassFactory classFactory = this.getReadOptions().getClassFactory(c);
        if (classFactory != null && jsonObj.target == null) {
            Object target = this.createInstanceUsingClassFactory(c, jsonObj);
            if (jsonObj.isFinished()) {
                return target;
            }
        }
        if ((closestReader = this.getCustomReader(c)) == null) {
            return null;
        }
        Object read = closestReader.read(o, stack, this);
        return jsonObj.setFinishedTarget(read, true);
    }

    /*
     * WARNING - void declaration
     */
    private void markUntypedObjects(Type type, Object rhs, Class<?> fieldType) {
        ArrayDeque<Object[]> stack = new ArrayDeque<Object[]>();
        stack.addFirst(new Object[]{type, rhs});
        Map<String, Injector> classFields = ClassDescriptors.instance().getDeepInjectorMap(fieldType);
        while (!stack.isEmpty()) {
            Object[] item = (Object[])stack.removeFirst();
            Type t = (Type)item[0];
            Object instance = item[1];
            if (t instanceof ParameterizedType) {
                JsonObject jObj;
                Class clazz = ObjectResolver.getRawType(t);
                ParameterizedType pType = (ParameterizedType)t;
                Type[] typeArgs = pType.getActualTypeArguments();
                if (typeArgs == null || typeArgs.length < 1 || clazz == null) continue;
                ObjectResolver.stampTypeOnJsonObject(instance, t);
                if (Map.class.isAssignableFrom(clazz)) {
                    Map map = (Map)instance;
                    if (!map.containsKey("@keys") && !map.containsKey("@items") && map instanceof JsonObject) {
                        ObjectResolver.convertMapToKeysItems((JsonObject)map);
                    }
                    Object[] keys = (Object[])map.get("@keys");
                    ObjectResolver.getTemplateTraverseWorkItem(stack, keys, typeArgs[0]);
                    Object[] objectArray = (Object[])map.get("@items");
                    ObjectResolver.getTemplateTraverseWorkItem(stack, objectArray, typeArgs[1]);
                    continue;
                }
                if (Collection.class.isAssignableFrom(clazz)) {
                    Object[] array;
                    if (instance instanceof Object[]) {
                        Object[] array2 = (Object[])instance;
                        for (int i = 0; i < array2.length; ++i) {
                            Object object = array2[i];
                            stack.addFirst(new Object[]{t, object});
                            if (object instanceof JsonObject) {
                                stack.addFirst(new Object[]{t, object});
                                continue;
                            }
                            if (object instanceof Object[]) {
                                JsonObject coll = new JsonObject();
                                coll.type = clazz.getName();
                                List<Object> items = Arrays.asList((Object[])object);
                                coll.put("@items", items.toArray());
                                stack.addFirst(new Object[]{t, items});
                                array2[i] = coll;
                                continue;
                            }
                            stack.addFirst(new Object[]{t, object});
                        }
                        continue;
                    }
                    if (instance instanceof Collection) {
                        Collection col = (Collection)instance;
                        for (Object e : col) {
                            stack.addFirst(new Object[]{typeArgs[0], e});
                        }
                        continue;
                    }
                    if (!(instance instanceof JsonObject) || (array = (jObj = (JsonObject)instance).getArray()) == null) continue;
                    for (Object object : array) {
                        stack.addFirst(new Object[]{typeArgs[0], object});
                    }
                    continue;
                }
                if (!(instance instanceof JsonObject)) continue;
                jObj = (JsonObject)instance;
                for (Map.Entry entry : jObj.entrySet()) {
                    void var17_31;
                    Injector injector;
                    String fieldName = (String)entry.getKey();
                    if (fieldName.startsWith("this$") || (injector = classFields.get(fieldName)) == null || injector.getType().getTypeParameters().length <= 0 && !(injector.getGenericType() instanceof TypeVariable)) continue;
                    Type type2 = typeArgs[0];
                    if (entry.getValue() instanceof JsonObject && ((JsonObject)entry.getValue()).get("@enum") != null) {
                        Type type3 = injector.getGenericType();
                    }
                    stack.addFirst(new Object[]{var17_31, entry.getValue()});
                }
                continue;
            }
            ObjectResolver.stampTypeOnJsonObject(instance, t);
        }
    }

    private static void getTemplateTraverseWorkItem(Deque<Object[]> stack, Object[] items, Type type) {
        if (items == null || items.length < 1) {
            return;
        }
        Class rawType = ObjectResolver.getRawType(type);
        if (rawType != null && Collection.class.isAssignableFrom(rawType)) {
            stack.add(new Object[]{type, items});
        } else {
            for (Object o : items) {
                stack.add(new Object[]{type, o});
            }
        }
    }

    private static void stampTypeOnJsonObject(Object o, Type t) {
        Class clazz;
        Class clazz2 = clazz = t instanceof Class ? (Class)t : ObjectResolver.getRawType(t);
        if (o instanceof JsonObject && clazz != null) {
            JsonObject jObj = (JsonObject)o;
            if ((jObj.type == null || jObj.type.isEmpty()) && jObj.target == null) {
                jObj.type = clazz.getName();
            }
        }
    }

    public static Class getRawType(Type t) {
        ParameterizedType pType;
        if (t instanceof ParameterizedType && (pType = (ParameterizedType)t).getRawType() instanceof Class) {
            return (Class)pType.getRawType();
        }
        return null;
    }
}

