/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.factory.AbstractTemporalFactory;
import com.cedarsoftware.util.io.factory.DateFactory;
import java.time.Instant;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class OffsetTimeFactory
extends AbstractTemporalFactory<OffsetTime> {
    public OffsetTimeFactory(DateTimeFormatter dateFormatter) {
        super(dateFormatter);
    }

    public OffsetTimeFactory() {
        super(DateTimeFormatter.ISO_OFFSET_TIME);
    }

    @Override
    protected OffsetTime fromNumber(Number l) {
        return OffsetTime.from(Instant.ofEpochMilli(l.longValue()));
    }

    @Override
    protected OffsetTime fromString(String s) {
        try {
            return OffsetTime.parse(s, this.dateTimeFormatter);
        }
        catch (Exception e) {
            Date date = DateFactory.parseDate(s);
            return date.toInstant().atZone(ZoneId.systemDefault()).toOffsetDateTime().toOffsetTime();
        }
    }

    @Override
    protected OffsetTime fromJsonObject(JsonObject job) {
        return null;
    }
}

