/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.factory.AbstractTemporalFactory;
import com.cedarsoftware.util.io.factory.DateFactory;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class LocalTimeFactory
extends AbstractTemporalFactory<LocalTime> {
    public LocalTimeFactory(DateTimeFormatter dateFormatter) {
        super(dateFormatter);
    }

    public LocalTimeFactory() {
        super(DateTimeFormatter.ISO_LOCAL_TIME);
    }

    @Override
    protected LocalTime fromString(String s) {
        try {
            return LocalTime.parse(s, this.dateTimeFormatter);
        }
        catch (Exception e) {
            Date date = DateFactory.parseDate(s);
            return date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
        }
    }

    @Override
    protected LocalTime fromNumber(Number l) {
        return LocalTime.from(Instant.ofEpochMilli(l.longValue()));
    }

    @Override
    protected LocalTime fromJsonObject(JsonObject job) {
        Number hour = (Number)job.get("hour");
        Number minute = (Number)job.get("minute");
        Number second = MetaUtils.getValueWithDefaultForNull(job, "second", 0);
        Number nano = MetaUtils.getValueWithDefaultForNull(job, "nano", 0);
        if (hour == null || minute == null) {
            throw new JsonIoException("hour and minute cannot be null if value is null for LocalTimeFactory");
        }
        return LocalTime.of(hour.intValue(), minute.intValue(), second.intValue(), nano.intValue());
    }
}

