/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.FastPushbackReader;
import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonParser;
import com.cedarsoftware.util.io.MapResolver;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.ObjectResolver;
import com.cedarsoftware.util.io.Readers;
import com.cedarsoftware.util.io.Resolver;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class JsonReader
implements Closeable {
    public static final String USE_MAPS = "USE_MAPS";
    public static final String UNKNOWN_OBJECT = "UNKNOWN_OBJECT";
    public static final String TYPE_NAME_MAP = "TYPE_NAME_MAP";
    static final String TYPE_NAME_MAP_REVERSE = "TYPE_NAME_MAP_REVERSE";
    protected static final Map<Class, JsonClassReader> readers = new ConcurrentHashMap<Class, JsonClassReader>();
    protected static final Set<Class> notCustom = new HashSet<Class>();
    private static final Map<Class, ClassFactory> factory = new ConcurrentHashMap<Class, ClassFactory>();
    private final Map<Long, JsonObject> objsRead = new HashMap<Long, JsonObject>();
    private final FastPushbackReader input;
    static final ThreadLocal<FastPushbackReader> threadInput = new ThreadLocal();
    static final ThreadLocal<Map<String, Object>> _args = new ThreadLocal<Map<String, Object>>(){

        @Override
        public Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    static {
        JsonReader.addReader(String.class, new Readers.StringReader());
        JsonReader.addReader(java.util.Date.class, new Readers.DateReader());
        JsonReader.addReader(BigInteger.class, new Readers.BigIntegerReader());
        JsonReader.addReader(BigDecimal.class, new Readers.BigDecimalReader());
        JsonReader.addReader(Date.class, new Readers.SqlDateReader());
        JsonReader.addReader(Timestamp.class, new Readers.TimestampReader());
        JsonReader.addReader(Calendar.class, new Readers.CalendarReader());
        JsonReader.addReader(TimeZone.class, new Readers.TimeZoneReader());
        JsonReader.addReader(Locale.class, new Readers.LocaleReader());
        JsonReader.addReader(Class.class, new Readers.ClassReader());
        JsonReader.addReader(StringBuilder.class, new Readers.StringBuilderReader());
        JsonReader.addReader(StringBuffer.class, new Readers.StringBufferReader());
        CollectionFactory colFactory = new CollectionFactory();
        JsonReader.assignInstantiator(Collection.class, colFactory);
        JsonReader.assignInstantiator(List.class, colFactory);
        JsonReader.assignInstantiator(Set.class, colFactory);
        JsonReader.assignInstantiator(SortedSet.class, colFactory);
        MapFactory mapFactory = new MapFactory();
        JsonReader.assignInstantiator(Map.class, mapFactory);
        JsonReader.assignInstantiator(SortedMap.class, mapFactory);
    }

    public static void assignInstantiator(Class c, ClassFactory f) {
        factory.put(c, f);
    }

    public static void addReader(Class c, JsonClassReader reader) {
        for (Map.Entry<Class, JsonClassReader> entry : readers.entrySet()) {
            Class clz = entry.getKey();
            if (clz != c) continue;
            entry.setValue(reader);
            return;
        }
        readers.put(c, reader);
    }

    public static void addNotCustomReader(Class c) {
        notCustom.add(c);
    }

    protected static Map getArgs() {
        return _args.get();
    }

    public static Object jsonToJava(String json) {
        return JsonReader.jsonToJava(json, new HashMap<String, Object>());
    }

    public static Object jsonToJava(String json, Map<String, Object> optionalArgs) {
        try {
            optionalArgs.put(USE_MAPS, false);
            ByteArrayInputStream ba = new ByteArrayInputStream(json.getBytes("UTF-8"));
            JsonReader jr = new JsonReader((InputStream)ba, optionalArgs);
            Object obj = jr.readObject();
            jr.close();
            return obj;
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonIoException("Could not convert JSON to Java because your JVM does not support UTF-8", e);
        }
    }

    public static Map jsonToMaps(String json) {
        return JsonReader.jsonToMaps(json, new HashMap<String, Object>());
    }

    public static Map jsonToMaps(String json, Map<String, Object> optionalArgs) {
        try {
            optionalArgs.put(USE_MAPS, true);
            ByteArrayInputStream ba = new ByteArrayInputStream(json.getBytes("UTF-8"));
            JsonReader jr = new JsonReader((InputStream)ba, optionalArgs);
            Object ret = jr.readObject();
            jr.close();
            if (ret instanceof Map) {
                return (Map)ret;
            }
            if (ret != null && ret.getClass().isArray()) {
                JsonObject<String, Object> retMap = new JsonObject<String, Object>();
                retMap.put("@items", ret);
                return retMap;
            }
            JsonObject<String, Object[]> retMap = new JsonObject<String, Object[]>();
            retMap.put("@items", new Object[]{ret});
            return retMap;
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonIoException("Could not convert JSON to Maps because your JVM does not support UTF-8", e);
        }
    }

    public JsonReader() {
        this.input = null;
        JsonReader.getArgs().put(USE_MAPS, false);
    }

    public JsonReader(InputStream inp) {
        this(inp, false);
    }

    static Map makeArgMap(Map<String, Object> args, boolean useMaps) {
        args.put(USE_MAPS, useMaps);
        return args;
    }

    public JsonReader(InputStream inp, boolean useMaps) {
        this(inp, JsonReader.makeArgMap(new HashMap<String, Object>(), useMaps));
    }

    public JsonReader(InputStream inp, Map<String, Object> optionalArgs) {
        Map args = JsonReader.getArgs();
        args.clear();
        args.putAll(optionalArgs);
        Map typeNames = (Map)args.get(TYPE_NAME_MAP);
        if (typeNames != null) {
            HashMap<String, String> typeNameMap = new HashMap<String, String>();
            for (Map.Entry entry : typeNames.entrySet()) {
                typeNameMap.put((String)entry.getValue(), (String)entry.getKey());
            }
            args.put(TYPE_NAME_MAP_REVERSE, typeNameMap);
        }
        try {
            this.input = new FastPushbackReader(new BufferedReader(new InputStreamReader(inp, "UTF-8")));
            threadInput.set(this.input);
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonIoException("Your JVM does not support UTF-8.  Get a better JVM.", e);
        }
    }

    public Object readObject() {
        Object graph;
        Object o;
        JsonParser parser = new JsonParser(this.input, this.objsRead, JsonReader.getArgs());
        JsonObject<String, Object> root = new JsonObject<String, Object>();
        try {
            o = parser.readValue(root);
            if (o == "~!o~") {
                return new JsonObject();
            }
        }
        catch (Exception e) {
            throw new JsonIoException("error parsing JSON value", e);
        }
        if (o instanceof Object[]) {
            root.setType(Object[].class.getName());
            root.setTarget(o);
            root.put("@items", o);
            graph = this.convertParsedMapsToJava(root);
        } else {
            Object object = graph = o instanceof JsonObject ? this.convertParsedMapsToJava((JsonObject)o) : o;
        }
        if (this.useMaps()) {
            return o;
        }
        return graph;
    }

    public Object jsonObjectsToJava(JsonObject root) {
        JsonReader.getArgs().put(USE_MAPS, false);
        return this.convertParsedMapsToJava(root);
    }

    protected boolean useMaps() {
        return Boolean.TRUE.equals(JsonReader.getArgs().get(USE_MAPS));
    }

    protected Object convertParsedMapsToJava(JsonObject root) {
        Resolver resolver = this.useMaps() ? new MapResolver(this.objsRead, JsonReader.getArgs()) : new ObjectResolver(this.objsRead, JsonReader.getArgs());
        resolver.createJavaObjectInstance(Object.class, root);
        Object graph = resolver.convertMapsToObjects(root);
        resolver.cleanup();
        return graph;
    }

    public static Object newInstance(Class c) {
        if (factory.containsKey(c)) {
            return factory.get(c).newInstance(c);
        }
        return MetaUtils.newInstance(c);
    }

    @Override
    public void close() {
        try {
            threadInput.remove();
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to close input", e);
        }
    }

    private static String getErrorMessage(String msg) {
        if (threadInput.get() != null) {
            return String.valueOf(msg) + "\nLast read: " + JsonReader.getLastReadSnippet() + "\nline: " + JsonReader.threadInput.get().line + ", col: " + JsonReader.threadInput.get().col;
        }
        return msg;
    }

    static Object error(String msg) {
        throw new JsonIoException(JsonReader.getErrorMessage(msg));
    }

    static Object error(String msg, Exception e) {
        throw new JsonIoException(JsonReader.getErrorMessage(msg), e);
    }

    private static String getLastReadSnippet() {
        if (threadInput.get() != null) {
            return threadInput.get().getLastSnippet();
        }
        return "";
    }

    @Deprecated
    public static boolean isPrimitive(Class c) {
        return MetaUtils.isPrimitive(c);
    }

    @Deprecated
    public static boolean isLogicalPrimitive(Class c) {
        return MetaUtils.isLogicalPrimitive(c);
    }

    public static interface ClassFactory {
        public Object newInstance(Class var1);
    }

    public static class CollectionFactory
    implements ClassFactory {
        @Override
        public Object newInstance(Class c) {
            if (List.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            if (SortedSet.class.isAssignableFrom(c)) {
                return new TreeSet();
            }
            if (Set.class.isAssignableFrom(c)) {
                return new LinkedHashSet();
            }
            if (Collection.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            throw new JsonIoException("CollectionFactory handed Class for which it was not expecting: " + c.getName());
        }
    }

    public static interface JsonClassReader {
        public Object read(Object var1, Deque<JsonObject<String, Object>> var2);
    }

    public static class MapFactory
    implements ClassFactory {
        @Override
        public Object newInstance(Class c) {
            if (SortedMap.class.isAssignableFrom(c)) {
                return new TreeMap();
            }
            if (Map.class.isAssignableFrom(c)) {
                return new LinkedHashMap();
            }
            throw new JsonIoException("MapFactory handed Class for which it was not expecting: " + c.getName());
        }
    }
}

