/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.FastPushbackReader;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.MetaUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class JsonParser {
    public static final String EMPTY_OBJECT = "~!o~";
    private static final String EMPTY_ARRAY = "~!a~";
    private static final int STATE_READ_START_OBJECT = 0;
    private static final int STATE_READ_FIELD = 1;
    private static final int STATE_READ_VALUE = 2;
    private static final int STATE_READ_POST_VALUE = 3;
    private static final Map<String, String> stringCache = new HashMap<String, String>();
    private final FastPushbackReader input;
    private final Map<Long, JsonObject> objsRead;
    private final StringBuilder strBuf = new StringBuilder();
    private final StringBuilder hexBuf = new StringBuilder();
    private final char[] numBuf = new char[256];
    private final boolean useMaps;
    private static final int STATE_STRING_START = 0;
    private static final int STATE_STRING_SLASH = 1;
    private static final int STATE_HEX_DIGITS_START = 2;
    private static final int STATE_HEX_DIGITS = 3;

    static {
        stringCache.put("", "");
        stringCache.put("true", "true");
        stringCache.put("True", "True");
        stringCache.put("TRUE", "TRUE");
        stringCache.put("false", "false");
        stringCache.put("False", "False");
        stringCache.put("FALSE", "FALSE");
        stringCache.put("null", "null");
        stringCache.put("yes", "yes");
        stringCache.put("Yes", "Yes");
        stringCache.put("YES", "YES");
        stringCache.put("no", "no");
        stringCache.put("No", "No");
        stringCache.put("NO", "NO");
        stringCache.put("on", "on");
        stringCache.put("On", "On");
        stringCache.put("ON", "ON");
        stringCache.put("off", "off");
        stringCache.put("Off", "Off");
        stringCache.put("OFF", "OFF");
        stringCache.put("@id", "@id");
        stringCache.put("@ref", "@ref");
        stringCache.put("@items", "@items");
        stringCache.put("@type", "@type");
        stringCache.put("@keys", "@keys");
        stringCache.put("0", "0");
        stringCache.put("1", "1");
        stringCache.put("2", "2");
        stringCache.put("3", "3");
        stringCache.put("4", "4");
        stringCache.put("5", "5");
        stringCache.put("6", "6");
        stringCache.put("7", "7");
        stringCache.put("8", "8");
        stringCache.put("9", "9");
    }

    JsonParser(FastPushbackReader reader, Map<Long, JsonObject> objectsMap, boolean useMaps) {
        this.input = reader;
        this.useMaps = useMaps;
        this.objsRead = objectsMap;
    }

    private Object readJsonObject() throws IOException {
        boolean done = false;
        String field = null;
        JsonObject<String, Object> object = new JsonObject<String, Object>();
        int state = 0;
        FastPushbackReader in = this.input;
        while (!done) {
            switch (state) {
                case 0: {
                    int c = this.skipWhitespaceRead();
                    if (c == 123) {
                        object.line = in.line;
                        object.col = in.col;
                        c = this.skipWhitespaceRead();
                        if (c == 125) {
                            return EMPTY_OBJECT;
                        }
                        in.unread(c);
                        state = 1;
                        break;
                    }
                    this.objsRead.size();
                    JsonParser.error("Input is invalid JSON; object does not start with '{', c=" + c);
                    break;
                }
                case 1: {
                    int c = this.skipWhitespaceRead();
                    if (c == 34) {
                        field = this.readString();
                        c = this.skipWhitespaceRead();
                        if (c != 58) {
                            JsonParser.error("Expected ':' between string field and value");
                        }
                        this.skipWhitespace();
                        state = 2;
                        break;
                    }
                    JsonParser.error("Expected quote");
                    break;
                }
                case 2: {
                    if (field == null) {
                        field = "@items";
                    }
                    Object value = this.readValue(object);
                    object.put(field, value);
                    if ("@id".equals(field)) {
                        this.objsRead.put((Long)value, object);
                    }
                    state = 3;
                    break;
                }
                case 3: {
                    int c = this.skipWhitespaceRead();
                    if (c == -1) {
                        JsonParser.error("EOF reached before closing '}'");
                    }
                    if (c == 125) {
                        done = true;
                        break;
                    }
                    if (c == 44) {
                        state = 1;
                        break;
                    }
                    JsonParser.error("Object not ended with '}'");
                }
            }
        }
        if (this.useMaps && object.isPrimitive()) {
            return object.getPrimitiveValue();
        }
        return object;
    }

    Object readValue(JsonObject object) throws IOException {
        int c = this.input.read();
        switch (c) {
            case 34: {
                return this.readString();
            }
            case 123: {
                this.input.unread(123);
                return this.readJsonObject();
            }
            case 91: {
                return this.readArray(object);
            }
            case 93: {
                this.input.unread(93);
                return EMPTY_ARRAY;
            }
            case 70: 
            case 102: {
                this.input.unread(c);
                this.readToken("false");
                return Boolean.FALSE;
            }
            case 78: 
            case 110: {
                this.input.unread(c);
                this.readToken("null");
                return null;
            }
            case 84: 
            case 116: {
                this.input.unread(c);
                this.readToken("true");
                return Boolean.TRUE;
            }
            case -1: {
                JsonParser.error("EOF reached prematurely");
            }
        }
        if (c >= 48 && c <= 57 || c == 45) {
            return this.readNumber(c);
        }
        return JsonParser.error("Unknown JSON value type");
    }

    private Object readArray(JsonObject object) throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        while (true) {
            int c;
            this.skipWhitespace();
            Object o = this.readValue(object);
            if (o != EMPTY_ARRAY) {
                array.add(o);
            }
            if ((c = this.skipWhitespaceRead()) == 93) break;
            if (c == 44) continue;
            JsonParser.error("Expected ',' or ']' inside array");
        }
        return array.toArray();
    }

    private void readToken(String token) throws IOException {
        int len = token.length();
        int i = 0;
        while (i < len) {
            int c = this.input.read();
            if (c == -1) {
                JsonParser.error("EOF reached while reading token: " + token);
            }
            c = Character.toLowerCase((char)c);
            char loTokenChar = token.charAt(i);
            if (loTokenChar != c) {
                JsonParser.error("Expected token: " + token);
            }
            ++i;
        }
    }

    private Number readNumber(int c) throws IOException {
        FastPushbackReader in = this.input;
        char[] buffer = this.numBuf;
        buffer[0] = (char)c;
        int len = 1;
        boolean isFloat = false;
        try {
            while (true) {
                if ((c = in.read()) >= 48 && c <= 57 || c == 45 || c == 43) {
                    buffer[len++] = (char)c;
                    continue;
                }
                if (c != 46 && c != 101 && c != 69) break;
                buffer[len++] = (char)c;
                isFloat = true;
            }
            if (c != -1) {
                in.unread(c);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            JsonParser.error("Too many digits in number: " + new String(buffer));
        }
        if (isFloat) {
            String num = new String(buffer, 0, len);
            try {
                return Double.parseDouble(num);
            }
            catch (NumberFormatException e) {
                JsonParser.error("Invalid floating point number: " + num, e);
            }
        }
        boolean isNeg = buffer[0] == '-';
        long n = 0L;
        int i = isNeg ? 1 : 0;
        while (i < len) {
            n = (long)(buffer[i] - 48) + n * 10L;
            ++i;
        }
        return isNeg ? -n : n;
    }

    private String readString() throws IOException {
        StringBuilder str = this.strBuf;
        str.setLength(0);
        boolean done = false;
        int state = 0;
        while (!done) {
            int c = this.input.read();
            if (c == -1) {
                JsonParser.error("EOF reached while reading JSON string");
            }
            block0 : switch (state) {
                case 0: {
                    if (c == 34) {
                        done = true;
                        break;
                    }
                    if (c == 92) {
                        state = 1;
                        break;
                    }
                    str.appendCodePoint(c);
                    break;
                }
                case 1: {
                    switch (c) {
                        case 92: {
                            str.append('\\');
                            break;
                        }
                        case 47: {
                            str.append('/');
                            break;
                        }
                        case 34: {
                            str.append('\"');
                            break;
                        }
                        case 39: {
                            str.append('\'');
                            break;
                        }
                        case 98: {
                            str.append('\b');
                            break;
                        }
                        case 102: {
                            str.append('\f');
                            break;
                        }
                        case 110: {
                            str.append('\n');
                            break;
                        }
                        case 114: {
                            str.append('\r');
                            break;
                        }
                        case 116: {
                            str.append('\t');
                            break;
                        }
                        case 117: {
                            state = 2;
                            break;
                        }
                        default: {
                            JsonParser.error("Invalid character escape sequence specified: " + c);
                        }
                    }
                    if (c == 117) break;
                    state = 0;
                    break;
                }
                case 2: {
                    this.hexBuf.setLength(0);
                    state = 3;
                }
                case 3: {
                    switch (c) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: {
                            this.hexBuf.append((char)c);
                            if (this.hexBuf.length() != 4) break block0;
                            int value = Integer.parseInt(this.hexBuf.toString(), 16);
                            str.append(MetaUtils.valueOf((char)value));
                            state = 0;
                            break block0;
                        }
                    }
                    JsonParser.error("Expected hexadecimal digits");
                }
            }
        }
        String s = str.toString();
        String cacheHit = stringCache.get(s);
        return cacheHit == null ? s : cacheHit;
    }

    private int skipWhitespaceRead() throws IOException {
        FastPushbackReader in = this.input;
        int c = in.read();
        while (true) {
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    return c;
                }
            }
            c = in.read();
        }
    }

    private void skipWhitespace() throws IOException {
        this.input.unread(this.skipWhitespaceRead());
    }

    static Object error(String msg) {
        return MetaUtils.error(msg);
    }

    static Object error(String msg, Exception e) {
        return MetaUtils.error(msg, e);
    }
}

