/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonWriter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonReader
implements Closeable {
    private static final int STATE_READ_START_OBJECT = 0;
    private static final int STATE_READ_FIELD = 1;
    private static final int STATE_READ_VALUE = 2;
    private static final int STATE_READ_POST_VALUE = 3;
    private static final int SNIPPET_LENGTH = 200;
    private static final String EMPTY_ARRAY = "~!a~";
    private static final String EMPTY_OBJECT = "~!o~";
    private static final Character[] charCache = new Character[128];
    private static final Byte[] byteCache = new Byte[256];
    private static final Map<String, String> stringCache = new HashMap<String, String>();
    private static final Set<Class> prims = new HashSet<Class>();
    private static final Map<Class, Object[]> constructors = new HashMap<Class, Object[]>();
    private static final Map<String, Class> nameToClass = new HashMap<String, Class>();
    private static final Class[] emptyClassArray = new Class[0];
    private static final List<Object[]> readers = new ArrayList<Object[]>();
    private static final Set<Class> notCustom = new HashSet<Class>();
    private static final Map<String, String> months = new LinkedHashMap<String, String>();
    private static final Map<Class, ClassFactory> factory = new LinkedHashMap<Class, ClassFactory>();
    private static final String days = "(monday|mon|tuesday|tues|tue|wednesday|wed|thursday|thur|thu|friday|fri|saturday|sat|sunday|sun)";
    private static final String mos = "(January|Jan|February|Feb|March|Mar|April|Apr|May|June|Jun|July|Jul|August|Aug|September|Sept|Sep|October|Oct|November|Nov|December|Dec)";
    private static final Pattern datePattern1 = Pattern.compile("(\\d{4})[./-](\\d{1,2})[./-](\\d{1,2})");
    private static final Pattern datePattern2 = Pattern.compile("(\\d{1,2})[./-](\\d{1,2})[./-](\\d{4})");
    private static final Pattern datePattern3 = Pattern.compile("(January|Jan|February|Feb|March|Mar|April|Apr|May|June|Jun|July|Jul|August|Aug|September|Sept|Sep|October|Oct|November|Nov|December|Dec)[ ]*[,]?[ ]*(\\d{1,2})(st|nd|rd|th|)[ ]*[,]?[ ]*(\\d{4})", 2);
    private static final Pattern datePattern4 = Pattern.compile("(\\d{1,2})(st|nd|rd|th|)[ ]*[,]?[ ]*(January|Jan|February|Feb|March|Mar|April|Apr|May|June|Jun|July|Jul|August|Aug|September|Sept|Sep|October|Oct|November|Nov|December|Dec)[ ]*[,]?[ ]*(\\d{4})", 2);
    private static final Pattern datePattern5 = Pattern.compile("(\\d{4})[ ]*[,]?[ ]*(January|Jan|February|Feb|March|Mar|April|Apr|May|June|Jun|July|Jul|August|Aug|September|Sept|Sep|October|Oct|November|Nov|December|Dec)[ ]*[,]?[ ]*(\\d{1,2})(st|nd|rd|th|)", 2);
    private static final Pattern datePattern6 = Pattern.compile("(monday|mon|tuesday|tues|tue|wednesday|wed|thursday|thur|thu|friday|fri|saturday|sat|sunday|sun)[ ]+(January|Jan|February|Feb|March|Mar|April|Apr|May|June|Jun|July|Jul|August|Aug|September|Sept|Sep|October|Oct|November|Nov|December|Dec)[ ]+(\\d{1,2})[ ]+(\\d{2}:\\d{2}:\\d{2})[ ]+[A-Z]{1,3}\\s+(\\d{4})", 2);
    private static final Pattern timePattern1 = Pattern.compile("(\\d{2})[.:](\\d{2})[.:](\\d{2})[.](\\d{1,10})([+-]\\d{2}[:]?\\d{2}|Z)?");
    private static final Pattern timePattern2 = Pattern.compile("(\\d{2})[.:](\\d{2})[.:](\\d{2})([+-]\\d{2}[:]?\\d{2}|Z)?");
    private static final Pattern timePattern3 = Pattern.compile("(\\d{2})[.:](\\d{2})([+-]\\d{2}[:]?\\d{2}|Z)?");
    private static final Pattern dayPattern = Pattern.compile("(monday|mon|tuesday|tues|tue|wednesday|wed|thursday|thur|thu|friday|fri|saturday|sat|sunday|sun)", 2);
    private static final Pattern extraQuotes = Pattern.compile("([\"]*)([^\"]*)([\"]*)");
    private static final Collection unmodifiableCollection = Collections.unmodifiableCollection(new ArrayList());
    private static final Collection unmodifiableSet = Collections.unmodifiableSet(new HashSet());
    private static final Collection unmodifiableSortedSet = Collections.unmodifiableSortedSet(new TreeSet());
    private static final Map unmodifiableMap = Collections.unmodifiableMap(new HashMap());
    private static final Map unmodifiableSortedMap = Collections.unmodifiableSortedMap(new TreeMap());
    private final Map<Long, JsonObject> _objsRead = new LinkedHashMap<Long, JsonObject>();
    private final Collection<UnresolvedReference> unresolvedRefs = new ArrayList<UnresolvedReference>();
    private final Collection<Object[]> prettyMaps = new ArrayList<Object[]>();
    private final FastPushbackReader input;
    private boolean useMaps = false;
    private final char[] numBuf = new char[256];
    private final StringBuilder strBuf = new StringBuilder();
    static final ThreadLocal<FastPushbackReader> threadInput = new ThreadLocal();
    private static boolean useUnsafe = false;
    private static Unsafe unsafe;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final char MIN_LOW_SURROGATE = '\udc00';
    public static final char MIN_HIGH_SURROGATE = '\ud800';

    static {
        int i = 0;
        while (i < charCache.length) {
            JsonReader.charCache[i] = Character.valueOf((char)i);
            ++i;
        }
        i = 0;
        while (i < byteCache.length) {
            JsonReader.byteCache[i] = (byte)(i - 128);
            ++i;
        }
        stringCache.put("", "");
        stringCache.put("true", "true");
        stringCache.put("True", "True");
        stringCache.put("TRUE", "TRUE");
        stringCache.put("false", "false");
        stringCache.put("False", "False");
        stringCache.put("FALSE", "FALSE");
        stringCache.put("null", "null");
        stringCache.put("yes", "yes");
        stringCache.put("Yes", "Yes");
        stringCache.put("YES", "YES");
        stringCache.put("no", "no");
        stringCache.put("No", "No");
        stringCache.put("NO", "NO");
        stringCache.put("on", "on");
        stringCache.put("On", "On");
        stringCache.put("ON", "ON");
        stringCache.put("off", "off");
        stringCache.put("Off", "Off");
        stringCache.put("OFF", "OFF");
        stringCache.put("@id", "@id");
        stringCache.put("@ref", "@ref");
        stringCache.put("@items", "@items");
        stringCache.put("@type", "@type");
        stringCache.put("@keys", "@keys");
        stringCache.put("0", "0");
        stringCache.put("1", "1");
        stringCache.put("2", "2");
        stringCache.put("3", "3");
        stringCache.put("4", "4");
        stringCache.put("5", "5");
        stringCache.put("6", "6");
        stringCache.put("7", "7");
        stringCache.put("8", "8");
        stringCache.put("9", "9");
        prims.add(Byte.class);
        prims.add(Integer.class);
        prims.add(Long.class);
        prims.add(Double.class);
        prims.add(Character.class);
        prims.add(Float.class);
        prims.add(Boolean.class);
        prims.add(Short.class);
        nameToClass.put("string", String.class);
        nameToClass.put("boolean", Boolean.TYPE);
        nameToClass.put("char", Character.TYPE);
        nameToClass.put("byte", Byte.TYPE);
        nameToClass.put("short", Short.TYPE);
        nameToClass.put("int", Integer.TYPE);
        nameToClass.put("long", Long.TYPE);
        nameToClass.put("float", Float.TYPE);
        nameToClass.put("double", Double.TYPE);
        nameToClass.put("date", Date.class);
        nameToClass.put("class", Class.class);
        JsonReader.addReader(String.class, new StringReader());
        JsonReader.addReader(Date.class, new DateReader());
        JsonReader.addReader(BigInteger.class, new BigIntegerReader());
        JsonReader.addReader(BigDecimal.class, new BigDecimalReader());
        JsonReader.addReader(java.sql.Date.class, new SqlDateReader());
        JsonReader.addReader(Timestamp.class, new TimestampReader());
        JsonReader.addReader(Calendar.class, new CalendarReader());
        JsonReader.addReader(TimeZone.class, new TimeZoneReader());
        JsonReader.addReader(Locale.class, new LocaleReader());
        JsonReader.addReader(Class.class, new ClassReader());
        JsonReader.addReader(StringBuilder.class, new StringBuilderReader());
        JsonReader.addReader(StringBuffer.class, new StringBufferReader());
        CollectionFactory colFactory = new CollectionFactory();
        JsonReader.assignInstantiator(Collection.class, colFactory);
        JsonReader.assignInstantiator(List.class, colFactory);
        JsonReader.assignInstantiator(Set.class, colFactory);
        JsonReader.assignInstantiator(SortedSet.class, colFactory);
        MapFactory mapFactory = new MapFactory();
        JsonReader.assignInstantiator(Map.class, mapFactory);
        JsonReader.assignInstantiator(SortedMap.class, mapFactory);
        months.put("jan", "1");
        months.put("january", "1");
        months.put("feb", "2");
        months.put("february", "2");
        months.put("mar", "3");
        months.put("march", "3");
        months.put("apr", "4");
        months.put("april", "4");
        months.put("may", "5");
        months.put("jun", "6");
        months.put("june", "6");
        months.put("jul", "7");
        months.put("july", "7");
        months.put("aug", "8");
        months.put("august", "8");
        months.put("sep", "9");
        months.put("sept", "9");
        months.put("september", "9");
        months.put("oct", "10");
        months.put("october", "10");
        months.put("nov", "11");
        months.put("november", "11");
        months.put("dec", "12");
        months.put("december", "12");
    }

    public static void setUseUnsafe(boolean state) {
        useUnsafe = state;
        if (state) {
            try {
                unsafe = new Unsafe();
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                useUnsafe = false;
            }
        }
    }

    public static void assignInstantiator(Class c, ClassFactory f) {
        factory.put(c, f);
    }

    public static BigInteger bigIntegerFrom(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof String) {
            String s = (String)value;
            if ("".equals(s.trim())) {
                return null;
            }
            try {
                return new BigInteger(JsonReader.removeLeadingAndTrailingQuotes(s));
            }
            catch (Exception e) {
                return (BigInteger)JsonReader.error("Could not parse '" + value + "' as BigInteger.", e);
            }
        }
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            return bd.toBigInteger();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
        }
        if (value instanceof Double || value instanceof Float) {
            return new BigDecimal(((Number)value).doubleValue()).toBigInteger();
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return new BigInteger(value.toString());
        }
        return (BigInteger)JsonReader.error("Could not convert value: " + value.toString() + " to BigInteger.");
    }

    public static BigDecimal bigDecimalFrom(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof String) {
            String s = (String)value;
            if ("".equals(s.trim())) {
                return null;
            }
            try {
                return new BigDecimal(JsonReader.removeLeadingAndTrailingQuotes(s));
            }
            catch (Exception e) {
                return (BigDecimal)JsonReader.error("Could not parse '" + s + "' as BigDecimal.", e);
            }
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Double || value instanceof Short || value instanceof Byte || value instanceof Float) {
            return new BigDecimal(value.toString());
        }
        return (BigDecimal)JsonReader.error("Could not convert value: " + value.toString() + " to BigInteger.");
    }

    public static void addReader(Class c, JsonClassReader reader) {
        for (Object[] item : readers) {
            Class clz = (Class)item[0];
            if (clz != c) continue;
            item[1] = reader;
            return;
        }
        readers.add(new Object[]{c, reader});
    }

    public static void addNotCustomReader(Class c) {
        notCustom.add(c);
    }

    protected static Object readIfMatching(Object o, Class compType, Deque<JsonObject<String, Object>> stack) throws IOException {
        Class c;
        boolean needsType;
        boolean isJsonObject;
        block14: {
            if (o == null) {
                JsonReader.error("Bug in json-io, null must be checked before calling this method.");
            }
            if (notCustom.contains(o.getClass())) {
                return null;
            }
            if (compType != null && notCustom.contains(compType)) {
                return null;
            }
            isJsonObject = o instanceof JsonObject;
            if (!isJsonObject && compType == null) {
                return null;
            }
            needsType = false;
            if (isJsonObject) {
                JsonObject jObj = (JsonObject)o;
                if (jObj.containsKey("@ref")) {
                    return null;
                }
                if (jObj.target == null) {
                    String typeStr = null;
                    try {
                        String type = jObj.type;
                        if (type != null) {
                            typeStr = type;
                            c = JsonReader.classForName(type);
                            break block14;
                        }
                        if (compType != null) {
                            c = compType;
                            needsType = true;
                            break block14;
                        }
                        return null;
                    }
                    catch (Exception e) {
                        return JsonReader.error("Class listed in @type [" + typeStr + "] is not found", e);
                    }
                }
                c = jObj.target.getClass();
            } else {
                c = compType;
            }
        }
        JsonClassReader closestReader = JsonReader.getCustomReader(c);
        if (closestReader == null) {
            return null;
        }
        if (needsType && isJsonObject) {
            ((JsonObject)o).setType(c.getName());
        }
        return closestReader.read(o, stack);
    }

    private static JsonClassReader getCustomReader(Class c) {
        JsonClassReader closestReader = null;
        int minDistance = Integer.MAX_VALUE;
        for (Object[] item : readers) {
            Class clz = (Class)item[0];
            if (clz == c) {
                closestReader = (JsonClassReader)item[1];
                break;
            }
            int distance = JsonWriter.getDistance(clz, c);
            if (distance >= minDistance) continue;
            minDistance = distance;
            closestReader = (JsonClassReader)item[1];
        }
        return closestReader;
    }

    @Deprecated
    public static Object toJava(String json) {
        throw new RuntimeException("Use com.cedarsoftware.util.JsonReader.jsonToJava()");
    }

    public static Object jsonToJava(String json) throws IOException {
        ByteArrayInputStream ba = new ByteArrayInputStream(json.getBytes("UTF-8"));
        JsonReader jr = new JsonReader(ba, false);
        Object obj = jr.readObject();
        jr.close();
        return obj;
    }

    @Deprecated
    public static Map toMaps(String json) {
        throw new RuntimeException("Use com.cedarsoftware.util.JsonReader.jsonToMaps()");
    }

    public static Map jsonToMaps(String json) throws IOException {
        ByteArrayInputStream ba = new ByteArrayInputStream(json.getBytes("UTF-8"));
        JsonReader jr = new JsonReader(ba, true);
        Object ret = jr.readObject();
        jr.close();
        if (ret instanceof Map) {
            return (Map)ret;
        }
        if (ret != null && ret.getClass().isArray()) {
            JsonObject<String, Object> retMap = new JsonObject<String, Object>();
            retMap.put("@items", ret);
            return retMap;
        }
        JsonObject<String, Object[]> retMap = new JsonObject<String, Object[]>();
        retMap.put("@items", new Object[]{ret});
        return retMap;
    }

    public JsonReader() {
        this.useMaps = false;
        this.input = null;
    }

    public JsonReader(InputStream inp) {
        this(inp, false);
    }

    public JsonReader(InputStream inp, boolean useMaps) {
        this.useMaps = useMaps;
        try {
            this.input = new FastPushbackReader((Reader)new BufferedReader(new InputStreamReader(inp, "UTF-8")));
            threadInput.set(this.input);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Your JVM does not support UTF-8.  Get a better JVM.", e);
        }
    }

    public Object readObject() throws IOException {
        Object graph;
        JsonObject<String, Object> root = new JsonObject<String, Object>();
        Object o = this.readValue(root);
        if (o == EMPTY_OBJECT) {
            return new JsonObject();
        }
        if (o instanceof Object[]) {
            root.setType(Object[].class.getName());
            root.setTarget(o);
            root.put("@items", o);
            graph = this.convertParsedMapsToJava(root);
        } else {
            graph = o instanceof JsonObject ? this.convertParsedMapsToJava((JsonObject)o) : o;
        }
        if (this.useMaps) {
            return o;
        }
        return graph;
    }

    public Object jsonObjectsToJava(JsonObject root) throws IOException {
        this.useMaps = false;
        return this.convertParsedMapsToJava(root);
    }

    protected Object convertParsedMapsToJava(JsonObject root) throws IOException {
        this.createJavaObjectInstance(Object.class, root);
        Object graph = this.convertMapsToObjects(root);
        this.patchUnresolvedReferences();
        this.rehashMaps();
        this._objsRead.clear();
        this.unresolvedRefs.clear();
        this.prettyMaps.clear();
        return graph;
    }

    protected Object convertMapsToObjects(JsonObject<String, Object> root) throws IOException {
        ArrayDeque<JsonObject<String, Object>> stack = new ArrayDeque<JsonObject<String, Object>>();
        stack.addFirst(root);
        boolean useMapsLocal = this.useMaps;
        while (!stack.isEmpty()) {
            JsonObject jsonObj = (JsonObject)stack.removeFirst();
            if (useMapsLocal) {
                if (jsonObj.isArray() || jsonObj.isCollection()) {
                    this.traverseCollectionNoObj(stack, jsonObj);
                    continue;
                }
                if (jsonObj.isMap()) {
                    this.traverseMap(stack, jsonObj);
                    continue;
                }
                this.traverseFieldsNoObj(stack, jsonObj);
                continue;
            }
            if (jsonObj.isArray()) {
                this.traverseArray(stack, jsonObj);
            } else if (jsonObj.isCollection()) {
                this.traverseCollection(stack, jsonObj);
            } else if (jsonObj.isMap()) {
                this.traverseMap(stack, jsonObj);
            } else {
                this.traverseFields(stack, jsonObj);
            }
            jsonObj.clear();
        }
        return root.target;
    }

    protected void traverseArray(Deque<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) throws IOException {
        int len = jsonObj.getLength();
        if (len == 0) {
            return;
        }
        Class compType = jsonObj.getComponentType();
        if (Character.TYPE == compType) {
            return;
        }
        if (Byte.TYPE == compType) {
            jsonObj.moveBytesToMate();
            jsonObj.clearArray();
            return;
        }
        boolean isPrimitive = JsonReader.isPrimitive(compType);
        Object array = jsonObj.target;
        Object[] items = jsonObj.getArray();
        int i = 0;
        while (i < len) {
            Object element = items[i];
            if (element == null) {
                Array.set(array, i, null);
            } else if (element == EMPTY_OBJECT) {
                Object arrayElement = this.createJavaObjectInstance(compType, new JsonObject());
                Array.set(array, i, arrayElement);
            } else {
                JsonObject<String, Object> jsonObject;
                Object special = JsonReader.readIfMatching(element, compType, stack);
                if (special != null) {
                    Array.set(array, i, special);
                } else if (isPrimitive) {
                    Array.set(array, i, JsonReader.newPrimitiveWrapper(compType, element));
                } else if (element.getClass().isArray()) {
                    if (char[].class == compType) {
                        Object[] jsonArray = (Object[])element;
                        if (jsonArray.length == 0) {
                            Array.set(array, i, new char[0]);
                        } else {
                            String value = (String)jsonArray[0];
                            int numChars = value.length();
                            char[] chars = new char[numChars];
                            int j = 0;
                            while (j < numChars) {
                                chars[j] = value.charAt(j);
                                ++j;
                            }
                            Array.set(array, i, chars);
                        }
                    } else {
                        jsonObject = new JsonObject<String, Object>();
                        jsonObject.put("@items", element);
                        Array.set(array, i, this.createJavaObjectInstance(compType, jsonObject));
                        stack.addFirst(jsonObject);
                    }
                } else if (element instanceof JsonObject) {
                    jsonObject = (JsonObject<String, Object>)element;
                    Long ref = (Long)jsonObject.get("@ref");
                    if (ref != null) {
                        JsonObject refObject = this.getReferencedObj(ref);
                        if (refObject.target != null) {
                            Array.set(array, i, refObject.target);
                        } else {
                            this.unresolvedRefs.add(new UnresolvedReference(jsonObj, i, (long)ref));
                        }
                    } else {
                        Object arrayElement = this.createJavaObjectInstance(compType, jsonObject);
                        Array.set(array, i, arrayElement);
                        if (!JsonReader.isLogicalPrimitive(arrayElement.getClass())) {
                            stack.addFirst(jsonObject);
                        }
                    }
                } else if (element instanceof String && "".equals(((String)element).trim()) && compType != String.class && compType != Object.class) {
                    Array.set(array, i, null);
                } else {
                    Array.set(array, i, element);
                }
            }
            ++i;
        }
        jsonObj.clearArray();
    }

    private JsonObject getReferencedObj(Long ref) throws IOException {
        JsonObject refObject = this._objsRead.get(ref);
        if (refObject == null) {
            JsonReader.error("Forward reference @ref: " + ref + ", but no object defined (@id) with that value");
        }
        return refObject;
    }

    protected void traverseCollectionNoObj(Deque<JsonObject<String, Object>> stack, JsonObject jsonObj) throws IOException {
        Object[] items = jsonObj.getArray();
        if (items == null || items.length == 0) {
            return;
        }
        int idx = 0;
        ArrayList<Object> copy = new ArrayList<Object>(items.length);
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element == EMPTY_OBJECT) {
                copy.add(new JsonObject());
            } else {
                JsonObject jsonObject;
                copy.add(element);
                if (element instanceof Object[]) {
                    jsonObject = new JsonObject();
                    jsonObject.put("@items", element);
                    stack.addFirst(jsonObject);
                } else if (element instanceof JsonObject) {
                    jsonObject = (JsonObject)element;
                    Long ref = (Long)jsonObject.get("@ref");
                    if (ref != null) {
                        JsonObject refObject = this.getReferencedObj(ref);
                        copy.set(idx, refObject);
                    } else {
                        stack.addFirst(jsonObject);
                    }
                }
                ++idx;
            }
            ++n2;
        }
        jsonObj.target = null;
        int i = 0;
        while (i < items.length) {
            items[i] = copy.get(i);
            ++i;
        }
    }

    protected void traverseCollection(Deque<JsonObject<String, Object>> stack, JsonObject jsonObj) throws IOException {
        Object[] items = jsonObj.getArray();
        if (items == null || items.length == 0) {
            return;
        }
        Collection col = (Collection)jsonObj.target;
        boolean isList = col instanceof List;
        int idx = 0;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element == null) {
                col.add(null);
            } else if (element == EMPTY_OBJECT) {
                col.add(new JsonObject());
            } else {
                JsonObject<String, Object> jObj;
                Object special = JsonReader.readIfMatching(element, null, stack);
                if (special != null) {
                    col.add(special);
                } else if (element instanceof String || element instanceof Boolean || element instanceof Double || element instanceof Long) {
                    col.add(element);
                } else if (element.getClass().isArray()) {
                    jObj = new JsonObject<String, Object>();
                    jObj.put("@items", element);
                    this.createJavaObjectInstance(Object.class, jObj);
                    col.add(jObj.target);
                    this.convertMapsToObjects(jObj);
                } else {
                    jObj = (JsonObject<String, Object>)element;
                    Long ref = (Long)jObj.get("@ref");
                    if (ref != null) {
                        JsonObject refObject = this.getReferencedObj(ref);
                        if (refObject.target != null) {
                            col.add(refObject.target);
                        } else {
                            this.unresolvedRefs.add(new UnresolvedReference(jsonObj, idx, (long)ref));
                            if (isList) {
                                col.add(null);
                            }
                        }
                    } else {
                        this.createJavaObjectInstance(Object.class, jObj);
                        if (!JsonReader.isLogicalPrimitive(jObj.getTargetClass())) {
                            this.convertMapsToObjects(jObj);
                        }
                        col.add(jObj.target);
                    }
                }
            }
            ++idx;
            ++n2;
        }
        jsonObj.remove("@items");
    }

    protected void traverseMap(Deque<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) throws IOException {
        JsonReader.convertMapToKeysItems(jsonObj);
        Object[] keys = (Object[])jsonObj.get("@keys");
        Object[] items = jsonObj.getArray();
        if (keys == null || items == null) {
            if (keys != items) {
                JsonReader.error("Map written where one of @keys or @items is empty");
            }
            return;
        }
        int size = keys.length;
        if (size != items.length) {
            JsonReader.error("Map written with @keys and @items entries of different sizes");
        }
        Object[] mapKeys = JsonReader.buildCollection(stack, keys, size);
        Object[] mapValues = JsonReader.buildCollection(stack, items, size);
        this.prettyMaps.add(new Object[]{jsonObj, mapKeys, mapValues});
    }

    private static Object[] buildCollection(Deque<JsonObject<String, Object>> stack, Object[] items, int size) {
        Object[] javaKeys;
        JsonObject<String, Object[]> jsonCollection = new JsonObject<String, Object[]>();
        jsonCollection.put("@items", items);
        jsonCollection.target = javaKeys = new Object[size];
        stack.addFirst(jsonCollection);
        return javaKeys;
    }

    protected void traverseFieldsNoObj(Deque<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) throws IOException {
        Object target = jsonObj.target;
        for (Map.Entry e : jsonObj.entrySet()) {
            Object value;
            String key = (String)e.getKey();
            if (key.charAt(0) == '@') continue;
            Field field = null;
            if (target != null) {
                field = this.getDeclaredField(target.getClass(), key);
            }
            if ((value = e.getValue()) == null) {
                jsonObj.put(key, null);
                continue;
            }
            if (value == EMPTY_OBJECT) {
                jsonObj.put(key, new JsonObject());
                continue;
            }
            if (value.getClass().isArray()) {
                JsonObject jsonArray = new JsonObject();
                jsonArray.put("@items", value);
                stack.addFirst(jsonArray);
                jsonObj.put(key, jsonArray);
                continue;
            }
            if (value instanceof JsonObject) {
                JsonObject jObj = (JsonObject)value;
                if (field != null && JsonObject.isPrimitiveWrapper(field.getType())) {
                    jObj.put("value", JsonReader.newPrimitiveWrapper(field.getType(), jObj.get("value")));
                    continue;
                }
                Long ref = (Long)jObj.get("@ref");
                if (ref != null) {
                    JsonObject refObject = this.getReferencedObj(ref);
                    jsonObj.put(key, refObject);
                    continue;
                }
                stack.addFirst(jObj);
                continue;
            }
            if (field == null) continue;
            Class<?> fieldType = field.getType();
            if (JsonReader.isPrimitive(fieldType)) {
                jsonObj.put(key, JsonReader.newPrimitiveWrapper(fieldType, value));
                continue;
            }
            if (BigDecimal.class == fieldType) {
                jsonObj.put(key, JsonReader.bigDecimalFrom(value));
                continue;
            }
            if (BigInteger.class == fieldType) {
                jsonObj.put(key, JsonReader.bigIntegerFrom(value));
                continue;
            }
            if (!(value instanceof String) || fieldType == String.class || fieldType == StringBuilder.class || fieldType == StringBuffer.class || !"".equals(((String)value).trim())) continue;
            jsonObj.put(key, null);
        }
        jsonObj.target = null;
    }

    protected void traverseFields(Deque<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) throws IOException {
        Object special = JsonReader.readIfMatching(jsonObj, null, stack);
        if (special != null) {
            jsonObj.target = special;
            return;
        }
        Object javaMate = jsonObj.target;
        Iterator i = jsonObj.entrySet().iterator();
        Class<?> cls = javaMate.getClass();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            Field field = this.getDeclaredField(cls, key);
            Object rhs = e.getValue();
            if (field == null) continue;
            this.assignField(stack, jsonObj, field, rhs);
        }
        jsonObj.clear();
    }

    protected void assignField(Deque<JsonObject<String, Object>> stack, JsonObject jsonObj, Field field, Object rhs) throws IOException {
        Object target = jsonObj.target;
        try {
            JsonObject jObj;
            Class<?> fieldType = field.getType();
            if (rhs instanceof JsonObject && field.getGenericType() instanceof ParameterizedType) {
                JsonReader.markUntypedObjects(field.getGenericType(), rhs, JsonWriter.getDeepDeclaredFields(fieldType));
            }
            if (rhs instanceof JsonObject) {
                JsonObject job = (JsonObject)rhs;
                String type = job.type;
                if (type == null || type.isEmpty()) {
                    job.setType(fieldType.getName());
                }
            }
            if (rhs == null) {
                field.set(target, null);
            } else if (rhs == EMPTY_OBJECT) {
                jObj = new JsonObject();
                jObj.type = fieldType.getName();
                Object value = this.createJavaObjectInstance(fieldType, jObj);
                field.set(target, value);
            } else {
                Object special = JsonReader.readIfMatching(rhs, fieldType, stack);
                if (special != null) {
                    field.set(target, special);
                } else if (rhs.getClass().isArray()) {
                    Object[] elements = (Object[])rhs;
                    JsonObject<String, Object[]> jsonArray = new JsonObject<String, Object[]>();
                    if (char[].class == fieldType) {
                        if (elements.length == 0) {
                            field.set(target, new char[0]);
                        } else {
                            field.set(target, ((String)elements[0]).toCharArray());
                        }
                    } else {
                        jsonArray.put("@items", elements);
                        this.createJavaObjectInstance(fieldType, jsonArray);
                        field.set(target, jsonArray.target);
                        stack.addFirst(jsonArray);
                    }
                } else if (rhs instanceof JsonObject) {
                    jObj = (JsonObject)rhs;
                    Long ref = (Long)jObj.get("@ref");
                    if (ref != null) {
                        JsonObject refObject = this.getReferencedObj(ref);
                        if (refObject.target != null) {
                            field.set(target, refObject.target);
                        } else {
                            this.unresolvedRefs.add(new UnresolvedReference(jsonObj, field.getName(), (long)ref));
                        }
                    } else {
                        field.set(target, this.createJavaObjectInstance(fieldType, jObj));
                        if (!JsonReader.isLogicalPrimitive(jObj.getTargetClass())) {
                            stack.addFirst((JsonObject)rhs);
                        }
                    }
                } else if (JsonReader.isPrimitive(fieldType)) {
                    field.set(target, JsonReader.newPrimitiveWrapper(fieldType, rhs));
                } else if (rhs instanceof String && "".equals(((String)rhs).trim()) && fieldType != String.class) {
                    field.set(target, null);
                } else {
                    field.set(target, rhs);
                }
            }
        }
        catch (Exception e) {
            JsonReader.error(String.valueOf(e.getClass().getSimpleName()) + " setting field '" + field.getName() + "' on target: " + JsonReader.safeToString(target) + " with value: " + rhs, e);
        }
    }

    private static String safeToString(Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Exception exception) {
            return o.getClass().toString();
        }
    }

    private static void markUntypedObjects(Type type, Object rhs, JsonWriter.ClassMeta classMeta) {
        ArrayDeque<Object[]> stack = new ArrayDeque<Object[]>();
        stack.addFirst(new Object[]{type, rhs});
        while (!stack.isEmpty()) {
            Object[] item = (Object[])stack.removeFirst();
            Type t = (Type)item[0];
            Object instance = item[1];
            if (t instanceof ParameterizedType) {
                JsonObject jObj;
                Class clazz = JsonReader.getRawType(t);
                ParameterizedType pType = (ParameterizedType)t;
                Type[] typeArgs = pType.getActualTypeArguments();
                if (typeArgs == null || typeArgs.length < 1 || clazz == null) continue;
                JsonReader.stampTypeOnJsonObject(instance, t);
                if (Map.class.isAssignableFrom(clazz)) {
                    Map map = (Map)instance;
                    if (!map.containsKey("@keys") && !map.containsKey("@items") && map instanceof JsonObject) {
                        JsonReader.convertMapToKeysItems((JsonObject)map);
                    }
                    Object[] keys = (Object[])map.get("@keys");
                    JsonReader.getTemplateTraverseWorkItem(stack, keys, typeArgs[0]);
                    Object[] items = (Object[])map.get("@items");
                    JsonReader.getTemplateTraverseWorkItem(stack, items, typeArgs[1]);
                    continue;
                }
                if (Collection.class.isAssignableFrom(clazz)) {
                    Object[] array;
                    if (instance instanceof Object[]) {
                        Object[] array2 = (Object[])instance;
                        int i = 0;
                        while (i < array2.length) {
                            Object vals = array2[i];
                            stack.addFirst(new Object[]{t, vals});
                            if (vals instanceof JsonObject) {
                                stack.addFirst(new Object[]{t, vals});
                            } else if (vals instanceof Object[]) {
                                JsonObject<String, Object[]> coll = new JsonObject<String, Object[]>();
                                coll.type = clazz.getName();
                                List<Object> items = Arrays.asList((Object[])vals);
                                coll.put("@items", items.toArray());
                                stack.addFirst(new Object[]{t, items});
                                array2[i] = coll;
                            } else {
                                stack.addFirst(new Object[]{t, vals});
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (instance instanceof Collection) {
                        Collection col = (Collection)instance;
                        for (Object o : col) {
                            stack.addFirst(new Object[]{typeArgs[0], o});
                        }
                        continue;
                    }
                    if (!(instance instanceof JsonObject) || (array = (jObj = (JsonObject)instance).getArray()) == null) continue;
                    Object[] objectArray = array;
                    int items = array.length;
                    int coll = 0;
                    while (coll < items) {
                        Object o = objectArray[coll];
                        stack.addFirst(new Object[]{typeArgs[0], o});
                        ++coll;
                    }
                    continue;
                }
                if (!(instance instanceof JsonObject)) continue;
                jObj = (JsonObject)instance;
                for (Map.Entry entry : jObj.entrySet()) {
                    Field field;
                    String fieldName = (String)entry.getKey();
                    if (fieldName.startsWith("this$") || (field = (Field)classMeta.get(fieldName)) == null || field.getType().getTypeParameters().length <= 0 && !(field.getGenericType() instanceof TypeVariable)) continue;
                    stack.addFirst(new Object[]{typeArgs[0], entry.getValue()});
                }
                continue;
            }
            JsonReader.stampTypeOnJsonObject(instance, t);
        }
    }

    private static void getTemplateTraverseWorkItem(Deque<Object[]> stack, Object[] items, Type type) {
        if (items == null || items.length < 1) {
            return;
        }
        Class rawType = JsonReader.getRawType(type);
        if (rawType != null && Collection.class.isAssignableFrom(rawType)) {
            stack.add(new Object[]{type, items});
        } else {
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                stack.add(new Object[]{type, o});
                ++n2;
            }
        }
    }

    private static void stampTypeOnJsonObject(Object o, Type t) {
        Class clazz;
        Class clazz2 = clazz = t instanceof Class ? (Class)t : JsonReader.getRawType(t);
        if (o instanceof JsonObject && clazz != null) {
            JsonObject jObj = (JsonObject)o;
            if ((jObj.type == null || jObj.type.isEmpty()) && jObj.target == null) {
                jObj.type = clazz.getName();
            }
        }
    }

    public static Class getRawType(Type t) {
        ParameterizedType pType;
        if (t instanceof ParameterizedType && (pType = (ParameterizedType)t).getRawType() instanceof Class) {
            return (Class)pType.getRawType();
        }
        return null;
    }

    private static void convertMapToKeysItems(JsonObject map) {
        if (!map.containsKey("@keys") && !map.containsKey("@ref")) {
            Object[] keys = new Object[map.keySet().size()];
            Object[] values = new Object[map.keySet().size()];
            int i = 0;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry e;
                Map.Entry entry = e = iterator.next();
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
            String saveType = map.getType();
            map.clear();
            map.setType(saveType);
            map.put("@keys", keys);
            map.put("@items", values);
        }
    }

    protected Object createJavaObjectInstance(Class clazz, JsonObject jsonObj) throws IOException {
        Object mate;
        boolean useMapsLocal = this.useMaps;
        String type = jsonObj.type;
        if (type != null) {
            Class c;
            try {
                c = JsonReader.classForName(type);
            }
            catch (IOException e) {
                if (useMapsLocal) {
                    jsonObj.type = null;
                    jsonObj.target = null;
                    return jsonObj;
                }
                throw e;
            }
            if (c.isArray()) {
                int size;
                Object[] items = jsonObj.getArray();
                int n = size = items == null ? 0 : items.length;
                if (c == char[].class) {
                    jsonObj.moveCharsToMate();
                    mate = jsonObj.target;
                } else {
                    mate = Array.newInstance(c.getComponentType(), size);
                }
            } else {
                JsonClassReader customReader;
                mate = JsonReader.isPrimitive(c) ? JsonReader.newPrimitiveWrapper(c, jsonObj.get("value")) : (c == Class.class ? JsonReader.classForName((String)jsonObj.get("value")) : (c.isEnum() ? JsonReader.getEnum(c, jsonObj) : (Enum.class.isAssignableFrom(c) ? JsonReader.getEnum(c.getSuperclass(), jsonObj) : ("java.util.Arrays$ArrayList".equals(c.getName()) ? new ArrayList() : ((customReader = JsonReader.getCustomReader(c)) != null ? customReader.read(jsonObj, new ArrayDeque<JsonObject<String, Object>>()) : JsonReader.newInstance(c))))));
            }
        } else {
            Object[] items = jsonObj.getArray();
            if (clazz.isArray() || items != null && clazz == Object.class && !jsonObj.containsKey("@keys")) {
                int size = items == null ? 0 : items.length;
                mate = Array.newInstance(clazz.isArray() ? clazz.getComponentType() : Object.class, size);
            } else if (clazz.isEnum()) {
                mate = JsonReader.getEnum(clazz, jsonObj);
            } else if (Enum.class.isAssignableFrom(clazz)) {
                mate = JsonReader.getEnum(clazz.getSuperclass(), jsonObj);
            } else if ("java.util.Arrays$ArrayList".equals(clazz.getName())) {
                mate = new ArrayList();
            } else if (clazz == Object.class && !useMapsLocal) {
                if (jsonObj.isMap() || jsonObj.size() > 0) {
                    mate = new JsonObject();
                    ((JsonObject)mate).type = Map.class.getName();
                } else {
                    mate = JsonReader.newInstance(clazz);
                }
            } else {
                mate = JsonReader.newInstance(clazz);
            }
        }
        jsonObj.target = mate;
        return jsonObj.target;
    }

    private static Object getEnum(Class c, JsonObject jsonObj) {
        try {
            return Enum.valueOf(c, (String)jsonObj.get("name"));
        }
        catch (Exception exception) {
            return Enum.valueOf(c, (String)jsonObj.get("java.lang.Enum.name"));
        }
    }

    private Object readJsonObject() throws IOException {
        boolean done = false;
        String field = null;
        JsonObject<String, Object> object = new JsonObject<String, Object>();
        int state = 0;
        FastPushbackReader in = this.input;
        while (!done) {
            switch (state) {
                case 0: {
                    int c = this.skipWhitespaceRead();
                    if (c == 123) {
                        object.line = in.line;
                        object.col = in.col;
                        c = this.skipWhitespaceRead();
                        if (c == 125) {
                            return EMPTY_OBJECT;
                        }
                        in.unread(c);
                        state = 1;
                        break;
                    }
                    JsonReader.error("Input is invalid JSON; object does not start with '{', c=" + c);
                    break;
                }
                case 1: {
                    int c = this.skipWhitespaceRead();
                    if (c == 34) {
                        field = this.readString();
                        c = this.skipWhitespaceRead();
                        if (c != 58) {
                            JsonReader.error("Expected ':' between string field and value");
                        }
                        this.skipWhitespace();
                        state = 2;
                        break;
                    }
                    JsonReader.error("Expected quote");
                    break;
                }
                case 2: {
                    if (field == null) {
                        field = "@items";
                    }
                    Object value = this.readValue(object);
                    object.put(field, value);
                    if ("@id".equals(field)) {
                        this._objsRead.put((Long)value, object);
                    }
                    state = 3;
                    break;
                }
                case 3: {
                    int c = this.skipWhitespaceRead();
                    if (c == -1) {
                        JsonReader.error("EOF reached before closing '}'");
                    }
                    if (c == 125) {
                        done = true;
                        break;
                    }
                    if (c == 44) {
                        state = 1;
                        break;
                    }
                    JsonReader.error("Object not ended with '}'");
                }
            }
        }
        if (this.useMaps && object.isPrimitive()) {
            return object.getPrimitiveValue();
        }
        return object;
    }

    private Object readValue(JsonObject object) throws IOException {
        int c = this.input.read();
        switch (c) {
            case 34: {
                return this.readString();
            }
            case 123: {
                this.input.unread(123);
                return this.readJsonObject();
            }
            case 91: {
                return this.readArray(object);
            }
            case 93: {
                this.input.unread(93);
                return EMPTY_ARRAY;
            }
            case 70: 
            case 102: {
                this.input.unread(c);
                this.readToken("false");
                return Boolean.FALSE;
            }
            case 78: 
            case 110: {
                this.input.unread(c);
                this.readToken("null");
                return null;
            }
            case 84: 
            case 116: {
                this.input.unread(c);
                this.readToken("true");
                return Boolean.TRUE;
            }
            case -1: {
                JsonReader.error("EOF reached prematurely");
            }
        }
        if (JsonReader.isDigit(c) || c == 45) {
            return this.readNumber(c);
        }
        return JsonReader.error("Unknown JSON value type");
    }

    private Object readArray(JsonObject object) throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        while (true) {
            int c;
            this.skipWhitespace();
            Object o = this.readValue(object);
            if (o != EMPTY_ARRAY) {
                array.add(o);
            }
            if ((c = this.skipWhitespaceRead()) == 93) break;
            if (c == 44) continue;
            JsonReader.error("Expected ',' or ']' inside array");
        }
        return array.toArray();
    }

    private void readToken(String token) throws IOException {
        int len = token.length();
        int i = 0;
        while (i < len) {
            int c = this.input.read();
            if (c == -1) {
                JsonReader.error("EOF reached while reading token: " + token);
            }
            c = Character.toLowerCase((char)c);
            char loTokenChar = token.charAt(i);
            if (loTokenChar != c) {
                JsonReader.error("Expected token: " + token);
            }
            ++i;
        }
    }

    private Number readNumber(int c) throws IOException {
        FastPushbackReader in = this.input;
        char[] buffer = this.numBuf;
        buffer[0] = (char)c;
        int len = 1;
        boolean isFloat = false;
        try {
            while (true) {
                if ((c = in.read()) >= 48 && c <= 57 || c == 45 || c == 43) {
                    buffer[len++] = (char)c;
                    continue;
                }
                if (c != 46 && c != 101 && c != 69) break;
                buffer[len++] = (char)c;
                isFloat = true;
            }
            if (c != -1) {
                in.unread(c);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            JsonReader.error("Too many digits in number: " + new String(buffer));
        }
        if (isFloat) {
            String num = new String(buffer, 0, len);
            try {
                return Double.parseDouble(num);
            }
            catch (NumberFormatException e) {
                JsonReader.error("Invalid floating point number: " + num, e);
            }
        }
        boolean isNeg = buffer[0] == '-';
        long n = 0L;
        int i = isNeg ? 1 : 0;
        while (i < len) {
            n = (long)(buffer[i] - 48) + n * 10L;
            ++i;
        }
        return isNeg ? -n : n;
    }

    private String readString() throws IOException {
        StringBuilder str = this.strBuf;
        str.setLength(0);
        StringBuilder hex = new StringBuilder();
        boolean done = false;
        int state = 0;
        while (!done) {
            int c = this.input.read();
            if (c == -1) {
                JsonReader.error("EOF reached while reading JSON string");
            }
            block0 : switch (state) {
                case 0: {
                    if (c == 92) {
                        state = 1;
                        break;
                    }
                    if (c == 34) {
                        done = true;
                        break;
                    }
                    str.append(JsonReader.toChars(c));
                    break;
                }
                case 1: {
                    switch (c) {
                        case 92: {
                            str.append('\\');
                            break;
                        }
                        case 47: {
                            str.append('/');
                            break;
                        }
                        case 34: {
                            str.append('\"');
                            break;
                        }
                        case 39: {
                            str.append('\'');
                            break;
                        }
                        case 98: {
                            str.append('\b');
                            break;
                        }
                        case 102: {
                            str.append('\f');
                            break;
                        }
                        case 110: {
                            str.append('\n');
                            break;
                        }
                        case 114: {
                            str.append('\r');
                            break;
                        }
                        case 116: {
                            str.append('\t');
                            break;
                        }
                        case 117: {
                            state = 2;
                            hex.setLength(0);
                            break;
                        }
                        default: {
                            JsonReader.error("Invalid character escape sequence specified: " + c);
                        }
                    }
                    if (c == 117) break;
                    state = 0;
                    break;
                }
                case 2: {
                    switch (c) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: {
                            hex.append((char)c);
                            if (hex.length() != 4) break block0;
                            int value = Integer.parseInt(hex.toString(), 16);
                            str.append(JsonReader.valueOf((char)value));
                            state = 0;
                            break block0;
                        }
                    }
                    JsonReader.error("Expected hexadecimal digits");
                }
            }
        }
        String s = str.toString();
        String cacheHit = stringCache.get(s);
        return cacheHit == null ? s : cacheHit;
    }

    private static Object newInstance(Class c) throws IOException {
        if (factory.containsKey(c)) {
            return factory.get(c).newInstance(c);
        }
        if (unmodifiableSortedMap.getClass().isAssignableFrom(c)) {
            return new TreeMap();
        }
        if (unmodifiableMap.getClass().isAssignableFrom(c)) {
            return new LinkedHashMap();
        }
        if (unmodifiableSortedSet.getClass().isAssignableFrom(c)) {
            return new TreeSet();
        }
        if (unmodifiableSet.getClass().isAssignableFrom(c)) {
            return new LinkedHashSet();
        }
        if (unmodifiableCollection.getClass().isAssignableFrom(c)) {
            return new ArrayList();
        }
        Object[] constructorInfo = constructors.get(c);
        if (constructorInfo != null) {
            Constructor constructor = (Constructor)constructorInfo[0];
            if (constructor == null && useUnsafe) {
                try {
                    return unsafe.allocateInstance(c);
                }
                catch (Exception e) {
                    JsonReader.error("Could not instantiate " + c.getName(), e);
                }
            }
            Boolean useNull = (Boolean)constructorInfo[1];
            Class[] paramTypes = constructor.getParameterTypes();
            if (paramTypes == null || paramTypes.length == 0) {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    JsonReader.error("Could not instantiate " + c.getName(), e);
                }
            }
            Object[] values = JsonReader.fillArgs(paramTypes, useNull);
            try {
                return constructor.newInstance(values);
            }
            catch (Exception e) {
                JsonReader.error("Could not instantiate " + c.getName(), e);
            }
        }
        Object[] ret = JsonReader.newInstanceEx(c);
        constructors.put(c, new Object[]{ret[1], ret[2]});
        return ret[0];
    }

    private static Object[] newInstanceEx(Class c) throws IOException {
        try {
            Constructor constructor = c.getConstructor(emptyClassArray);
            if (constructor != null) {
                return new Object[]{constructor.newInstance(new Object[0]), constructor, true};
            }
            return JsonReader.tryOtherConstruction(c);
        }
        catch (Exception exception) {
            return JsonReader.tryOtherConstruction(c);
        }
    }

    private static Object[] tryOtherConstruction(Class c) throws IOException {
        Object[] values;
        Class[] argTypes;
        Constructor<?> constructor;
        Constructor<?>[] constructors = c.getDeclaredConstructors();
        if (constructors.length == 0) {
            JsonReader.error("Cannot instantiate '" + c.getName() + "' - Primitive, interface, array[] or void");
        }
        Constructor<?>[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            constructor = constructorArray[n2];
            constructor.setAccessible(true);
            argTypes = constructor.getParameterTypes();
            values = JsonReader.fillArgs(argTypes, true);
            try {
                return new Object[]{constructor.newInstance(values), constructor, true};
            }
            catch (Exception exception) {
                ++n2;
            }
        }
        constructorArray = constructors;
        n = constructors.length;
        n2 = 0;
        while (n2 < n) {
            constructor = constructorArray[n2];
            constructor.setAccessible(true);
            argTypes = constructor.getParameterTypes();
            values = JsonReader.fillArgs(argTypes, false);
            try {
                return new Object[]{constructor.newInstance(values), constructor, false};
            }
            catch (Exception exception) {
                ++n2;
            }
        }
        if (useUnsafe) {
            try {
                Object[] objectArray = new Object[3];
                objectArray[0] = unsafe.allocateInstance(c);
                return objectArray;
            }
            catch (Exception exception) {}
        }
        JsonReader.error("Could not instantiate " + c.getName() + " using any constructor");
        return null;
    }

    private static Object[] fillArgs(Class[] argTypes, boolean useNull) throws IOException {
        Object[] values = new Object[argTypes.length];
        int i = 0;
        while (i < argTypes.length) {
            Class argType = argTypes[i];
            values[i] = JsonReader.isPrimitive(argType) ? JsonReader.newPrimitiveWrapper(argType, null) : (useNull ? null : (argType == String.class ? "" : (argType == Date.class ? new Date() : (List.class.isAssignableFrom(argType) ? new ArrayList() : (SortedSet.class.isAssignableFrom(argType) ? new TreeSet() : (Set.class.isAssignableFrom(argType) ? new LinkedHashSet() : (SortedMap.class.isAssignableFrom(argType) ? new TreeMap() : (Map.class.isAssignableFrom(argType) ? new LinkedHashMap() : (Collection.class.isAssignableFrom(argType) ? new ArrayList() : (Calendar.class.isAssignableFrom(argType) ? Calendar.getInstance() : (TimeZone.class.isAssignableFrom(argType) ? TimeZone.getDefault() : (argType == BigInteger.class ? BigInteger.TEN : (argType == BigDecimal.class ? BigDecimal.TEN : (argType == StringBuilder.class ? new StringBuilder() : (argType == StringBuffer.class ? new StringBuffer() : (argType == Locale.class ? Locale.FRANCE : (argType == Class.class ? String.class : (argType == Timestamp.class ? new Timestamp(System.currentTimeMillis()) : (argType == java.sql.Date.class ? new java.sql.Date(System.currentTimeMillis()) : (argType == URL.class ? new URL("http://localhost") : (argType == Object.class ? new Object() : null)))))))))))))))))))));
            ++i;
        }
        return values;
    }

    public static boolean isPrimitive(Class c) {
        return c.isPrimitive() || prims.contains(c);
    }

    public static boolean isLogicalPrimitive(Class c) {
        return JsonReader.isPrimitive(c) || String.class.isAssignableFrom(c) || Number.class.isAssignableFrom(c) || Date.class.isAssignableFrom(c) || Class.class.isAssignableFrom(c);
    }

    private static Object newPrimitiveWrapper(Class c, Object rhs) throws IOException {
        String cname;
        switch (cname = c.getName()) {
            case "boolean": 
            case "java.lang.Boolean": {
                if (rhs instanceof String) {
                    if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "false";
                    }
                    return Boolean.parseBoolean((String)rhs);
                }
                return rhs != null ? rhs : Boolean.FALSE;
            }
            case "byte": 
            case "java.lang.Byte": {
                if (rhs instanceof String) {
                    if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "0";
                    }
                    return Byte.parseByte((String)rhs);
                }
                return rhs != null ? byteCache[((Number)rhs).byteValue() + 128] : (byte)0;
            }
            case "char": 
            case "java.lang.Character": {
                if (rhs == null) {
                    return Character.valueOf('\u0000');
                }
                if (rhs instanceof String) {
                    if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "\u0000";
                    }
                    return JsonReader.valueOf(((String)rhs).charAt(0));
                }
                if (!(rhs instanceof Character)) break;
                return rhs;
            }
            case "double": 
            case "java.lang.Double": {
                if (rhs instanceof String) {
                    if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "0.0";
                    }
                    return Double.parseDouble((String)rhs);
                }
                return rhs != null ? rhs : Double.valueOf(0.0);
            }
            case "java.lang.Float": 
            case "float": {
                if (rhs instanceof String) {
                    if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "0.0f";
                    }
                    return Float.valueOf(Float.parseFloat((String)rhs));
                }
                return Float.valueOf(rhs != null ? ((Number)rhs).floatValue() : 0.0f);
            }
            case "java.lang.Integer": 
            case "int": {
                if (rhs instanceof String) {
                    if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "0";
                    }
                    return Integer.parseInt((String)rhs);
                }
                return rhs != null ? ((Number)rhs).intValue() : 0;
            }
            case "long": 
            case "java.lang.Long": {
                if (rhs instanceof String) {
                    if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "0";
                    }
                    return Long.parseLong((String)rhs);
                }
                return rhs != null ? rhs : Long.valueOf(0L);
            }
            case "java.lang.Short": 
            case "short": {
                if (rhs instanceof String) {
                    if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "0";
                    }
                    return Short.parseShort((String)rhs);
                }
                return rhs != null ? ((Number)rhs).shortValue() : (short)0;
            }
        }
        return JsonReader.error("Class '" + cname + "' requested for special instantiation - isPrimitive() does not match newPrimitiveWrapper()");
    }

    static String removeLeadingAndTrailingQuotes(String s) {
        Matcher m = extraQuotes.matcher(s);
        if (m.find()) {
            s = m.group(2);
        }
        return s;
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    static Class classForName(String name) throws IOException {
        if (name == null || name.isEmpty()) {
            JsonReader.error("Empty class name");
        }
        try {
            Class c = nameToClass.get(name);
            return c == null ? JsonReader.loadClass(name) : c;
        }
        catch (ClassNotFoundException e) {
            return (Class)JsonReader.error("Class instance '" + name + "' could not be created", e);
        }
    }

    private static Class loadClass(String name) throws ClassNotFoundException {
        String className = name;
        boolean arrayType = false;
        Class<Object> primitiveArray = null;
        while (className.startsWith("[")) {
            arrayType = true;
            if (className.endsWith(";")) {
                className = className.substring(0, className.length() - 1);
            }
            switch (className) {
                case "[B": {
                    primitiveArray = byte[].class;
                    break;
                }
                case "[S": {
                    primitiveArray = short[].class;
                    break;
                }
                case "[I": {
                    primitiveArray = int[].class;
                    break;
                }
                case "[J": {
                    primitiveArray = long[].class;
                    break;
                }
                case "[F": {
                    primitiveArray = float[].class;
                    break;
                }
                case "[D": {
                    primitiveArray = double[].class;
                    break;
                }
                case "[Z": {
                    primitiveArray = boolean[].class;
                    break;
                }
                case "[C": {
                    primitiveArray = char[].class;
                }
            }
            int startpos = className.startsWith("[L") ? 2 : 1;
            className = className.substring(startpos);
        }
        Class<?> currentClass = null;
        if (primitiveArray == null) {
            currentClass = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        if (arrayType) {
            currentClass = primitiveArray != null ? primitiveArray : Array.newInstance(currentClass, 0).getClass();
            while (name.startsWith("[[")) {
                currentClass = Array.newInstance(currentClass, 0).getClass();
                name = name.substring(1);
            }
        }
        return currentClass;
    }

    protected Field getDeclaredField(Class c, String fieldName) {
        return (Field)JsonWriter.getDeepDeclaredFields(c).get(fieldName);
    }

    private int skipWhitespaceRead() throws IOException {
        FastPushbackReader in = this.input;
        int c = in.read();
        while (true) {
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    return c;
                }
            }
            c = in.read();
        }
    }

    private void skipWhitespace() throws IOException {
        this.input.unread(this.skipWhitespaceRead());
    }

    @Override
    public void close() {
        try {
            threadInput.remove();
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void patchUnresolvedReferences() throws IOException {
        Iterator<UnresolvedReference> i = this.unresolvedRefs.iterator();
        while (i.hasNext()) {
            UnresolvedReference ref = i.next();
            Object objToFix = ((UnresolvedReference)ref).referencingObj.target;
            JsonObject objReferenced = this._objsRead.get(ref.refId);
            if (objReferenced == null || objReferenced.target == null || objToFix == null) continue;
            if (ref.index >= 0) {
                if (objToFix instanceof List) {
                    List list = (List)objToFix;
                    list.set(ref.index, objReferenced.target);
                } else if (objToFix instanceof Collection) {
                    Collection col = (Collection)objToFix;
                    col.add(objReferenced.target);
                } else {
                    Array.set(objToFix, ref.index, objReferenced.target);
                }
            } else {
                Field field = this.getDeclaredField(objToFix.getClass(), ref.field);
                if (field != null) {
                    try {
                        field.set(objToFix, objReferenced.target);
                    }
                    catch (Exception e) {
                        JsonReader.error("Error setting field while resolving references '" + field.getName() + "', @ref = " + ref.refId, e);
                    }
                }
            }
            i.remove();
        }
        int count = this.unresolvedRefs.size();
        if (count > 0) {
            StringBuilder out = new StringBuilder();
            out.append(count);
            out.append(" unresolved references:\n");
            i = this.unresolvedRefs.iterator();
            count = 1;
            while (i.hasNext()) {
                UnresolvedReference ref = i.next();
                out.append("    Unresolved reference ");
                out.append(count);
                out.append('\n');
                out.append("        @ref ");
                out.append(ref.refId);
                out.append('\n');
                out.append("        field ");
                out.append(ref.field);
                out.append("\n\n");
                ++count;
            }
            JsonReader.error(out.toString());
        }
    }

    private void rehashMaps() {
        boolean useMapsLocal = this.useMaps;
        for (Object[] mapPieces : this.prettyMaps) {
            Object[] javaValues;
            Object[] javaKeys;
            Map<Object, Object> map;
            JsonObject jObj = (JsonObject)mapPieces[0];
            if (useMapsLocal) {
                map = jObj;
                javaKeys = (Object[])jObj.remove("@keys");
                javaValues = (Object[])jObj.remove("@items");
            } else {
                map = (Map)jObj.target;
                javaKeys = (Object[])mapPieces[1];
                javaValues = (Object[])mapPieces[2];
                jObj.clear();
            }
            int j = 0;
            while (javaKeys != null && j < javaKeys.length) {
                map.put(javaKeys[j], javaValues[j]);
                ++j;
            }
        }
    }

    private static String getErrorMessage(String msg) {
        if (threadInput.get() != null) {
            return String.valueOf(msg) + "\nLast read: " + JsonReader.getLastReadSnippet() + "\nline: " + threadInput.get().line + ", col: " + threadInput.get().col;
        }
        return msg;
    }

    static Object error(String msg) throws IOException {
        throw new IOException(JsonReader.getErrorMessage(msg));
    }

    static Object error(String msg, Exception e) throws IOException {
        throw new IOException(JsonReader.getErrorMessage(msg), e);
    }

    private static String getLastReadSnippet() {
        if (threadInput.get() != null) {
            return JsonReader.threadInput.get().getLastSnippet();
        }
        return "";
    }

    private static Character valueOf(char c) {
        return Character.valueOf(c <= '\u007f' ? charCache[c].charValue() : c);
    }

    private static char[] toChars(int codePoint) {
        if (codePoint < 0 || codePoint > 0x10FFFF) {
            throw new IllegalArgumentException("value ' + codePoint + ' outside UTF-8 range");
        }
        if (codePoint < 65536) {
            return new char[]{(char)codePoint};
        }
        char[] result = new char[2];
        int offset = codePoint - 65536;
        result[1] = (char)((offset & 0x3FF) + 56320);
        result[0] = (char)((offset >>> 10) + 55296);
        return result;
    }

    public static class BigDecimalReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject<String, Object>> stack) throws IOException {
            JsonObject jObj = null;
            Object value = o;
            if (o instanceof JsonObject) {
                jObj = (JsonObject)o;
                if (jObj.containsKey("value")) {
                    value = jObj.get("value");
                } else {
                    return JsonReader.error("BigDecimal missing 'value' field");
                }
            }
            if (value instanceof JsonObject) {
                JsonObject valueObj = (JsonObject)value;
                if ("java.math.BigInteger".equals(valueObj.type)) {
                    BigIntegerReader reader = new BigIntegerReader();
                    value = reader.read(value, stack);
                } else if ("java.math.BigDecimal".equals(valueObj.type)) {
                    value = this.read(value, stack);
                } else {
                    return JsonReader.error("Unknown object type attempted to be assigned to BigInteger field: " + value);
                }
            }
            BigDecimal x = JsonReader.bigDecimalFrom(value);
            if (jObj != null) {
                jObj.target = x;
            }
            return x;
        }
    }

    public static class BigIntegerReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject<String, Object>> stack) throws IOException {
            JsonObject jObj = null;
            Object value = o;
            if (o instanceof JsonObject) {
                jObj = (JsonObject)o;
                if (jObj.containsKey("value")) {
                    value = jObj.get("value");
                } else {
                    return JsonReader.error("BigInteger missing 'value' field");
                }
            }
            if (value instanceof JsonObject) {
                JsonObject valueObj = (JsonObject)value;
                if ("java.math.BigDecimal".equals(valueObj.type)) {
                    BigDecimalReader reader = new BigDecimalReader();
                    value = reader.read(value, stack);
                } else if ("java.math.BigInteger".equals(valueObj.type)) {
                    value = this.read(value, stack);
                } else {
                    return JsonReader.error("Unknown object type attempted to be assigned to BigInteger field: " + value);
                }
            }
            BigInteger x = JsonReader.bigIntegerFrom(value);
            if (jObj != null) {
                jObj.target = x;
            }
            return x;
        }
    }

    public static class CalendarReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject<String, Object>> stack) throws IOException {
            String time = null;
            try {
                Class c;
                JsonObject jObj = (JsonObject)o;
                time = (String)jObj.get("time");
                if (time == null) {
                    JsonReader.error("Calendar missing 'time' field");
                }
                Date date = JsonWriter._dateFormat.get().parse(time);
                if (jObj.getTarget() != null) {
                    c = jObj.getTarget().getClass();
                } else {
                    String type = jObj.type;
                    c = JsonReader.classForName(type);
                }
                Calendar calendar = (Calendar)JsonReader.newInstance(c);
                calendar.setTime(date);
                jObj.setTarget(calendar);
                String zone = (String)jObj.get("zone");
                if (zone != null) {
                    calendar.setTimeZone(TimeZone.getTimeZone(zone));
                }
                return calendar;
            }
            catch (Exception exception) {
                return JsonReader.error("Failed to parse calendar, time: " + time);
            }
        }
    }

    public static interface ClassFactory {
        public Object newInstance(Class var1);
    }

    public static class ClassReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject<String, Object>> stack) throws IOException {
            if (o instanceof String) {
                return JsonReader.classForName((String)o);
            }
            JsonObject jObj = (JsonObject)o;
            if (jObj.containsKey("value")) {
                jObj.target = JsonReader.classForName((String)jObj.get("value"));
                return jObj.target;
            }
            return JsonReader.error("Class missing 'value' field");
        }
    }

    public static class CollectionFactory
    implements ClassFactory {
        @Override
        public Object newInstance(Class c) {
            if (List.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            if (SortedSet.class.isAssignableFrom(c)) {
                return new TreeSet();
            }
            if (Set.class.isAssignableFrom(c)) {
                return new LinkedHashSet();
            }
            if (Collection.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            throw new RuntimeException("CollectionFactory handed Class for which it was not expecting: " + c.getName());
        }
    }

    public static class DateReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject<String, Object>> stack) throws IOException {
            if (o instanceof Long) {
                return new Date((Long)o);
            }
            if (o instanceof String) {
                return DateReader.parseDate((String)o);
            }
            if (o instanceof JsonObject) {
                JsonObject jObj = (JsonObject)o;
                Object val = jObj.get("value");
                if (val instanceof Long) {
                    return new Date((Long)val);
                }
                if (val instanceof String) {
                    return DateReader.parseDate((String)val);
                }
                return JsonReader.error("Unable to parse date: " + o);
            }
            return JsonReader.error("Unable to parse date, encountered unknown object: " + o);
        }

        private static Date parseDate(String dateStr) throws IOException {
            Matcher dayMatcher;
            String remains;
            String day;
            String year;
            if (dateStr == null) {
                return null;
            }
            if ((dateStr = dateStr.trim()).isEmpty()) {
                return null;
            }
            Matcher matcher = datePattern1.matcher(dateStr);
            String month = null;
            String mon = null;
            if (matcher.find()) {
                year = matcher.group(1);
                month = matcher.group(2);
                day = matcher.group(3);
                remains = matcher.replaceFirst("");
            } else {
                matcher = datePattern2.matcher(dateStr);
                if (matcher.find()) {
                    month = matcher.group(1);
                    day = matcher.group(2);
                    year = matcher.group(3);
                    remains = matcher.replaceFirst("");
                } else {
                    matcher = datePattern3.matcher(dateStr);
                    if (matcher.find()) {
                        mon = matcher.group(1);
                        day = matcher.group(2);
                        year = matcher.group(4);
                        remains = matcher.replaceFirst("");
                    } else {
                        matcher = datePattern4.matcher(dateStr);
                        if (matcher.find()) {
                            day = matcher.group(1);
                            mon = matcher.group(3);
                            year = matcher.group(4);
                            remains = matcher.replaceFirst("");
                        } else {
                            matcher = datePattern5.matcher(dateStr);
                            if (matcher.find()) {
                                year = matcher.group(1);
                                mon = matcher.group(2);
                                day = matcher.group(3);
                                remains = matcher.replaceFirst("");
                            } else {
                                matcher = datePattern6.matcher(dateStr);
                                if (!matcher.find()) {
                                    JsonReader.error("Unable to parse: " + dateStr);
                                }
                                year = matcher.group(5);
                                mon = matcher.group(2);
                                day = matcher.group(3);
                                remains = matcher.group(4);
                            }
                        }
                    }
                }
            }
            if (mon != null) {
                month = (String)months.get(mon.trim().toLowerCase());
            }
            String hour = null;
            String min = null;
            String sec = "00";
            String milli = "0";
            String tz = null;
            remains = remains.trim();
            matcher = timePattern1.matcher(remains);
            if (matcher.find()) {
                hour = matcher.group(1);
                min = matcher.group(2);
                sec = matcher.group(3);
                milli = matcher.group(4);
                if (matcher.groupCount() > 4) {
                    tz = matcher.group(5);
                }
            } else {
                matcher = timePattern2.matcher(remains);
                if (matcher.find()) {
                    hour = matcher.group(1);
                    min = matcher.group(2);
                    sec = matcher.group(3);
                    if (matcher.groupCount() > 3) {
                        tz = matcher.group(4);
                    }
                } else {
                    matcher = timePattern3.matcher(remains);
                    if (matcher.find()) {
                        hour = matcher.group(1);
                        min = matcher.group(2);
                        if (matcher.groupCount() > 2) {
                            tz = matcher.group(3);
                        }
                    } else {
                        matcher = null;
                    }
                }
            }
            if (matcher != null) {
                remains = matcher.replaceFirst("");
            }
            if (remains != null && remains.length() > 0 && (dayMatcher = dayPattern.matcher(remains)).find()) {
                remains = dayMatcher.replaceFirst("").trim();
            }
            if (remains != null && remains.length() > 0 && !(remains = remains.trim()).equals(",") && !remains.equals("T")) {
                JsonReader.error("Issue parsing data/time, other characters present: " + remains);
            }
            Calendar c = Calendar.getInstance();
            c.clear();
            if (tz != null) {
                if ("z".equalsIgnoreCase(tz)) {
                    c.setTimeZone(TimeZone.getTimeZone("GMT"));
                } else {
                    c.setTimeZone(TimeZone.getTimeZone("GMT" + tz));
                }
            }
            int y = Integer.parseInt(year);
            int m = Integer.parseInt(month) - 1;
            int d = Integer.parseInt(day);
            if (m < 0 || m > 11) {
                JsonReader.error("Month must be between 1 and 12 inclusive, date: " + dateStr);
            }
            if (d < 1 || d > 31) {
                JsonReader.error("Day must be between 1 and 31 inclusive, date: " + dateStr);
            }
            if (matcher == null) {
                c.set(y, m, d);
            } else {
                int h = Integer.parseInt(hour);
                int mn = Integer.parseInt(min);
                int s = Integer.parseInt(sec);
                int ms = Integer.parseInt(milli);
                if (h > 23) {
                    JsonReader.error("Hour must be between 0 and 23 inclusive, time: " + dateStr);
                }
                if (mn > 59) {
                    JsonReader.error("Minute must be between 0 and 59 inclusive, time: " + dateStr);
                }
                if (s > 59) {
                    JsonReader.error("Second must be between 0 and 59 inclusive, time: " + dateStr);
                }
                c.set(y, m, d, h, mn, s);
                c.set(14, ms);
            }
            return c.getTime();
        }
    }

    private static final class FastPushbackReader
    extends FilterReader {
        private final int[] buf;
        private final int[] snippet;
        private int idx;
        private int line;
        private int col;
        private int snippetLoc = 0;

        private FastPushbackReader(Reader reader, int size) {
            super(reader);
            if (size <= 0) {
                throw new IllegalArgumentException("size <= 0");
            }
            this.buf = new int[size];
            this.idx = size;
            this.snippet = new int[200];
            this.line = 1;
            this.col = 0;
        }

        private FastPushbackReader(Reader r) {
            this(r, 1);
        }

        private String getLastSnippet() {
            StringBuilder s = new StringBuilder();
            int i = this.snippetLoc;
            while (i < 200) {
                if (this.addCharToSnippet(s, i)) break;
                ++i;
            }
            i = 0;
            while (i < this.snippetLoc) {
                if (this.addCharToSnippet(s, i)) break;
                ++i;
            }
            return s.toString();
        }

        private boolean addCharToSnippet(StringBuilder s, int i) {
            char[] character;
            try {
                character = JsonReader.toChars(this.snippet[i]);
            }
            catch (Exception exception) {
                return true;
            }
            if (this.snippet[i] == 0) {
                return true;
            }
            s.append(character);
            return false;
        }

        @Override
        public int read() throws IOException {
            int ch;
            int n = ch = this.idx < this.buf.length ? this.buf[this.idx++] : this.in.read();
            if (ch >= 0) {
                if (ch == 10) {
                    ++this.line;
                    this.col = 0;
                } else {
                    ++this.col;
                }
                this.snippet[this.snippetLoc++] = ch;
                if (this.snippetLoc >= 200) {
                    this.snippetLoc = 0;
                }
            }
            return ch;
        }

        public void unread(int c) throws IOException {
            if (this.idx == 0) {
                JsonReader.error("unread(int c) called more than buffer size (" + this.buf.length + ")");
            }
            if (c == 10) {
                --this.line;
            } else {
                --this.col;
            }
            this.buf[--this.idx] = c;
            --this.snippetLoc;
            if (this.snippetLoc < 0) {
                this.snippetLoc = 199;
            }
            this.snippet[this.snippetLoc] = c;
        }
    }

    public static interface JsonClassReader {
        public Object read(Object var1, Deque<JsonObject<String, Object>> var2) throws IOException;
    }

    public static class LocaleReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject<String, Object>> stack) throws IOException {
            JsonObject jObj = (JsonObject)o;
            Object language = jObj.get("language");
            if (language == null) {
                JsonReader.error("java.util.Locale must specify 'language' field");
            }
            Object country = jObj.get("country");
            Object variant = jObj.get("variant");
            if (country == null) {
                jObj.target = new Locale((String)language);
                return jObj.target;
            }
            if (variant == null) {
                jObj.target = new Locale((String)language, (String)country);
                return jObj.target;
            }
            jObj.target = new Locale((String)language, (String)country, (String)variant);
            return jObj.target;
        }
    }

    public static class MapFactory
    implements ClassFactory {
        @Override
        public Object newInstance(Class c) {
            if (SortedMap.class.isAssignableFrom(c)) {
                return new TreeMap();
            }
            if (Map.class.isAssignableFrom(c)) {
                return new LinkedHashMap();
            }
            throw new RuntimeException("MapFactory handed Class for which it was not expecting: " + c.getName());
        }
    }

    public static class SqlDateReader
    extends DateReader {
        @Override
        public Object read(Object o, Deque<JsonObject<String, Object>> stack) throws IOException {
            return new java.sql.Date(((Date)super.read(o, stack)).getTime());
        }
    }

    public static class StringBufferReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject<String, Object>> stack) throws IOException {
            if (o instanceof String) {
                return new StringBuffer((String)o);
            }
            JsonObject jObj = (JsonObject)o;
            if (jObj.containsKey("value")) {
                jObj.target = new StringBuffer((String)jObj.get("value"));
                return jObj.target;
            }
            return JsonReader.error("StringBuffer missing 'value' field");
        }
    }

    public static class StringBuilderReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject<String, Object>> stack) throws IOException {
            if (o instanceof String) {
                return new StringBuilder((String)o);
            }
            JsonObject jObj = (JsonObject)o;
            if (jObj.containsKey("value")) {
                jObj.target = new StringBuilder((String)jObj.get("value"));
                return jObj.target;
            }
            return JsonReader.error("StringBuilder missing 'value' field");
        }
    }

    public static class StringReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject<String, Object>> stack) throws IOException {
            if (o instanceof String) {
                return o;
            }
            if (JsonReader.isPrimitive(o.getClass())) {
                return o.toString();
            }
            JsonObject jObj = (JsonObject)o;
            if (jObj.containsKey("value")) {
                jObj.target = jObj.get("value");
                return jObj.target;
            }
            return JsonReader.error("String missing 'value' field");
        }
    }

    public static class TimeZoneReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject<String, Object>> stack) throws IOException {
            JsonObject jObj = (JsonObject)o;
            Object zone = jObj.get("zone");
            if (zone == null) {
                JsonReader.error("java.util.TimeZone must specify 'zone' field");
            }
            jObj.target = TimeZone.getTimeZone((String)zone);
            return jObj.target;
        }
    }

    public static class TimestampReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, Deque<JsonObject<String, Object>> stack) throws IOException {
            Object nanos;
            JsonObject jObj = (JsonObject)o;
            Object time = jObj.get("time");
            if (time == null) {
                JsonReader.error("java.sql.Timestamp must specify 'time' field");
            }
            if ((nanos = jObj.get("nanos")) == null) {
                jObj.target = new Timestamp(Long.valueOf((String)time));
                return jObj.target;
            }
            Timestamp tstamp = new Timestamp(Long.valueOf((String)time));
            tstamp.setNanos(Integer.valueOf((String)nanos));
            jObj.target = tstamp;
            return jObj.target;
        }
    }

    private static final class UnresolvedReference {
        private final JsonObject referencingObj;
        private String field;
        private final long refId;
        private int index = -1;

        private UnresolvedReference(JsonObject referrer, String fld, long id) {
            this.referencingObj = referrer;
            this.field = fld;
            this.refId = id;
        }

        private UnresolvedReference(JsonObject referrer, int idx, long id) {
            this.referencingObj = referrer;
            this.index = idx;
            this.refId = id;
        }
    }

    static final class Unsafe {
        private final Object sunUnsafe;
        private final Method allocateInstance;

        public Unsafe() throws ReflectiveOperationException {
            try {
                Constructor unsafeConstructor = JsonReader.classForName("sun.misc.Unsafe").getDeclaredConstructor(new Class[0]);
                unsafeConstructor.setAccessible(true);
                this.sunUnsafe = unsafeConstructor.newInstance(new Object[0]);
                this.allocateInstance = this.sunUnsafe.getClass().getMethod("allocateInstance", Class.class);
                this.allocateInstance.setAccessible(true);
            }
            catch (Exception e) {
                throw new ReflectiveOperationException(e);
            }
        }

        public Object allocateInstance(Class clazz) {
            try {
                return this.allocateInstance.invoke(this.sunUnsafe, clazz);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

