/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.geom.Dimension;
import com.cedarsoftware.util.geom.Insets;
import com.cedarsoftware.util.geom.Point;
import com.cedarsoftware.util.geom.Rectangle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

final class PointConversions {
    private PointConversions() {
    }

    static String toString(Object from, Converter converter) {
        Point point = (Point)from;
        return "(" + point.getX() + "," + point.getY() + ")";
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        Point point = (Point)from;
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("x", point.getX());
        target.put("y", point.getY());
        return target;
    }

    static int[] toIntArray(Object from, Converter converter) {
        Point point = (Point)from;
        return new int[]{point.getX(), point.getY()};
    }

    static Integer toInteger(Object from, Converter converter) {
        Point point = (Point)from;
        return point.getX();
    }

    static Long toLong(Object from, Converter converter) {
        Point point = (Point)from;
        return point.getX();
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Point point = (Point)from;
        return BigInteger.valueOf(point.getX());
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        throw new IllegalArgumentException("Unsupported conversion from Point to BigDecimal - no meaningful conversion exists.");
    }

    static Dimension toDimension(Object from, Converter converter) {
        Point point = (Point)from;
        return new Dimension(point.getX(), point.getY());
    }

    static Boolean toBoolean(Object from, Converter converter) {
        Point point = (Point)from;
        return point.getX() != 0 || point.getY() != 0;
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return new AtomicBoolean(PointConversions.toBoolean(from, converter));
    }

    static Rectangle toRectangle(Object from, Converter converter) {
        Point point = (Point)from;
        return new Rectangle(point.getX(), point.getY(), 0, 0);
    }

    static Insets toInsets(Object from, Converter converter) {
        Point point = (Point)from;
        return new Insets(point.getX(), point.getY(), 0, 0);
    }
}

