/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.EncryptionUtilities;
import java.time.Duration;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;

public class IntervalSet<T extends Comparable<? super T>>
implements Iterable<Interval<T>> {
    private final ConcurrentSkipListMap<T, T> intervals = new ConcurrentSkipListMap();
    private final transient ReentrantLock lock = new ReentrantLock();

    public IntervalSet() {
    }

    public IntervalSet(IntervalSet<T> other) {
        this.intervals.putAll(other.intervals);
    }

    public IntervalSet(List<Interval<T>> intervals) {
        Objects.requireNonNull(intervals, "intervals");
        for (Interval<T> interval : intervals) {
            Objects.requireNonNull(interval, "interval");
            this.add(interval.getStart(), interval.getEnd());
        }
    }

    public void add(T start, T end) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        if (end.compareTo(start) <= 0) {
            return;
        }
        this.lock.lock();
        try {
            this.addWithMerge(start, end);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addWithMerge(T start, T end) {
        Map.Entry e;
        Object newStart = start;
        Object newEnd = end;
        Map.Entry<T, T> lower = this.intervals.lowerEntry(start);
        if (lower != null && ((Comparable)lower.getValue()).compareTo(start) >= 0) {
            newStart = (Comparable)lower.getKey();
            newEnd = IntervalSet.greaterOf((Comparable)lower.getValue(), end);
            this.intervals.remove(lower.getKey());
        }
        Iterator it = this.intervals.tailMap((Object)start, true).entrySet().iterator();
        while (it.hasNext() && ((Comparable)(e = it.next()).getKey()).compareTo(newEnd) <= 0) {
            newEnd = IntervalSet.greaterOf(newEnd, (Comparable)e.getValue());
            it.remove();
        }
        this.intervals.put(newStart, newEnd);
    }

    public void remove(T start, T end) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        if (end.compareTo(start) <= 0) {
            return;
        }
        this.removeRange(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeExact(T start, T end) {
        Objects.requireNonNull(start);
        Objects.requireNonNull(end);
        this.lock.lock();
        try {
            Comparable existingEnd = (Comparable)this.intervals.get(start);
            if (existingEnd != null && existingEnd.equals(end)) {
                this.intervals.remove(start);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeRange(T start, T end) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        if (end.compareTo(start) <= 0) {
            return;
        }
        this.lock.lock();
        try {
            this.removeRangeWithSplitting(start, end);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeRangeWithSplitting(T start, T end) {
        Map.Entry e;
        Map.Entry<T, T> lower = this.intervals.lowerEntry(start);
        if (lower != null && ((Comparable)lower.getValue()).compareTo(start) > 0) {
            Comparable lowerKey = (Comparable)lower.getKey();
            Comparable lowerValue = (Comparable)lower.getValue();
            this.intervals.remove(lowerKey);
            if (lowerKey.compareTo(start) < 0) {
                this.intervals.put(lowerKey, start);
            }
            if (lowerValue.compareTo(end) > 0) {
                this.intervals.put(end, lowerValue);
            }
        }
        Iterator it = this.intervals.tailMap((Object)start, true).entrySet().iterator();
        while (it.hasNext() && ((Comparable)(e = it.next()).getKey()).compareTo(end) < 0) {
            Comparable entryValue = (Comparable)e.getValue();
            it.remove();
            if (entryValue.compareTo(end) <= 0) continue;
            this.intervals.put(end, entryValue);
        }
    }

    public boolean contains(T value) {
        Objects.requireNonNull(value);
        Map.Entry<T, T> e = this.intervals.floorEntry(value);
        return e != null && ((Comparable)e.getValue()).compareTo(value) > 0;
    }

    public Interval<T> intervalContaining(T value) {
        Objects.requireNonNull(value);
        Map.Entry<T, T> e = this.intervals.floorEntry(value);
        return e != null && ((Comparable)e.getValue()).compareTo(value) > 0 ? new Interval<Comparable>((Comparable)e.getKey(), (Comparable)e.getValue()) : null;
    }

    public Interval<T> first() {
        Map.Entry<T, T> e = this.intervals.firstEntry();
        return e == null ? null : new Interval<Comparable>((Comparable)e.getKey(), (Comparable)e.getValue());
    }

    public Interval<T> last() {
        Map.Entry<T, T> e = this.intervals.lastEntry();
        return e == null ? null : new Interval<Comparable>((Comparable)e.getKey(), (Comparable)e.getValue());
    }

    public Interval<T> nextInterval(T value) {
        Objects.requireNonNull(value);
        Interval<T> containing = this.intervalContaining(value);
        if (containing != null) {
            return containing;
        }
        Map.Entry<T, T> entry = this.intervals.ceilingEntry(value);
        return entry != null ? new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue()) : null;
    }

    public Interval<T> higherInterval(T value) {
        Objects.requireNonNull(value);
        Map.Entry<T, T> entry = this.intervals.higherEntry(value);
        return entry != null ? new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue()) : null;
    }

    public Interval<T> previousInterval(T value) {
        Objects.requireNonNull(value);
        Map.Entry<T, T> entry = this.intervals.floorEntry(value);
        return entry != null ? new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue()) : null;
    }

    public Interval<T> lowerInterval(T value) {
        Objects.requireNonNull(value);
        Map.Entry<T, T> entry = this.intervals.lowerEntry(value);
        return entry != null ? new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue()) : null;
    }

    public List<Interval<T>> getIntervalsInRange(T fromKey, T toKey) {
        Objects.requireNonNull(fromKey);
        Objects.requireNonNull(toKey);
        if (toKey.compareTo(fromKey) < 0) {
            throw new IllegalArgumentException("toKey < fromKey");
        }
        ArrayList<Interval<T>> result = new ArrayList<Interval<T>>();
        for (Map.Entry entry : this.intervals.subMap((Object)fromKey, true, (Object)toKey, true).entrySet()) {
            result.add(new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue()));
        }
        return result;
    }

    public List<Interval<T>> getIntervalsBefore(T toKey) {
        Objects.requireNonNull(toKey);
        ArrayList<Interval<T>> result = new ArrayList<Interval<T>>();
        for (Map.Entry entry : this.intervals.headMap((Object)toKey, false).entrySet()) {
            result.add(new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue()));
        }
        return result;
    }

    public List<Interval<T>> getIntervalsFrom(T fromKey) {
        Objects.requireNonNull(fromKey);
        ArrayList<Interval<T>> result = new ArrayList<Interval<T>>();
        for (Map.Entry entry : this.intervals.tailMap((Object)fromKey, true).entrySet()) {
            result.add(new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue()));
        }
        return result;
    }

    public Iterator<Interval<T>> descendingIterator() {
        return new Iterator<Interval<T>>(){
            private final Iterator<Map.Entry<T, T>> entryIterator;
            {
                this.entryIterator = IntervalSet.this.intervals.descendingMap().entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }

            @Override
            public Interval<T> next() {
                Map.Entry entry = this.entryIterator.next();
                return new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue());
            }
        };
    }

    public NavigableSet<T> keySet() {
        return this.intervals.navigableKeySet();
    }

    public NavigableSet<T> descendingKeySet() {
        return this.intervals.descendingKeySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeIntervalsInKeyRange(T fromKey, T toKey) {
        Objects.requireNonNull(fromKey);
        Objects.requireNonNull(toKey);
        if (toKey.compareTo(fromKey) < 0) {
            throw new IllegalArgumentException("toKey < fromKey");
        }
        this.lock.lock();
        try {
            NavigableMap subMap = this.intervals.subMap((Object)fromKey, true, (Object)toKey, true);
            int count = subMap.size();
            subMap.clear();
            int n = count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        return this.intervals.size();
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public void clear() {
        this.lock.lock();
        try {
            this.intervals.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Interval<T>> snapshot() {
        this.lock.lock();
        try {
            ArrayList<Interval<Comparable>> result = new ArrayList<Interval<Comparable>>(this.intervals.size());
            for (Map.Entry<T, T> entry : this.intervals.entrySet()) {
                result.add(new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue()));
            }
            ArrayList<Interval<Comparable>> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Duration totalDuration() {
        return this.totalDuration(this::defaultToDuration);
    }

    private Duration defaultToDuration(T start, T end) {
        if (start instanceof Temporal && end instanceof Temporal) {
            return Duration.between((Temporal)start, (Temporal)end);
        }
        if (start instanceof Number && end instanceof Number) {
            long diff = ((Number)end).longValue() - ((Number)start).longValue();
            return Duration.ofNanos(diff);
        }
        if (start instanceof Date && end instanceof Date) {
            long startMillis = ((Date)start).getTime();
            long endMillis = ((Date)end).getTime();
            return Duration.ofMillis(endMillis - startMillis);
        }
        if (start instanceof Character && end instanceof Character) {
            int diff = ((Character)end).charValue() - ((Character)start).charValue();
            return Duration.ofNanos(diff);
        }
        if (start instanceof Duration && end instanceof Duration) {
            Duration startDuration = (Duration)start;
            Duration endDuration = (Duration)end;
            return endDuration.minus(startDuration);
        }
        throw new UnsupportedOperationException("No default duration mapping for type " + start.getClass());
    }

    public Duration totalDuration(BiFunction<T, T, Duration> toDuration) {
        Duration d = Duration.ZERO;
        for (Interval<T> interval : this) {
            d = d.plus(toDuration.apply(interval.getStart(), interval.getEnd()));
        }
        return d;
    }

    @Override
    public Iterator<Interval<T>> iterator() {
        return new Iterator<Interval<T>>(){
            private final Iterator<Map.Entry<T, T>> entryIterator;
            {
                this.entryIterator = IntervalSet.this.intervals.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }

            @Override
            public Interval<T> next() {
                Map.Entry entry = this.entryIterator.next();
                return new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue());
            }
        };
    }

    public IntervalSet<T> union(IntervalSet<T> other) {
        IntervalSet<T> result = new IntervalSet<T>(this);
        for (Interval<T> i : other) {
            result.add(i.getStart(), i.getEnd());
        }
        return result;
    }

    public IntervalSet<T> intersection(IntervalSet<T> other) {
        Interval<T> b;
        IntervalSet<T> result = new IntervalSet<T>();
        Iterator<Interval<T>> it1 = this.iterator();
        Iterator<Interval<T>> it2 = other.iterator();
        Interval<T> a = it1.hasNext() ? it1.next() : null;
        Interval<T> interval = b = it2.hasNext() ? it2.next() : null;
        while (a != null && b != null) {
            T minEnd;
            if (a.getEnd().compareTo(b.getStart()) <= 0) {
                a = it1.hasNext() ? it1.next() : null;
                continue;
            }
            if (b.getEnd().compareTo(a.getStart()) <= 0) {
                b = it2.hasNext() ? it2.next() : null;
                continue;
            }
            T maxStart = IntervalSet.greaterOf(a.getStart(), b.getStart());
            T t = minEnd = a.getEnd().compareTo(b.getEnd()) <= 0 ? a.getEnd() : b.getEnd();
            if (maxStart.compareTo(minEnd) < 0) {
                result.add(maxStart, minEnd);
            }
            if (a.getEnd().compareTo(b.getEnd()) <= 0) {
                a = it1.hasNext() ? it1.next() : null;
                continue;
            }
            b = it2.hasNext() ? it2.next() : null;
        }
        return result;
    }

    public IntervalSet<T> difference(IntervalSet<T> other) {
        IntervalSet<T> result = new IntervalSet<T>(this);
        for (Interval<T> interval : other) {
            result.removeRange(interval.getStart(), interval.getEnd());
        }
        return result;
    }

    public boolean intersects(IntervalSet<T> other) {
        Interval<T> b;
        Iterator<Interval<T>> it1 = this.iterator();
        Iterator<Interval<T>> it2 = other.iterator();
        Interval<T> a = it1.hasNext() ? it1.next() : null;
        Interval<T> interval = b = it2.hasNext() ? it2.next() : null;
        while (a != null && b != null) {
            if (a.getEnd().compareTo(b.getStart()) <= 0) {
                a = it1.hasNext() ? it1.next() : null;
                continue;
            }
            if (b.getEnd().compareTo(a.getStart()) <= 0) {
                b = it2.hasNext() ? it2.next() : null;
                continue;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalSet that = (IntervalSet)o;
        Iterator<Interval<T>> thisIt = this.iterator();
        Iterator<Interval<T>> thatIt = that.iterator();
        while (thisIt.hasNext() && thatIt.hasNext()) {
            if (thisIt.next().equals(thatIt.next())) continue;
            return false;
        }
        return !thisIt.hasNext() && !thatIt.hasNext();
    }

    public int hashCode() {
        int hash = 1;
        for (Interval<T> interval : this) {
            hash = 31 * hash + interval.hashCode();
        }
        return EncryptionUtilities.finalizeHash(hash);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Interval<T> i : this) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("[").append(i.getStart()).append("-").append(i.getEnd()).append(")");
            first = false;
        }
        sb.append("}");
        return sb.toString();
    }

    private static <T extends Comparable<? super T>> T greaterOf(T a, T b) {
        return a.compareTo(b) >= 0 ? a : b;
    }

    public static final class Interval<T extends Comparable<? super T>>
    implements Comparable<Interval<T>> {
        private final T start;
        private final T end;

        Interval(T start, T end) {
            this.start = start;
            this.end = end;
        }

        public T getStart() {
            return this.start;
        }

        public T getEnd() {
            return this.end;
        }

        public int hashCode() {
            return EncryptionUtilities.finalizeHash(Objects.hash(this.start, this.end));
        }

        public boolean equals(Object o) {
            return o instanceof Interval && this.start.equals(((Interval)o).start) && this.end.equals(((Interval)o).end);
        }

        public String toString() {
            return "[" + this.start + " \u2013 " + this.end + ")";
        }

        @Override
        public int compareTo(Interval<T> o) {
            int cmp = this.start.compareTo(o.start);
            return cmp != 0 ? cmp : this.end.compareTo(o.end);
        }
    }
}

