/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;

public class SqlDateConversions {
    static long toLong(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        return sqlDate.toLocalDate().atStartOfDay(converter.getOptions().getZoneId()).toInstant().toEpochMilli();
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        return new AtomicLong(sqlDate.toLocalDate().atStartOfDay(converter.getOptions().getZoneId()).toInstant().toEpochMilli());
    }

    static double toDouble(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        return (double)sqlDate.toLocalDate().atStartOfDay(converter.getOptions().getZoneId()).toInstant().toEpochMilli() / 1000.0;
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        return BigInteger.valueOf(sqlDate.toLocalDate().atStartOfDay(converter.getOptions().getZoneId()).toInstant().toEpochMilli());
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        ZoneId zone = converter.getOptions().getZoneId();
        Instant instant = sqlDate.toLocalDate().atStartOfDay(zone).toInstant();
        BigDecimal seconds = BigDecimal.valueOf(instant.toEpochMilli()).divide(BigDecimal.valueOf(1000L), 9, RoundingMode.DOWN).stripTrailingZeros();
        return new BigDecimal(seconds.toPlainString());
    }

    static Instant toInstant(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        return sqlDate.toLocalDate().atStartOfDay(converter.getOptions().getZoneId()).toInstant();
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        return sqlDate.toLocalDate().atStartOfDay(converter.getOptions().getZoneId()).toLocalDateTime();
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        return sqlDate.toLocalDate().atStartOfDay(converter.getOptions().getZoneId()).toOffsetDateTime();
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        return sqlDate.toLocalDate().atStartOfDay(converter.getOptions().getZoneId());
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        return sqlDate.toLocalDate();
    }

    static java.sql.Date toSqlDate(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        return java.sql.Date.valueOf(sqlDate.toLocalDate());
    }

    static Date toDate(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        return Date.from(sqlDate.toLocalDate().atStartOfDay(converter.getOptions().getZoneId()).toInstant());
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        return Timestamp.from(sqlDate.toLocalDate().atStartOfDay(converter.getOptions().getZoneId()).toInstant());
    }

    static Calendar toCalendar(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        ZonedDateTime zdt = sqlDate.toLocalDate().atStartOfDay(converter.getOptions().getZoneId());
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(converter.getOptions().getZoneId()));
        cal.setTimeInMillis(zdt.toInstant().toEpochMilli());
        return cal;
    }

    static YearMonth toYearMonth(Object from, Converter converter) {
        return YearMonth.from(((java.sql.Date)from).toLocalDate());
    }

    static Year toYear(Object from, Converter converter) {
        return Year.from(((java.sql.Date)from).toLocalDate());
    }

    static MonthDay toMonthDay(Object from, Converter converter) {
        return MonthDay.from(((java.sql.Date)from).toLocalDate());
    }

    static String toString(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        return sqlDate.toString();
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        java.sql.Date date = (java.sql.Date)from;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("sqlDate", SqlDateConversions.toString(date, converter));
        return map;
    }
}

