/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;

final class PathConversions {
    private PathConversions() {
    }

    static String toString(Object from, Converter converter) {
        Path path = (Path)from;
        return path.toString();
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        Path path = (Path)from;
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("path", path.toString());
        return target;
    }

    static URI toURI(Object from, Converter converter) {
        Path path = (Path)from;
        return path.toUri();
    }

    static URL toURL(Object from, Converter converter) {
        Path path = (Path)from;
        try {
            return path.toUri().toURL();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to convert Path to URL, input Path: " + path, e);
        }
    }

    static File toFile(Object from, Converter converter) {
        Path path = (Path)from;
        return path.toFile();
    }

    static char[] toCharArray(Object from, Converter converter) {
        Path path = (Path)from;
        return path.toString().toCharArray();
    }

    static byte[] toByteArray(Object from, Converter converter) {
        Path path = (Path)from;
        return path.toString().getBytes(StandardCharsets.UTF_8);
    }
}

