/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.ConcurrentHashMapNullSafe;
import com.cedarsoftware.util.ConcurrentNavigableMapNullSafe;
import com.cedarsoftware.util.LoggingConfig;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.SystemUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import java.util.regex.Pattern;

final class MapConversions {
    private static final Logger LOG = Logger.getLogger(MapConversions.class.getName());
    static final String V = "_v";
    static final String VALUE = "value";
    static final String DATE = "date";
    static final String SQL_DATE = "sqlDate";
    static final String CALENDAR = "calendar";
    static final String TIMESTAMP = "timestamp";
    static final String DURATION = "duration";
    static final String INSTANT = "instant";
    static final String LOCALE = "locale";
    static final String MONTH_DAY = "monthDay";
    static final String YEAR_MONTH = "yearMonth";
    static final String PERIOD = "period";
    static final String ZONE_OFFSET = "zoneOffset";
    static final String LOCAL_DATE = "localDate";
    static final String LOCAL_TIME = "localTime";
    static final String LOCAL_DATE_TIME = "localDateTime";
    static final String OFFSET_TIME = "offsetTime";
    static final String OFFSET_DATE_TIME = "offsetDateTime";
    static final String ZONED_DATE_TIME = "zonedDateTime";
    static final String ZONE = "zone";
    static final String YEAR = "year";
    static final String EPOCH_MILLIS = "epochMillis";
    static final String MOST_SIG_BITS = "mostSigBits";
    static final String LEAST_SIG_BITS = "leastSigBits";
    static final String ID = "id";
    static final String URI_KEY = "URI";
    static final String URL_KEY = "URL";
    static final String FILE_KEY = "file";
    static final String PATH_KEY = "path";
    static final String UUID = "UUID";
    static final String CLASS = "class";
    static final String MESSAGE = "message";
    static final String DETAIL_MESSAGE = "detailMessage";
    static final String CAUSE = "cause";
    static final String CAUSE_MESSAGE = "causeMessage";
    static final String RED = "red";
    static final String GREEN = "green";
    static final String BLUE = "blue";
    static final String ALPHA = "alpha";
    static final String RGB = "rgb";
    static final String COLOR = "color";
    static final String R = "r";
    static final String G = "g";
    static final String B = "b";
    static final String A = "a";
    static final String WIDTH = "width";
    static final String HEIGHT = "height";
    static final String W = "w";
    static final String H = "h";
    static final String X = "x";
    static final String Y = "y";
    static final String TOP = "top";
    static final String LEFT = "left";
    static final String BOTTOM = "bottom";
    static final String RIGHT = "right";
    private static final Object NO_MATCH;
    private static final String[] VALUE_KEYS;
    private static final String[] SQL_DATE_KEYS;
    private static final String[] DATE_KEYS;
    private static final String[] TIMESTAMP_KEYS;
    private static final String[] ZONE_KEYS;
    private static final String[] CALENDAR_KEYS;
    private static final String[] LOCALE_KEYS;
    private static final String[] LOCAL_DATE_KEYS;
    private static final String[] LOCAL_TIME_KEYS;
    private static final String[] LDT_KEYS;
    private static final String[] OFFSET_TIME_KEYS;
    private static final String[] OFFSET_KEYS;
    private static final String[] ZDT_KEYS;
    private static final String[] CLASS_KEYS;
    private static final String[] DURATION_KEYS;
    private static final String[] INSTANT_KEYS;
    private static final String[] MONTH_DAY_KEYS;
    private static final String[] YEAR_MONTH_KEYS;
    private static final String[] PERIOD_KEYS;
    private static final String[] ZONE_OFFSET_KEYS;
    private static final String[] YEAR_KEYS;
    private static final String[] URL_KEYS;
    private static final String[] URI_KEYS;
    private static final String[] COLOR_KEYS;
    private static final String[] DIMENSION_KEYS;
    private static final String[] POINT_KEYS;
    private static final String[] RECTANGLE_KEYS;
    private static final String[] INSETS_KEYS;
    private static final String[] FILE_KEYS;
    private static final String[] PATH_KEYS;

    private MapConversions() {
    }

    private static <T> T dispatch(Object from, Converter converter, Class<T> clazz, String[] keys) {
        Object value = MapConversions.getValue((Map)from, keys);
        if (value != NO_MATCH) {
            return converter.convert(value, clazz);
        }
        return MapConversions.fromMap(clazz, keys);
    }

    static Object toUUID(Object from, Converter converter) {
        Map map = (Map)from;
        Object mostSigBits = map.get(MOST_SIG_BITS);
        Object leastSigBits = map.get(LEAST_SIG_BITS);
        if (mostSigBits != null && leastSigBits != null) {
            long most = converter.convert(mostSigBits, Long.TYPE);
            long least = converter.convert(leastSigBits, Long.TYPE);
            return new UUID(most, least);
        }
        return MapConversions.dispatch(from, converter, UUID.class, new String[]{UUID, VALUE, V, "mostSigBits, leastSigBits"});
    }

    static Byte toByte(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Byte.class, VALUE_KEYS);
    }

    static Short toShort(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Short.class, VALUE_KEYS);
    }

    static Integer toInt(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Integer.class, VALUE_KEYS);
    }

    static Long toLong(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Long.class, VALUE_KEYS);
    }

    static Float toFloat(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Float.class, VALUE_KEYS);
    }

    static Double toDouble(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Double.class, VALUE_KEYS);
    }

    static Boolean toBoolean(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Boolean.class, VALUE_KEYS);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, BigDecimal.class, VALUE_KEYS);
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, BigInteger.class, VALUE_KEYS);
    }

    static String toString(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, String.class, VALUE_KEYS);
    }

    static StringBuffer toStringBuffer(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, StringBuffer.class, VALUE_KEYS);
    }

    static StringBuilder toStringBuilder(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, StringBuilder.class, VALUE_KEYS);
    }

    static Character toCharacter(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Character.TYPE, VALUE_KEYS);
    }

    static AtomicInteger toAtomicInteger(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, AtomicInteger.class, VALUE_KEYS);
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, AtomicLong.class, VALUE_KEYS);
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, AtomicBoolean.class, VALUE_KEYS);
    }

    static Pattern toPattern(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Pattern.class, VALUE_KEYS);
    }

    static Currency toCurrency(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Currency.class, VALUE_KEYS);
    }

    static Date toSqlDate(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Date.class, SQL_DATE_KEYS);
    }

    static java.util.Date toDate(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, java.util.Date.class, DATE_KEYS);
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Timestamp.class, TIMESTAMP_KEYS);
    }

    static TimeZone toTimeZone(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, TimeZone.class, ZONE_KEYS);
    }

    static Calendar toCalendar(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Calendar.class, CALENDAR_KEYS);
    }

    static Locale toLocale(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Locale.class, LOCALE_KEYS);
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, LocalDate.class, LOCAL_DATE_KEYS);
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, LocalTime.class, LOCAL_TIME_KEYS);
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, LocalDateTime.class, LDT_KEYS);
    }

    static OffsetTime toOffsetTime(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, OffsetTime.class, OFFSET_TIME_KEYS);
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, OffsetDateTime.class, OFFSET_KEYS);
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, ZonedDateTime.class, ZDT_KEYS);
    }

    static Class<?> toClass(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Class.class, CLASS_KEYS);
    }

    static Duration toDuration(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Duration.class, DURATION_KEYS);
    }

    static Instant toInstant(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Instant.class, INSTANT_KEYS);
    }

    static MonthDay toMonthDay(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, MonthDay.class, MONTH_DAY_KEYS);
    }

    static YearMonth toYearMonth(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, YearMonth.class, YEAR_MONTH_KEYS);
    }

    static Period toPeriod(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Period.class, PERIOD_KEYS);
    }

    static ZoneId toZoneId(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, ZoneId.class, ZONE_KEYS);
    }

    static ZoneOffset toZoneOffset(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, ZoneOffset.class, ZONE_OFFSET_KEYS);
    }

    static Year toYear(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Year.class, YEAR_KEYS);
    }

    static URL toURL(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, URL.class, URL_KEYS);
    }

    static URI toURI(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, URI.class, URI_KEYS);
    }

    static ByteBuffer toByteBuffer(Object from, Converter converter) {
        Object valueObj;
        Map map = (Map)from;
        Object v = valueObj = map.containsKey(VALUE) ? map.get(VALUE) : map.get(V);
        if (valueObj == null) {
            throw new IllegalArgumentException("Unable to convert map to ByteBuffer: Missing or null 'value' or '_v' field");
        }
        if (!(valueObj instanceof String)) {
            throw new IllegalArgumentException("Unable to convert map to ByteBuffer: Value must be a Base64-encoded String, found: " + valueObj.getClass().getName());
        }
        String base64 = (String)valueObj;
        try {
            byte[] decoded = Base64.getDecoder().decode(base64);
            return ByteBuffer.wrap(decoded);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to convert map to ByteBuffer: Invalid Base64 encoding", e);
        }
    }

    static CharBuffer toCharBuffer(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, CharBuffer.class, VALUE_KEYS);
    }

    static Throwable toThrowable(Object from, Converter converter, Class<?> target) {
        if (from == null) {
            return null;
        }
        Map map = (Map)from;
        if (map.isEmpty()) {
            return null;
        }
        try {
            Class<?> specifiedClass;
            LinkedHashMap<String, Object> namedParams = new LinkedHashMap<String, Object>(map);
            Object causeValue = namedParams.get(CAUSE);
            if (causeValue instanceof String) {
                Class<?> causeClass;
                String causeClassName = (String)causeValue;
                String causeMessage = (String)namedParams.get(CAUSE_MESSAGE);
                if (StringUtilities.hasContent(causeClassName) && (causeClass = ClassUtilities.forName(causeClassName, ClassUtilities.getClassLoader(MapConversions.class))) != null) {
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                    if (causeMessage != null) {
                        linkedHashMap.put(MESSAGE, causeMessage);
                    }
                    Throwable cause = (Throwable)ClassUtilities.newInstance(converter, causeClass, linkedHashMap);
                    namedParams.put(CAUSE, cause);
                }
                namedParams.remove(CAUSE_MESSAGE);
            } else if (causeValue instanceof Map) {
                Class<?> clazz;
                Map causeMap = (Map)causeValue;
                Class causeType = Throwable.class;
                Object causeClassName = (String)causeMap.get("@type");
                if (causeClassName == null) {
                    causeClassName = (String)causeMap.get(CLASS);
                }
                if (StringUtilities.hasContent((String)causeClassName) && (clazz = ClassUtilities.forName((String)causeClassName, ClassUtilities.getClassLoader(MapConversions.class))) != null && Throwable.class.isAssignableFrom(clazz)) {
                    causeType = clazz;
                }
                Throwable throwable = MapConversions.toThrowable(causeMap, converter, causeType);
                namedParams.put(CAUSE, throwable);
            }
            MapConversions.addThrowableAliases(namedParams);
            namedParams.remove(DETAIL_MESSAGE);
            namedParams.remove("suppressed");
            namedParams.remove("stackTrace");
            if (!namedParams.isEmpty() && (namedParams.containsKey("msg") || namedParams.containsKey(MESSAGE))) {
                LinkedHashMap orderedParams = new LinkedHashMap();
                Object messageValue = namedParams.get("msg");
                if (messageValue == null) {
                    messageValue = namedParams.get(MESSAGE);
                }
                if (messageValue != null) {
                    orderedParams.put("msg", messageValue);
                    orderedParams.put(MESSAGE, messageValue);
                }
                for (Map.Entry entry : namedParams.entrySet()) {
                    if (((String)entry.getKey()).equals("msg") || ((String)entry.getKey()).equals(MESSAGE) || ((String)entry.getKey()).equals("s")) continue;
                    orderedParams.put((String)entry.getKey(), entry.getValue());
                }
                namedParams = orderedParams;
            }
            Class<?> classToUse = target;
            String className = (String)namedParams.get(CLASS);
            if (StringUtilities.hasContent(className) && (specifiedClass = ClassUtilities.forName(className, ClassUtilities.getClassLoader(MapConversions.class))) != null && target.isAssignableFrom(specifiedClass)) {
                classToUse = specifiedClass;
            }
            namedParams.remove(CLASS);
            Throwable exception = (Throwable)ClassUtilities.newInstance(converter, classToUse, namedParams);
            exception.setStackTrace(new StackTraceElement[0]);
            return exception;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create " + target.getName() + " from map: " + map, e);
        }
    }

    private static void addThrowableAliases(Map<String, Object> namedParams) {
        Object causeValue;
        Object messageValue;
        String[] messageFields;
        for (String field : messageFields = new String[]{DETAIL_MESSAGE, MESSAGE, "msg"}) {
            if (!namedParams.containsKey(field) || namedParams.get(field) != null) continue;
            namedParams.put(field, "");
        }
        if (!namedParams.containsKey("msg")) {
            messageValue = null;
            if (namedParams.containsKey(DETAIL_MESSAGE)) {
                messageValue = namedParams.get(DETAIL_MESSAGE);
            } else if (namedParams.containsKey(MESSAGE)) {
                messageValue = namedParams.get(MESSAGE);
            } else if (namedParams.containsKey("reason")) {
                messageValue = namedParams.get("reason");
            } else if (namedParams.containsKey("description")) {
                messageValue = namedParams.get("description");
            }
            if (messageValue != null) {
                namedParams.put("msg", messageValue);
            }
        }
        if (!namedParams.containsKey(MESSAGE)) {
            messageValue = null;
            if (namedParams.containsKey(DETAIL_MESSAGE)) {
                messageValue = namedParams.get(DETAIL_MESSAGE);
            } else if (namedParams.containsKey("msg")) {
                messageValue = namedParams.get("msg");
            }
            if (messageValue != null) {
                namedParams.put(MESSAGE, messageValue);
            }
        }
        if (!namedParams.containsKey("s")) {
            messageValue = namedParams.get(MESSAGE);
            if (messageValue == null) {
                messageValue = namedParams.get("msg");
            }
            if (messageValue == null) {
                messageValue = namedParams.get(DETAIL_MESSAGE);
            }
            if (messageValue != null) {
                namedParams.put("s", messageValue);
            }
        }
        if ((causeValue = namedParams.get(CAUSE)) != null) {
            if (!namedParams.containsKey("rootCause")) {
                namedParams.put("rootCause", causeValue);
            }
            if (!namedParams.containsKey("throwable")) {
                namedParams.put("throwable", causeValue);
            }
            if (!namedParams.containsKey("t")) {
                namedParams.put("t", causeValue);
            }
        }
        if (namedParams.containsKey("suppressionEnabled") && !namedParams.containsKey("enableSuppression")) {
            namedParams.put("enableSuppression", namedParams.get("suppressionEnabled"));
        }
        if (namedParams.containsKey("stackTraceWritable") && !namedParams.containsKey("writableStackTrace")) {
            namedParams.put("writableStackTrace", namedParams.get("stackTraceWritable"));
        }
    }

    static Map<String, Object> recordToMap(Object from, Converter converter) {
        if (!MapConversions.isRecord(from.getClass())) {
            throw new IllegalArgumentException("Expected Record instance, got: " + from.getClass().getName());
        }
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        try {
            Object[] components;
            for (Object component : components = MapConversions.getRecordComponents(from.getClass())) {
                String name = MapConversions.getRecordComponentName(component);
                Object accessor = MapConversions.getRecordComponentAccessor(component);
                Object value = ReflectionUtils.call(from, (Method)accessor, new Object[0]);
                target.put(name, value);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to convert Record to Map: " + from.getClass().getName(), e);
        }
        return target;
    }

    static boolean isRecord(Class<?> clazz) {
        if (!SystemUtilities.isJavaVersionAtLeast(14, 0)) {
            return false;
        }
        try {
            Method isRecord = ReflectionUtils.getMethod(Class.class, "isRecord", new Class[0]);
            if (isRecord != null) {
                return (Boolean)ReflectionUtils.call(clazz, isRecord, new Object[0]);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Object[] getRecordComponents(Class<?> recordClass) {
        try {
            Method getRecordComponents = ReflectionUtils.getMethod(Class.class, "getRecordComponents", new Class[0]);
            if (getRecordComponents != null) {
                return (Object[])ReflectionUtils.call(recordClass, getRecordComponents, new Object[0]);
            }
            throw new IllegalArgumentException("Records not supported in this JVM version");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a record class or Records not supported: " + recordClass.getName(), e);
        }
    }

    private static String getRecordComponentName(Object component) {
        try {
            Method getName = ReflectionUtils.getMethod(component.getClass(), "getName", new Class[0]);
            if (getName != null) {
                return (String)ReflectionUtils.call(component, getName, new Object[0]);
            }
            throw new IllegalArgumentException("Cannot get component name");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to get record component name", e);
        }
    }

    private static Object getRecordComponentAccessor(Object component) {
        try {
            Method getAccessor = ReflectionUtils.getMethod(component.getClass(), "getAccessor", new Class[0]);
            if (getAccessor != null) {
                return ReflectionUtils.call(component, getAccessor, new Object[0]);
            }
            throw new IllegalArgumentException("Cannot get component accessor");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to get record component accessor", e);
        }
    }

    static Map<String, ?> initMap(Object from, Converter converter) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(V, from);
        return map;
    }

    static Map<?, ?> mapToMapWithTarget(Object from, Converter converter, Class<?> toType) {
        if (from == null) {
            return null;
        }
        if (!(from instanceof Map)) {
            throw new IllegalArgumentException("Expected Map instance, got: " + from.getClass().getName());
        }
        Map sourceMap = (Map)from;
        SourceCharacteristics source = MapConversions.analyzeSource(sourceMap);
        TargetCharacteristics target = MapConversions.analyzeTarget(toType);
        return MapConversions.routeConversion(sourceMap, source, target, converter);
    }

    private static SourceCharacteristics analyzeSource(Map<?, ?> sourceMap) {
        SourceCharacteristics source = new SourceCharacteristics();
        source.size = sourceMap.size();
        source.isSortedMap = sourceMap instanceof SortedMap;
        if (source.isSortedMap) {
            source.comparator = ((SortedMap)sourceMap).comparator();
        }
        return source;
    }

    private static TargetCharacteristics analyzeTarget(Class<?> toType) {
        TargetCharacteristics target = new TargetCharacteristics();
        target.toType = toType;
        if (toType == null) {
            target.isGenericMap = true;
            return target;
        }
        String typeName = toType.getName();
        target.isEmptyMap = typeName.endsWith("$EmptyMap");
        target.isSingletonMap = typeName.endsWith("$SingletonMap");
        target.isUnmodifiableMap = typeName.endsWith("$UnmodifiableMap");
        target.isSynchronizedMap = typeName.endsWith("$SynchronizedMap");
        target.isCheckedMap = typeName.endsWith("$CheckedMap");
        target.isConcurrentMapInterface = toType.getName().equals("java.util.concurrent.ConcurrentMap");
        target.isConcurrentNavigableMapInterface = toType.getName().equals("java.util.concurrent.ConcurrentNavigableMap");
        target.isGenericMap = toType == Map.class;
        target.isTreeMap = toType == TreeMap.class;
        target.isConcurrentSkipListMap = toType == ConcurrentSkipListMap.class;
        target.isConcurrentHashMap = toType == ConcurrentHashMap.class;
        return target;
    }

    private static Map<?, ?> routeConversion(Map<?, ?> sourceMap, SourceCharacteristics source, TargetCharacteristics target, Converter converter) {
        if (target.isEmptyMap) {
            return Collections.emptyMap();
        }
        if (target.isSingletonMap) {
            if (source.size == 1) {
                Map.Entry<?, ?> entry = sourceMap.entrySet().iterator().next();
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
            throw new IllegalArgumentException("Cannot convert Map with " + source.size + " entries to SingletonMap (requires exactly 1 entry)");
        }
        if (target.isUnmodifiableMap) {
            LinkedHashMap<Object, Object> mutableCopy = new LinkedHashMap<Object, Object>();
            MapConversions.copyEntries(sourceMap, mutableCopy, false, false);
            return Collections.unmodifiableMap(mutableCopy);
        }
        if (target.isSynchronizedMap) {
            LinkedHashMap<Object, Object> mutableCopy = new LinkedHashMap<Object, Object>();
            MapConversions.copyEntries(sourceMap, mutableCopy, false, false);
            return Collections.synchronizedMap(mutableCopy);
        }
        if (target.isCheckedMap) {
            LinkedHashMap<Object, Object> mutableCopy = new LinkedHashMap<Object, Object>();
            MapConversions.copyEntries(sourceMap, mutableCopy, false, false);
            return Collections.checkedMap(mutableCopy, Object.class, Object.class);
        }
        if (target.isConcurrentMapInterface) {
            ConcurrentHashMapNullSafe<Object, Object> result = new ConcurrentHashMapNullSafe<Object, Object>();
            MapConversions.copyEntries(sourceMap, result, false, false);
            return result;
        }
        if (target.isConcurrentNavigableMapInterface) {
            ConcurrentNavigableMapNullSafe<Object, Object> result = new ConcurrentNavigableMapNullSafe<Object, Object>();
            MapConversions.copyEntries(sourceMap, result, false, false);
            return result;
        }
        if (target.isGenericMap) {
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
            MapConversions.copyEntries(sourceMap, result, false, false);
            return result;
        }
        if (target.isTreeMap && source.isSortedMap && source.comparator != null) {
            TreeMap<Object, Object> result = new TreeMap<Object, Object>(source.comparator);
            MapConversions.copyEntries(sourceMap, result, true, false);
            return result;
        }
        if (target.isConcurrentSkipListMap && source.isSortedMap && source.comparator != null) {
            ConcurrentSkipListMap<Object, Object> result = new ConcurrentSkipListMap<Object, Object>(source.comparator);
            MapConversions.copyEntries(sourceMap, result, true, true);
            return result;
        }
        try {
            Map result = sourceMap.size() > 0 && MapConversions.hasIntConstructor(target.toType) ? (Map)ClassUtilities.newInstance(target.toType, sourceMap.size()) : (Map)ClassUtilities.newInstance(target.toType, null);
            boolean skipNullKeys = target.isConcurrentHashMap || target.isConcurrentSkipListMap || target.isTreeMap;
            boolean skipNullValues = target.isConcurrentHashMap || target.isConcurrentSkipListMap;
            MapConversions.copyEntries(sourceMap, result, skipNullKeys, skipNullValues);
            return result;
        }
        catch (Exception e) {
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
            MapConversions.copyEntries(sourceMap, result, false, false);
            return result;
        }
    }

    private static boolean hasIntConstructor(Class<?> targetType) {
        try {
            return ReflectionUtils.getConstructor(targetType, Integer.TYPE) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void copyEntries(Map<?, ?> source, Map<Object, Object> target, boolean skipNullKeys, boolean skipNullValues) {
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (skipNullKeys && key == null || skipNullValues && value == null) continue;
            try {
                target.put(key, value);
            }
            catch (Exception e) {}
        }
    }

    private static <T> T fromMap(Class<T> type, String[] keys) {
        StringBuilder builder = new StringBuilder();
        builder.append("To convert from Map to '").append(Converter.getShortName(type)).append("' the map must include: ");
        builder.append(MapConversions.formatKeys(keys));
        builder.append(" as key with associated value.");
        throw new IllegalArgumentException(builder.toString());
    }

    private static String formatKeys(String[] keys) {
        if (keys == null || keys.length == 0) {
            return "";
        }
        if (keys.length == 1) {
            return "[" + keys[0] + "]";
        }
        if (keys.length == 2) {
            return "[" + keys[0] + "] or [" + keys[1] + "]";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                if (i == keys.length - 1) {
                    sb.append(", or ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("[").append(keys[i]).append("]");
        }
        return sb.toString();
    }

    private static Object getValue(Map<String, Object> map, String[] keys) {
        String hadKey = null;
        for (String key : keys) {
            Object value = map.get(key);
            if (value != null && (!(value instanceof String) || StringUtilities.hasContent((String)value))) {
                return value;
            }
            if (!map.containsKey(key)) continue;
            hadKey = key;
        }
        if (hadKey != null) {
            return map.get(hadKey);
        }
        return NO_MATCH;
    }

    static Color toColor(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(RED) && map.containsKey(GREEN) && map.containsKey(BLUE)) {
            int r = converter.convert(map.get(RED), Integer.TYPE);
            int g = converter.convert(map.get(GREEN), Integer.TYPE);
            int b = converter.convert(map.get(BLUE), Integer.TYPE);
            if (map.containsKey(ALPHA)) {
                int a = converter.convert(map.get(ALPHA), Integer.TYPE);
                return new Color(r, g, b, a);
            }
            return new Color(r, g, b);
        }
        if (map.containsKey(R) && map.containsKey(G) && map.containsKey(B)) {
            int r = converter.convert(map.get(R), Integer.TYPE);
            int g = converter.convert(map.get(G), Integer.TYPE);
            int b = converter.convert(map.get(B), Integer.TYPE);
            if (map.containsKey(A)) {
                int a = converter.convert(map.get(A), Integer.TYPE);
                return new Color(r, g, b, a);
            }
            return new Color(r, g, b);
        }
        if (map.containsKey(RGB)) {
            int rgb = converter.convert(map.get(RGB), Integer.class);
            return new Color(rgb, map.containsKey(ALPHA));
        }
        return MapConversions.dispatch(from, converter, Color.class, COLOR_KEYS);
    }

    static Dimension toDimension(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(WIDTH) && map.containsKey(HEIGHT)) {
            int w = converter.convert(map.get(WIDTH), Integer.TYPE);
            int h = converter.convert(map.get(HEIGHT), Integer.TYPE);
            return new Dimension(w, h);
        }
        if (map.containsKey(W) && map.containsKey(H)) {
            int w = converter.convert(map.get(W), Integer.TYPE);
            int h = converter.convert(map.get(H), Integer.TYPE);
            return new Dimension(w, h);
        }
        return MapConversions.dispatch(from, converter, Dimension.class, DIMENSION_KEYS);
    }

    static Point toPoint(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(X) && map.containsKey(Y)) {
            int x = converter.convert(map.get(X), Integer.TYPE);
            int y = converter.convert(map.get(Y), Integer.TYPE);
            return new Point(x, y);
        }
        return MapConversions.dispatch(from, converter, Point.class, POINT_KEYS);
    }

    static Rectangle toRectangle(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(X) && map.containsKey(Y) && map.containsKey(WIDTH) && map.containsKey(HEIGHT)) {
            int x = converter.convert(map.get(X), Integer.TYPE);
            int y = converter.convert(map.get(Y), Integer.TYPE);
            int width = converter.convert(map.get(WIDTH), Integer.TYPE);
            int height = converter.convert(map.get(HEIGHT), Integer.TYPE);
            return new Rectangle(x, y, width, height);
        }
        return MapConversions.dispatch(from, converter, Rectangle.class, RECTANGLE_KEYS);
    }

    static Insets toInsets(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(TOP) && map.containsKey(LEFT) && map.containsKey(BOTTOM) && map.containsKey(RIGHT)) {
            int top = converter.convert(map.get(TOP), Integer.TYPE);
            int left = converter.convert(map.get(LEFT), Integer.TYPE);
            int bottom = converter.convert(map.get(BOTTOM), Integer.TYPE);
            int right = converter.convert(map.get(RIGHT), Integer.TYPE);
            return new Insets(top, left, bottom, right);
        }
        return MapConversions.dispatch(from, converter, Insets.class, INSETS_KEYS);
    }

    static File toFile(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, File.class, FILE_KEYS);
    }

    static Path toPath(Object from, Converter converter) {
        return MapConversions.dispatch(from, converter, Path.class, PATH_KEYS);
    }

    static {
        LoggingConfig.init();
        NO_MATCH = new Object();
        VALUE_KEYS = new String[]{VALUE, V};
        SQL_DATE_KEYS = new String[]{SQL_DATE, VALUE, V, EPOCH_MILLIS};
        DATE_KEYS = new String[]{DATE, VALUE, V, EPOCH_MILLIS};
        TIMESTAMP_KEYS = new String[]{TIMESTAMP, VALUE, V, EPOCH_MILLIS};
        ZONE_KEYS = new String[]{ZONE, ID, VALUE, V};
        CALENDAR_KEYS = new String[]{CALENDAR, VALUE, V, EPOCH_MILLIS};
        LOCALE_KEYS = new String[]{LOCALE, VALUE, V};
        LOCAL_DATE_KEYS = new String[]{LOCAL_DATE, VALUE, V};
        LOCAL_TIME_KEYS = new String[]{LOCAL_TIME, VALUE, V};
        LDT_KEYS = new String[]{LOCAL_DATE_TIME, VALUE, V, EPOCH_MILLIS};
        OFFSET_TIME_KEYS = new String[]{OFFSET_TIME, VALUE, V};
        OFFSET_KEYS = new String[]{OFFSET_DATE_TIME, VALUE, V, EPOCH_MILLIS};
        ZDT_KEYS = new String[]{ZONED_DATE_TIME, VALUE, V, EPOCH_MILLIS};
        CLASS_KEYS = new String[]{CLASS, VALUE, V};
        DURATION_KEYS = new String[]{DURATION, VALUE, V};
        INSTANT_KEYS = new String[]{INSTANT, VALUE, V};
        MONTH_DAY_KEYS = new String[]{MONTH_DAY, VALUE, V};
        YEAR_MONTH_KEYS = new String[]{YEAR_MONTH, VALUE, V};
        PERIOD_KEYS = new String[]{PERIOD, VALUE, V};
        ZONE_OFFSET_KEYS = new String[]{ZONE_OFFSET, VALUE, V};
        YEAR_KEYS = new String[]{YEAR, VALUE, V};
        URL_KEYS = new String[]{URL_KEY, VALUE, V};
        URI_KEYS = new String[]{URI_KEY, VALUE, V};
        COLOR_KEYS = new String[]{COLOR, VALUE, V};
        DIMENSION_KEYS = new String[]{WIDTH, HEIGHT, VALUE, V};
        POINT_KEYS = new String[]{X, Y, VALUE, V};
        RECTANGLE_KEYS = new String[]{X, Y, WIDTH, HEIGHT, VALUE, V};
        INSETS_KEYS = new String[]{TOP, LEFT, BOTTOM, RIGHT, VALUE, V};
        FILE_KEYS = new String[]{FILE_KEY, VALUE, V};
        PATH_KEYS = new String[]{PATH_KEY, VALUE, V};
    }

    private static class SourceCharacteristics {
        int size;
        boolean isSortedMap;
        Comparator<Object> comparator;

        private SourceCharacteristics() {
        }
    }

    private static class TargetCharacteristics {
        Class<?> toType;
        boolean isEmptyMap;
        boolean isSingletonMap;
        boolean isUnmodifiableMap;
        boolean isSynchronizedMap;
        boolean isCheckedMap;
        boolean isConcurrentMapInterface;
        boolean isConcurrentNavigableMapInterface;
        boolean isGenericMap;
        boolean isTreeMap;
        boolean isConcurrentSkipListMap;
        boolean isConcurrentHashMap;

        private TargetCharacteristics() {
        }
    }
}

