/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class SafeSimpleDateFormat
extends DateFormat {
    private final String _format;
    private static final ThreadLocal<Map<String, SimpleDateFormat>> _dateFormats = ThreadLocal.withInitial(ConcurrentHashMap::new);

    public static SimpleDateFormat getDateFormat(String format) {
        Map<String, SimpleDateFormat> formatters = _dateFormats.get();
        return formatters.computeIfAbsent(format, SimpleDateFormat::new);
    }

    public SafeSimpleDateFormat(String format) {
        this._format = format;
        SimpleDateFormat dateFormat = SafeSimpleDateFormat.getDateFormat(this._format);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        dateFormat.setCalendar(cal);
        dateFormat.setLenient(cal.isLenient());
        dateFormat.setTimeZone(cal.getTimeZone());
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(false);
        dateFormat.setNumberFormat(numberFormat);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return SafeSimpleDateFormat.getDateFormat(this._format).format(date, toAppendTo, fieldPosition);
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        return SafeSimpleDateFormat.getDateFormat(this._format).parse(source, pos);
    }

    @Override
    public void setTimeZone(TimeZone tz) {
        SafeSimpleDateFormat.getDateFormat(this._format).setTimeZone(tz);
    }

    @Override
    public void setCalendar(Calendar cal) {
        SafeSimpleDateFormat.getDateFormat(this._format).setCalendar(cal);
    }

    @Override
    public void setNumberFormat(NumberFormat format) {
        SafeSimpleDateFormat.getDateFormat(this._format).setNumberFormat(format);
    }

    @Override
    public void setLenient(boolean lenient) {
        SafeSimpleDateFormat.getDateFormat(this._format).setLenient(lenient);
    }

    public void setDateFormatSymbols(DateFormatSymbols symbols) {
        SafeSimpleDateFormat.getDateFormat(this._format).setDateFormatSymbols(symbols);
    }

    public void set2DigitYearStart(Date date) {
        SafeSimpleDateFormat.getDateFormat(this._format).set2DigitYearStart(date);
    }

    public String toString() {
        return this._format;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SafeSimpleDateFormat) {
            SafeSimpleDateFormat that = (SafeSimpleDateFormat)other;
            return SafeSimpleDateFormat.getDateFormat(this._format).equals(SafeSimpleDateFormat.getDateFormat(that._format));
        }
        if (other instanceof SimpleDateFormat) {
            return SafeSimpleDateFormat.getDateFormat(this._format).equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return SafeSimpleDateFormat.getDateFormat(this._format).hashCode();
    }
}

