/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public final class ConcurrentList<E>
implements List<E>,
RandomAccess,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<E> list;
    private final transient ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public ConcurrentList() {
        this.list = new ArrayList();
    }

    public ConcurrentList(int size) {
        this.list = new ArrayList(size);
    }

    public ConcurrentList(List<E> list) {
        if (list == null) {
            throw new IllegalArgumentException("List cannot be null");
        }
        this.list = list;
    }

    @Override
    public boolean equals(Object other) {
        return this.withReadLock(() -> this.list.equals(other));
    }

    @Override
    public int hashCode() {
        return this.withReadLock(this.list::hashCode);
    }

    public String toString() {
        return this.withReadLock(this.list::toString);
    }

    @Override
    public int size() {
        return this.withReadLock(this.list::size);
    }

    @Override
    public boolean isEmpty() {
        return this.withReadLock(this.list::isEmpty);
    }

    @Override
    public boolean contains(Object o) {
        return this.withReadLock(() -> this.list.contains(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.withReadLock(() -> this.list.containsAll(c));
    }

    @Override
    public E get(int index) {
        return (E)this.withReadLock(() -> this.list.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.withReadLock(() -> this.list.indexOf(o));
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.withReadLock(() -> this.list.lastIndexOf(o));
    }

    @Override
    public Iterator<E> iterator() {
        return this.withReadLock(() -> new ArrayList<E>(this.list).iterator());
    }

    @Override
    public Object[] toArray() {
        return this.withReadLock(this.list::toArray);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.withReadLock(() -> this.list.toArray(a));
    }

    @Override
    public boolean add(E e) {
        return this.withWriteLock(() -> this.list.add(e));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.withWriteLock(() -> this.list.addAll(c));
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.withWriteLock(() -> this.list.addAll(index, c));
    }

    @Override
    public void add(int index, E element) {
        this.withWriteLockVoid(() -> this.list.add(index, element));
    }

    @Override
    public E set(int index, E element) {
        return (E)this.withWriteLock(() -> this.list.set(index, element));
    }

    @Override
    public E remove(int index) {
        return (E)this.withWriteLock(() -> this.list.remove(index));
    }

    @Override
    public boolean remove(Object o) {
        return this.withWriteLock(() -> this.list.remove(o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.withWriteLock(() -> this.list.removeAll(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.withWriteLock(() -> this.list.retainAll(c));
    }

    @Override
    public void clear() {
        this.withWriteLockVoid(() -> this.list.clear());
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.withReadLock(() -> new ArrayList<E>(this.list).listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.withReadLock(() -> new ArrayList<E>(this.list).listIterator(index));
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not implemented for ConcurrentList");
    }

    private <T> T withReadLock(Supplier<T> operation) {
        this.lock.readLock().lock();
        try {
            T t = operation.get();
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void withReadLockVoid(Runnable operation) {
        this.lock.readLock().lock();
        try {
            operation.run();
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private <T> T withWriteLock(Supplier<T> operation) {
        this.lock.writeLock().lock();
        try {
            T t = operation.get();
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void withWriteLockVoid(Runnable operation) {
        this.lock.writeLock().lock();
        try {
            operation.run();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

