/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;

public final class MathUtilities {
    public static final BigInteger BIG_INT_LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger BIG_INT_LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigDecimal BIG_DEC_DOUBLE_MIN = BigDecimal.valueOf(-1.7976931348623157E308);
    public static final BigDecimal BIG_DEC_DOUBLE_MAX = BigDecimal.valueOf(Double.MAX_VALUE);

    private MathUtilities() {
    }

    public static long minimum(long ... values) {
        int len = values.length;
        long current = values[0];
        for (int i = 1; i < len; ++i) {
            current = Math.min(values[i], current);
        }
        return current;
    }

    public static long maximum(long ... values) {
        int len = values.length;
        long current = values[0];
        for (int i = 1; i < len; ++i) {
            current = Math.max(values[i], current);
        }
        return current;
    }

    public static double minimum(double ... values) {
        int len = values.length;
        double current = values[0];
        for (int i = 1; i < len; ++i) {
            current = Math.min(values[i], current);
        }
        return current;
    }

    public static double maximum(double ... values) {
        int len = values.length;
        double current = values[0];
        for (int i = 1; i < len; ++i) {
            current = Math.max(values[i], current);
        }
        return current;
    }

    public static BigInteger minimum(BigInteger ... values) {
        int len = values.length;
        if (len == 1) {
            if (values[0] == null) {
                throw new IllegalArgumentException("Cannot passed null BigInteger entry to minimum()");
            }
            return values[0];
        }
        BigInteger current = values[0];
        for (int i = 1; i < len; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("Cannot passed null BigInteger entry to minimum()");
            }
            current = values[i].min(current);
        }
        return current;
    }

    public static BigInteger maximum(BigInteger ... values) {
        int len = values.length;
        if (len == 1) {
            if (values[0] == null) {
                throw new IllegalArgumentException("Cannot passed null BigInteger entry to maximum()");
            }
            return values[0];
        }
        BigInteger current = values[0];
        for (int i = 1; i < len; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("Cannot passed null BigInteger entry to maximum()");
            }
            current = values[i].max(current);
        }
        return current;
    }

    public static BigDecimal minimum(BigDecimal ... values) {
        int len = values.length;
        if (len == 1) {
            if (values[0] == null) {
                throw new IllegalArgumentException("Cannot passed null BigDecimal entry to minimum()");
            }
            return values[0];
        }
        BigDecimal current = values[0];
        for (int i = 1; i < len; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("Cannot passed null BigDecimal entry to minimum()");
            }
            current = values[i].min(current);
        }
        return current;
    }

    public static BigDecimal maximum(BigDecimal ... values) {
        int len = values.length;
        if (len == 1) {
            if (values[0] == null) {
                throw new IllegalArgumentException("Cannot pass null BigDecimal entry to maximum()");
            }
            return values[0];
        }
        BigDecimal current = values[0];
        for (int i = 1; i < len; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("Cannot pass null BigDecimal entry to maximum()");
            }
            current = values[i].max(current);
        }
        return current;
    }

    public static Number parseToMinimalNumericType(String numStr) {
        boolean negative = numStr.startsWith("-");
        boolean hasSign = negative || numStr.startsWith("+");
        String digits = hasSign ? numStr.substring(1) : numStr;
        if ((digits = digits.replaceFirst("^0+", "")).isEmpty()) {
            digits = "0";
        }
        numStr = (negative ? "-" : (hasSign ? "+" : "")) + digits;
        boolean hasDecimalPoint = false;
        boolean hasExponent = false;
        int mantissaSize = 0;
        StringBuilder exponentValue = new StringBuilder();
        int len = numStr.length();
        for (int i = 0; i < len; ++i) {
            char c = numStr.charAt(i);
            if (c == '.') {
                hasDecimalPoint = true;
                continue;
            }
            if (c == 'e' || c == 'E') {
                hasExponent = true;
                continue;
            }
            if (c < '0' || c > '9') continue;
            if (!hasExponent) {
                ++mantissaSize;
                continue;
            }
            exponentValue.append(c);
        }
        if (hasDecimalPoint || hasExponent) {
            if (mantissaSize < 17 && (exponentValue.length() == 0 || Math.abs(Integer.parseInt(exponentValue.toString())) < 308)) {
                return Double.parseDouble(numStr);
            }
            return new BigDecimal(numStr);
        }
        if (numStr.length() < 19) {
            return Long.parseLong(numStr);
        }
        BigInteger bigInt = new BigInteger(numStr);
        if (bigInt.compareTo(BIG_INT_LONG_MIN) >= 0 && bigInt.compareTo(BIG_INT_LONG_MAX) <= 0) {
            return bigInt.longValue();
        }
        return bigInt;
    }

    public static <T extends Comparable<? super T>> boolean nextPermutation(List<T> list) {
        int k;
        for (k = list.size() - 2; k >= 0 && ((Comparable)list.get(k)).compareTo(list.get(k + 1)) >= 0; --k) {
        }
        if (k < 0) {
            return false;
        }
        int l = list.size() - 1;
        while (((Comparable)list.get(k)).compareTo(list.get(l)) >= 0) {
            --l;
        }
        Collections.swap(list, k, l);
        int i = k + 1;
        for (int j = list.size() - 1; i < j; ++i, --j) {
            Collections.swap(list, i, j);
        }
        return true;
    }
}

