/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class ConcurrentList<E>
implements List<E> {
    private final List<E> list;
    private final transient ReadWriteLock lock = new ReentrantReadWriteLock();

    public ConcurrentList() {
        this.list = new ArrayList();
    }

    public ConcurrentList(int size) {
        this.list = new ArrayList(size);
    }

    public ConcurrentList(List<E> list) {
        if (list == null) {
            throw new IllegalArgumentException("List cannot be null");
        }
        this.list = list;
    }

    @Override
    public boolean equals(Object other) {
        return this.readOperation(() -> this.list.equals(other));
    }

    @Override
    public int hashCode() {
        return this.readOperation(this.list::hashCode);
    }

    public String toString() {
        return this.readOperation((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(this.list));
    }

    @Override
    public int size() {
        return this.readOperation(this.list::size);
    }

    @Override
    public boolean isEmpty() {
        return this.readOperation(this.list::isEmpty);
    }

    @Override
    public boolean contains(Object o) {
        return this.readOperation(() -> this.list.contains(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.readOperation(() -> new HashSet<E>(this.list).containsAll(c));
    }

    @Override
    public E get(int index) {
        return (E)this.readOperation(() -> this.list.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.readOperation(() -> this.list.indexOf(o));
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.readOperation(() -> this.list.lastIndexOf(o));
    }

    @Override
    public Iterator<E> iterator() {
        return this.readOperation(() -> new ArrayList<E>(this.list).iterator());
    }

    @Override
    public Object[] toArray() {
        return this.readOperation(this.list::toArray);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.readOperation(() -> this.list.toArray(a));
    }

    @Override
    public boolean add(E e) {
        return this.writeOperation(() -> this.list.add(e));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.writeOperation(() -> this.list.addAll(c));
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.writeOperation(() -> this.list.addAll(index, c));
    }

    @Override
    public void add(int index, E element) {
        this.writeOperation(() -> {
            this.list.add(index, element);
            return null;
        });
    }

    @Override
    public E set(int index, E element) {
        return (E)this.writeOperation(() -> this.list.set(index, element));
    }

    @Override
    public E remove(int index) {
        return (E)this.writeOperation(() -> this.list.remove(index));
    }

    @Override
    public boolean remove(Object o) {
        return this.writeOperation(() -> this.list.remove(o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.writeOperation(() -> this.list.removeAll(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.writeOperation(() -> this.list.retainAll(c));
    }

    @Override
    public void clear() {
        this.writeOperation(() -> {
            this.list.clear();
            return null;
        });
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.readOperation(() -> new ArrayList<E>(this.list).listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException("listIterator(index) not implemented for ConcurrentList");
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not implemented for ConcurrentList");
    }

    private <T> T readOperation(Supplier<T> operation) {
        this.lock.readLock().lock();
        try {
            T t = operation.get();
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private <T> T writeOperation(Supplier<T> operation) {
        this.lock.writeLock().lock();
        try {
            T t = operation.get();
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

